/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.Cos;
import org.nd4j.linalg.util.ComplexUtil;

public class Sin
extends BaseTransformOp {
    public Sin(INDArray x, INDArray z) {
        super(x, z);
    }

    public Sin(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public Sin(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Sin(INDArray x) {
        super(x);
    }

    public Sin() {
    }

    @Override
    public String name() {
        return "sin";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return ComplexUtil.sin(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return ComplexUtil.sin(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return ComplexUtil.sin(origin);
    }

    @Override
    public float op(float origin, float other) {
        return (float)FastMath.sin((double)origin);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.sin((double)origin);
    }

    @Override
    public double op(double origin) {
        return FastMath.sin((double)origin);
    }

    @Override
    public float op(float origin) {
        return (float)FastMath.sin((double)origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return ComplexUtil.sin(origin);
    }

    @Override
    public TransformOp derivative() {
        return new Cos(this.x, this.y, this.z, this.n);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Sin(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Sin(this.x.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Sin(this.x.tensorAlongDimension(index, dimension), this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Sin(this.x.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

