/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.params;

import org.nd4j.linalg.api.ndarray.INDArray;

public class GemmParams {
    private int lda;
    private int ldb;
    private int ldc;
    private int m;
    private int n;
    private int k;
    private INDArray a;
    private INDArray b;
    private INDArray c;
    private char aOrdering = (char)78;
    private char bOrdering = (char)78;

    public GemmParams(INDArray a, INDArray b, INDArray c) {
        if (b.columns() != c.columns()) {
            throw new IllegalArgumentException("B columns must match c columns");
        }
        if (a.rows() != c.rows()) {
            throw new IllegalArgumentException("A rows must equal c rows");
        }
        this.a = this.copyIfNeccessary(a);
        this.b = this.copyIfNeccessary(b);
        this.c = this.copyIfNeccessary(c);
        this.m = c.rows();
        this.n = c.columns();
        if (this.a.ordering() == 'f' && this.b.ordering() == 'f') {
            this.k = this.a.columns();
            this.lda = this.a.rows();
            this.ldb = this.b.rows();
            this.ldc = this.a.rows();
        } else if (this.a.ordering() == 'c' && this.b.ordering() == 'c') {
            this.k = this.b.rows();
            this.lda = this.a.columns();
            this.ldb = this.b.columns();
            this.ldc = this.c.rows();
            this.aOrdering = (char)84;
            this.bOrdering = (char)84;
        } else if (this.a.ordering() == 'f' && this.b.ordering() == 'c') {
            this.k = this.a.columns();
            this.lda = this.a.rows();
            this.ldb = this.b.columns();
            this.ldc = this.c.rows();
            this.bOrdering = (char)84;
        } else if (this.a.ordering() == 'c' && this.b.ordering() == 'f') {
            this.k = this.b.rows();
            this.lda = this.a.columns();
            this.ldb = this.b.rows();
            this.ldc = this.c.rows();
            this.aOrdering = (char)84;
        } else {
            throw new RuntimeException();
        }
        this.validate();
    }

    private INDArray copyIfNeccessary(INDArray arr) {
        if (arr.isMatrix()) {
            if (arr.ordering() == 'c' && (arr.stride(0) != arr.size(1) || arr.stride(1) != 1)) {
                return arr.dup();
            }
            if (arr.stride(0) != 1 || arr.stride(1) != arr.size(0)) {
                return arr.dup();
            }
        }
        return arr;
    }

    private void validate() {
        if (this.c.ordering() != 'f') {
            throw new IllegalStateException("C is not order f");
        }
    }

    public int getLda() {
        return this.lda;
    }

    public int getLdb() {
        return this.ldb;
    }

    public int getLdc() {
        return this.ldc;
    }

    public int getM() {
        return this.m;
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public INDArray getA() {
        return this.a;
    }

    public INDArray getB() {
        return this.b;
    }

    public INDArray getC() {
        return this.c;
    }

    public char getAOrdering() {
        return this.aOrdering;
    }

    public char getBOrdering() {
        return this.bOrdering;
    }

    public void setLda(int lda) {
        this.lda = lda;
    }

    public void setLdb(int ldb) {
        this.ldb = ldb;
    }

    public void setLdc(int ldc) {
        this.ldc = ldc;
    }

    public void setM(int m) {
        this.m = m;
    }

    public void setN(int n) {
        this.n = n;
    }

    public void setK(int k) {
        this.k = k;
    }

    public void setA(INDArray a) {
        this.a = a;
    }

    public void setB(INDArray b) {
        this.b = b;
    }

    public void setC(INDArray c) {
        this.c = c;
    }

    public void setAOrdering(char aOrdering) {
        this.aOrdering = aOrdering;
    }

    public void setBOrdering(char bOrdering) {
        this.bOrdering = bOrdering;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GemmParams)) {
            return false;
        }
        GemmParams other = (GemmParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLda() != other.getLda()) {
            return false;
        }
        if (this.getLdb() != other.getLdb()) {
            return false;
        }
        if (this.getLdc() != other.getLdc()) {
            return false;
        }
        if (this.getM() != other.getM()) {
            return false;
        }
        if (this.getN() != other.getN()) {
            return false;
        }
        if (this.getK() != other.getK()) {
            return false;
        }
        INDArray this$a = this.getA();
        INDArray other$a = other.getA();
        if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
            return false;
        }
        INDArray this$b = this.getB();
        INDArray other$b = other.getB();
        if (this$b == null ? other$b != null : !this$b.equals(other$b)) {
            return false;
        }
        INDArray this$c = this.getC();
        INDArray other$c = other.getC();
        if (this$c == null ? other$c != null : !this$c.equals(other$c)) {
            return false;
        }
        if (this.getAOrdering() != other.getAOrdering()) {
            return false;
        }
        return this.getBOrdering() == other.getBOrdering();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GemmParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLda();
        result = result * 59 + this.getLdb();
        result = result * 59 + this.getLdc();
        result = result * 59 + this.getM();
        result = result * 59 + this.getN();
        result = result * 59 + this.getK();
        INDArray $a = this.getA();
        result = result * 59 + ($a == null ? 0 : $a.hashCode());
        INDArray $b = this.getB();
        result = result * 59 + ($b == null ? 0 : $b.hashCode());
        INDArray $c = this.getC();
        result = result * 59 + ($c == null ? 0 : $c.hashCode());
        result = result * 59 + this.getAOrdering();
        result = result * 59 + this.getBOrdering();
        return result;
    }

    public String toString() {
        return "GemmParams(lda=" + this.getLda() + ", ldb=" + this.getLdb() + ", ldc=" + this.getLdc() + ", m=" + this.getM() + ", n=" + this.getN() + ", k=" + this.getK() + ", a=" + this.getA() + ", b=" + this.getB() + ", c=" + this.getC() + ", aOrdering=" + this.getAOrdering() + ", bOrdering=" + this.getBOrdering() + ")";
    }
}

