/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.util.ComplexUtil;

public class Sqrt
extends BaseTransformOp {
    public Sqrt() {
    }

    public Sqrt(INDArray x, INDArray z) {
        super(x, z);
    }

    public Sqrt(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public Sqrt(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Sqrt(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "sqrt";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return ComplexUtil.sqrt(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return ComplexUtil.sqrt(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return ComplexUtil.sqrt(origin);
    }

    @Override
    public float op(float origin, float other) {
        return (float)FastMath.sqrt((double)origin);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.sqrt((double)origin);
    }

    @Override
    public double op(double origin) {
        return FastMath.sqrt((double)origin);
    }

    @Override
    public float op(float origin) {
        return (float)FastMath.sqrt((double)origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return ComplexUtil.sqrt(origin);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Sqrt(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Sqrt(xAlongDimension, this.z.vectorAlongDimension(index, dimension), this.x.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Sqrt(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Sqrt(xAlongDimension, this.z.tensorAlongDimension(index, dimension), this.x.length());
    }
}

