/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.iter;

import java.util.Iterator;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.util.ArrayUtil;

public class NdIndexIterator
implements Iterator<int[]> {
    private int length = -1;
    private int i = 0;
    private int[] shape;
    private char order = (char)99;

    public NdIndexIterator(char order) {
        this.order = order;
    }

    public NdIndexIterator(int ... shape) {
        this('c', shape);
    }

    public NdIndexIterator(char order, int ... shape) {
        this.shape = ArrayUtil.copy(shape);
        this.length = ArrayUtil.prod(shape);
        this.order = order;
    }

    @Override
    public boolean hasNext() {
        return this.i < this.length;
    }

    @Override
    public int[] next() {
        switch (this.order) {
            case 'c': {
                return Shape.ind2subC(this.shape, this.i++);
            }
            case 'f': {
                return Shape.ind2sub(this.shape, this.i++);
            }
        }
        throw new IllegalArgumentException("Illegal ordering " + this.order);
    }

    @Override
    public void remove() {
    }
}

