/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer;

import io.netty.buffer.ByteBuf;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.factory.Nd4j;

public class DoubleBuffer
extends BaseDataBuffer {
    public DoubleBuffer(int length) {
        super(length);
    }

    public DoubleBuffer(ByteBuf buf, int length) {
        super(buf, length);
    }

    public DoubleBuffer(double[] data) {
        super(data);
    }

    public DoubleBuffer(int[] data) {
        this(data, Nd4j.copyOnOps);
    }

    public DoubleBuffer(int[] data, boolean copyOnOps) {
        super(data, copyOnOps);
    }

    public DoubleBuffer(float[] data) {
        this(data, Nd4j.copyOnOps);
    }

    public DoubleBuffer(float[] data, boolean copyOnOps) {
        super(data, copyOnOps);
    }

    @Override
    public DataBuffer create(ByteBuf buf, int length) {
        return new DoubleBuffer(buf, length);
    }

    public DoubleBuffer(double[] doubles, boolean copy) {
        super(doubles, copy);
    }

    @Override
    public DataBuffer.Type dataType() {
        return DataBuffer.Type.DOUBLE;
    }

    @Override
    public float getFloat(int i) {
        return (float)this.getDouble(i);
    }

    @Override
    public Number getNumber(int i) {
        return (int)this.getDouble(i);
    }

    @Override
    public DataBuffer create(double[] data) {
        return new DoubleBuffer(data);
    }

    @Override
    public DataBuffer create(float[] data) {
        return new DoubleBuffer(data);
    }

    @Override
    public DataBuffer create(int[] data) {
        return new DoubleBuffer(data);
    }

    @Override
    protected DataBuffer create(int length) {
        return new DoubleBuffer(length);
    }

    @Override
    public void flush() {
        this.dataBuffer = null;
    }

    @Override
    public int getElementSize() {
        return 8;
    }
}

