/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.transforms.SoftMax;
import org.nd4j.linalg.factory.Nd4j;

public class SoftMaxDerivative
extends SoftMax {
    public SoftMaxDerivative(INDArray x, INDArray z) {
        super(x, z);
    }

    public SoftMaxDerivative(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public SoftMaxDerivative(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public SoftMaxDerivative(INDArray x) {
        super(x);
    }

    public SoftMaxDerivative() {
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        IComplexNumber softmax = super.op(origin, other);
        return softmax.mul(Nd4j.createComplexNumber(1, 1).sub(softmax));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        IComplexNumber softmax = super.op(origin, other);
        return softmax.mul(Nd4j.createComplexNumber(1, 1).sub(softmax));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        IComplexNumber softmax = super.op(origin, other);
        return softmax.mul(Nd4j.createComplexNumber(1, 1).sub(softmax));
    }

    @Override
    public float op(float origin, float other) {
        float softmax = super.op(origin, other);
        return softmax * (1.0f - softmax);
    }

    @Override
    public double op(double origin, double other) {
        double softmax = super.op(origin, other);
        return softmax * (1.0 - softmax);
    }

    @Override
    public double op(double origin) {
        double softmax = super.op(origin);
        return softmax * (1.0 - softmax);
    }

    @Override
    public float op(float origin) {
        float softmax = super.op(origin);
        return softmax * (1.0f - softmax);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        IComplexNumber softmax = super.op(origin);
        return softmax.mul(Nd4j.createComplexNumber(1, 1).sub(softmax));
    }

    @Override
    public String name() {
        return "softmaxderivative";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new SoftMaxDerivative(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new SoftMaxDerivative(this.x.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

