/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.ops.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.BaseElementWiseOp;
import org.nd4j.linalg.util.ComplexUtil;

public class HardTanh
extends BaseElementWiseOp {
    public Object apply(INDArray from, Object value, int i) {
        if (value instanceof IComplexNumber) {
            IComplexNumber element = (IComplexNumber)value;
            IComplexNumber ret = ComplexUtil.tanh(element);
            if (ret.realComponent().doubleValue() < -1.0) {
                ret.set(-1, ret.imaginaryComponent().doubleValue());
            }
            if (ret.realComponent().doubleValue() > 1.0) {
                ret.set(1, ret.imaginaryComponent().doubleValue());
            }
            return Nd4j.scalar(ret);
        }
        double d = (Double)value;
        double ret = Math.tanh(d);
        if (ret < -1.0) {
            return -1;
        }
        if (ret > 1.0) {
            return 1.0;
        }
        return ret;
    }
}

