/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.ops.transforms;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.ops.ArrayOps;
import org.nd4j.linalg.ops.ElementWiseOp;
import org.nd4j.linalg.ops.factory.ElementWiseOpFactories;
import org.nd4j.linalg.ops.factory.ElementWiseOpFactory;
import org.nd4j.linalg.util.ArrayUtil;

public class Transforms {
    public static INDArray maxPool(INDArray input, int[] ds, boolean ignoreBorder) {
        assert (input.length() >= 2) : "Max pooling requires an ndarray of >= length 2";
        assert (ds.length == 2) : "Down sampling must be of length 2 (the factors used for each image size";
        assert (input.shape().length == 4) : "Only supports 4 dimensional tensors";
        int batchSize = ArrayUtil.prod(new int[]{input.size(0) * input.size(1)});
        int rows = input.size(2);
        int cols = input.size(3);
        INDArray signalNDArray = input.reshape(batchSize, 1, rows, cols);
        INDArray zz = Nd4j.create(signalNDArray.shape()).assign(Float.valueOf(Float.MIN_VALUE));
        int rowIter = ignoreBorder ? rows / (int)Math.pow(ds[0], 2.0) : rows;
        int colIter = ignoreBorder ? cols / (int)Math.pow(ds[1], 2.0) : cols;
        for (int i = 0; i < signalNDArray.size(0); ++i) {
            for (int j = 0; j < signalNDArray.size(1); ++j) {
                for (int k = 0; k < rowIter; ++k) {
                    int zk = k / ds[0];
                    int l = 0;
                    while (l < colIter) {
                        int zl = l / ds[1];
                        double num = input.getDouble(i, j, k, l++);
                        double zzGet = zz.getDouble(i, j, zk, zl);
                        zz.putScalar(new int[]{i, j, zk, zl}, Math.max(num, zzGet));
                    }
                }
            }
        }
        return zz.reshape(signalNDArray.shape());
    }

    public static INDArray downSample(INDArray d1, int[] stride) {
        INDArray d = Nd4j.ones(stride);
        d.divi(ArrayUtil.prod(stride));
        INDArray ret = Convolution.convn(d1, d, Convolution.Type.VALID);
        ret = ret.get(NDArrayIndex.interval(0, stride[0]), NDArrayIndex.interval(0, stride[1]));
        return ret;
    }

    public static INDArray pool(INDArray toPool, int[] stride) {
        int nDims = toPool.shape().length;
        assert (nDims == 3) : "NDArray must have 3 dimensions";
        int nRows = toPool.shape()[nDims - 2];
        int nCols = toPool.shape()[nDims - 1];
        int yStride = stride[0];
        int xStride = stride[1];
        INDArray blocks = Nd4j.create(toPool.shape());
        int iR = 0;
        while ((double)iR < Math.ceil(nRows / yStride)) {
            NDArrayIndex rows = NDArrayIndex.interval(iR * yStride, iR * yStride, true);
            int jC = 0;
            while ((double)jC < Math.ceil(nCols / xStride)) {
                NDArrayIndex cols = NDArrayIndex.interval(jC * xStride, jC * xStride + 1, true);
                INDArray blockVal = toPool.get(rows, cols).sum(toPool.shape().length - 1).sum(toPool.shape().length - 1);
                blocks.put(new NDArrayIndex[]{rows, cols}, blockVal.permute(1, 2, 0)).repmat(new int[]{rows.length(), cols.length()});
                ++jC;
            }
            ++iR;
        }
        return blocks;
    }

    public static INDArray upSample(INDArray d, INDArray scale) {
        INDArray idx = Nd4j.create(d.shape().length, 1);
        for (int i = 0; i < d.shape().length; ++i) {
            INDArray tmp = Nd4j.zeros(d.size(i) * (int)scale.getDouble(i), 1);
            int[] indices = ArrayUtil.range(0, (int)scale.getDouble(i) * d.size(i), (int)scale.getDouble(i));
            tmp.putScalar(indices, 1.0f);
            idx.put(i, tmp.cumsum(Integer.MAX_VALUE).sum(Integer.MAX_VALUE));
        }
        return idx;
    }

    public static double cosineSim(INDArray d1, INDArray d2) {
        d1 = Transforms.unitVec(d1.dup());
        d2 = Transforms.unitVec(d2.dup());
        double ret = Nd4j.getBlasWrapper().dot(d1, d2);
        return ret;
    }

    public static INDArray normalizeZeroMeanAndUnitVariance(INDArray toNormalize) {
        INDArray columnMeans = toNormalize.mean(0);
        INDArray columnStds = toNormalize.std(0);
        toNormalize.subiRowVector(columnMeans);
        columnStds.addi(Nd4j.EPS_THRESHOLD);
        toNormalize.diviRowVector(columnStds);
        return toNormalize;
    }

    public static INDArray unitVec(INDArray toScale) {
        double length = toScale.norm2(Integer.MAX_VALUE).getDouble(0);
        if (length > 0.0) {
            if (toScale.data().dataType() == 1) {
                return Nd4j.getBlasWrapper().scal(1.0f / (float)length, toScale);
            }
            return Nd4j.getBlasWrapper().scal(1.0 / length, toScale);
        }
        return toScale;
    }

    public static INDArray neg(INDArray ndArray) {
        return Transforms.neg(ndArray, true);
    }

    public static IComplexNDArray neg(IComplexNDArray ndArray) {
        return Transforms.neg(ndArray, true);
    }

    public static INDArray eq(INDArray ndArray) {
        return Transforms.eq(ndArray, true);
    }

    public static IComplexNDArray eq(IComplexNDArray ndArray) {
        return Transforms.eq(ndArray, true);
    }

    public static INDArray neq(INDArray ndArray) {
        return Transforms.neq(ndArray, true);
    }

    public static IComplexNDArray neq(IComplexNDArray ndArray) {
        return Transforms.neq(ndArray, true);
    }

    public static INDArray floor(INDArray ndArray) {
        return Transforms.floor(ndArray, true);
    }

    public static INDArray sign(IComplexNDArray toSign) {
        return Transforms.sign(toSign, true);
    }

    public static INDArray sign(INDArray toSign) {
        return Transforms.sign(toSign, true);
    }

    public static IComplexNDArray floor(IComplexNDArray ndArray) {
        return Transforms.floor(ndArray, true);
    }

    public static INDArray gt(INDArray ndArray) {
        return Transforms.gt(ndArray, true);
    }

    public static IComplexNDArray gt(IComplexNDArray ndArray) {
        return Transforms.gt(ndArray, true);
    }

    public static INDArray lt(INDArray ndArray) {
        return Transforms.lt(ndArray, true);
    }

    public static IComplexNDArray lt(IComplexNDArray ndArray) {
        return Transforms.lt(ndArray, true);
    }

    public static INDArray stabilize(INDArray ndArray, double k) {
        return Transforms.stabilize(ndArray, k, true);
    }

    public static IComplexNDArray stabilize(IComplexNDArray ndArray, double k) {
        return Transforms.stabilize(ndArray, k, true);
    }

    public static INDArray abs(INDArray ndArray) {
        return Transforms.abs(ndArray, true);
    }

    public static IComplexNDArray abs(IComplexNDArray ndArray) {
        return Transforms.abs(ndArray, true);
    }

    public static INDArray exp(INDArray ndArray) {
        return Transforms.exp(ndArray, true);
    }

    public static IComplexNDArray exp(IComplexNDArray ndArray) {
        return Transforms.exp(ndArray, true);
    }

    public static INDArray hardTanh(INDArray ndArray) {
        return Transforms.hardTanh(ndArray, true);
    }

    public static IComplexNDArray hardTanh(IComplexNDArray ndArray) {
        return Transforms.hardTanh(ndArray, true);
    }

    public static INDArray identity(INDArray ndArray) {
        return Transforms.identity(ndArray, true);
    }

    public static IComplexNDArray identity(IComplexNDArray ndArray) {
        return Transforms.identity(ndArray, true);
    }

    public static INDArray max(INDArray ndArray) {
        return Transforms.max(ndArray, true);
    }

    public static INDArray max(INDArray ndArray, double max) {
        return Transforms.max(ndArray, max, true);
    }

    public static IComplexNDArray max(IComplexNDArray ndArray, double max) {
        return Transforms.max(ndArray, max, true);
    }

    public static IComplexNDArray max(IComplexNDArray ndArray) {
        return Transforms.max(ndArray, true);
    }

    public static INDArray pow(INDArray ndArray, Number power) {
        return Transforms.pow(ndArray, power, true);
    }

    public static IComplexNDArray pow(IComplexNDArray ndArray, IComplexNumber power) {
        return Transforms.pow(ndArray, power, true);
    }

    public static INDArray round(INDArray ndArray) {
        return Transforms.round(ndArray, true);
    }

    public static IComplexNDArray round(IComplexNDArray ndArray) {
        return Transforms.round(ndArray, true);
    }

    public static INDArray sigmoid(INDArray ndArray) {
        return Transforms.sigmoid(ndArray, true);
    }

    public static IComplexNDArray sigmoid(IComplexNDArray ndArray) {
        return Transforms.sigmoid(ndArray, true);
    }

    public static INDArray sqrt(INDArray ndArray) {
        return Transforms.sqrt(ndArray, true);
    }

    public static IComplexNDArray sqrt(IComplexNDArray ndArray) {
        return Transforms.sqrt(ndArray, true);
    }

    public static INDArray tanh(INDArray ndArray) {
        return Transforms.tanh(ndArray, true);
    }

    public static IComplexNDArray tanh(IComplexNDArray ndArray) {
        return Transforms.tanh(ndArray, true);
    }

    public static INDArray log(INDArray ndArray) {
        return Transforms.log(ndArray, true);
    }

    public static IComplexNDArray log(IComplexNDArray ndArray) {
        return Transforms.log(ndArray, true);
    }

    public static INDArray eq(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.equalTo(), null, dup);
    }

    public static IComplexNDArray eq(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.equalTo(), null, dup);
    }

    public static INDArray neq(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.notEqualTo(), null, dup);
    }

    public static IComplexNDArray neq(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.notEqualTo(), null, dup);
    }

    public static INDArray floor(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.floor(), null, dup);
    }

    public static INDArray sign(IComplexNDArray toSign, boolean dup) {
        return Transforms.exec(toSign, ElementWiseOpFactories.sign(), null, dup);
    }

    public static INDArray sign(INDArray toSign, boolean dup) {
        return Transforms.exec(toSign, ElementWiseOpFactories.sign(), null, dup);
    }

    public static IComplexNDArray floor(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.floor(), null, dup);
    }

    public static INDArray gt(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.greaterThan(), null, dup);
    }

    public static IComplexNDArray gt(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.greaterThan(), null, dup);
    }

    public static INDArray lt(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.lessThan(), null, dup);
    }

    public static IComplexNDArray lt(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.lessThan(), null, dup);
    }

    public static INDArray stabilize(INDArray ndArray, double k, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.stabilize(), new Object[]{k}, dup);
    }

    public static IComplexNDArray stabilize(IComplexNDArray ndArray, double k, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.stabilize(), new Object[]{k}, dup);
    }

    public static INDArray abs(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.abs(), null, dup);
    }

    public static IComplexNDArray abs(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.abs(), null, dup);
    }

    public static INDArray exp(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.exp(), null, dup);
    }

    public static IComplexNDArray exp(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.exp(), null, dup);
    }

    public static INDArray hardTanh(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.hardTanh(), null, dup);
    }

    public static IComplexNDArray hardTanh(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.hardTanh(), null, dup);
    }

    public static INDArray identity(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.identity(), null, dup);
    }

    public static IComplexNDArray identity(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.identity(), null, dup);
    }

    public static INDArray max(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.max(), null, dup);
    }

    public static INDArray max(INDArray ndArray, double max, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.max(), new Object[]{max}, dup);
    }

    public static IComplexNDArray max(IComplexNDArray ndArray, double max, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.max(), new Object[]{max}, dup);
    }

    public static IComplexNDArray max(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.max(), null, dup);
    }

    public static INDArray pow(INDArray ndArray, Number power, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.pow(), new Object[]{power}, dup);
    }

    public static IComplexNDArray pow(IComplexNDArray ndArray, IComplexNumber power, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.pow(), new Object[]{power}, dup);
    }

    public static INDArray round(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.round(), null, dup);
    }

    public static IComplexNDArray round(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.round(), null, dup);
    }

    public static INDArray sigmoid(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.sigmoid(), null, dup);
    }

    public static IComplexNDArray sigmoid(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.sigmoid(), null, dup);
    }

    public static INDArray sqrt(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.sqrt(), null, dup);
    }

    public static IComplexNDArray sqrt(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.sqrt(), null, dup);
    }

    public static INDArray tanh(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.tanh(), null, dup);
    }

    public static IComplexNDArray tanh(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.tanh(), null, dup);
    }

    public static INDArray log(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.log(), null, dup);
    }

    public static IComplexNDArray log(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.log(), null, dup);
    }

    public static INDArray neg(INDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.negative(), null, dup);
    }

    public static IComplexNDArray neg(IComplexNDArray ndArray, boolean dup) {
        return Transforms.exec(ndArray, ElementWiseOpFactories.negative(), null, dup);
    }

    private static INDArray exec(INDArray indArray, ElementWiseOpFactory factory, Object[] extraArgs, boolean dup) {
        ElementWiseOp ops = new ArrayOps().from(dup ? indArray.dup() : indArray).op(factory).extraArgs(extraArgs).build();
        ops.exec();
        return ops.from();
    }

    private static IComplexNDArray exec(IComplexNDArray indArray, ElementWiseOpFactory factory, Object[] extraArgs, boolean dup) {
        ElementWiseOp ops = new ArrayOps().from(dup ? indArray.dup() : indArray).op(factory).extraArgs(extraArgs).build();
        ops.exec();
        IComplexNDArray n = (IComplexNDArray)ops.from();
        return n;
    }
}

