/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.fft.test;

import org.junit.Assert;
import org.junit.Test;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.fft.VectorFFT;
import org.nd4j.linalg.fft.VectorIFFT;

public abstract class BaseIFFTTests {
    @Test
    public void testIfft() {
        double[] ffted = new double[]{10.2, 5.0, -3.0, -1.0};
        double[] orig = new double[]{3.5999999999999996, 2.0, 6.6, 3.0};
        IComplexNDArray c = Nd4j.createComplex(orig, new int[]{2});
        IComplexNDArray assertion = Nd4j.createComplex(ffted, new int[]{2});
        Assert.assertEquals((Object)assertion, (Object)new VectorFFT(2).apply(c));
        IComplexNDArray iffted = new VectorIFFT(2).apply(assertion.dup());
        Assert.assertEquals((Object)iffted, (Object)c);
        double[] ffted2 = new double[]{17.8, 9.0, -1.0, -8.6, 4.6, 3.0};
        double[] orig2 = new double[]{3.6, 2.0, 6.6, 3.0, 7.6, 4.0};
        double[] fftOrig2 = new double[]{17.8, 9.0, -4.3660254, -0.6339746, -2.6339746, -2.3660254};
        IComplexNDArray c2 = Nd4j.createComplex(orig2, new int[]{3});
        IComplexNDArray fftOrig2Arr = Nd4j.createComplex(fftOrig2, new int[]{fftOrig2.length / 2});
        IComplexNDArray fftOrig2Test = new VectorFFT(fftOrig2Arr.length()).apply(c2);
        Assert.assertEquals((Object)fftOrig2Arr, (Object)fftOrig2Test);
        IComplexNDArray ifftTestFor = Nd4j.createComplex(new double[]{3.6, 2.0, 6.6, 3.0, 7.6, 4.0}, new int[]{3});
        IComplexNDArray ifftTest = new VectorIFFT(fftOrig2Arr.length()).apply(fftOrig2Arr);
        Assert.assertEquals((Object)ifftTestFor, (Object)ifftTest);
    }
}

