/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.complex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.BaseNDArray;
import org.nd4j.linalg.api.ndarray.DimensionSlice;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.SliceOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.Indices;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.ops.reduceops.Ops;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.ComplexIterationResult;
import org.nd4j.linalg.util.LinAlgExceptions;
import org.nd4j.linalg.util.Shape;

public abstract class BaseComplexNDArray
extends BaseNDArray
implements IComplexNDArray {
    public BaseComplexNDArray() {
    }

    public BaseComplexNDArray(DataBuffer data, int[] shape, int[] stride) {
        this(data, shape, stride, 0, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(float[] data) {
        super(data);
    }

    public BaseComplexNDArray(DataBuffer buffer, int[] shape, int[] stride, int offset, char ordering) {
        super(buffer, shape, stride, offset, ordering);
    }

    public BaseComplexNDArray(float[] data, int[] shape, char ordering) {
        this(data, shape, Nd4j.getComplexStrides(shape, ordering), 0, Character.valueOf(ordering));
    }

    public BaseComplexNDArray(int[] shape, int offset, char ordering) {
        this(Nd4j.createBuffer(ArrayUtil.prod(shape) * 2), shape, Nd4j.getComplexStrides(shape, ordering), offset, ordering);
    }

    public BaseComplexNDArray(int[] shape) {
        this(Nd4j.createBuffer(ArrayUtil.prod(shape) * 2), shape, Nd4j.getComplexStrides(shape));
    }

    public BaseComplexNDArray(float[] data, int[] shape, int[] stride, char ordering) {
        this(data, shape, stride, 0, Character.valueOf(ordering));
    }

    public BaseComplexNDArray(int[] shape, char ordering) {
        this(Nd4j.createBuffer(ArrayUtil.prod(shape) * 2), shape, Nd4j.getComplexStrides(shape, ordering), 0, ordering);
    }

    public BaseComplexNDArray(INDArray m, int[] stride, char ordering) {
        this(m.shape(), stride, ordering);
        this.copyFromReal(m);
    }

    public BaseComplexNDArray(INDArray m, char ordering) {
        this(m.shape(), ordering);
        this.copyFromReal(m);
    }

    public BaseComplexNDArray(INDArray m) {
        this(m, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(INDArray m, int[] stride) {
        this(m, stride, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(List<IComplexNDArray> slices, int[] shape, int[] stride) {
        this(slices, shape, stride, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(List<IComplexNDArray> slices, int[] shape, int[] stride, char ordering) {
        this(new float[ArrayUtil.prod(shape) * 2]);
        ArrayList<IComplexNumber> list = new ArrayList<IComplexNumber>();
        for (int i = 0; i < slices.size(); ++i) {
            IComplexNDArray flattened = slices.get(i).ravel();
            for (int j = 0; j < flattened.length(); ++j) {
                list.add(flattened.getComplex(j));
            }
        }
        this.ordering = ordering;
        this.data = Nd4j.createBuffer(ArrayUtil.prod(shape) * 2);
        this.stride = stride;
        this.initShape(shape);
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            this.putScalar(count, (IComplexNumber)list.get(i));
            ++count;
        }
    }

    public BaseComplexNDArray(List<IComplexNDArray> slices, int[] shape, char ordering) {
        this(slices, shape, ordering == 'c' ? ArrayUtil.calcStrides(shape, 2) : ArrayUtil.calcStridesFortran(shape, 2), ordering);
    }

    public BaseComplexNDArray(float[] data, int[] shape, int[] stride, int offset, Character order) {
        this.data = Nd4j.createBuffer(data);
        this.stride = stride;
        this.offset = offset;
        this.ordering = order.charValue();
        this.initShape(shape);
    }

    public BaseComplexNDArray(DataBuffer data) {
        super(data);
    }

    public BaseComplexNDArray(DataBuffer data, int[] shape, int[] stride, int offset) {
        this.data = data;
        this.stride = stride;
        this.offset = offset;
        this.ordering = Nd4j.order().charValue();
        this.initShape(shape);
    }

    public BaseComplexNDArray(IComplexNumber[] data, int[] shape, int[] stride, int offset, char ordering) {
        this(shape, stride, offset, ordering);
        assert (data.length <= this.length);
        for (int i = 0; i < data.length; ++i) {
            this.putScalar(i, data[i]);
        }
    }

    public BaseComplexNDArray(DataBuffer data, int[] shape) {
        this(shape);
        this.data = data;
    }

    public BaseComplexNDArray(IComplexNumber[] data, int[] shape, int[] stride, int offset) {
        this(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(IComplexNumber[] data, int[] shape, int offset, char ordering) {
        this(data, shape, Nd4j.getComplexStrides(shape), offset, ordering);
    }

    public BaseComplexNDArray(DataBuffer buffer, int[] shape, int offset, char ordering) {
        this(buffer, shape, Nd4j.getComplexStrides(shape), offset, ordering);
    }

    public BaseComplexNDArray(DataBuffer buffer, int[] shape, int offset) {
        this(buffer, shape, Nd4j.getComplexStrides(shape), offset, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(float[] data, Character order) {
        this(data, new int[]{data.length / 2}, order.charValue());
    }

    protected void copyFromReal(INDArray real) {
        INDArray linear = real.linearView();
        IComplexNDArray thisLinear = this.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            thisLinear.putScalar(i, Nd4j.createComplexNumber(linear.getDouble(i), 0));
        }
    }

    @Override
    protected void copyRealTo(INDArray arr) {
        INDArray linear = arr.linearView();
        IComplexNDArray thisLinear = this.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            arr.putScalar(i, thisLinear.getReal(i));
        }
    }

    @Override
    public int blasOffset() {
        return this.offset > 0 ? this.offset() / 2 : this.offset();
    }

    @Override
    public IComplexNDArray linearViewColumnOrder() {
        return Nd4j.createComplex(this.data, new int[]{this.length, 1}, this.offset());
    }

    @Override
    public IComplexNDArray linearView() {
        if (this.isVector()) {
            return this;
        }
        if (this.linearView == null) {
            this.linearView = Nd4j.createComplex(this.data, new int[]{1, this.length}, this.stride(), this.offset());
        }
        return (IComplexNDArray)this.linearView;
    }

    public BaseComplexNDArray(List<IComplexNDArray> slices, int[] shape) {
        this(slices, shape, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(IComplexNumber[] newData, int[] shape) {
        super(new float[ArrayUtil.prod(shape) * 2]);
        this.initShape(shape);
        for (int i = 0; i < this.length; ++i) {
            this.put(i, (IComplexNumber)newData[i].asDouble());
        }
    }

    public BaseComplexNDArray(IComplexNumber[] newData, int[] shape, int[] stride) {
        super(new float[ArrayUtil.prod(shape) * 2]);
        this.stride = stride;
        this.initShape(shape);
        for (int i = 0; i < this.length; ++i) {
            this.put(i, (IComplexNumber)newData[i].asDouble());
        }
    }

    public BaseComplexNDArray(IComplexNumber[] newData, int[] shape, char ordering) {
        super(new float[ArrayUtil.prod(shape) * 2]);
        this.ordering = ordering;
        this.initShape(shape);
        for (int i = 0; i < this.length; ++i) {
            this.put(i, newData[i]);
        }
    }

    public BaseComplexNDArray(float[] data, int[] shape, int[] stride) {
        this(data, shape, stride, 0, Nd4j.order());
    }

    public BaseComplexNDArray(float[] data, int[] shape) {
        this(data, shape, 0);
    }

    public BaseComplexNDArray(float[] data, int[] shape, int offset, char ordering) {
        this(data, shape, ordering == 'c' ? ArrayUtil.calcStrides(shape, 2) : ArrayUtil.calcStridesFortran(shape, 2), offset, Character.valueOf(ordering));
    }

    public BaseComplexNDArray(float[] data, int[] shape, int offset) {
        this(data, shape, offset, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(int[] shape, int[] stride, int offset) {
        this(new float[ArrayUtil.prod(shape) * 2], shape, stride, offset);
    }

    public BaseComplexNDArray(int[] shape, int[] stride, int offset, char ordering) {
        this(new float[ArrayUtil.prod(shape) * 2], shape, stride, offset);
        this.ordering = ordering;
    }

    public BaseComplexNDArray(int[] shape, int[] stride, char ordering) {
        this(shape, stride, 0, ordering);
    }

    public BaseComplexNDArray(int[] shape, int[] stride) {
        this(shape, stride, 0);
    }

    public BaseComplexNDArray(int[] shape, int offset) {
        this(shape, offset, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(int newRows, int newColumns) {
        this(new int[]{newRows, newColumns});
    }

    public BaseComplexNDArray(int newRows, int newColumns, char ordering) {
        this(new int[]{newRows, newColumns}, ordering);
    }

    public BaseComplexNDArray(float[] data, int[] shape, int[] stride, int offset) {
        this(data, shape, stride, offset, Nd4j.order());
    }

    @Override
    public IComplexNumber getComplex(int i, IComplexNumber result) {
        IComplexNumber d = this.getComplex(i);
        return result.set(d.realComponent(), d.imaginaryComponent());
    }

    @Override
    public IComplexNumber getComplex(int i, int j, IComplexNumber result) {
        IComplexNumber d = this.getComplex(i, j);
        return result.set(d.realComponent(), d.imaginaryComponent());
    }

    @Override
    public IComplexNDArray putScalar(int j, int i, IComplexNumber conji) {
        int idx = this.index(j, i);
        this.data.put(idx, conji.realComponent().doubleValue());
        this.data.put(idx + 1, conji.imaginaryComponent().doubleValue());
        return this;
    }

    @Override
    public IComplexNDArray eps(Number other) {
        return this.dup().epsi(other);
    }

    @Override
    public IComplexNDArray eps(IComplexNumber other) {
        return this.dup().epsi(other);
    }

    @Override
    public IComplexNDArray epsi(IComplexNumber other) {
        IComplexNDArray linear = this.linearView();
        double otherVal = other.realComponent().doubleValue();
        for (int i = 0; i < this.linearView().length(); ++i) {
            IComplexNumber n = linear.getComplex(i);
            double real = n.realComponent().doubleValue();
            double diff = Math.abs(real - otherVal);
            if (diff <= Nd4j.EPS_THRESHOLD) {
                linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(1.0, 0.0));
                continue;
            }
            linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(0.0, 0.0));
        }
        return this;
    }

    @Override
    public IComplexNDArray epsi(Number other) {
        IComplexNDArray linear = this.linearView();
        double otherVal = other.doubleValue();
        for (int i = 0; i < this.linearView().length(); ++i) {
            IComplexNumber n = linear.getComplex(i);
            double real = n.realComponent().doubleValue();
            double diff = Math.abs(real - otherVal);
            if (diff <= Nd4j.EPS_THRESHOLD) {
                linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(1.0, 0.0));
                continue;
            }
            linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(0.0, 0.0));
        }
        return this;
    }

    @Override
    public IComplexNDArray eps(INDArray other) {
        return this.dup().epsi(other);
    }

    @Override
    public IComplexNDArray epsi(INDArray other) {
        IComplexNDArray linear = this.linearView();
        if (other instanceof IComplexNDArray) {
            IComplexNDArray otherComplex = (IComplexNDArray)other;
            IComplexNDArray otherComplexLinear = otherComplex.linearView();
            for (int i = 0; i < this.linearView().length(); ++i) {
                double otherAbs;
                IComplexNumber n = linear.getComplex(i);
                IComplexNumber otherComplexNumber = otherComplexLinear.getComplex(i);
                double real = n.absoluteValue().doubleValue();
                double diff = Math.abs(real - (otherAbs = otherComplexNumber.absoluteValue().doubleValue()));
                if (diff <= Nd4j.EPS_THRESHOLD) {
                    linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(1.0, 0.0));
                    continue;
                }
                linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(0.0, 0.0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray lt(Number other) {
        return this.dup().lti(other);
    }

    @Override
    public IComplexNDArray lti(Number other) {
        IComplexNDArray linear = this.linearView();
        double val = other.doubleValue();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() < val ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
        }
        return this;
    }

    @Override
    public IComplexNDArray eq(Number other) {
        return this.dup().eqi(other);
    }

    @Override
    public IComplexNDArray eqi(Number other) {
        IComplexNDArray linear = this.linearView();
        double val = other.doubleValue();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() == val ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
        }
        return this;
    }

    @Override
    public IComplexNDArray gt(Number other) {
        return this.dup().gti(other);
    }

    @Override
    public IComplexNDArray gti(Number other) {
        IComplexNDArray linear = this.linearView();
        double val = other.doubleValue();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() > val ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
        }
        return this;
    }

    @Override
    public IComplexNDArray lt(INDArray other) {
        return this.dup().lti(other);
    }

    @Override
    public IComplexNDArray lti(INDArray other) {
        if (other instanceof IComplexNDArray) {
            IComplexNDArray linear = this.linearView();
            IComplexNDArray otherLinear = (IComplexNDArray)other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() < otherLinear.getComplex(i).absoluteValue().doubleValue() ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        } else {
            IComplexNDArray linear = this.linearView();
            INDArray otherLinear = other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() < otherLinear.getDouble(i) ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray eq(INDArray other) {
        return this.dup().eqi(other);
    }

    @Override
    public IComplexNDArray eqi(INDArray other) {
        if (other instanceof IComplexNDArray) {
            IComplexNDArray linear = this.linearView();
            IComplexNDArray otherLinear = (IComplexNDArray)other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() == otherLinear.getComplex(i).absoluteValue().doubleValue() ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        } else {
            IComplexNDArray linear = this.linearView();
            INDArray otherLinear = other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() == otherLinear.getDouble(i) ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray neq(INDArray other) {
        return this.dup().neqi(other);
    }

    @Override
    public IComplexNDArray neq(Number other) {
        return this.dup().neqi(other);
    }

    @Override
    public IComplexNDArray neqi(Number other) {
        IComplexNDArray linear = this.linearView();
        double otherVal = other.doubleValue();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() != otherVal ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
        }
        return this;
    }

    @Override
    public IComplexNDArray neqi(INDArray other) {
        if (other instanceof IComplexNDArray) {
            IComplexNDArray linear = this.linearView();
            IComplexNDArray otherLinear = (IComplexNDArray)other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() != otherLinear.getComplex(i).absoluteValue().doubleValue() ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        } else {
            IComplexNDArray linear = this.linearView();
            INDArray otherLinear = other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() != otherLinear.getDouble(i) ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray gt(INDArray other) {
        return this.dup().gti(other);
    }

    @Override
    public IComplexNDArray gti(INDArray other) {
        if (other instanceof IComplexNDArray) {
            IComplexNDArray linear = this.linearView();
            IComplexNDArray otherLinear = (IComplexNDArray)other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() > otherLinear.getComplex(i).absoluteValue().doubleValue() ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        } else {
            IComplexNDArray linear = this.linearView();
            INDArray otherLinear = other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() > otherLinear.getDouble(i) ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray rdiv(Number n, INDArray result) {
        return this.dup().rdivi(n, result);
    }

    @Override
    public IComplexNDArray rdivi(Number n, INDArray result) {
        return this.rdivi((IComplexNumber)Nd4j.createDouble(n.doubleValue(), 0.0), result);
    }

    @Override
    public IComplexNDArray rsub(Number n, INDArray result) {
        return this.dup().rsubi(n, result);
    }

    @Override
    public IComplexNDArray rsubi(Number n, INDArray result) {
        return this.rsubi((IComplexNumber)Nd4j.createDouble(n.doubleValue(), 0.0), result);
    }

    @Override
    public IComplexNDArray div(Number n, INDArray result) {
        return this.dup().divi(n, result);
    }

    @Override
    public IComplexNDArray divi(Number n, INDArray result) {
        return this.divi((IComplexNumber)Nd4j.createDouble(n.doubleValue(), 0.0), result);
    }

    @Override
    public IComplexNDArray mul(Number n, INDArray result) {
        return this.dup().muli(n, result);
    }

    @Override
    public IComplexNDArray muli(Number n, INDArray result) {
        return this.muli((IComplexNumber)Nd4j.createDouble(n.doubleValue(), 0.0), result);
    }

    @Override
    public IComplexNDArray sub(Number n, INDArray result) {
        return this.dup().subi(n, result);
    }

    @Override
    public IComplexNDArray subi(Number n, INDArray result) {
        return this.subi((IComplexNumber)Nd4j.createDouble(n.doubleValue(), 0.0), result);
    }

    @Override
    public IComplexNDArray add(Number n, INDArray result) {
        return this.dup().addi(n, result);
    }

    @Override
    public IComplexNDArray addi(Number n, INDArray result) {
        return this.addi((IComplexNumber)Nd4j.createDouble(n.doubleValue(), 0.0), result);
    }

    @Override
    public IComplexNDArray dup() {
        IComplexNDArray ret = Nd4j.createComplex(this.shape());
        IComplexNDArray linear = this.linearView();
        IComplexNDArray retLinear = ret.linearView();
        for (int i = 0; i < ret.length(); ++i) {
            retLinear.putScalar(i, linear.getComplex(i));
        }
        return ret;
    }

    @Override
    public IComplexNDArray rsubRowVector(INDArray rowVector) {
        return this.dup().rsubiRowVector(rowVector);
    }

    @Override
    public IComplexNDArray rsubiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 't');
    }

    @Override
    public IComplexNDArray rsubColumnVector(INDArray columnVector) {
        return this.dup().rsubiColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray rsubiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'h');
    }

    @Override
    public IComplexNDArray rdivRowVector(INDArray rowVector) {
        return this.dup().rdiviRowVector(rowVector);
    }

    @Override
    public IComplexNDArray rdiviRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 't');
    }

    @Override
    public IComplexNDArray rdivColumnVector(INDArray columnVector) {
        return this.dup().rdiviColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray rdiviColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 't');
    }

    @Override
    protected IComplexNDArray doRowWise(INDArray rowVector, char operation) {
        if (this.columns() == 1 && rowVector.isScalar()) {
            if (rowVector instanceof IComplexNDArray) {
                IComplexNDArray rowVectorComplex = (IComplexNDArray)rowVector;
                switch (operation) {
                    case 'a': {
                        this.addi(rowVectorComplex.getComplex(0));
                        break;
                    }
                    case 's': {
                        this.subi(rowVectorComplex.getComplex(0));
                        break;
                    }
                    case 'm': {
                        this.muli(rowVectorComplex.getComplex(0));
                        break;
                    }
                    case 'd': {
                        this.divi(rowVectorComplex.getComplex(0));
                        break;
                    }
                    case 'h': {
                        this.rsubi(rowVectorComplex.getComplex(0));
                        break;
                    }
                    case 't': {
                        this.rdivi(rowVectorComplex.getComplex(0));
                    }
                }
            } else {
                switch (operation) {
                    case 'a': {
                        this.addi(rowVector.getDouble(0));
                        break;
                    }
                    case 's': {
                        this.subi(rowVector.getDouble(0));
                        break;
                    }
                    case 'm': {
                        this.muli(rowVector.getDouble(0));
                        break;
                    }
                    case 'd': {
                        this.divi(rowVector.getDouble(0));
                        break;
                    }
                    case 'h': {
                        this.rsubi(rowVector.getDouble(0));
                        break;
                    }
                    case 't': {
                        this.rdivi(rowVector.getDouble(0));
                    }
                }
            }
            return this;
        }
        this.assertRowVector(rowVector);
        block24: for (int i = 0; i < this.rows(); ++i) {
            switch (operation) {
                case 'a': {
                    this.getRow(i).addi(rowVector);
                    continue block24;
                }
                case 's': {
                    this.getRow(i).subi(rowVector);
                    continue block24;
                }
                case 'm': {
                    this.getRow(i).muli(rowVector);
                    continue block24;
                }
                case 'd': {
                    this.getRow(i).divi(rowVector);
                    continue block24;
                }
                case 'h': {
                    this.getRow(i).rsubi(rowVector);
                    continue block24;
                }
                case 't': {
                    this.getRow(i).rdivi(rowVector);
                }
            }
        }
        return this;
    }

    @Override
    protected IComplexNDArray doColumnWise(INDArray columnVector, char operation) {
        if (this.rows() == 1 && columnVector.isScalar()) {
            if (columnVector instanceof IComplexNDArray) {
                IComplexNDArray columnVectorComplex = (IComplexNDArray)columnVector;
                switch (operation) {
                    case 'a': {
                        this.addi(columnVectorComplex.getComplex(0));
                        break;
                    }
                    case 's': {
                        this.subi(columnVectorComplex.getComplex(0));
                        break;
                    }
                    case 'm': {
                        this.muli(columnVectorComplex.getComplex(0));
                        break;
                    }
                    case 'd': {
                        this.divi(columnVectorComplex.getComplex(0));
                        break;
                    }
                    case 'h': {
                        this.rsubi(columnVectorComplex.getComplex(0));
                        break;
                    }
                    case 't': {
                        this.rdivi(columnVectorComplex.getComplex(0));
                    }
                }
            } else {
                switch (operation) {
                    case 'a': {
                        this.addi(columnVector.getDouble(0));
                        break;
                    }
                    case 's': {
                        this.subi(columnVector.getDouble(0));
                        break;
                    }
                    case 'm': {
                        this.muli(columnVector.getDouble(0));
                        break;
                    }
                    case 'd': {
                        this.divi(columnVector.getDouble(0));
                        break;
                    }
                    case 'h': {
                        this.rsubi(columnVector.getDouble(0));
                        break;
                    }
                    case 't': {
                        this.rdivi(columnVector.getDouble(0));
                    }
                }
            }
            return this;
        }
        this.assertColumnVector(columnVector);
        block24: for (int i = 0; i < this.columns(); ++i) {
            IComplexNDArray slice = this.slice(i, 0);
            switch (operation) {
                case 'a': {
                    slice.addi(columnVector);
                    continue block24;
                }
                case 's': {
                    slice.subi(columnVector);
                    continue block24;
                }
                case 'm': {
                    slice.muli(columnVector);
                    continue block24;
                }
                case 'd': {
                    slice.divi(columnVector);
                    continue block24;
                }
                case 'h': {
                    slice.rsubi(columnVector);
                    continue block24;
                }
                case 't': {
                    slice.rdivi(columnVector);
                }
            }
        }
        return this;
    }

    @Override
    public double squaredDistance(INDArray other) {
        double sd = 0.0;
        if (other instanceof IComplexNDArray) {
            IComplexNDArray n = (IComplexNDArray)other;
            IComplexNDArray nLinear = n.linearView();
            for (int i = 0; i < this.length; ++i) {
                IComplexNumber diff = this.linearView().getComplex(i).sub(nLinear.getComplex(i));
                double d = diff.absoluteValue().doubleValue();
                sd += d * d;
            }
            return sd;
        }
        for (int i = 0; i < this.length; ++i) {
            INDArray linear = other.linearView();
            IComplexNumber diff = this.linearView().getComplex(i).sub(linear.getDouble(i));
            double d = diff.absoluteValue().doubleValue();
            sd += d * d;
        }
        return sd;
    }

    @Override
    public double distance2(INDArray other) {
        return Math.sqrt(this.squaredDistance(other));
    }

    @Override
    public double distance1(INDArray other) {
        float d = 0.0f;
        if (other instanceof IComplexNDArray) {
            IComplexNDArray n2 = (IComplexNDArray)other;
            IComplexNDArray n2Linear = n2.linearView();
            for (int i = 0; i < this.length; ++i) {
                IComplexNumber n = this.getComplex(i).sub(n2Linear.getComplex(i));
                d = (float)((double)d + n.absoluteValue().doubleValue());
            }
            return d;
        }
        INDArray linear = other.linearView();
        for (int i = 0; i < this.length; ++i) {
            IComplexNumber n = this.linearView().getComplex(i).sub(linear.getDouble(i));
            d = (float)((double)d + n.absoluteValue().doubleValue());
        }
        return d;
    }

    @Override
    public IComplexNDArray put(NDArrayIndex[] indices, INDArray element) {
        block12: {
            block11: {
                int i;
                if (!Indices.isContiguous(indices)) break block11;
                IComplexNDArray get = this.get(indices);
                IComplexNDArray linear = get.linearView();
                IComplexNDArray imag = element instanceof IComplexNDArray ? (IComplexNDArray)element : Nd4j.createComplex(element);
                IComplexNDArray elementLinear = imag.linearView();
                if (element.isScalar()) {
                    for (i = 0; i < linear.length(); ++i) {
                        linear.putScalar(i, elementLinear.getComplex(0));
                    }
                }
                if (!Shape.shapeEquals(element.shape(), get.shape()) && element.length() > get.length()) break block12;
                for (i = 0; i < elementLinear.length(); ++i) {
                    linear.putScalar(i, elementLinear.getComplex(i));
                }
                break block12;
            }
            if (this.isVector()) {
                assert (indices.length == 1) : "Indices must only be of length 1.";
                assert (element.isScalar() || element.isVector()) : "Unable to assign elements. Element is not a vector.";
                assert (indices[0].length() == element.length()) : "Number of specified elements in index does not match length of element.";
                int[] assign = indices[0].indices();
                IComplexNDArray imag = element instanceof IComplexNDArray ? (IComplexNDArray)element : Nd4j.createComplex(element);
                IComplexNDArray elementLinear = imag.linearView();
                for (int i = 0; i < element.length(); ++i) {
                    this.putScalar(assign[i], elementLinear.getComplex(i));
                }
                return this;
            }
            if (element.isVector()) {
                this.slice(indices[0].indices()[0]).put(Arrays.copyOfRange(indices, 1, indices.length), element);
            } else {
                for (int i = 0; i < element.slices(); ++i) {
                    IComplexNDArray slice = this.slice(indices[0].indices()[i]);
                    slice.put(Arrays.copyOfRange(indices, 1, indices.length), element.slice(i));
                }
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray normmax(int dimension) {
        return Nd4j.createComplex(super.normmax(dimension));
    }

    @Override
    public IComplexNDArray prod(int dimension) {
        return Nd4j.createComplex(super.prod(dimension));
    }

    @Override
    public IComplexNDArray mean(int dimension) {
        return Nd4j.createComplex(super.mean(dimension));
    }

    @Override
    public IComplexNDArray var(int dimension) {
        return Nd4j.createComplex(super.var(dimension));
    }

    @Override
    public IComplexNDArray max(int dimension) {
        return Nd4j.createComplex(super.max(dimension));
    }

    @Override
    public IComplexNDArray sum(int dimension) {
        return Nd4j.createComplex(super.sum(dimension));
    }

    @Override
    public IComplexNDArray min(int dimension) {
        return Nd4j.createComplex(super.min(dimension));
    }

    @Override
    public IComplexNDArray norm1(int dimension) {
        return Nd4j.createComplex(super.norm1(dimension));
    }

    @Override
    public IComplexNDArray std(int dimension) {
        return Nd4j.createComplex(super.std(dimension));
    }

    @Override
    public IComplexNDArray norm2(int dimension) {
        return Nd4j.createComplex(super.norm2(dimension));
    }

    @Override
    public IComplexNDArray put(int i, int j, Number element) {
        return this.put(i, j, Nd4j.scalar(element));
    }

    @Override
    public IComplexNDArray put(int[] indexes, double value) {
        int ix = this.offset;
        if (indexes.length != this.shape.length) {
            throw new IllegalArgumentException("Unable to applyTransformToDestination values: number of indices must be equal to the shape");
        }
        for (int i = 0; i < this.shape.length; ++i) {
            ix += indexes[i] * this.stride[i];
        }
        this.data.put(ix, value);
        return this;
    }

    @Override
    public IComplexNDArray putSlice(int slice, IComplexNDArray put) {
        if (this.isScalar()) {
            assert (put.isScalar()) : "Invalid dimension. Can only insert a scalar in to another scalar";
            this.putScalar(0, put.getDouble(0));
            return this;
        }
        if (this.isVector()) {
            assert (put.isScalar()) : "Invalid dimension on insertion. Can only insert scalars input vectors";
            this.putScalar(slice, put.getDouble(0));
            return this;
        }
        this.assertSlice(put, slice);
        IComplexNDArray view = this.slice(slice);
        if (put.isScalar()) {
            this.putScalar(slice, put.getDouble(0));
        } else if (put.isVector()) {
            for (int i = 0; i < put.length(); ++i) {
                view.putScalar(i, put.getComplex(i));
            }
        } else if (put.shape().length == 2) {
            for (int i = 0; i < put.rows(); ++i) {
                for (int j = 0; j < put.columns(); ++j) {
                    view.put(i, j, put.getDouble(i, j));
                }
            }
        } else {
            assert (put.slices() == view.slices()) : "Slices must be equivalent.";
            for (int i = 0; i < put.slices(); ++i) {
                view.slice(i).putSlice(i, view.slice(i));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray swapAxes(int dimension, int with) {
        int[] shape = ArrayUtil.range(0, this.shape().length);
        shape[dimension] = with;
        shape[with] = dimension;
        return this.permute(shape);
    }

    @Override
    public IComplexNDArray conji() {
        IComplexNDArray reshaped = this.linearView();
        IComplexDouble c = Nd4j.createDouble(0.0, 0.0);
        for (int i = 0; i < this.length; ++i) {
            IComplexNumber conj = reshaped.getComplex(i, c).conj();
            reshaped.putScalar(i, conj);
        }
        return this;
    }

    @Override
    public IComplexNDArray hermitian() {
        IComplexNDArray result = Nd4j.createComplex(this.shape());
        IComplexDouble c = Nd4j.createDouble(0.0, 0.0);
        for (int i = 0; i < this.slices(); ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.putScalar(j, i, this.getComplex(i, j, c).conji());
            }
        }
        return result;
    }

    @Override
    public IComplexNDArray conj() {
        return this.dup().conji();
    }

    @Override
    public INDArray getReal() {
        INDArray result = Nd4j.create(this.shape());
        IComplexNDArray linearView = this.linearView();
        INDArray linearRet = result.linearView();
        for (int i = 0; i < linearView.length(); ++i) {
            linearRet.putScalar(i, linearView.getReal(i));
        }
        return result;
    }

    @Override
    public double getImag(int i) {
        int linear = this.linearIndex(i);
        return this.data.getDouble(linear + 1);
    }

    @Override
    public double getReal(int i) {
        int linear = this.linearIndex(i);
        return this.data.getDouble(linear);
    }

    @Override
    public IComplexNDArray putReal(int rowIndex, int columnIndex, double value) {
        this.data.put(2 * this.index(rowIndex, columnIndex) + this.offset, value);
        return this;
    }

    @Override
    public int linearIndex(int i) {
        int realStride = this.majorStride();
        int idx = this.offset + i * realStride;
        if (idx >= this.data.length()) {
            throw new IllegalArgumentException("Illegal index " + idx + " derived from " + i + " with offset of " + this.offset + " and stride of " + realStride);
        }
        return idx;
    }

    @Override
    public IComplexNDArray putImag(int rowIndex, int columnIndex, double value) {
        this.data.put(this.index(rowIndex, columnIndex) + 1 + this.offset, value);
        return this;
    }

    @Override
    public IComplexNDArray putReal(int i, float v) {
        int idx = this.linearIndex(i);
        this.data.put(idx, v);
        return this;
    }

    @Override
    public IComplexNDArray putImag(int i, float v) {
        int idx = this.linearIndex(i);
        this.data.put(idx * 2 + 1, v);
        return this;
    }

    @Override
    public IComplexNumber getComplex(int i) {
        int idx = this.linearIndex(i);
        return Nd4j.createDouble(this.data.getDouble(idx), this.data.getDouble(idx + 1));
    }

    @Override
    public IComplexNumber getComplex(int i, int j) {
        int idx = this.index(i, j);
        return Nd4j.createDouble(this.data.getDouble(idx), this.data.getDouble(idx + 1));
    }

    @Override
    public INDArray real() {
        INDArray ret = Nd4j.create(this.shape);
        this.copyRealTo(ret);
        return ret;
    }

    @Override
    public INDArray imag() {
        INDArray ret = Nd4j.create(this.shape);
        Nd4j.getBlasWrapper().dcopy(this.length, this.data.asFloat(), 1, 2, ret.data().asFloat(), 0, 1);
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void iterateOverDimension(int dimension, SliceOp op, boolean modify) {
        if (this.isScalar()) {
            if (dimension > 1) {
                throw new IllegalArgumentException("Dimension must be 0 for a scalar");
            }
            DimensionSlice slice = this.vectorForDimensionAndOffset(0, 0);
            op.operate(slice);
            if (!modify || slice.getIndices() == null) return;
            IComplexNDArray result = (IComplexNDArray)slice.getResult();
            for (int i = 0; i < slice.getIndices().length; ++i) {
                this.data.put(slice.getIndices()[i], result.getComplex(i).realComponent().doubleValue());
                this.data.put(slice.getIndices()[i] + 1, result.getComplex(i).imaginaryComponent().doubleValue());
            }
            return;
        } else if (this.isVector()) {
            if (dimension == 0) {
                DimensionSlice slice = this.vectorForDimensionAndOffset(0, 0);
                op.operate(slice);
                if (!modify || slice.getIndices() == null) return;
                IComplexNDArray result = (IComplexNDArray)slice.getResult();
                for (int i = 0; i < slice.getIndices().length; ++i) {
                    this.data.put(slice.getIndices()[i], result.getComplex(i).realComponent().doubleValue());
                    this.data.put(slice.getIndices()[i] + 1, result.getComplex(i).imaginaryComponent().doubleValue());
                }
                return;
            } else {
                if (dimension != 1) throw new IllegalArgumentException("Illegal dimension for vector " + dimension);
                for (int i = 0; i < this.length; ++i) {
                    DimensionSlice slice = this.vectorForDimensionAndOffset(dimension, i);
                    op.operate(slice);
                    if (!modify || slice.getIndices() == null) continue;
                    IComplexNDArray result = (IComplexNDArray)slice.getResult();
                    for (int j = 0; j < slice.getIndices().length; ++j) {
                        this.data.put(slice.getIndices()[j], result.getComplex(j).realComponent().doubleValue());
                        this.data.put(slice.getIndices()[j] + 1, result.getComplex(j).imaginaryComponent().doubleValue());
                    }
                }
            }
            return;
        } else {
            if (dimension >= this.shape.length) {
                throw new IllegalArgumentException("Unable to remove dimension  " + dimension + " was >= shape length");
            }
            int[] shape = ArrayUtil.removeIndex(this.shape, dimension);
            if (dimension == 0) {
                int numTimes = ArrayUtil.prod(shape);
                for (int offset = this.offset; offset < numTimes; offset += 2) {
                    DimensionSlice vector = this.vectorForDimensionAndOffset(dimension, offset);
                    op.operate(vector);
                    if (!modify || vector.getIndices() == null) continue;
                    IComplexNDArray result = (IComplexNDArray)vector.getResult();
                    for (int i = 0; i < vector.getIndices().length; ++i) {
                        this.data.put(vector.getIndices()[i], result.getComplex(i).realComponent().doubleValue());
                        this.data.put(vector.getIndices()[i] + 1, result.getComplex(i).imaginaryComponent().doubleValue());
                    }
                }
                return;
            } else {
                float[] data2 = new float[ArrayUtil.prod(shape)];
                int dataIter = 0;
                int[] sliceIndices = this.endsForSlices();
                int currOffset = 0;
                int offset = this.offset;
                while (dataIter < data2.length && currOffset < sliceIndices.length) {
                    DimensionSlice pair = this.vectorForDimensionAndOffsetPair(dimension, offset, sliceIndices[currOffset]);
                    op.operate(pair);
                    if (modify && pair.getIndices() != null) {
                        IComplexNDArray result = (IComplexNDArray)pair.getResult();
                        for (int i = 0; i < pair.getIndices().length; ++i) {
                            this.data.put(pair.getIndices()[i], result.getComplex(i).realComponent().doubleValue());
                            this.data.put(pair.getIndices()[i] + 1, result.getComplex(i).imaginaryComponent().doubleValue());
                        }
                    }
                    if (!pair.isNextSlice()) continue;
                    if (++currOffset >= sliceIndices.length) return;
                    offset = sliceIndices[currOffset];
                }
            }
        }
    }

    public DimensionSlice vectorForDimensionAndOffsetPair(int dimension, int offset, int currOffsetForSlice) {
        int count = 0;
        IComplexNDArray ret = Nd4j.createComplex(new int[]{this.shape[dimension]});
        boolean newSlice = false;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int j = offset;
        while (count < this.shape[dimension]) {
            IComplexDouble d = Nd4j.createDouble(this.data.getDouble(j), this.data.getDouble(j + 1));
            indices.add(j);
            ret.putScalar(count++, (IComplexNumber)d);
            if (j >= currOffsetForSlice) {
                newSlice = true;
            }
            j += this.stride[dimension];
        }
        return new DimensionSlice(newSlice, ret, ArrayUtil.toArray(indices));
    }

    @Override
    public DimensionSlice vectorForDimensionAndOffset(int dimension, int offset) {
        if (this.isScalar() && dimension == 0 && offset == 0) {
            return new DimensionSlice(false, Nd4j.complexScalar(this.getDouble(offset)), new int[]{offset});
        }
        if (this.isVector()) {
            if (dimension == 0) {
                int[] indices = new int[this.length];
                for (int i = 0; i < indices.length; ++i) {
                    indices[i] = i;
                }
                return new DimensionSlice(false, this.dup(), indices);
            }
            if (dimension == 1) {
                return new DimensionSlice(false, Nd4j.complexScalar(this.getDouble(offset)), new int[]{offset});
            }
            throw new IllegalArgumentException("Illegal dimension for vector " + dimension);
        }
        int count = 0;
        IComplexNDArray ret = Nd4j.createComplex(new int[]{this.shape[dimension]});
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int j = offset;
        while (count < this.shape[dimension]) {
            IComplexDouble d = Nd4j.createDouble(this.data.getDouble(j), this.data.getDouble(j + 1));
            ret.putScalar(count++, (IComplexNumber)d);
            indices.add(j);
            j += this.stride[dimension];
        }
        return new DimensionSlice(false, ret, ArrayUtil.toArray(indices));
    }

    @Override
    public IComplexNDArray put(int i, IComplexNDArray element) {
        if (element == null) {
            throw new IllegalArgumentException("Unable to insert null element");
        }
        assert (element.isScalar()) : "Unable to insert non scalar element";
        int idx = this.linearIndex(i);
        IComplexNumber n = element.getComplex(0);
        this.data.put(idx, n.realComponent().doubleValue());
        this.data.put(idx + 1, n.imaginaryComponent().doubleValue());
        return this;
    }

    private ComplexIterationResult op(int dimension, int offset, Ops.DimensionOp op, int currOffsetForSlice) {
        double[] dim = new double[this.shape[dimension]];
        int count = 0;
        boolean newSlice = false;
        int j = offset;
        while (count < dim.length) {
            double d = this.data.getDouble(j);
            dim[count++] = d;
            if (j >= currOffsetForSlice) {
                newSlice = true;
            }
            j += this.stride[dimension];
        }
        IComplexNDArray r = Nd4j.createComplex(dim);
        IComplexDouble r2 = this.reduceVector(op, r);
        return new ComplexIterationResult(newSlice, r2);
    }

    private IComplexNumber op(int dimension, int offset, Ops.DimensionOp op) {
        double[] dim = new double[this.shape[dimension]];
        int count = 0;
        int j = offset;
        while (count < dim.length) {
            double d = this.data.getDouble(j);
            dim[count++] = d;
            j += this.stride[dimension];
        }
        return this.reduceVector(op, Nd4j.createComplex(dim));
    }

    private IComplexDouble reduceVector(Ops.DimensionOp op, IComplexNDArray vector) {
        switch (op) {
            case SUM: {
                return (IComplexDouble)vector.sum(Integer.MAX_VALUE).element();
            }
            case MEAN: {
                return (IComplexDouble)vector.mean(Integer.MAX_VALUE).element();
            }
            case NORM_1: {
                return Nd4j.createDouble((Double)vector.norm1(Integer.MAX_VALUE).element(), 0.0);
            }
            case NORM_2: {
                return Nd4j.createDouble((Double)vector.norm2(Integer.MAX_VALUE).element(), 0.0);
            }
            case NORM_MAX: {
                return Nd4j.createDouble((Double)vector.normmax(Integer.MAX_VALUE).element(), 0.0);
            }
        }
        throw new IllegalArgumentException("Illegal operation");
    }

    @Override
    public IComplexNDArray getScalar(int ... indexes) {
        int ix = this.offset;
        for (int i = 0; i < this.shape.length; ++i) {
            ix += indexes[i] * this.stride[i];
        }
        return Nd4j.scalar(Nd4j.createDouble(this.data.getDouble(ix), this.data.getDouble(ix + 1)));
    }

    @Override
    public void checkDimensions(INDArray other) {
    }

    @Override
    public int[] endsForSlices() {
        int[] ret = new int[this.slices()];
        int currOffset = this.offset;
        for (int i = 0; i < this.slices(); ++i) {
            ret[i] = currOffset;
            currOffset += this.stride[0];
        }
        return ret;
    }

    @Override
    public IComplexNDArray reduce(Ops.DimensionOp op, int dimension) {
        if (this.isScalar()) {
            return this;
        }
        if (this.isVector()) {
            return Nd4j.scalar(this.reduceVector(op, this));
        }
        int[] shape = ArrayUtil.removeIndex(this.shape, dimension);
        if (dimension == 0) {
            double[] data2 = new double[ArrayUtil.prod(shape) * 2];
            int dataIter = 0;
            int numTimes = ArrayUtil.prod(shape);
            for (int offset = this.offset; offset < numTimes; ++offset) {
                IComplexNumber reduce = this.op(dimension, offset, op);
                data2[dataIter++] = reduce.realComponent().doubleValue();
                data2[dataIter++] = reduce.imaginaryComponent().doubleValue();
            }
            return Nd4j.createComplex(data2, shape);
        }
        double[] data2 = new double[ArrayUtil.prod(shape)];
        int dataIter = 0;
        int[] sliceIndices = this.endsForSlices();
        int currOffset = 0;
        int numTimes = ArrayUtil.prod(shape);
        for (int offset = this.offset; offset < numTimes && dataIter < data2.length && currOffset < sliceIndices.length; ++offset) {
            ComplexIterationResult pair = this.op(dimension, offset, op, sliceIndices[currOffset]);
            IComplexNumber reduce = pair.getNumber();
            data2[dataIter++] = reduce.realComponent().doubleValue();
            data2[dataIter++] = reduce.imaginaryComponent().doubleValue();
            if (!pair.isNextIteration()) continue;
            offset = sliceIndices[currOffset];
            numTimes += sliceIndices[currOffset];
            ++currOffset;
        }
        return Nd4j.createComplex(data2, shape);
    }

    @Override
    public IComplexNDArray putSlice(int slice, INDArray put) {
        if (this.isScalar()) {
            assert (put.isScalar()) : "Invalid dimension. Can only insert a scalar in to another scalar";
            this.put(0, put.getScalar(0));
            return this;
        }
        if (this.isVector()) {
            assert (put.isScalar()) : "Invalid dimension on insertion. Can only insert scalars input vectors";
            this.put(slice, put.getScalar(0));
            return this;
        }
        this.assertSlice(put, slice);
        IComplexNDArray view = this.slice(slice);
        if (put.isScalar()) {
            this.put(slice, put.getScalar(0));
        } else if (put.isVector()) {
            for (int i = 0; i < put.length(); ++i) {
                view.put(i, put.getScalar(i));
            }
        } else if (put.shape().length == 2) {
            if (put instanceof IComplexNDArray) {
                IComplexNDArray complexPut = (IComplexNDArray)put;
                for (int i = 0; i < put.rows(); ++i) {
                    for (int j = 0; j < put.columns(); ++j) {
                        view.putScalar(i, j, complexPut.getComplex(i, j));
                    }
                }
            }
            for (int i = 0; i < put.rows(); ++i) {
                for (int j = 0; j < put.columns(); ++j) {
                    view.putScalar(i, j, Nd4j.createDouble(put.getDouble(i, j), 0.0));
                }
            }
        } else {
            assert (put.slices() == view.slices()) : "Slices must be equivalent.";
            for (int i = 0; i < put.slices(); ++i) {
                view.slice(i).putSlice(i, view.slice(i));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray subArray(int[] offsets, int[] shape, int[] stride) {
        int n = shape.length;
        if (offsets.length != n) {
            throw new IllegalArgumentException("Invalid offset " + Arrays.toString(offsets));
        }
        if (shape.length != n) {
            throw new IllegalArgumentException("Invalid shape " + Arrays.toString(shape));
        }
        if (Arrays.equals(shape, this.shape)) {
            if (ArrayUtil.isZero(offsets)) {
                return this;
            }
            throw new IllegalArgumentException("Invalid subArray offsets");
        }
        return Nd4j.createComplex(this.data, Arrays.copyOf(shape, shape.length), stride, this.offset + ArrayUtil.dotProduct(offsets, stride));
    }

    @Override
    public int majorStride() {
        if (this.offset == 0) {
            return super.majorStride();
        }
        return super.majorStride();
    }

    @Override
    public IComplexNDArray put(int[] indices, INDArray element) {
        if (!element.isScalar()) {
            throw new IllegalArgumentException("Unable to insert anything but a scalar");
        }
        int ix = this.offset;
        if (indices.length != this.shape.length) {
            throw new IllegalArgumentException("Unable to transform values: number of indices must be equal to the shape");
        }
        for (int i = 0; i < this.shape.length; ++i) {
            ix += indices[i] * this.stride[i];
        }
        if (element instanceof IComplexNDArray) {
            IComplexNumber element2 = ((IComplexNDArray)element).getComplex(0);
            this.data.put(ix, element2.realComponent().doubleValue());
            this.data.put(ix + 1, element2.imaginaryComponent().doubleValue());
        } else {
            double element2 = element.getDouble(0);
            this.data.put(ix, element2);
            this.data.put(ix + 1, 0);
        }
        return this;
    }

    @Override
    public IComplexNDArray put(int i, int j, INDArray element) {
        return this.put(new int[]{i, j}, element);
    }

    @Override
    public IComplexNDArray slice(int slice) {
        IComplexNDArray ret;
        int offset = this.offset + slice * this.majorStride();
        if (this.shape.length == 0) {
            throw new IllegalArgumentException("Can't slice a 0-d ComplexNDArray");
        }
        if (this.shape.length == 1) {
            ret = Nd4j.createComplex(this.data, ArrayUtil.empty(), ArrayUtil.empty(), offset, this.ordering);
        } else if (this.shape.length == 2) {
            ret = Nd4j.createComplex(this.data, ArrayUtil.of(this.shape[1]), Arrays.copyOfRange(this.stride, 1, this.stride.length), offset, this.ordering);
        } else {
            if (offset >= this.data.length()) {
                throw new IllegalArgumentException("Offset index is > data.length");
            }
            ret = Nd4j.createComplex(this.data, Arrays.copyOfRange(this.shape, 1, this.shape.length), Arrays.copyOfRange(this.stride, 1, this.stride.length), offset, this.ordering);
        }
        return ret;
    }

    @Override
    public IComplexNDArray slice(int slice, int dimension) {
        int offset = this.offset + dimension * this.stride[slice];
        if (this.offset == 0) {
            offset *= 2;
        }
        if (this.shape.length == 2) {
            int st = this.stride[1];
            if (st == 1) {
                return Nd4j.createComplex(this.data, new int[]{this.shape[dimension]}, offset, this.ordering);
            }
            return Nd4j.createComplex(this.data, new int[]{this.shape[dimension]}, new int[]{st}, offset);
        }
        if (slice == 0) {
            return this.slice(dimension);
        }
        return Nd4j.createComplex(this.data, ArrayUtil.removeIndex(this.shape, dimension), ArrayUtil.removeIndex(this.stride, dimension), offset, this.ordering);
    }

    @Override
    protected void initShape(int[] shape) {
        this.shape = shape;
        if (this.shape.length == 1) {
            this.rows = 1;
            this.columns = this.shape[0];
        } else if (this.shape().length == 2) {
            if (shape[0] == 1) {
                this.shape = new int[1];
                this.shape[0] = shape[1];
                this.rows = 1;
                this.columns = shape[1];
            } else {
                this.rows = shape[0];
                this.columns = shape[1];
            }
        } else if (this.shape.length == 1) {
            this.columns = this.shape[0];
            this.rows = 1;
        }
        if (this.ordering == '\u0000') {
            this.ordering = Nd4j.order().charValue();
        }
        this.length = ArrayUtil.prod(this.shape);
        if (this.stride == null) {
            this.stride = this.ordering == 'f' ? ArrayUtil.calcStridesFortran(this.shape, 2) : ArrayUtil.calcStrides(this.shape, 2);
        }
        if (this.stride.length != this.shape.length) {
            this.stride = this.ordering == 'f' ? ArrayUtil.calcStridesFortran(this.shape, 2) : ArrayUtil.calcStrides(this.shape, 2);
        }
    }

    @Override
    protected INDArray newShape(int[] newShape, char ordering) {
        if (Arrays.equals(newShape, this.shape())) {
            return this;
        }
        if (Shape.isVector(newShape) && this.isVector()) {
            if (this.isRowVector() && Shape.isColumnVectorShape(newShape)) {
                return Nd4j.createComplex(this.data, newShape, new int[]{this.stride[0], 1}, this.offset);
            }
            if (this.isColumnVector() && Shape.isRowVectorShape(newShape)) {
                return Nd4j.createComplex(this.data, newShape, new int[]{this.stride[1]}, this.offset);
            }
        }
        IComplexNDArray newCopy = this;
        int[] newStrides = null;
        if (this.shape().length > 1 && (ordering == 'c' && this.ordering != 'c' || ordering == 'f' && this.ordering != 'f') && (newStrides = this.noCopyReshape(newShape, ordering)) == null) {
            newCopy = Nd4j.createComplex(this.shape(), ordering);
            for (int i = 0; i < this.vectorsAlongDimension(0); ++i) {
                IComplexNDArray copyFrom = this.vectorAlongDimension(i, 0);
                IComplexNDArray copyTo = newCopy.vectorAlongDimension(i, 0);
                for (int j = 0; j < copyFrom.length(); ++j) {
                    copyTo.putScalar(j, copyFrom.getDouble(i));
                }
            }
        }
        if (newStrides == null) {
            newStrides = Nd4j.getComplexStrides(newShape, ordering);
        }
        return Nd4j.createComplex(newCopy.data(), newShape, newStrides, this.offset);
    }

    @Override
    public IComplexNDArray repmat(int[] shape) {
        int[] newShape = ArrayUtil.copy(this.shape());
        assert (shape.length <= newShape.length) : "Illegal shape: The passed in shape must be <= the current shape length";
        for (int i = 0; i < shape.length; ++i) {
            int n = i;
            newShape[n] = newShape[n] * shape[i];
        }
        IComplexNDArray result = Nd4j.createComplex(newShape);
        if (this.isScalar()) {
            for (int i = 0; i < result.length(); ++i) {
                result.put(i, this.getScalar(0));
            }
        } else if (this.isMatrix()) {
            for (int c = 0; c < this.shape()[1]; ++c) {
                for (int r = 0; r < this.shape()[0]; ++r) {
                    for (int i = 0; i < this.rows(); ++i) {
                        for (int j = 0; j < this.columns(); ++j) {
                            result.put(r * this.rows() + i, c * this.columns() + j, this.getScalar(i, j));
                        }
                    }
                }
            }
        } else {
            int[] sliceRepmat = ArrayUtil.removeIndex(shape, 0);
            for (int i = 0; i < result.slices(); ++i) {
                result.putSlice(i, this.repmat(sliceRepmat));
            }
        }
        return result;
    }

    @Override
    public IComplexNDArray assign(IComplexNDArray arr) {
        if (!arr.isScalar()) {
            LinAlgExceptions.assertSameShape(this, arr);
        }
        IComplexNDArray linear = this.linearView();
        IComplexNDArray otherLinear = arr.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, otherLinear.getComplex(i));
        }
        return this;
    }

    @Override
    public void assign(IComplexNumber aDouble) {
        IComplexNDArray linear = this.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, aDouble);
        }
    }

    @Override
    public IComplexNDArray getRows(int[] rindices) {
        INDArray rows = Nd4j.create(rindices.length, this.columns());
        for (int i = 0; i < rindices.length; ++i) {
            rows.putRow(i, this.getRow(rindices[i]));
        }
        return (IComplexNDArray)rows;
    }

    @Override
    public IComplexNDArray put(NDArrayIndex[] indices, IComplexNumber element) {
        return this.put(indices, Nd4j.scalar(element));
    }

    @Override
    public IComplexNDArray put(NDArrayIndex[] indices, IComplexNDArray element) {
        block12: {
            block11: {
                if (!Indices.isContiguous(indices)) break block11;
                IComplexNDArray get = this.get(indices);
                IComplexNDArray linear = get.linearView();
                if (element.isScalar()) {
                    for (int i = 0; i < linear.length(); ++i) {
                        linear.putScalar(i, element.getComplex(0));
                    }
                }
                if (!Shape.shapeEquals(element.shape(), get.shape()) && element.length() > get.length()) break block12;
                IComplexNDArray elementLinear = element.linearView();
                for (int i = 0; i < elementLinear.length(); ++i) {
                    linear.putScalar(i, elementLinear.getComplex(i));
                }
                break block12;
            }
            if (this.isVector()) {
                assert (indices.length == 1) : "Indices must only be of length 1.";
                assert (element.isScalar() || element.isVector()) : "Unable to assign elements. Element is not a vector.";
                assert (indices[0].length() == element.length()) : "Number of specified elements in index does not match length of element.";
                int[] assign = indices[0].indices();
                for (int i = 0; i < element.length(); ++i) {
                    this.putScalar(assign[i], element.getComplex(i));
                }
                return this;
            }
            if (element.isVector()) {
                this.slice(indices[0].indices()[0]).put(Arrays.copyOfRange(indices, 1, indices.length), element);
            } else {
                for (int i = 0; i < element.slices(); ++i) {
                    IComplexNDArray slice = this.slice(indices[0].indices()[i]);
                    slice.put(Arrays.copyOfRange(indices, 1, indices.length), (INDArray)element.slice(i));
                }
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray put(NDArrayIndex[] indices, Number element) {
        return this.put(indices, Nd4j.scalar(element));
    }

    @Override
    public IComplexNDArray putScalar(int i, IComplexNumber value) {
        int idx = this.linearIndex(i);
        this.data.put(idx, value.realComponent().doubleValue());
        this.data.put(idx + 1, value.imaginaryComponent().doubleValue());
        return this;
    }

    @Override
    public IComplexNDArray vectorAlongDimension(int index, int dimension) {
        assert (dimension <= this.shape.length) : "Invalid dimension " + dimension;
        if (this.ordering == 'c') {
            if (dimension == this.shape.length - 1 && dimension != 0) {
                if (this.size(dimension) == 1) {
                    return Nd4j.createComplex(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index * 2);
                }
                return Nd4j.createComplex(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index * this.stride[0]);
            }
            if (dimension == 0) {
                return Nd4j.createComplex(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index * 2);
            }
            if (this.size(dimension) == 0) {
                return Nd4j.createComplex(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index * 2);
            }
            return Nd4j.createComplex(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index * 2 * this.stride[0]);
        }
        if (this.ordering == 'f') {
            if (dimension == this.shape.length - 1 && dimension != 0) {
                if (this.size(dimension) == 1) {
                    return Nd4j.createComplex(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index * 2);
                }
                return Nd4j.createComplex(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index * 2 * this.stride[0]);
            }
            if (this.size(dimension) == 1) {
                return Nd4j.createComplex(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index * 2);
            }
            return Nd4j.createComplex(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index * 2 * this.stride[0]);
        }
        throw new IllegalStateException("Illegal ordering..none declared");
    }

    @Override
    public IComplexNDArray cumsumi(int dimension) {
        if (this.isVector()) {
            IComplexDouble s = Nd4j.createDouble(0.0, 0.0);
            for (int i = 0; i < this.length; ++i) {
                s.addi(this.getComplex(i));
                this.putScalar(i, (IComplexNumber)s);
            }
        } else {
            if (dimension == Integer.MAX_VALUE || dimension == this.shape.length - 1) {
                IComplexNDArray flattened = this.ravel().dup();
                IComplexNumber prevVal = flattened.getComplex(0);
                for (int i = 1; i < flattened.length(); ++i) {
                    IComplexNumber d = prevVal.add(flattened.getComplex(i));
                    flattened.putScalar(i, d);
                    prevVal = d;
                }
                return flattened;
            }
            for (int i = 0; i < this.vectorsAlongDimension(dimension); ++i) {
                IComplexNDArray vec = this.vectorAlongDimension(i, dimension);
                vec.cumsumi(0);
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray dimShuffle(Object[] rearrange, int[] newOrder, boolean[] broadCastable) {
        int i;
        assert (broadCastable.length == this.shape.length) : "The broadcastable dimensions must be the same length as the current shape";
        boolean broadcast = false;
        HashSet<Object> set = new HashSet<Object>();
        for (int i2 = 0; i2 < rearrange.length; ++i2) {
            set.add(rearrange[i2]);
            if (rearrange[i2] instanceof Integer) {
                Integer j = (Integer)rearrange[i2];
                if (j < broadCastable.length) continue;
                throw new IllegalArgumentException("Illegal dimension, dimension must be < broadcastable.length (aka the real dimensions");
            }
            if (rearrange[i2] instanceof Character) {
                Character c = (Character)rearrange[i2];
                if (c.charValue() != 'x') {
                    throw new IllegalArgumentException("Illegal input: Must be x");
                }
                broadcast = true;
                continue;
            }
            throw new IllegalArgumentException("Only characters and integers allowed");
        }
        if (!broadcast) {
            int[] ret = new int[rearrange.length];
            for (int i3 = 0; i3 < ret.length; ++i3) {
                ret[i3] = (Integer)rearrange[i3];
            }
            return this.permute(ret);
        }
        ArrayList<Integer> drop = new ArrayList<Integer>();
        for (int i4 = 0; i4 < broadCastable.length; ++i4) {
            if (set.contains(i4)) continue;
            if (broadCastable[i4]) {
                drop.add(i4);
                continue;
            }
            throw new IllegalArgumentException("We can't drop the given dimension because its not broadcastable");
        }
        int[] shuffle = new int[broadCastable.length];
        int count = 0;
        for (int i5 = 0; i5 < rearrange.length; ++i5) {
            if (!(rearrange[i5] instanceof Integer)) continue;
            shuffle[count++] = (Integer)rearrange[i5];
        }
        ArrayList<Integer> augment = new ArrayList<Integer>();
        for (int i6 = 0; i6 < rearrange.length; ++i6) {
            if (!(rearrange[i6] instanceof Character)) continue;
            augment.add(i6);
        }
        Integer[] augmentDims = augment.toArray(new Integer[1]);
        count = 0;
        int[] newShape = new int[shuffle.length + drop.size()];
        for (int i7 = 0; i7 < newShape.length; ++i7) {
            newShape[count++] = i7 < shuffle.length ? shuffle[i7] : (Integer)drop.get(i7);
        }
        IComplexNDArray ret = this.permute(newShape);
        ArrayList<Integer> newDims = new ArrayList<Integer>();
        int[] shape = Arrays.copyOfRange(ret.shape(), 0, shuffle.length);
        for (i = 0; i < shape.length; ++i) {
            newDims.add(shape[i]);
        }
        for (i = 0; i < augmentDims.length; ++i) {
            newDims.add(augmentDims[i], 1);
        }
        int[] toReshape = ArrayUtil.toArray(newDims);
        ret = ret.reshape(toReshape);
        return ret;
    }

    @Override
    public IComplexNDArray cumsum(int dimension) {
        return this.dup().cumsumi(dimension);
    }

    @Override
    public INDArray assign(INDArray arr) {
        return this.assign((IComplexNDArray)arr);
    }

    @Override
    public IComplexNDArray putScalar(int i, double value) {
        return this.put(i, Nd4j.scalar(value));
    }

    @Override
    public INDArray putScalar(int[] i, double value) {
        super.putScalar(i, value);
        return this.putScalar(i, Nd4j.createComplexNumber(value, 0));
    }

    @Override
    public INDArray putScalar(int[] indexes, IComplexNumber complexNumber) {
        int ix = this.offset;
        for (int i = 0; i < this.shape.length; ++i) {
            ix += indexes[i] * this.stride[i];
        }
        this.data.put(ix, complexNumber.asFloat().realComponent().doubleValue());
        this.data.put(ix + 1, complexNumber.asFloat().imaginaryComponent().doubleValue());
        return this;
    }

    @Override
    public IComplexNDArray neg() {
        return this.dup().negi();
    }

    @Override
    public IComplexNDArray negi() {
        return Transforms.neg(this);
    }

    @Override
    public IComplexNDArray rdiv(Number n) {
        return this.rdiv(n, (INDArray)this);
    }

    @Override
    public IComplexNDArray rdivi(Number n) {
        return this.rdivi(n, (INDArray)this);
    }

    @Override
    public IComplexNDArray rsub(Number n) {
        return this.rsub(n, (INDArray)this);
    }

    @Override
    public IComplexNDArray rsubi(Number n) {
        return this.rsubi(n, (INDArray)this);
    }

    @Override
    public IComplexNDArray div(Number n) {
        return this.dup().divi(n);
    }

    @Override
    public IComplexNDArray divi(Number n) {
        return this.divi(Nd4j.complexScalar(n));
    }

    @Override
    public IComplexNDArray mul(Number n) {
        return this.dup().muli(n);
    }

    @Override
    public IComplexNDArray muli(Number n) {
        return this.muli(Nd4j.complexScalar(n));
    }

    @Override
    public IComplexNDArray sub(Number n) {
        return this.dup().subi(n);
    }

    @Override
    public IComplexNDArray subi(Number n) {
        return this.subi(Nd4j.complexScalar(n));
    }

    @Override
    public IComplexNDArray add(Number n) {
        return this.dup().addi(n);
    }

    @Override
    public IComplexNDArray addi(Number n) {
        return this.addi(Nd4j.complexScalar(n));
    }

    @Override
    public IComplexNDArray get(NDArrayIndex ... indexes) {
        int[] strides;
        indexes = Indices.adjustIndices(this.shape(), indexes);
        int[] offsets = Indices.offsets(indexes);
        int[] shape = Indices.shape(this.shape(), indexes);
        if (ArrayUtil.prod(shape) > this.length()) {
            return this;
        }
        if (!Indices.isContiguous(indexes)) {
            IComplexNDArray ret = Nd4j.createComplex(shape);
            if (ret.isVector() && this.isVector()) {
                int[] indices = indexes[0].indices();
                for (int i = 0; i < ret.length(); ++i) {
                    ret.putScalar(i, this.getComplex(indices[i]));
                }
                return ret;
            }
            for (int i = 0; i < ret.slices(); ++i) {
                IComplexNDArray putSlice = this.slice(i).get(Arrays.copyOfRange(indexes, 1, indexes.length));
                ret.putSlice(i, putSlice);
            }
            return ret;
        }
        int[] nArray = strides = this.ordering == 'f' ? ArrayUtil.calcStridesFortran(shape, 2) : ArrayUtil.copy(this.stride());
        if (offsets.length != shape.length) {
            offsets = Arrays.copyOfRange(offsets, 0, shape.length);
        }
        if (strides.length != shape.length) {
            strides = Arrays.copyOfRange(offsets, 0, shape.length);
        }
        return this.subArray(offsets, shape, strides);
    }

    @Override
    public IComplexNDArray cond(Condition condition) {
        return this.dup().condi(condition);
    }

    @Override
    public IComplexNDArray condi(Condition condition) {
        IComplexNDArray linear = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            boolean met = condition.apply(linear.getComplex(i));
            IComplexNumber put = Nd4j.createComplexNumber(met ? 1 : 0, 0);
            linear.putScalar(i, put);
        }
        return this;
    }

    @Override
    public IComplexNDArray getColumns(int[] cindices) {
        IComplexNDArray rows = Nd4j.createComplex(this.rows(), cindices.length);
        for (int i = 0; i < cindices.length; ++i) {
            rows.putColumn(i, this.getColumn(cindices[i]));
        }
        return rows;
    }

    @Override
    public IComplexNDArray putRow(int row, INDArray toPut) {
        assert (toPut.isVector() && toPut.length() == this.columns) : "Illegal length for row " + toPut.length() + " should have been " + this.columns;
        IComplexNDArray r = this.getRow(row);
        if (toPut instanceof IComplexNDArray) {
            IComplexNDArray putComplex = (IComplexNDArray)toPut;
            for (int i = 0; i < r.length(); ++i) {
                r.putScalar(i, putComplex.getComplex(i));
            }
        } else {
            for (int i = 0; i < r.length(); ++i) {
                r.putScalar(i, (IComplexNumber)Nd4j.createDouble(toPut.getDouble(i), 0.0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray putColumn(int column, INDArray toPut) {
        assert (toPut.isVector() && toPut.length() == this.rows) : "Illegal length for row " + toPut.length() + " should have been " + this.columns;
        IComplexNDArray r = this.getColumn(column);
        if (toPut instanceof IComplexNDArray) {
            IComplexNDArray putComplex = (IComplexNDArray)toPut;
            for (int i = 0; i < r.length(); ++i) {
                IComplexNumber n = putComplex.getComplex(i);
                r.putScalar(i, n);
            }
        } else {
            for (int i = 0; i < r.length(); ++i) {
                r.putScalar(i, (IComplexNumber)Nd4j.createDouble(toPut.getDouble(i), 0.0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray getScalar(int row, int column) {
        return this.getScalar(new int[]{row, column});
    }

    @Override
    public IComplexNDArray getScalar(int i) {
        int idx = this.linearIndex(i);
        return Nd4j.scalar(Nd4j.createDouble(this.data.getDouble(idx), this.data.getDouble(idx + 1)));
    }

    @Override
    public IComplexNDArray put(int i, INDArray element) {
        if (element == null) {
            throw new IllegalArgumentException("Unable to insert null element");
        }
        assert (element.isScalar()) : "Unable to insert non scalar element";
        if (element instanceof IComplexNDArray) {
            IComplexNDArray n1 = (IComplexNDArray)element;
            IComplexNumber n = n1.getComplex(0);
            this.put(i, n);
        } else {
            this.putScalar(i, (IComplexNumber)Nd4j.createDouble(element.getDouble(0), 0.0));
        }
        return this;
    }

    private void put(int i, float element) {
        int idx = this.linearIndex(i);
        this.data.put(idx, element);
        this.data.put(idx + 1, 0.0);
    }

    public void put(int i, IComplexNumber element) {
        int idx = this.linearIndex(i);
        this.data.put(idx, element.realComponent().doubleValue());
        this.data.put(idx + 1, element.imaginaryComponent().doubleValue());
    }

    @Override
    public IComplexNDArray diviColumnVector(INDArray columnVector) {
        for (int i = 0; i < this.columns(); ++i) {
            this.getColumn(i).divi(columnVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray divColumnVector(INDArray columnVector) {
        return this.dup().diviColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray diviRowVector(INDArray rowVector) {
        for (int i = 0; i < this.rows(); ++i) {
            this.getRow(i).divi(rowVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray divRowVector(INDArray rowVector) {
        return this.dup().diviRowVector(rowVector);
    }

    @Override
    public IComplexNDArray muliColumnVector(INDArray columnVector) {
        for (int i = 0; i < this.columns(); ++i) {
            this.getColumn(i).muli(columnVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray mulColumnVector(INDArray columnVector) {
        return this.dup().muliColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray muliRowVector(INDArray rowVector) {
        for (int i = 0; i < this.rows(); ++i) {
            this.getRow(i).muli(rowVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray mulRowVector(INDArray rowVector) {
        return this.dup().muliRowVector(rowVector);
    }

    @Override
    public IComplexNDArray subiColumnVector(INDArray columnVector) {
        for (int i = 0; i < this.columns(); ++i) {
            this.getColumn(i).subi(columnVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray subColumnVector(INDArray columnVector) {
        return this.dup().subiColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray subiRowVector(INDArray rowVector) {
        for (int i = 0; i < this.rows(); ++i) {
            this.getRow(i).subi(rowVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray subRowVector(INDArray rowVector) {
        return this.dup().subiRowVector(rowVector);
    }

    @Override
    public IComplexNDArray addiColumnVector(INDArray columnVector) {
        for (int i = 0; i < this.columns(); ++i) {
            this.getColumn(i).addi(columnVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray addColumnVector(INDArray columnVector) {
        return this.dup().addiColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray addiRowVector(INDArray rowVector) {
        for (int i = 0; i < this.rows(); ++i) {
            this.getRow(i).addi(rowVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray addRowVector(INDArray rowVector) {
        return this.dup().addiRowVector(rowVector);
    }

    @Override
    public IComplexNDArray mmul(INDArray other) {
        int[] shape = new int[]{this.rows(), other.columns()};
        return this.mmuli(other, Nd4j.createComplex(shape));
    }

    @Override
    public IComplexNDArray mmul(INDArray other, INDArray result) {
        return this.dup().mmuli(other, result);
    }

    @Override
    public IComplexNDArray div(INDArray other) {
        return this.dup().divi(other);
    }

    @Override
    public IComplexNDArray div(INDArray other, INDArray result) {
        return this.dup().divi(other, result);
    }

    @Override
    public IComplexNDArray mul(INDArray other) {
        return this.dup().muli(other);
    }

    @Override
    public IComplexNDArray mul(INDArray other, INDArray result) {
        return this.dup().muli(other, result);
    }

    @Override
    public IComplexNDArray sub(INDArray other) {
        return this.dup().subi(other);
    }

    @Override
    public IComplexNDArray sub(INDArray other, INDArray result) {
        return this.dup().subi(other, result);
    }

    @Override
    public IComplexNDArray add(INDArray other) {
        return this.dup().addi(other);
    }

    @Override
    public IComplexNDArray add(INDArray other, INDArray result) {
        return this.dup().addi(other, result);
    }

    @Override
    public IComplexNDArray mmuli(INDArray other) {
        return this.mmuli(other, this);
    }

    @Override
    public IComplexNDArray mmuli(INDArray other, INDArray result) {
        IComplexNDArray otherArray = (IComplexNDArray)other;
        IComplexNDArray resultArray = (IComplexNDArray)result;
        if (other.shape().length > 2) {
            for (int i = 0; i < other.slices(); ++i) {
                resultArray.putSlice(i, this.slice(i).mmul(otherArray.slice(i)));
            }
            return resultArray;
        }
        LinAlgExceptions.assertMultiplies(this, other);
        if (other.isScalar()) {
            return this.muli(otherArray.getDouble(0), (INDArray)resultArray);
        }
        if (this.isScalar()) {
            return otherArray.muli(this.getDouble(0), (INDArray)resultArray);
        }
        if (result == this || result == other) {
            IComplexNDArray temp = Nd4j.createComplex(resultArray.shape(), ArrayUtil.calcStridesFortran(resultArray.shape(), 2));
            if (otherArray.columns() == 1) {
                if (this.data.dataType() == 0) {
                    Nd4j.getBlasWrapper().gemv(Nd4j.UNIT.asDouble(), (IComplexNDArray)this, otherArray, Nd4j.ZERO.asDouble(), temp);
                } else {
                    Nd4j.getBlasWrapper().gemv(Nd4j.UNIT.asFloat(), (IComplexNDArray)this, otherArray, Nd4j.ZERO.asFloat(), temp);
                }
            } else if (this.data.dataType() == 0) {
                Nd4j.getBlasWrapper().gemm(Nd4j.UNIT.asDouble(), this, otherArray, Nd4j.ZERO.asDouble(), temp);
            } else {
                Nd4j.getBlasWrapper().gemm(Nd4j.UNIT.asFloat(), this, otherArray, Nd4j.ZERO.asFloat(), temp);
            }
            Nd4j.getBlasWrapper().copy(temp, resultArray);
        } else if (otherArray.columns() == 1) {
            if (this.data.dataType() == 0) {
                Nd4j.getBlasWrapper().gemv(Nd4j.UNIT.asDouble(), (IComplexNDArray)this, otherArray, Nd4j.ZERO.asDouble(), resultArray);
            } else {
                Nd4j.getBlasWrapper().gemv(Nd4j.UNIT.asFloat(), (IComplexNDArray)this, otherArray, Nd4j.ZERO.asFloat(), resultArray);
            }
        } else if (this.data.dataType() == 1) {
            Nd4j.getBlasWrapper().gemm(Nd4j.UNIT.asFloat(), this, otherArray, Nd4j.ZERO.asFloat(), resultArray);
        } else {
            Nd4j.getBlasWrapper().gemm(Nd4j.UNIT.asDouble(), this, otherArray, Nd4j.ZERO.asDouble(), resultArray);
        }
        return resultArray;
    }

    @Override
    public int secondaryStride() {
        return super.secondaryStride() / 2;
    }

    @Override
    public IComplexNDArray divi(INDArray other) {
        return this.divi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray divi(INDArray other, INDArray result) {
        IComplexNDArray cOther = (IComplexNDArray)other;
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cOtherLinear = cOther.linearView();
        IComplexNDArray cResultLinear = cResult.linearView();
        if (other.isScalar()) {
            return this.divi(cOther.getComplex(0), result);
        }
        IComplexNumber c = Nd4j.createComplexNumber(0, 0);
        IComplexNumber d = Nd4j.createComplexNumber(0, 0);
        for (int i = 0; i < this.length; ++i) {
            cResultLinear.putScalar(i, linear.getComplex(i, c).divi(cOtherLinear.getComplex(i, d)));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray muli(INDArray other) {
        return this.muli(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray muli(INDArray other, INDArray result) {
        IComplexNDArray cOther = (IComplexNDArray)other;
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cOtherLinear = cOther.linearView();
        IComplexNDArray cResultLinear = cResult.linearView();
        if (other.isScalar()) {
            return this.muli(cOther.getComplex(0), result);
        }
        IComplexNumber c = Nd4j.createComplexNumber(0, 0);
        IComplexNumber d = Nd4j.createComplexNumber(0, 0);
        for (int i = 0; i < this.length; ++i) {
            cResultLinear.putScalar(i, linear.getComplex(i, c).muli(cOtherLinear.getComplex(i, d)));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray subi(INDArray other) {
        return this.subi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray subi(INDArray other, INDArray result) {
        IComplexNDArray cOther = (IComplexNDArray)other;
        IComplexNDArray cResult = (IComplexNDArray)result;
        if (other.isScalar()) {
            return this.subi(cOther.getComplex(0), result);
        }
        if (result == this) {
            Nd4j.getBlasWrapper().axpy(Nd4j.NEG_UNIT, cOther, cResult);
        } else if (result == other) {
            if (this.data.dataType() == 0) {
                Nd4j.getBlasWrapper().scal(Nd4j.NEG_UNIT.asDouble(), cResult);
                Nd4j.getBlasWrapper().axpy(Nd4j.UNIT, this, cResult);
            } else {
                Nd4j.getBlasWrapper().scal(Nd4j.NEG_UNIT.asFloat(), cResult);
                Nd4j.getBlasWrapper().axpy(Nd4j.UNIT, this, cResult);
            }
        } else {
            Nd4j.getBlasWrapper().copy(this, result);
            Nd4j.getBlasWrapper().axpy(Nd4j.NEG_UNIT, cOther, cResult);
        }
        return cResult;
    }

    @Override
    public IComplexNDArray addi(INDArray other) {
        return this.addi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray addi(INDArray other, INDArray result) {
        IComplexNDArray cOther = (IComplexNDArray)other;
        IComplexNDArray cResult = (IComplexNDArray)result;
        if (cOther.isScalar()) {
            return cResult.addi(cOther.getComplex(0), result);
        }
        if (this.isScalar()) {
            return cOther.addi(this.getComplex(0), result);
        }
        if (result == this) {
            Nd4j.getBlasWrapper().axpy(Nd4j.UNIT, cOther, cResult);
        } else if (result == other) {
            Nd4j.getBlasWrapper().axpy(Nd4j.UNIT, this, cResult);
        } else {
            INDArray resultLinear = result.linearView();
            INDArray otherLinear = other.linearView();
            IComplexNDArray linear = this.linearView();
            for (int i = 0; i < resultLinear.length(); ++i) {
                resultLinear.putScalar(i, otherLinear.getDouble(i) + linear.getDouble(i));
            }
        }
        return (IComplexNDArray)result;
    }

    @Override
    public IComplexNDArray rdiv(IComplexNumber n, INDArray result) {
        return this.dup().rdivi(n, result);
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        for (int i = 0; i < this.length; ++i) {
            cResultLinear.putScalar(i, n.div(this.getComplex(i)));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray rsub(IComplexNumber n, INDArray result) {
        return this.dup().rsubi(n, result);
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        for (int i = 0; i < this.length; ++i) {
            cResultLinear.putScalar(i, n.sub(this.getComplex(i)));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray div(IComplexNumber n, INDArray result) {
        return this.dup().divi(n, result);
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        for (int i = 0; i < this.length; ++i) {
            cResultLinear.putScalar(i, this.getComplex(i).div(n));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray mul(IComplexNumber n, INDArray result) {
        return this.dup().muli(n, result);
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        for (int i = 0; i < this.length; ++i) {
            cResultLinear.putScalar(i, this.getComplex(i).mul(n));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray sub(IComplexNumber n, INDArray result) {
        return this.dup().subi(n, result);
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        IComplexNDArray linear = this.linearView();
        for (int i = 0; i < this.length; ++i) {
            cResultLinear.putScalar(i, linear.getComplex(i).sub(n));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray add(IComplexNumber n, INDArray result) {
        return this.dup().addi(n, result);
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n, INDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = (IComplexNDArray)result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, linear.getComplex(i).add(n));
        }
        return (IComplexNDArray)result;
    }

    @Override
    public IComplexNDArray rdiv(IComplexNumber n) {
        return this.dup().rdivi(n, this);
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n) {
        return this.rdivi(n, this);
    }

    @Override
    public IComplexNDArray rsub(IComplexNumber n) {
        return this.rsub(n, this);
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n) {
        return this.rsubi(n, this);
    }

    @Override
    public IComplexNDArray div(IComplexNumber n) {
        return this.div(n, this);
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n) {
        return this.divi(n, this);
    }

    @Override
    public IComplexNDArray mul(IComplexNumber n) {
        return this.dup().muli(n);
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n) {
        return this.muli(n, this);
    }

    @Override
    public IComplexNDArray sub(IComplexNumber n) {
        return this.dup().subi(n);
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n) {
        return this.subi(n, this);
    }

    @Override
    public IComplexNDArray add(IComplexNumber n) {
        return this.addi(n, this);
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n) {
        return this.addi(n, this);
    }

    @Override
    public IComplexNDArray putReal(int rowIndex, int columnIndex, float value) {
        return this.putReal(new int[]{rowIndex, columnIndex}, value);
    }

    @Override
    public IComplexNDArray putReal(int[] indices, float value) {
        return this.putReal(indices, (double)value);
    }

    @Override
    public IComplexNDArray putImag(int[] indices, float value) {
        return this.putImag(indices, (double)value);
    }

    @Override
    public IComplexNDArray putReal(int[] indices, double value) {
        int ix = this.offset;
        for (int i = 0; i < indices.length; ++i) {
            ix += indices[i] * this.stride[i];
        }
        this.data.put(ix, value);
        return this;
    }

    @Override
    public IComplexNDArray putImag(int[] indices, double value) {
        int ix = this.offset;
        for (int i = 0; i < indices.length; ++i) {
            ix += indices[i] * this.stride[i];
        }
        this.data.put(ix + 1, value);
        return this;
    }

    @Override
    public IComplexNDArray putImag(int rowIndex, int columnIndex, float value) {
        return this.putReal(new int[]{rowIndex, columnIndex}, value);
    }

    @Override
    public IComplexNDArray put(int[] indexes, float value) {
        return this.put(indexes, (double)value);
    }

    @Override
    public IComplexNDArray neqi(IComplexNumber other) {
        IComplexNDArray ret = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            IComplexNumber num = ret.getComplex(i);
            ret.putScalar(i, num.neqc(other));
        }
        return this;
    }

    @Override
    public IComplexNDArray neq(IComplexNumber other) {
        return this.dup().neqi(other);
    }

    @Override
    public IComplexNDArray lt(IComplexNumber other) {
        return this.dup().lti(other);
    }

    @Override
    public IComplexNDArray lti(IComplexNumber other) {
        IComplexNDArray ret = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            IComplexNumber num = ret.getComplex(i);
            ret.putScalar(i, num.lt(other));
        }
        return this;
    }

    @Override
    public IComplexNDArray eq(IComplexNumber other) {
        return this.dup().eqi(other);
    }

    @Override
    public IComplexNDArray eqi(IComplexNumber other) {
        return this.dup().eqi(other);
    }

    @Override
    public IComplexNDArray gt(IComplexNumber other) {
        return this.dup().gti(other);
    }

    @Override
    public IComplexNDArray gti(IComplexNumber other) {
        IComplexNDArray ret = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            IComplexNumber num = ret.getComplex(i);
            ret.putScalar(i, num.gt(other));
        }
        return this;
    }

    @Override
    public IComplexNDArray transpose() {
        if (this.isRowVector()) {
            return Nd4j.createComplex(this.data, new int[]{this.shape[0], 1}, this.offset);
        }
        if (this.isColumnVector()) {
            return Nd4j.createComplex(this.data, new int[]{this.shape[0]}, this.offset);
        }
        if (this.isMatrix()) {
            IComplexNDArray reverse = Nd4j.createComplex(new int[]{this.shape[1], this.shape[0]});
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    reverse.putScalar(j, i, this.getComplex(i, j));
                }
            }
            return reverse;
        }
        IComplexNDArray ret = this.permute(ArrayUtil.range(this.shape.length - 1, -1));
        return ret;
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, linear.getComplex(i).addi(n));
        }
        return result;
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, linear.getComplex(i).subi(n));
        }
        return result;
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            IComplexNumber n3 = linear.getComplex(i);
            IComplexNumber num = n3.mul(n);
            cResult.putScalar(i, linear.getComplex(i).mul(n));
        }
        return result;
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, linear.getComplex(i).div(n));
        }
        return result;
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, n.sub(linear.getComplex(i)));
        }
        return result;
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, n.div(linear.getComplex(i)));
        }
        return result;
    }

    @Override
    public IComplexNDArray reshape(int[] shape) {
        return (IComplexNDArray)super.reshape(shape);
    }

    @Override
    public IComplexNDArray assign(Number value) {
        IComplexNDArray one = this.linearView();
        for (int i = 0; i < one.length(); ++i) {
            one.putScalar(i, (IComplexNumber)Nd4j.createDouble(value.doubleValue(), 0.0));
        }
        return this;
    }

    @Override
    public IComplexNDArray rdiv(INDArray other) {
        return this.dup().rdivi(other);
    }

    @Override
    public IComplexNDArray rdivi(INDArray other) {
        return this.rdivi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray rdiv(INDArray other, INDArray result) {
        return this.dup().rdivi(other, result);
    }

    @Override
    public IComplexNDArray rdivi(INDArray other, INDArray result) {
        return (IComplexNDArray)other.divi(this, result);
    }

    @Override
    public IComplexNDArray rsub(INDArray other, INDArray result) {
        return this.dup().rsubi(other, result);
    }

    @Override
    public IComplexNDArray rsub(INDArray other) {
        return this.dup().rsubi(other);
    }

    @Override
    public IComplexNDArray rsubi(INDArray other) {
        return this.rsubi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray rsubi(INDArray other, INDArray result) {
        return (IComplexNDArray)other.subi(this, result);
    }

    public IComplexNumber max() {
        IComplexNDArray reshape = this.ravel();
        IComplexNumber max = reshape.getComplex(0);
        for (int i = 1; i < reshape.length(); ++i) {
            IComplexNumber curr = reshape.getComplex(i);
            double val = curr.realComponent().doubleValue();
            if (!(val > curr.realComponent().doubleValue())) continue;
            max = curr;
        }
        return max;
    }

    public IComplexNumber min() {
        IComplexNDArray reshape = this.ravel();
        IComplexNumber min = reshape.getComplex(0);
        for (int i = 1; i < reshape.length(); ++i) {
            IComplexNumber curr = reshape.getComplex(i);
            double val = curr.realComponent().doubleValue();
            if (!(val < curr.realComponent().doubleValue())) continue;
            min = curr;
        }
        return min;
    }

    @Override
    public IComplexNumber[] toArray() {
        this.length = ArrayUtil.prod(this.shape);
        IComplexNumber[] ret = new IComplexNumber[this.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getComplex(i);
        }
        return ret;
    }

    @Override
    public IComplexNDArray reshape(int newRows, int newColumns) {
        return this.reshape(new int[]{newRows, newColumns});
    }

    @Override
    public IComplexNDArray getColumn(int c) {
        if (this.shape.length == 2) {
            if (this.ordering == 'c') {
                IComplexNDArray ret = Nd4j.createComplex(this.data, new int[]{this.shape[0]}, new int[]{this.stride[0]}, this.offset + c * 2, this.ordering);
                return ret;
            }
            IComplexNDArray ret = Nd4j.createComplex(this.data, new int[]{this.shape[0]}, new int[]{this.stride[0]}, this.offset + c * 2, this.ordering);
            return ret;
        }
        if (this.isColumnVector() && c == 0) {
            return this;
        }
        throw new IllegalArgumentException("Unable to getFromOrigin column of non 2d matrix");
    }

    @Override
    public IComplexNDArray getRow(int r) {
        if (this.shape.length == 2) {
            if (this.ordering == 'c') {
                IComplexNDArray ret = Nd4j.createComplex(this.data, new int[]{this.shape[1]}, new int[]{this.stride[1]}, this.offset + r * 2 * this.columns(), this.ordering);
                return ret;
            }
            IComplexNDArray ret = Nd4j.createComplex(this.data, new int[]{this.shape[1]}, new int[]{this.stride[1]}, this.offset + r * 2, this.ordering);
            return ret;
        }
        if (this.isRowVector() && r == 0) {
            return this;
        }
        throw new IllegalArgumentException("Unable to getFromOrigin row of non 2d matrix");
    }

    @Override
    public boolean equals(Object o) {
        IComplexNDArray n = null;
        if (!(o instanceof IComplexNDArray)) {
            return false;
        }
        if (n == null) {
            n = (IComplexNDArray)o;
        }
        if (this.isScalar() && n.isScalar()) {
            IComplexNumber c = n.getComplex(0);
            return Math.abs(this.getComplex(0).sub(c).realComponent().doubleValue()) < 1.0E-6;
        }
        if (this.isVector() && n.isVector()) {
            for (int i = 0; i < this.length; ++i) {
                double curr = this.getComplex(i).realComponent().doubleValue();
                double comp = n.getComplex(i).realComponent().doubleValue();
                double currImag = this.getComplex(i).imaginaryComponent().doubleValue();
                double compImag = n.getComplex(i).imaginaryComponent().doubleValue();
                if (!(Math.abs(curr - comp) > 0.001) && !(Math.abs(currImag - compImag) > 0.001)) continue;
                return false;
            }
            return true;
        }
        if (!Shape.shapeEquals(this.shape(), n.shape())) {
            return false;
        }
        if (this.isScalar()) {
            IComplexNumber c = n.getComplex(0);
            return this.getComplex(0).sub(c).absoluteValue().doubleValue() < 1.0E-6;
        }
        if (this.isVector()) {
            for (int i = 0; i < this.length; ++i) {
                IComplexNumber comp;
                IComplexNumber curr = this.getComplex(i);
                if (!(curr.sub(comp = n.getComplex(i)).absoluteValue().doubleValue() > 1.0E-6)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.slices(); ++i) {
            if (this.slice(i).equals(n.slice(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public IComplexNDArray broadcast(int[] shape) {
        int targetDimensions = shape.length;
        int dims = this.shape.length;
        if (targetDimensions < dims) {
            throw new IllegalArgumentException("Invalid shape to broad cast " + Arrays.toString(shape));
        }
        if (dims == targetDimensions) {
            if (Shape.shapeEquals(shape, this.shape())) {
                return this;
            }
            throw new IllegalArgumentException("Invalid shape to broad cast " + Arrays.toString(shape));
        }
        int n = shape[0];
        IComplexNDArray s = this.broadcast(Arrays.copyOfRange(shape, 1, targetDimensions));
        return Nd4j.repeat(s, n);
    }

    @Override
    public Object element() {
        if (!this.isScalar()) {
            throw new IllegalStateException("Unable to getScalar the element of a non scalar");
        }
        int idx = this.linearIndex(0);
        return Nd4j.createDouble(this.data.getDouble(idx), this.data.getDouble(idx + 1));
    }

    @Override
    public IComplexNDArray permute(int[] rearrange) {
        if (rearrange.length < this.shape.length) {
            return this.dup();
        }
        this.checkArrangeArray(rearrange);
        int[] newDims = this.doPermuteSwap(this.shape, rearrange);
        int[] newStrides = this.doPermuteSwap(this.stride, rearrange);
        IComplexNDArray ret = Nd4j.createComplex(this.data, newDims, newStrides, this.offset, this.ordering);
        return ret;
    }

    @Override
    public IComplexNDArray ravel() {
        final IComplexNDArray ret = Nd4j.createComplex(this.length, this.ordering);
        final AtomicInteger counter = new AtomicInteger(0);
        SliceOp op = new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                IComplexNDArray nd1 = (IComplexNDArray)nd.getResult();
                for (int i = 0; i < nd1.length(); ++i) {
                    int element = counter.getAndIncrement();
                    ret.putScalar(element, nd1.getComplex(i));
                }
            }

            @Override
            public void operate(INDArray nd) {
                IComplexNDArray nd1 = (IComplexNDArray)nd;
                for (int i = 0; i < nd.length(); ++i) {
                    int element = counter.getAndIncrement();
                    ret.putScalar(element, nd1.getComplex(i));
                }
            }
        };
        if (this.ordering == 'c') {
            this.iterateOverAllRows(op);
        } else if (this.ordering == 'f') {
            this.iterateOverAllColumns(op);
        }
        return ret;
    }

    @Override
    public String toString() {
        if (this.isScalar()) {
            return this.element().toString();
        }
        if (this.isVector()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            int numElementsToPrint = Nd4j.MAX_ELEMENTS_PER_SLICE < 0 ? this.length : Nd4j.MAX_ELEMENTS_PER_SLICE;
            for (int i = 0; i < this.length; ++i) {
                int numElementsLeft;
                sb.append(this.getComplex(i));
                if (i < this.length - 1) {
                    sb.append(" ,");
                }
                if (i < numElementsToPrint || (numElementsLeft = this.length - i) <= numElementsToPrint) continue;
                i += numElementsLeft - numElementsToPrint - 1;
                sb.append(" ,... ,");
            }
            sb.append("]\n");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        int length = this.shape[0];
        sb.append("[");
        if (length > 0) {
            int slices;
            sb.append(this.slice(0).toString());
            int n = slices = Nd4j.MAX_SLICES_TO_PRINT > 0 ? Nd4j.MAX_SLICES_TO_PRINT : this.slices();
            if (slices > this.slices()) {
                slices = this.slices();
            }
            for (int i = 1; i < slices; ++i) {
                sb.append(this.slice(i).toString());
                if (i >= length - 1) continue;
                sb.append(" ,");
            }
        }
        sb.append("]\n");
        return sb.toString();
    }
}

