/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.nd4j.linalg.util.AbstractNumber;

public class IntervalNumber
implements AbstractNumber {
    private static MathContext mcLow = new MathContext(9, RoundingMode.FLOOR);
    private static MathContext mcHigh = new MathContext(9, RoundingMode.CEILING);
    protected BigDecimal low;
    protected BigDecimal high;

    public IntervalNumber() {
        this.low = BigDecimal.ZERO;
        this.high = BigDecimal.ZERO;
    }

    public IntervalNumber(double l, double r) {
        this(new BigDecimal(l), new BigDecimal(r));
    }

    public IntervalNumber(String l, String r) {
        this(new BigDecimal(l), new BigDecimal(r));
    }

    public IntervalNumber(BigDecimal l, BigDecimal r) {
        this.low = l;
        this.high = r;
    }

    public IntervalNumber(IntervalNumber a) {
        this(a.low, a.high);
    }

    public IntervalNumber(AbstractNumber a) {
        if (a instanceof IntervalNumber) {
            IntervalNumber _a = (IntervalNumber)a;
            this.low = _a.low;
            this.high = _a.high;
        }
    }

    public static IntervalNumber neg(IntervalNumber x, IntervalNumber y) {
        return new IntervalNumber(x.add(new IntervalNumber(y.high.negate(mcLow), y.low.negate(mcLow))));
    }

    public BigDecimal inf() {
        return this.low;
    }

    public BigDecimal sup() {
        return this.high;
    }

    @Override
    public AbstractNumber add(AbstractNumber _b) {
        if (this == null || _b == null) {
            throw new ArithmeticException("Null pointer argument in add");
        }
        if (this instanceof IntervalNumber && _b instanceof IntervalNumber) {
            IntervalNumber a = this;
            IntervalNumber b = (IntervalNumber)_b;
            return new IntervalNumber(a.low.add(b.low, mcLow), a.high.add(b.high, mcHigh));
        }
        throw new ArithmeticException("Unexpected arithmetical error!!!");
    }

    @Override
    public AbstractNumber sub(AbstractNumber _b) {
        if (this == null || _b == null) {
            throw new ArithmeticException("Null pointer argument in sub");
        }
        if (this instanceof IntervalNumber && _b instanceof IntervalNumber) {
            IntervalNumber a = this;
            IntervalNumber b = (IntervalNumber)_b;
            return new IntervalNumber(a.low.subtract(b.high, mcLow), a.high.subtract(b.low, mcLow));
        }
        throw new ArithmeticException("Unexpected arithmetical error!!!");
    }

    @Override
    public AbstractNumber mult(AbstractNumber _b) {
        if (this == null || _b == null) {
            throw new ArithmeticException("Null pointer argument in mult");
        }
        if (this instanceof IntervalNumber && _b instanceof IntervalNumber) {
            IntervalNumber a = this;
            IntervalNumber b = (IntervalNumber)_b;
            switch (a.getTypeOfInterval()) {
                case P: {
                    switch (b.getTypeOfInterval()) {
                        case P: {
                            return new IntervalNumber(a.low.multiply(b.low, mcLow), a.high.multiply(b.high, mcHigh));
                        }
                        case Z: {
                            return new IntervalNumber(a.high.multiply(b.low, mcLow), a.high.multiply(b.high, mcHigh));
                        }
                        case negP: {
                            return new IntervalNumber(a.high.multiply(b.low, mcLow), a.low.multiply(b.high, mcHigh));
                        }
                        case dualZ: {
                            return new IntervalNumber(a.low.multiply(b.low, mcLow), a.low.multiply(b.high, mcHigh));
                        }
                    }
                }
                case Z: {
                    switch (b.getTypeOfInterval()) {
                        case P: {
                            return new IntervalNumber(a.low.multiply(b.high, mcLow), a.high.multiply(b.high, mcHigh));
                        }
                        case Z: {
                            return new IntervalNumber(a.low.multiply(b.high, mcLow).min(a.high.multiply(b.low, mcLow)), a.low.multiply(b.low, mcHigh).max(a.high.multiply(b.high, mcHigh)));
                        }
                        case negP: {
                            return new IntervalNumber(a.high.multiply(b.low, mcLow), a.low.multiply(b.low, mcHigh));
                        }
                        case dualZ: {
                            return new IntervalNumber(BigDecimal.ZERO, BigDecimal.ZERO);
                        }
                    }
                }
                case negP: {
                    switch (b.getTypeOfInterval()) {
                        case P: {
                            return new IntervalNumber(a.low.multiply(b.high, mcLow), a.high.multiply(b.low, mcHigh));
                        }
                        case Z: {
                            return new IntervalNumber(a.low.multiply(b.high, mcLow), a.low.multiply(b.low, mcHigh));
                        }
                        case negP: {
                            return new IntervalNumber(a.high.multiply(b.high, mcLow), a.low.multiply(b.low, mcHigh));
                        }
                        case dualZ: {
                            return new IntervalNumber(a.high.multiply(b.high, mcLow), a.high.multiply(b.low, mcHigh));
                        }
                    }
                }
                case dualZ: {
                    switch (b.getTypeOfInterval()) {
                        case P: {
                            return new IntervalNumber(a.low.multiply(b.low, mcLow), a.high.multiply(b.low, mcHigh));
                        }
                        case Z: {
                            return new IntervalNumber(BigDecimal.ZERO, BigDecimal.ZERO);
                        }
                        case negP: {
                            return new IntervalNumber(a.high.multiply(b.high, mcLow), a.low.multiply(b.high, mcHigh));
                        }
                        case dualZ: {
                            return new IntervalNumber(a.low.multiply(b.low, mcLow).max(a.high.multiply(b.high, mcLow)), a.low.multiply(b.high, mcHigh).min(a.high.multiply(b.low, mcHigh)));
                        }
                    }
                }
            }
        }
        throw new ArithmeticException("Unexpected arithmetical error!!!");
    }

    @Override
    public AbstractNumber div(AbstractNumber _b) {
        if (this == null || _b == null) {
            throw new ArithmeticException("Null pointer argument in div");
        }
        if (this instanceof IntervalNumber && _b instanceof IntervalNumber) {
            IntervalNumber a = this;
            IntervalNumber b = (IntervalNumber)_b;
            if (!b.zeroInPro()) {
                return new IntervalNumber(this.mult(new IntervalNumber(BigDecimal.ONE.divide(b.high, mcLow), BigDecimal.ONE.divide(b.low, mcHigh))));
            }
            throw new ArithmeticException("Division by interval in Z");
        }
        throw new ArithmeticException("Unexpected arithmetical error!!!");
    }

    public String toString() {
        return "[" + this.low.toPlainString() + ", " + this.high.toPlainString() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof IntervalNumber && this instanceof IntervalNumber) {
            IntervalNumber interval = (IntervalNumber)obj;
            IntervalNumber thisInterval = this;
            return Math.abs(thisInterval.low.doubleValue() - interval.low.doubleValue()) <= 1.0E-7 && Math.abs(thisInterval.high.doubleValue() - interval.high.doubleValue()) <= 1.0E-7;
        }
        return false;
    }

    public typeOfInterval getTypeOfInterval() {
        if (this.low.compareTo(BigDecimal.ZERO) <= 0 && 0 <= this.high.compareTo(BigDecimal.ZERO)) {
            return typeOfInterval.Z;
        }
        if (this.low.compareTo(BigDecimal.ZERO) >= 0 && this.high.compareTo(BigDecimal.ZERO) >= 0) {
            return typeOfInterval.P;
        }
        if (this.low.compareTo(BigDecimal.ZERO) <= 0 && this.high.compareTo(BigDecimal.ZERO) <= 0) {
            return typeOfInterval.negP;
        }
        if (this.high.compareTo(BigDecimal.ZERO) <= 0 && 0 <= this.low.compareTo(BigDecimal.ZERO)) {
            return typeOfInterval.dualZ;
        }
        return null;
    }

    public BigDecimal abs() {
        BigDecimal ar;
        BigDecimal al = this.low.abs(mcLow);
        return al.compareTo(ar = this.high.abs(mcHigh)) > 0 ? al : ar;
    }

    public IntervalNumber dual() {
        return new IntervalNumber(this.high, this.low);
    }

    public IntervalNumber pro() {
        return this.low.compareTo(this.high) < 0 ? new IntervalNumber(this) : this.dual();
    }

    public IntervalNumber opp() {
        return new IntervalNumber(this.low.negate(mcLow), this.high.negate(mcHigh));
    }

    public IntervalNumber inv() {
        return new IntervalNumber(BigDecimal.ONE.divide(this.low, mcLow), BigDecimal.ONE.divide(this.high, mcHigh));
    }

    public IntervalNumber innerSub(IntervalNumber y) {
        return new IntervalNumber(this.low.subtract(y.low, mcLow), this.high.subtract(y.high, mcHigh));
    }

    public boolean zeroInPro() {
        IntervalNumber y = this.pro();
        return y.low.compareTo(BigDecimal.ZERO) <= 0 && 0 <= y.high.compareTo(BigDecimal.ZERO);
    }

    public IntervalNumber innerDiv(IntervalNumber y) {
        if (!y.zeroInPro()) {
            return new IntervalNumber(this.mult(y.inv()));
        }
        throw new ArithmeticException("Division by interval in Z");
    }

    public static enum typeOfInterval {
        P,
        Z,
        negP,
        dualZ;

    }
}

