/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.util.ComplexUtil;

public class Pow
extends BaseTransformOp {
    private double pow;

    public Pow() {
    }

    public Pow(INDArray x, INDArray z, double pow) {
        super(x, z);
        this.pow = pow;
        this.init(x, null, z, x.length());
    }

    public Pow(INDArray x, INDArray z, int n, double pow) {
        super(x, z, n);
        this.pow = pow;
        this.init(x, null, z, n);
    }

    public Pow(INDArray x, INDArray y, INDArray z, int n, double pow) {
        super(x, y, z, n);
        this.pow = pow;
        this.init(x, y, z, n);
    }

    public Pow(INDArray x, double pow) {
        super(x);
        this.pow = pow;
        this.init(x, null, x, x.length());
    }

    @Override
    public String name() {
        return "pow";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return ComplexUtil.pow(origin, this.pow);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return ComplexUtil.pow(origin, this.pow);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return ComplexUtil.pow(origin, this.pow);
    }

    @Override
    public float op(float origin, float other) {
        return (float)FastMath.pow((double)origin, (double)this.pow);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.pow((double)origin, (double)this.pow);
    }

    @Override
    public double op(double origin) {
        return FastMath.pow((double)origin, (double)this.pow);
    }

    @Override
    public float op(float origin) {
        return (float)FastMath.pow((double)origin, (double)this.pow);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return ComplexUtil.pow(origin, this.pow);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Pow(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.pow);
        }
        return new Pow(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.pow);
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
        this.extraArgs = new Object[]{this.pow};
    }
}

