/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.util.ComplexUtil;

public class Abs
extends BaseTransformOp {
    public Abs() {
    }

    public Abs(INDArray x, INDArray z) {
        super(x, z);
    }

    public Abs(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public Abs(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Abs(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "abs";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return ComplexUtil.abs(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return ComplexUtil.abs(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return ComplexUtil.abs(origin);
    }

    @Override
    public float op(float origin, float other) {
        return FastMath.abs((float)origin);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.abs((double)origin);
    }

    @Override
    public double op(double origin) {
        return FastMath.abs((double)origin);
    }

    @Override
    public float op(float origin) {
        return FastMath.abs((float)origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return ComplexUtil.abs(origin);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Abs(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Abs(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

