/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum.distances;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ComplexUtil;

public class ManhattanDistance
extends BaseAccumulation {
    public ManhattanDistance() {
    }

    public ManhattanDistance(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public ManhattanDistance(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public ManhattanDistance(INDArray x) {
        super(x);
    }

    public ManhattanDistance(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public void update(Number result) {
        this.currentResult = this.currentResult.doubleValue() + FastMath.abs((double)result.doubleValue());
    }

    @Override
    public void update(IComplexNumber result) {
        this.currentComplexResult.addi(ComplexUtil.pow(result, 2.0));
    }

    @Override
    public Number zero() {
        return 0.0;
    }

    @Override
    public IComplexNumber zeroComplex() {
        return Nd4j.createComplexNumber(0.0, 0.0);
    }

    @Override
    public String name() {
        return "manhattan";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        ++this.numProcessed;
        return origin.sub(other);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        ++this.numProcessed;
        return origin.sub(Float.valueOf(other));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        ++this.numProcessed;
        return origin.sub(other);
    }

    @Override
    public float op(float origin, float other) {
        return origin - other;
    }

    @Override
    public double op(double origin, double other) {
        ++this.numProcessed;
        return origin - other;
    }

    @Override
    public double op(double origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public float op(float origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        if (this.y() != null) {
            return new ManhattanDistance(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.x.length());
        }
        return new ManhattanDistance(this.x.vectorAlongDimension(index, dimension));
    }
}

