/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;

public class IAMax
extends BaseAccumulation {
    private int currIndexOfMax = 0;

    public IAMax() {
    }

    public IAMax(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public IAMax(INDArray x) {
        super(x);
    }

    public IAMax(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public void update(Number result) {
        if (result.doubleValue() > this.currentResult().doubleValue()) {
            this.currentResult = result;
            this.currIndexOfMax = this.numProcessed;
        }
        ++this.numProcessed;
        if (this.numProcessed() == this.n()) {
            this.currentResult = this.currIndexOfMax;
        }
    }

    @Override
    public void update(IComplexNumber result) {
        if (result.absoluteValue().doubleValue() > this.currentResultComplex().absoluteValue().doubleValue()) {
            this.currentComplexResult = result;
            this.currIndexOfMax = this.numProcessed;
        }
        ++this.numProcessed;
        if (this.numProcessed() == this.n()) {
            this.currentResult = this.currIndexOfMax;
        }
    }

    @Override
    public String name() {
        return "iamax";
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
        super.init(x, y, z, n);
        if (x instanceof IComplexNDArray) {
            IComplexNDArray complexX = (IComplexNDArray)x;
            this.currentComplexResult = complexX.getComplex(0);
        } else {
            this.currentResult = x.getDouble(0);
            this.initial = x.getDouble(0);
        }
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new IAMax(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new IAMax(this.x.vectorAlongDimension(index, dimension));
    }
}

