/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.comparison;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class GreaterThan
extends BaseTransformOp {
    public GreaterThan(INDArray x, INDArray z) {
        super(x, z);
    }

    public GreaterThan(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public GreaterThan(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public GreaterThan(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "gt";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        if (origin.isReal()) {
            return origin.realComponent().doubleValue() > other ? Nd4j.createComplexNumber(1.0, 0.0) : Nd4j.createComplexNumber(0.0, 0.0);
        }
        return Nd4j.createComplexNumber(0.0, 0.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        if (origin.isReal()) {
            return origin.realComponent().doubleValue() > (double)other ? Nd4j.createComplexNumber(1.0, 0.0) : Nd4j.createComplexNumber(0.0, 0.0);
        }
        return Nd4j.createComplexNumber(0.0, 0.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin.gt(other).eq(Nd4j.createComplexNumber(1.0, 0.0)) ? Nd4j.createComplexNumber(1.0, 0.0) : Nd4j.createComplexNumber(0.0, 0.0);
    }

    @Override
    public float op(float origin, float other) {
        return origin > other ? 1.0f : 0.0f;
    }

    @Override
    public double op(double origin, double other) {
        return origin > other ? 1.0 : 0.0;
    }

    @Override
    public double op(double origin) {
        return 1.0;
    }

    @Override
    public float op(float origin) {
        return 1.0f;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return Nd4j.createComplexNumber(1.0, 0.0);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new GreaterThan(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new GreaterThan(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

