/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ComplexNDArrayUtil;

public class VectorFFT
extends BaseTransformOp {
    protected int fftLength;
    private int originalN = -1;
    protected boolean executed = false;

    public VectorFFT(INDArray x, INDArray z, int fftLength) {
        super(x, z);
        this.fftLength = fftLength;
        this.exec();
    }

    public VectorFFT(INDArray x, INDArray z, int n, int fftLength) {
        super(x, z, n);
        this.fftLength = fftLength;
        this.exec();
    }

    public VectorFFT(INDArray x, INDArray y, INDArray z, int n, int fftLength) {
        super(x, y, z, n);
        this.z = z;
        this.fftLength = fftLength;
        this.exec();
    }

    public VectorFFT(INDArray x, int fftLength) {
        super(x);
        this.z = x;
        this.fftLength = fftLength;
        this.exec();
    }

    public VectorFFT(INDArray x) {
        this(x, x.length());
    }

    @Override
    public String name() {
        return "fft";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin;
    }

    @Override
    public float op(float origin, float other) {
        return origin;
    }

    @Override
    public double op(double origin, double other) {
        return origin;
    }

    @Override
    public double op(double origin) {
        return origin;
    }

    @Override
    public float op(float origin) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new VectorFFT(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.fftLength);
        }
        return new VectorFFT(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.fftLength);
    }

    @Override
    public void exec() {
        if (!this.x.isVector()) {
            return;
        }
        if (this.executed) {
            return;
        }
        this.executed = true;
        double len = this.fftLength;
        IComplexNDArray ret = this.x instanceof IComplexNDArray ? (IComplexNDArray)this.x : Nd4j.createComplex(this.x);
        int desiredElementsAlongDimension = ret.length();
        if (len > (double)desiredElementsAlongDimension) {
            ret = ComplexNDArrayUtil.padWithZeros(ret, new int[]{this.fftLength});
        } else if (len < (double)desiredElementsAlongDimension) {
            ret = ComplexNDArrayUtil.truncate(ret, this.fftLength, 0);
        }
        IComplexNumber c2 = Nd4j.createDouble(0.0, -2.0).muli(Math.PI);
        INDArray n2 = Nd4j.arange(0.0, this.fftLength).reshape(1, this.fftLength);
        INDArray k = n2.reshape(n2.length(), 1);
        INDArray kTimesN = k.mmul(n2);
        IComplexNDArray c1 = kTimesN.muli(c2);
        c1.divi(len);
        IComplexNDArray M = (IComplexNDArray)Transforms.exp(c1);
        IComplexNDArray reshaped = ret.reshape(new int[]{1, ret.length()});
        IComplexNDArray matrix = reshaped.mmul(M);
        if (this.originalN > 0) {
            matrix = ComplexNDArrayUtil.truncate(matrix, this.originalN, 0);
        }
        this.x = matrix;
        this.z = matrix;
    }

    @Override
    public boolean isPassThrough() {
        return true;
    }

    @Override
    public void setX(INDArray x) {
        this.x = x;
        this.fftLength = x.length();
        this.executed = false;
    }

    @Override
    public void setZ(INDArray z) {
        this.z = z;
        this.fftLength = z.length();
        this.executed = false;
    }

    @Override
    public void setY(INDArray y) {
        this.y = y;
    }
}

