/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class MaxOut
extends BaseTransformOp {
    private IComplexNumber maxComplex = Nd4j.createComplexNumber(Double.NaN, Double.NaN);
    private Number max = Double.NaN;

    public MaxOut(INDArray x, INDArray z) {
        super(x, z);
    }

    public MaxOut(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public MaxOut(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public MaxOut(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "maxout";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        this.setMax(this.extraArgs);
        return this.maxComplex;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        this.setMax(this.extraArgs);
        return this.maxComplex;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        this.setMax(this.extraArgs);
        return this.maxComplex;
    }

    @Override
    public float op(float origin, float other) {
        this.setMax(this.extraArgs);
        return this.max.floatValue();
    }

    @Override
    public double op(double origin, double other) {
        this.setMax(this.extraArgs);
        return this.max.doubleValue();
    }

    @Override
    public double op(double origin) {
        this.setMax(this.extraArgs);
        return this.max.doubleValue();
    }

    @Override
    public float op(float origin) {
        this.setMax(this.extraArgs);
        return this.max.floatValue();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        this.setMax(this.extraArgs);
        return this.maxComplex;
    }

    private void setMax(Object[] extraArgs) {
        if (extraArgs.length < 1) {
            throw new IllegalArgumentException("Please specify a max value");
        }
        if (Double.isNaN(this.max.doubleValue()) && extraArgs[0] instanceof Number) {
            this.max = Double.valueOf(extraArgs[0].toString());
        } else if (Double.isNaN(this.maxComplex.realComponent().doubleValue()) && extraArgs[0] instanceof IComplexNumber) {
            this.maxComplex = (IComplexNumber)extraArgs[0];
        }
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new MaxOut(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new MaxOut(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

