/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.HardTanhDerivative;
import org.nd4j.linalg.util.ComplexUtil;

public class HardTanh
extends BaseTransformOp {
    public HardTanh(INDArray x, INDArray z) {
        super(x, z);
    }

    public HardTanh(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public HardTanh(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public HardTanh(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "hardtanh";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return ComplexUtil.hardTanh(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return ComplexUtil.hardTanh(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return ComplexUtil.hardTanh(origin);
    }

    @Override
    public float op(float origin, float other) {
        return this.hardTanh(origin);
    }

    @Override
    public double op(double origin, double other) {
        return this.hardTanh(origin);
    }

    @Override
    public double op(double origin) {
        return this.hardTanh(origin);
    }

    @Override
    public float op(float origin) {
        return this.hardTanh(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return ComplexUtil.hardTanh(origin);
    }

    @Override
    public TransformOp derivative() {
        return new HardTanhDerivative(this.x, this.y, this.z, this.n);
    }

    private float hardTanh(float num) {
        return (float)this.hardTanh((double)num);
    }

    private double hardTanh(double num) {
        double tanh = FastMath.tanh((double)num);
        return tanh < -1.0 ? -1.0 : (tanh > 1.0 ? 1.0 : tanh);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new HardTanh(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new HardTanh(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

