/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.util.ComplexUtil;

public class ASin
extends BaseTransformOp {
    public ASin(INDArray x, INDArray z) {
        super(x, z);
    }

    public ASin(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public ASin(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public ASin(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "asin";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return ComplexUtil.asin(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return ComplexUtil.asin(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return ComplexUtil.asin(origin);
    }

    @Override
    public float op(float origin, float other) {
        return (float)FastMath.asin((double)origin);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.asin((double)origin);
    }

    @Override
    public double op(double origin) {
        return FastMath.asin((double)origin);
    }

    @Override
    public float op(float origin) {
        return (float)FastMath.asin((double)origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return ComplexUtil.asin(origin);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new ASin(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new ASin(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

