/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.scalar;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseScalarOp;
import org.nd4j.linalg.api.ops.Op;

public class ScalarAdd
extends BaseScalarOp {
    public ScalarAdd(INDArray x, INDArray y, INDArray z, int n, Number num) {
        super(x, y, z, n, num);
    }

    public ScalarAdd(INDArray x, Number num) {
        super(x, num);
    }

    public ScalarAdd(INDArray x, INDArray y, INDArray z, int n, IComplexNumber num) {
        super(x, y, z, n, num);
    }

    public ScalarAdd(INDArray x, IComplexNumber num) {
        super(x, num);
    }

    @Override
    public String name() {
        return "add_scalar";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        if (this.complexNumber != null) {
            return origin.add(this.complexNumber);
        }
        return this.complexNumber.add(this.num);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        if (this.complexNumber != null) {
            return origin.add(this.complexNumber);
        }
        return this.complexNumber.add(this.num);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        if (this.complexNumber != null) {
            return origin.add(this.complexNumber);
        }
        return this.complexNumber.add(this.num);
    }

    @Override
    public float op(float origin, float other) {
        return origin + this.num.floatValue();
    }

    @Override
    public double op(double origin, double other) {
        return origin + (double)this.num.floatValue();
    }

    @Override
    public double op(double origin) {
        return origin + this.num.doubleValue();
    }

    @Override
    public float op(float origin) {
        return origin + this.num.floatValue();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        if (this.complexNumber != null) {
            return origin.add(this.complexNumber);
        }
        return this.complexNumber.add(this.num);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        if (this.num != null) {
            return new ScalarAdd(this.x.vectorAlongDimension(index, dimension), this.num);
        }
        return new ScalarAdd(this.x.vectorAlongDimension(index, dimension), this.complexNumber);
    }
}

