/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.accum.Variance;
import org.nd4j.linalg.util.ComplexUtil;

public class StandardDeviation
extends Variance {
    public StandardDeviation(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public StandardDeviation(INDArray x) {
        super(x);
    }

    public StandardDeviation(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public void update(Number result) {
        super.update(result);
        if (this.n() == this.numProcessed()) {
            this.currentResult = FastMath.sqrt((double)this.currentResult.doubleValue());
        }
    }

    @Override
    public void update(IComplexNumber result) {
        super.update(result);
        if (this.n() == this.numProcessed()) {
            this.currentComplexResult = ComplexUtil.sqrt(this.currentComplexResult);
        }
    }

    @Override
    public String name() {
        return "std";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new StandardDeviation(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new StandardDeviation(xAlongDimension);
    }
}

