/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;

public class Mean
extends BaseAccumulation {
    public Mean(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Mean(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public Mean(INDArray x) {
        super(x);
    }

    public Mean(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public void update(Number result) {
        this.currentResult = Double.isInfinite(this.currentResult.doubleValue()) ? (Number)result : (Number)(this.currentResult.doubleValue() + result.doubleValue());
        if (this.numProcessed() == this.n()) {
            this.currentResult = this.currentResult.doubleValue() / (double)this.n();
        }
    }

    @Override
    public void update(IComplexNumber result) {
        if (this.currentComplexResult.realComponent().doubleValue() == Double.NEGATIVE_INFINITY) {
            this.currentComplexResult = result;
        } else {
            this.currentComplexResult.addi(result);
        }
        if (this.numProcessed() == this.n()) {
            this.currentComplexResult.divi(this.n);
        }
    }

    @Override
    public Number zero() {
        return 0.0;
    }

    @Override
    public String name() {
        return "mean";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Mean(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Mean(this.x.vectorAlongDimension(index, dimension));
    }
}

