/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.accum.Mean;
import org.nd4j.linalg.factory.Nd4j;

public class Bias
extends BaseAccumulation {
    private double mean;

    public Bias(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Bias(INDArray x, INDArray y, int n) {
        this(x, y, x, n);
    }

    public Bias(INDArray x) {
        super(x);
    }

    public Bias(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public String name() {
        return "bias";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Bias(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Bias(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public void update(Number result) {
        double dev = result.doubleValue() - this.mean;
        this.currentResult = this.currentResult().doubleValue() + dev;
        ++this.numProcessed;
    }

    @Override
    public void update(IComplexNumber result) {
        IComplexNumber dev = result.sub(this.mean);
        this.currentComplexResult.addi(dev);
        ++this.numProcessed;
    }

    @Override
    public Number zero() {
        return 0.0;
    }

    @Override
    public IComplexNumber zeroComplex() {
        return Nd4j.createComplexNumber(0.0, 0.0);
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
        super.init(x, y, z, n);
        this.mean = Nd4j.getExecutioner().execAndReturn(new Mean(x)).currentResult().doubleValue();
        this.extraArgs = new Object[]{this.zero(), this.mean};
    }
}

