/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.ArrayList;
import java.util.List;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseAccumulation
extends BaseOp
implements Accumulation {
    protected Number currentResult;
    protected IComplexNumber currentComplexResult;
    protected List<Number> otherAccum;
    protected List<IComplexNumber> otherAccumComplex;
    protected Number initial;
    protected IComplexNumber initialComplex;

    public BaseAccumulation(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
        this.init();
    }

    public BaseAccumulation(INDArray x, INDArray y, int n) {
        this(x, y, x, n);
    }

    public BaseAccumulation(INDArray x) {
        this(x, null, x, x.length());
    }

    public BaseAccumulation(INDArray x, INDArray y) {
        this(x, y, x, x.length());
    }

    private void init() {
        this.currentResult = this.zero();
        this.currentComplexResult = this.zeroComplex();
        this.otherAccum = new ArrayList<Number>();
        this.otherAccumComplex = new ArrayList<IComplexNumber>();
        this.init(this.x, this.y, this.x, this.x.length());
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public float op(float origin, float other) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public double op(double origin, double other) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public double op(double origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public float op(float origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public Number zero() {
        return this.initial;
    }

    @Override
    public IComplexNumber zeroComplex() {
        return this.initialComplex.dup();
    }

    @Override
    public IComplexNumber currentResultComplex() {
        return this.currentComplexResult;
    }

    @Override
    public Number currentResult() {
        return this.currentResult;
    }

    @Override
    public int numProcessed() {
        return this.numProcessed;
    }

    @Override
    public List<IComplexNumber> otherAccumComplex() {
        return this.otherAccumComplex;
    }

    @Override
    public List<Number> otherAccum() {
        return this.otherAccum;
    }

    @Override
    public void setCurrentResult(Number number) {
        this.currentResult = number;
    }

    @Override
    public void setCurrentResultComplex(IComplexNumber complexNumber) {
        this.currentComplexResult = complexNumber;
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
        super.init(x, y, z, n);
        if (this.initial == null) {
            this.initial = 0.0;
        }
        if (this.initialComplex == null) {
            this.initialComplex = Nd4j.createComplexNumber(0.0, 0.0);
        }
        this.extraArgs = new Object[]{this.zero()};
    }
}

