/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.factory.Nd4j;

public class ComplexUtil {
    private ComplexUtil() {
    }

    public static IComplexNumber atan(IComplexNumber num) {
        Complex c = new Complex(num.realComponent().doubleValue(), num.imaginaryComponent().doubleValue()).atan();
        return Nd4j.createDouble(c.getReal(), c.getImaginary());
    }

    public static IComplexNumber acos(IComplexNumber num) {
        Complex c = new Complex(num.realComponent().doubleValue(), num.imaginaryComponent().doubleValue()).acos();
        return Nd4j.createDouble(c.getReal(), c.getImaginary());
    }

    public static IComplexNumber asin(IComplexNumber num) {
        Complex c = new Complex(num.realComponent().doubleValue(), num.imaginaryComponent().doubleValue()).asin();
        return Nd4j.createDouble(c.getReal(), c.getImaginary());
    }

    public static IComplexNumber sin(IComplexNumber num) {
        Complex c = new Complex(num.realComponent().doubleValue(), num.imaginaryComponent().doubleValue()).sin();
        return Nd4j.createDouble(c.getReal(), c.getImaginary());
    }

    public static IComplexNumber ceil(IComplexNumber num) {
        Complex c = new Complex(FastMath.ceil((double)num.realComponent().doubleValue()), FastMath.ceil((double)num.imaginaryComponent().doubleValue()));
        return Nd4j.createDouble(c.getReal(), c.getImaginary());
    }

    public static IComplexNumber floor(IComplexNumber num) {
        Complex c = new Complex(FastMath.floor((double)num.realComponent().doubleValue()), FastMath.floor((double)num.imaginaryComponent().doubleValue()));
        return Nd4j.createDouble(c.getReal(), c.getImaginary());
    }

    public static IComplexNumber neg(IComplexNumber num) {
        Complex c = new Complex(num.realComponent().doubleValue(), num.imaginaryComponent().doubleValue()).negate();
        return Nd4j.createDouble(c.getReal(), c.getImaginary());
    }

    public static IComplexNumber log(IComplexNumber num) {
        Complex c = new Complex(num.realComponent().doubleValue(), num.imaginaryComponent().doubleValue()).log();
        return Nd4j.createDouble(c.getReal(), c.getImaginary());
    }

    public static IComplexNumber sqrt(IComplexNumber num) {
        Complex c = new Complex(num.realComponent().doubleValue(), num.imaginaryComponent().doubleValue()).sqrt();
        return Nd4j.createDouble(c.getReal(), c.getImaginary());
    }

    public static IComplexNumber abs(IComplexNumber num) {
        double c = new Complex(num.realComponent().doubleValue(), num.imaginaryComponent().doubleValue()).abs();
        return Nd4j.createDouble(c, 0.0);
    }

    public static IComplexNumber round(IComplexNumber num) {
        return Nd4j.createDouble(Math.round(num.realComponent().doubleValue()), Math.round(num.imaginaryComponent().doubleValue()));
    }

    public static IComplexNumber pow(IComplexNumber num, IComplexNumber power) {
        Complex c = new Complex(num.realComponent().doubleValue(), num.imaginaryComponent().doubleValue()).pow(new Complex(power.realComponent().doubleValue(), power.imaginaryComponent().doubleValue()));
        if (c.isNaN()) {
            c = new Complex(Nd4j.EPS_THRESHOLD, 0.0);
        }
        return Nd4j.createDouble(c.getReal(), c.getImaginary());
    }

    public static IComplexNumber pow(IComplexNumber num, double power) {
        Complex c = new Complex(num.realComponent().doubleValue(), num.imaginaryComponent().doubleValue()).pow(power);
        if (c.isNaN()) {
            c = new Complex(Nd4j.EPS_THRESHOLD, 0.0);
        }
        return Nd4j.createDouble(c.getReal(), c.getImaginary());
    }

    public static IComplexNumber cos(IComplexNumber num) {
        Complex c = new Complex(num.realComponent().doubleValue(), num.imaginaryComponent().doubleValue()).cos();
        return Nd4j.createDouble(c.getReal(), c.getImaginary());
    }

    public static IComplexNumber hardTanh(IComplexNumber num) {
        Complex c = new Complex(num.realComponent().doubleValue(), num.imaginaryComponent().doubleValue()).tanh();
        if (c.getReal() < -1.0) {
            c = new Complex(-1.0, c.getImaginary());
        }
        return Nd4j.createDouble(c.getReal(), c.getImaginary());
    }

    public static IComplexNumber tanh(IComplexNumber num) {
        Complex c = new Complex(num.realComponent().doubleValue(), num.imaginaryComponent().doubleValue()).tanh();
        return Nd4j.createDouble(c.getReal(), c.getImaginary());
    }

    public static IComplexNumber exp(IComplexNumber d) {
        if (d instanceof IComplexFloat) {
            return ComplexUtil.exp((IComplexFloat)d);
        }
        return ComplexUtil.exp((IComplexDouble)d);
    }

    public static IComplexDouble exp(IComplexDouble d) {
        return Nd4j.createDouble(FastMath.exp((double)d.realComponent()) * FastMath.cos((double)d.imaginaryComponent()), FastMath.exp((double)d.realComponent()) * FastMath.sin((double)d.imaginaryComponent()));
    }

    public static IComplexFloat exp(IComplexFloat d) {
        return Nd4j.createFloat((float)FastMath.exp((double)d.realComponent().floatValue()) * (float)FastMath.cos((double)d.imaginaryComponent().floatValue()), (float)FastMath.exp((double)d.realComponent().floatValue()) * (float)FastMath.sin((double)d.imaginaryComponent().floatValue()));
    }
}

