/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.fft.test;

import org.junit.Assert;
import org.junit.Test;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.VectorFFT;
import org.nd4j.linalg.api.ops.impl.transforms.VectorIFFT;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.fft.FFT;

public abstract class BaseIFFTTests {
    @Test
    public void testIfft() {
        Nd4j.EPS_THRESHOLD = 0.1;
        double[] ffted = new double[]{10.2, 5.0, -3.0, -1.0};
        double[] orig = new double[]{3.5999999999999996, 2.0, 6.6, 3.0};
        IComplexNDArray c = Nd4j.createComplex(orig, new int[]{2});
        IComplexNDArray assertion = Nd4j.createComplex(ffted, new int[]{2});
        Assert.assertEquals((Object)assertion, (Object)Nd4j.getExecutioner().execAndReturn(new VectorFFT((INDArray)c, 2)));
        IComplexNDArray iffted = (IComplexNDArray)Nd4j.getExecutioner().execAndReturn(new VectorIFFT((INDArray)assertion.dup(), 2));
        Assert.assertEquals((Object)iffted, (Object)c);
    }

    @Test
    public void testFftToIfft() {
        IComplexNDArray linspace = Nd4j.complexLinSpace(1, 8, 8);
        IComplexNDArray ffted = Nd4j.createComplex(new IComplexNumber[]{Nd4j.createComplexNumber(36, 0), Nd4j.createComplexNumber(-4, 9.6585425), Nd4j.createComplexNumber(-4, 4), Nd4j.createComplexNumber(-4, 1.65685425), Nd4j.createComplexNumber(-4, 0), Nd4j.createComplexNumber(-4, -1.65685425), Nd4j.createComplexNumber(-4, -4), Nd4j.createComplexNumber(-4, -9.65685425)});
        IComplexNDArray ffted2 = FFT.fft(linspace);
        Nd4j.EPS_THRESHOLD = 0.1;
        Assert.assertEquals((double)ffted.eps(ffted2).sum(Integer.MAX_VALUE).getDouble(0), (double)8.0, (double)0.1);
        IComplexNDArray iffted = FFT.ifft(ffted2);
        Assert.assertEquals((double)iffted.eps(linspace).sum(Integer.MAX_VALUE).getDouble(0), (double)8.0, (double)0.1);
    }
}

