/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.fft.test;

import org.junit.Assert;
import org.junit.Test;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.VectorFFT;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.fft.FFT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFFTTest {
    private static Logger log = LoggerFactory.getLogger(BaseFFTTest.class);

    @Test
    public void testColumnVector() {
        Nd4j.EPS_THRESHOLD = 0.1;
        IComplexNDArray n = (IComplexNDArray)Nd4j.getExecutioner().execAndReturn(new VectorFFT((INDArray)Nd4j.complexLinSpace(1, 8, 8), 8));
        IComplexNDArray assertion = Nd4j.createComplex(new double[]{36.0, 0.0, -4.0, 9.65685425, -4.0, 4.0, -4.0, 1.65685425, -4.0, 0.0, -4.0, -1.65685425, -4.0, -4.0, -4.0, -9.65685425}, new int[]{8});
        Assert.assertEquals((Object)n, (Object)assertion);
    }

    @Test
    public void testWithOffset() {
        Nd4j.dtype = DataBuffer.Type.DOUBLE;
        Nd4j.factory().setOrder('f');
        INDArray n = Nd4j.create(Nd4j.linspace(1, 30, 30).data(), new int[]{3, 5, 2});
        INDArray swapped = n.swapAxes(n.shape().length - 1, 1);
        INDArray firstSlice = swapped.slice(0).slice(0);
        IComplexNDArray test = Nd4j.createComplex(firstSlice);
        IComplexNDArray testNoOffset = Nd4j.createComplex(new double[]{1.0, 0.0, 4.0, 0.0, 7.0, 0.0, 10.0, 0.0, 13.0, 0.0}, new int[]{5});
        Assert.assertEquals((Object)Nd4j.getExecutioner().execAndReturn(new VectorFFT((INDArray)testNoOffset, 5)), (Object)Nd4j.getExecutioner().execAndReturn(new VectorFFT((INDArray)test, 5)));
    }

    @Test
    public void testSimple() {
        IComplexNDArray arr = Nd4j.createComplex(new IComplexNumber[]{Nd4j.createComplexNumber(5, 0), Nd4j.createComplexNumber(1, 0)});
        IComplexNDArray arr2 = Nd4j.createComplex(new IComplexNumber[]{Nd4j.createComplexNumber(1, 0), Nd4j.createComplexNumber(5, 0)});
        IComplexNDArray assertion = Nd4j.createComplex(new IComplexNumber[]{Nd4j.createComplexNumber(6, 0), Nd4j.createComplexNumber(4, 0)});
        IComplexNDArray assertion2 = Nd4j.createComplex(new IComplexNumber[]{Nd4j.createComplexNumber(6, 0), Nd4j.createComplexNumber(-4, 4.371139E-7)});
        Assert.assertEquals((Object)assertion, (Object)Nd4j.getFFt().fft(arr));
        Assert.assertEquals((Object)assertion2, (Object)Nd4j.getFFt().fft(arr2));
    }

    @Test
    public void testMultiDimFFT() {
        Nd4j.EPS_THRESHOLD = 0.1;
        INDArray a = Nd4j.linspace(1, 8, 8).reshape(2, 2, 2);
        IComplexNDArray fftedAnswer = Nd4j.createComplex(2, 2, 2);
        IComplexNDArray matrix1 = Nd4j.createComplex(new IComplexNumber[][]{{Nd4j.createComplexNumber(36, 0), Nd4j.createComplexNumber(-16, 0)}, {Nd4j.createComplexNumber(-8, 0), Nd4j.createComplexNumber(0, 0)}});
        IComplexNDArray matrix2 = Nd4j.createComplex(new IComplexNumber[][]{{Nd4j.createComplexNumber(-4, 0), Nd4j.createComplexNumber(0, 0)}, {Nd4j.createComplexNumber(0, 0), Nd4j.createComplexNumber(0, 0)}});
        fftedAnswer.putSlice(0, matrix1);
        fftedAnswer.putSlice(1, matrix2);
        IComplexNDArray ffted = FFT.fftn(a);
        Assert.assertEquals((Object)fftedAnswer, (Object)ffted);
        Nd4j.EPS_THRESHOLD = 1.0E-12;
    }

    @Test
    public void testNoSwap() {
        Nd4j.EPS_THRESHOLD = 0.1;
        IComplexNDArray linspaced = Nd4j.complexLinSpace(1, 6, 6).reshape(2, 3);
        IComplexNDArray assertion = Nd4j.createComplex(2, 3);
        assertion.putSlice(0, Nd4j.createComplex(new IComplexNumber[]{Nd4j.createComplexNumber(21, 0), Nd4j.createComplexNumber(-6, 3.46), Nd4j.createComplexNumber(-6, -3.46)}));
        assertion.putSlice(1, Nd4j.createComplex(new IComplexNumber[]{Nd4j.createComplexNumber(-3, 0), Nd4j.createComplexNumber(0, 0), Nd4j.createComplexNumber(0, 0)}));
        IComplexNDArray fftLinspaced = Nd4j.getFFt().fftn(linspaced);
        Assert.assertEquals((Object)assertion, (Object)fftLinspaced);
        fftLinspaced = Nd4j.getFFt().rawfftn(linspaced, new int[]{2, 2}, null);
        assertion = Nd4j.createComplex(new IComplexNumber[][]{{Nd4j.createComplexNumber(10, 0), Nd4j.createComplexNumber(-4, 0)}, {Nd4j.createComplexNumber(-2, 0), Nd4j.createComplexNumber(0, 0)}});
        Assert.assertEquals((Object)assertion, (Object)fftLinspaced);
    }

    @Test
    public void testOnes() {
        Nd4j.EPS_THRESHOLD = 0.1;
        IComplexNDArray ones = Nd4j.complexOnes(5, 5);
        IComplexNDArray ffted = FFT.fftn(ones);
        IComplexNDArray zeros = Nd4j.createComplex(5, 5);
        zeros.putScalar(0, 0, Nd4j.createComplexNumber(25, 0));
        Assert.assertEquals((Object)zeros, (Object)ffted);
        IComplexNDArray threeOnes = Nd4j.complexOnes(3, 3);
        IComplexNDArray threeComp = Nd4j.createComplex(3, 3);
        threeComp.putScalar(0, 0, Nd4j.createComplexNumber(9, 0));
        Assert.assertEquals((Object)FFT.fftn(threeOnes), (Object)threeComp);
    }

    @Test
    public void testOnesDifferentShapes() {
        Nd4j.EPS_THRESHOLD = 0.1;
        IComplexNDArray ones = Nd4j.complexOnes(5, 5);
        IComplexNDArray ffted = Nd4j.getFFt().rawfftn(ones, new int[]{3, 3}, new int[]{0, 1});
        System.out.println(ffted);
    }

    @Test
    public void testRawfft() {
        int i;
        Nd4j.EPS_THRESHOLD = 0.1;
        IComplexNDArray test = Nd4j.complexOnes(5, 5);
        IComplexNDArray result = Nd4j.getFFt().rawfft(test, 3, 1);
        IComplexNDArray assertion = Nd4j.createComplex(5, 3);
        for (i = 0; i < assertion.rows(); ++i) {
            assertion.slice(i).putScalar(0, Nd4j.createComplexNumber(3, 0));
        }
        for (i = 0; i < result.slices(); ++i) {
            IComplexNDArray assertionSlice = assertion.slice(i);
            IComplexNDArray resultSlice = result.slice(i);
            Assert.assertEquals((String)("Failed on iteration " + i), (Object)assertionSlice, (Object)resultSlice);
        }
    }
}

