/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public abstract class Nd4jBackend {
    public static final int BACKEND_PRIORITY_CPU = 0;
    public static final int BACKEND_PRIORITY_GPU = 100;
    private static final Logger log = LoggerFactory.getLogger(Nd4jBackend.class);

    public abstract int getPriority();

    public abstract boolean isAvailable();

    public abstract Resource getConfigurationResource();

    public static Nd4jBackend load() throws NoAvailableBackendException {
        ArrayList<Nd4jBackend> backends = new ArrayList<Nd4jBackend>(1);
        ServiceLoader<Nd4jBackend> loader = ServiceLoader.load(Nd4jBackend.class);
        try {
            Iterator<Nd4jBackend> backendIterator = loader.iterator();
            while (backendIterator.hasNext()) {
                backends.add(backendIterator.next());
            }
        }
        catch (ServiceConfigurationError serviceError) {
            throw new RuntimeException("failed to process available backends", serviceError);
        }
        Collections.sort(backends, new Comparator<Nd4jBackend>(){

            @Override
            public int compare(Nd4jBackend o1, Nd4jBackend o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        for (Nd4jBackend backend : backends) {
            if (!backend.isAvailable()) {
                log.trace("Skipped [{}] backend (unavailable)", (Object)backend.getClass().getSimpleName());
                continue;
            }
            log.trace("Loaded [{}] backend", (Object)backend.getClass().getSimpleName());
            return backend;
        }
        throw new NoAvailableBackendException();
    }

    public static class NoAvailableBackendException
    extends Exception {
    }
}

