/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import org.junit.Assert;
import org.junit.Test;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BlasWrapperTests {
    @Test
    public void axpyTest() {
        Nd4j.factory().setOrder('f');
        Nd4j.dtype = DataBuffer.Type.DOUBLE;
        INDArray a = Nd4j.getBlasWrapper().axpy(1.0, Nd4j.ones(3), Nd4j.ones(3));
        INDArray a2 = Nd4j.create(new double[]{2.0, 2.0, 2.0});
        Assert.assertEquals((Object)a2, (Object)a);
        INDArray matrix = Nd4j.linspace(1, 4, 4).reshape(2, 2);
        INDArray row = matrix.getRow(1);
        INDArray result = Nd4j.create(new double[]{1.0, 2.0});
        result = Nd4j.getBlasWrapper().axpy(1.0, row, result);
        Assert.assertEquals((Object)Nd4j.create(new double[]{3.0, 6.0}), (Object)result);
    }

    @Test
    public void testAxpyFortran() {
        Nd4j.factory().setOrder('f');
        INDArray threeByFour = Nd4j.linspace(1, 12, 12).reshape(3, 4);
        INDArray row = threeByFour.getRow(1);
        Nd4j.getBlasWrapper().axpy(2.0, row, row);
    }

    @Test
    public void testIaMax() {
        INDArray test = Nd4j.create(new float[]{1.0f, 2.0f, 3.0f, 4.0f});
        test.toString();
        int max = Nd4j.getBlasWrapper().iamax(test);
        Assert.assertEquals((long)3L, (long)max);
        INDArray rows = Nd4j.create(new float[]{1.0f, 3.0f, 2.0f, 4.0f}, new int[]{2, 2});
        for (int i = 0; i < rows.rows(); ++i) {
            INDArray row = rows.getRow(i);
            int max2 = Nd4j.getBlasWrapper().iamax(row);
            Assert.assertEquals((long)1L, (long)max2);
        }
    }
}

