/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.test;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DoubleBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComplexNDArrayTests {
    private static Logger log = LoggerFactory.getLogger(ComplexNDArrayTests.class);

    @Before
    public void before() {
        Nd4j.factory().setOrder('c');
    }

    @Test
    public void testConstruction() {
        IComplexNDArray arr2 = Nd4j.createComplex(new int[]{3, 2});
        Assert.assertEquals((long)3L, (long)arr2.rows());
        Assert.assertEquals((long)arr2.rows(), (long)arr2.rows());
        Assert.assertEquals((long)2L, (long)arr2.columns());
        Assert.assertEquals((long)arr2.columns(), (long)arr2.columns());
        Assert.assertTrue((boolean)arr2.isMatrix());
        IComplexNDArray arr = Nd4j.createComplex(new double[]{0.0, 1.0}, new int[]{1});
        Assert.assertEquals((long)1L, (long)arr.length());
        Assert.assertEquals((long)2L, (long)arr.data().length());
        IComplexNumber n1 = (IComplexNumber)arr.getScalar(0).element();
        Assert.assertEquals((double)0.0, (double)n1.realComponent().doubleValue(), (double)0.1);
        IComplexNumber[] two = new IComplexDouble[]{Nd4j.createDouble(1.0, 0.0), Nd4j.createDouble(2.0, 0.0)};
        double[] testArr = new double[]{1.0, 0.0, 2.0, 0.0};
        IComplexNDArray assertComplexDouble = Nd4j.createComplex(testArr, new int[]{2});
        IComplexNDArray testComplexDouble = Nd4j.createComplex(two, new int[]{2});
        Assert.assertEquals((Object)assertComplexDouble, (Object)testComplexDouble);
    }

    @Test
    public void testSortFortran() {
        IComplexNDArray matrix = Nd4j.complexLinSpace(1, 4, 4).reshape(2, 2);
        IComplexNDArray sorted = Nd4j.sort(matrix.dup(), 1, true);
        Assert.assertEquals((Object)matrix, (Object)sorted);
        IComplexNDArray reversed = Nd4j.createComplex(new float[]{2.0f, 0.0f, 1.0f, 0.0f, 4.0f, 0.0f, 3.0f, 0.0f}, new int[]{2, 2});
        IComplexNDArray sortedReversed = Nd4j.sort(matrix.dup(), 1, false);
        Assert.assertEquals((Object)reversed, (Object)sortedReversed);
    }

    @Test
    public void testSort() {
        IComplexNDArray matrix = Nd4j.complexLinSpace(1, 4, 4).reshape(2, 2);
        IComplexNDArray sorted = Nd4j.sort(matrix.dup(), 1, true);
        Assert.assertEquals((Object)matrix, (Object)sorted);
        IComplexNDArray reversed = Nd4j.createComplex(new float[]{2.0f, 0.0f, 1.0f, 0.0f, 4.0f, 0.0f, 3.0f, 0.0f}, new int[]{2, 2});
        IComplexNDArray sortedReversed = Nd4j.sort(matrix, 1, false);
        Assert.assertEquals((Object)reversed, (Object)sortedReversed);
    }

    @Test
    public void testSortWithIndicesDescending() {
        IComplexNDArray toSort = Nd4j.complexLinSpace(1, 4, 4).reshape(2, 2);
        INDArray[] sorted = Nd4j.sortWithIndices(toSort.dup(), 1, false);
        IComplexNDArray sorted2 = Nd4j.sort(toSort.dup(), 1, false);
        Assert.assertEquals((Object)sorted[1], (Object)sorted2);
        INDArray shouldIndex = Nd4j.create(new float[]{1.0f, 0.0f, 1.0f, 0.0f}, new int[]{2, 2});
        Assert.assertEquals((Object)shouldIndex, (Object)sorted[0]);
    }

    @Test
    public void testSortWithIndices() {
        IComplexNDArray toSort = Nd4j.complexLinSpace(1, 4, 4).reshape(2, 2);
        INDArray[] sorted = Nd4j.sortWithIndices(toSort.dup(), 1, true);
        IComplexNDArray sorted2 = Nd4j.sort(toSort.dup(), 1, true);
        Assert.assertEquals((Object)sorted[1], (Object)sorted2);
        INDArray shouldIndex = Nd4j.create(new float[]{0.0f, 1.0f, 0.0f, 1.0f}, new int[]{2, 2});
        Assert.assertEquals((Object)shouldIndex, (Object)sorted[0]);
    }

    @Test
    public void testDimShuffle() {
        IComplexNDArray n = Nd4j.complexLinSpace(1, 4, 4).reshape(2, 2);
        IComplexNDArray twoOneTwo = n.dimShuffle(new Object[]{0, Character.valueOf('x'), 1}, new int[]{0, 1}, new boolean[]{false, false});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 1, 2}, twoOneTwo.shape()));
        IComplexNDArray reverse = n.dimShuffle(new Object[]{1, Character.valueOf('x'), 0}, new int[]{1, 0}, new boolean[]{false, false});
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 1, 2}, reverse.shape()));
    }

    @Test
    public void testPutComplex() {
        IComplexNDArray complexVector;
        INDArray vector;
        int i;
        INDArray fourTwoTwo = Nd4j.linspace(1, 16, 16).reshape(4, 2, 2);
        IComplexNDArray test = Nd4j.createComplex(4, 2, 2);
        for (i = 0; i < test.vectorsAlongDimension(0); ++i) {
            vector = fourTwoTwo.vectorAlongDimension(i, 0);
            complexVector = test.vectorAlongDimension(i, 0);
            for (int j = 0; j < complexVector.length(); ++j) {
                complexVector.putReal(j, vector.getFloat(j));
            }
        }
        for (i = 0; i < test.vectorsAlongDimension(0); ++i) {
            vector = fourTwoTwo.vectorAlongDimension(i, 0);
            complexVector = test.vectorAlongDimension(i, 0);
            Assert.assertEquals((Object)vector, (Object)complexVector.real());
        }
    }

    @Test
    public void testColumnWithReshape() {
        IComplexNDArray ones = Nd4j.complexOnes(4).reshape(2, 2);
        IComplexNDArray column = Nd4j.createComplex(new float[]{2.0f, 0.0f, 6.0f, 0.0f});
        ones.putColumn(1, column);
        Assert.assertEquals((Object)column, (Object)ones.getColumn(1));
    }

    @Test
    public void testCreateFromNDArray() {
        Nd4j.dtype = DataBuffer.Type.DOUBLE;
        INDArray arr = Nd4j.create(new double[][]{{1.0, 2.0}, {3.0, 4.0}});
        IComplexNDArray complex = Nd4j.createComplex(arr);
        for (int i = 0; i < arr.rows(); ++i) {
            for (int j = 0; j < arr.columns(); ++j) {
                double d = arr.getFloat(i, j);
                IComplexNumber complexD = complex.getComplex(i, j);
                Assert.assertEquals((Object)Nd4j.createDouble(d, 0.0), (Object)complexD);
            }
        }
        Nd4j.factory().setOrder('f');
        INDArray fortran = Nd4j.create(new double[][]{{1.0, 2.0}, {3.0, 4.0}});
        Assert.assertEquals((Object)arr, (Object)fortran);
        IComplexNDArray fortranComplex = Nd4j.createComplex(fortran);
        for (int i = 0; i < fortran.rows(); ++i) {
            for (int j = 0; j < fortran.columns(); ++j) {
                double d = fortran.getFloat(i, j);
                IComplexNumber complexD = fortranComplex.getComplex(i, j);
                Assert.assertEquals((Object)Nd4j.createDouble(d, 0.0), (Object)complexD);
            }
        }
        Nd4j.factory().setOrder('c');
    }

    @Test
    public void testSum() {
        IComplexNDArray n = Nd4j.createComplex(Nd4j.create(Nd4j.linspace(1, 8, 8).data(), new int[]{2, 2, 2}));
        Assert.assertEquals((Object)Nd4j.createDouble(36.0, 0.0), (Object)n.sum(Integer.MAX_VALUE).getComplex(0));
    }

    @Test
    public void testCreateComplexFromReal() {
        INDArray n = Nd4j.create(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0}, new int[]{2, 4});
        IComplexNDArray nComplex = Nd4j.createComplex(n);
        for (int i = 0; i < n.vectorsAlongDimension(0); ++i) {
            INDArray vec = n.vectorAlongDimension(i, 0);
            IComplexNDArray vecComplex = nComplex.vectorAlongDimension(i, 0);
            Assert.assertEquals((long)vec.length(), (long)vecComplex.length());
            for (int j = 0; j < vec.length(); ++j) {
                IComplexNumber currComplex = vecComplex.getComplex(j);
                double curr = vec.getFloat(j);
                Assert.assertEquals((double)curr, (double)currComplex.realComponent().doubleValue(), (double)0.1);
            }
            Assert.assertEquals((Object)vec, (Object)vecComplex.getReal());
        }
    }

    @Test
    public void testVectorOffsetRavel() {
        IComplexNDArray arr = Nd4j.complexLinSpace(1, 20, 20).reshape(4, 5);
        for (int i = 0; i < arr.slices(); ++i) {
            Assert.assertEquals((Object)arr.slice(i), (Object)arr.slice(i).ravel());
        }
    }

    @Test
    public void testSliceVsVectorAlongDimension() {
        IComplexNDArray arr = Nd4j.complexLinSpace(1, 20, 20).reshape(4, 5);
        Assert.assertEquals((long)arr.slices(), (long)arr.vectorsAlongDimension(1));
        for (int i = 0; i < arr.slices(); ++i) {
            Assert.assertEquals((Object)arr.vectorAlongDimension(i, 1), (Object)arr.slice(i));
            Assert.assertEquals((Object)arr.vectorAlongDimension(i, 1).ravel(), (Object)arr.slice(i).ravel());
        }
    }

    @Test
    public void testVectorAlongDimension() {
        INDArray n = Nd4j.linspace(1, 8, 8).reshape(2, 4);
        IComplexNDArray nComplex = Nd4j.createComplex(Nd4j.linspace(1, 8, 8)).reshape(2, 4);
        Assert.assertEquals((long)n.vectorsAlongDimension(0), (long)nComplex.vectorsAlongDimension(0));
        for (int i = 0; i < n.vectorsAlongDimension(0); ++i) {
            INDArray vec = n.vectorAlongDimension(i, 0);
            IComplexNDArray vecComplex = nComplex.vectorAlongDimension(i, 0);
            Assert.assertEquals((long)vec.length(), (long)vecComplex.length());
            for (int j = 0; j < vec.length(); ++j) {
                IComplexNumber currComplex = vecComplex.getComplex(j);
                double curr = vec.getFloat(j);
                Assert.assertEquals((double)curr, (double)currComplex.realComponent().doubleValue(), (double)0.1);
            }
            Assert.assertEquals((Object)vec, (Object)vecComplex.getReal());
        }
    }

    @Test
    public void testVectorGet() {
        IComplexNDArray arr = Nd4j.createComplex(Nd4j.create(Nd4j.linspace(1, 8, 8).data(), new int[]{8}));
        for (int i = 0; i < arr.length(); ++i) {
            IComplexNumber curr = arr.getComplex(i);
            Assert.assertEquals((Object)Nd4j.createDouble(i + 1, 0.0), (Object)curr);
        }
        IComplexNDArray matrix = Nd4j.createComplex(Nd4j.create(Nd4j.linspace(1, 8, 8).data(), new int[]{2, 4}));
        IComplexNDArray row = matrix.getRow(1);
        IComplexNDArray column = matrix.getColumn(1);
        IComplexNDArray validate = Nd4j.createComplex(Nd4j.create(new double[]{5.0, 6.0, 7.0, 8.0}, new int[]{4}));
        IComplexNumber d = row.getComplex(3);
        Assert.assertEquals((Object)Nd4j.createDouble(8.0, 0.0), (Object)d);
        Assert.assertEquals((Object)row, (Object)validate);
        IComplexNumber d2 = column.getComplex(1);
        Assert.assertEquals((Object)Nd4j.createDouble(6.0, 0.0), (Object)d2);
    }

    @Test
    public void testTensorStrides() {
        Nd4j.factory().setOrder('c');
        IComplexNDArray arr = Nd4j.createComplex(106, 1, 3, 3);
        int[] assertion = ArrayUtil.of(18, 18, 6, 2);
        int[] arrShape = arr.stride();
        Assert.assertTrue((boolean)Arrays.equals(assertion, arrShape));
        Nd4j.factory().setOrder('f');
        arr = Nd4j.createComplex(106, 1, 3, 3);
        assertion = ArrayUtil.of(2, 212, 212, 636);
        arrShape = arr.stride();
        Assert.assertTrue((boolean)Arrays.equals(assertion, arrShape));
    }

    @Test
    public void testLinearView() {
        IComplexNDArray n = Nd4j.complexLinSpace(1, 4, 4).reshape(2, 2);
        IComplexNDArray row = n.getRow(1);
        IComplexNDArray linear = row.linearView();
        Assert.assertEquals((Object)row, (Object)linear);
        IComplexNDArray large = Nd4j.complexLinSpace(1, 1000, 1000).reshape(2, 500);
        IComplexNDArray largeLinear = large.linearView();
        for (int i = 0; i < largeLinear.length(); ++i) {
            Assert.assertEquals((double)(i + 1), (double)largeLinear.getReal(i), (double)0.1);
        }
        IComplexNDArray largeTensor = large.reshape(1000, 1, 1, 1);
        for (int i = 0; i < largeLinear.length(); ++i) {
            Assert.assertEquals((double)(i + 1), (double)largeTensor.getReal(i), (double)0.1);
        }
    }

    @Test
    public void testSwapAxesFortranOrder() {
        Nd4j.factory().setOrder('f');
        IComplexNDArray n = Nd4j.createComplex(Nd4j.linspace(1, 30, 30)).reshape(3, 5, 2);
        IComplexNDArray slice = n.swapAxes(2, 1);
        IComplexNDArray assertion = Nd4j.createComplex(new double[]{1.0, 0.0, 4.0, 0.0, 7.0, 0.0, 10.0, 0.0, 13.0, 0.0});
        IComplexNDArray test = slice.slice(0).slice(0);
        Assert.assertEquals((Object)assertion, (Object)test);
    }

    @Test
    public void testSwapAxes() {
        IComplexNDArray n = Nd4j.createComplex(Nd4j.create(new double[]{1.0, 2.0, 3.0}, new int[]{3, 1}));
        IComplexNDArray swapped = n.swapAxes(1, 0);
        Assert.assertEquals((Object)n.transpose(), (Object)swapped);
        Assert.assertEquals((Object)swapped.getScalar(0), (Object)n.getScalar(0));
        Assert.assertEquals((Object)swapped.getScalar(1), (Object)n.getScalar(1));
        Assert.assertEquals((Object)swapped.getScalar(2), (Object)n.getScalar(2));
        IComplexNDArray n2 = Nd4j.createComplex(Nd4j.create(Nd4j.linspace(0, 7, 8).data(), new int[]{2, 2, 2}));
        IComplexNDArray assertion = n2.permute(new int[]{2, 1, 0});
        IComplexNDArray validate = Nd4j.createComplex(Nd4j.create(new double[]{0.0, 4.0, 2.0, 6.0, 1.0, 5.0, 3.0, 7.0}, new int[]{2, 2, 2}));
        Assert.assertEquals((Object)validate, (Object)assertion);
        IComplexNDArray v1 = Nd4j.createComplex(Nd4j.create(Nd4j.linspace(1, 8, 8).data(), new int[]{8, 1}));
        IComplexNDArray swap = v1.swapAxes(1, 0);
        IComplexNDArray transposed = v1.transpose();
        Assert.assertEquals((Object)swap, (Object)transposed);
        transposed.put(1, Nd4j.scalar(9.0f));
        swap.put(1, Nd4j.scalar(9.0f));
        Assert.assertEquals((Object)transposed, (Object)swap);
        Assert.assertEquals((Object)transposed.getScalar(1).element(), (Object)swap.getScalar(1).element());
        IComplexNDArray row = n2.slice(0).getRow(1);
        row.put(1, Nd4j.scalar(9.0f));
        IComplexNumber n3 = (IComplexNumber)row.getScalar(1).element();
        Assert.assertEquals((double)9.0, (double)n3.realComponent().doubleValue(), (double)0.1);
    }

    @Test
    public void testSliceOffset() {
        IComplexNDArray test = Nd4j.complexLinSpace(1, 10, 10).reshape(2, 5);
        IComplexNDArray testSlice0 = Nd4j.complexLinSpace(1, 5, 5);
        IComplexNDArray testSlice1 = Nd4j.complexLinSpace(6, 10, 5);
        Assert.assertEquals((Object)testSlice0, (Object)test.slice(0));
        Assert.assertEquals((Object)testSlice1, (Object)test.slice(1));
        IComplexNDArray sliceOfSlice0 = test.slice(0).slice(0);
        Assert.assertEquals((Object)sliceOfSlice0.getComplex(0), (Object)Nd4j.createComplexNumber(1, 0));
        Assert.assertEquals((Object)test.slice(1).slice(0).getComplex(0), (Object)Nd4j.createComplexNumber(6, 0));
        Assert.assertEquals((Object)test.slice(1).getComplex(1), (Object)Nd4j.createComplexNumber(7, 0));
    }

    @Test
    public void testSlice() {
        Nd4j.MAX_ELEMENTS_PER_SLICE = -1;
        Nd4j.MAX_SLICES_TO_PRINT = -1;
        IComplexNDArray slices = Nd4j.createComplex(2, 3);
        slices.put(0, 0, 1);
        slices.put(0, 1, 2);
        slices.put(0, 2, 3);
        slices.put(1, 1, 4);
        IComplexNDArray assertion = Nd4j.createComplex(new IComplexNumber[]{Nd4j.createComplexNumber(1, 0), Nd4j.createComplexNumber(2, 0), Nd4j.createComplexNumber(3, 0)});
        Assert.assertEquals((Object)assertion, (Object)slices.slice(0));
        INDArray arr = Nd4j.create(Nd4j.linspace(1, 24, 24).data(), new int[]{4, 3, 2});
        IComplexNDArray arr2 = Nd4j.createComplex(arr);
        Assert.assertEquals((Object)arr, (Object)arr2.getReal());
        INDArray firstSlice = arr.slice(0);
        INDArray firstSliceTest = arr2.slice(0).getReal();
        Assert.assertEquals((Object)firstSlice, (Object)firstSliceTest);
        INDArray secondSlice = arr.slice(1);
        INDArray secondSliceTest = arr2.slice(1).getReal();
        Assert.assertEquals((Object)secondSlice, (Object)secondSliceTest);
        INDArray slice0 = Nd4j.create(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0}, new int[]{3, 2});
        INDArray slice2 = Nd4j.create(new double[]{7.0, 8.0, 9.0, 10.0, 11.0, 12.0}, new int[]{3, 2});
        IComplexNDArray testSliceComplex = arr2.slice(0);
        IComplexNDArray testSliceComplex2 = arr2.slice(1);
        INDArray testSlice0 = testSliceComplex.getReal();
        INDArray testSlice1 = testSliceComplex2.getReal();
        Assert.assertEquals((Object)slice0, (Object)testSlice0);
        Assert.assertEquals((Object)slice2, (Object)testSlice1);
        INDArray n2 = Nd4j.create(Nd4j.linspace(1, 30, 30).data(), new int[]{3, 5, 2});
        INDArray swapped = n2.swapAxes(n2.shape().length - 1, 1);
        INDArray firstSlice2 = swapped.slice(0).slice(0);
        IComplexNDArray testSlice = Nd4j.createComplex(firstSlice2);
        IComplexNDArray testNoOffset = Nd4j.createComplex(new double[]{1.0, 0.0, 3.0, 0.0, 5.0, 0.0, 7.0, 0.0, 9.0, 0.0}, new int[]{5});
        Assert.assertEquals((Object)testSlice, (Object)testNoOffset);
    }

    @Test
    public void testSliceConstructor() {
        ArrayList<IComplexNDArray> testList = new ArrayList<IComplexNDArray>();
        for (int i = 0; i < 5; ++i) {
            testList.add(Nd4j.complexScalar(i + 1));
        }
        IComplexNDArray test = Nd4j.createComplex(testList, new int[]{testList.size()});
        IComplexNDArray expected = Nd4j.createComplex(Nd4j.create(new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, new int[]{5}));
        Assert.assertEquals((Object)expected, (Object)test);
    }

    @Test
    public void testVectorInit() {
        DataBuffer data = Nd4j.linspace(1, 4, 4).data();
        IComplexNDArray arr = Nd4j.createComplex(data, new int[]{4});
        Assert.assertEquals((Object)true, (Object)arr.isRowVector());
        IComplexNDArray arr2 = Nd4j.createComplex(data, new int[]{1, 4});
        Assert.assertEquals((Object)true, (Object)arr2.isRowVector());
        IComplexNDArray columnVector = Nd4j.createComplex(data, new int[]{4, 1});
        Assert.assertEquals((Object)true, (Object)columnVector.isColumnVector());
    }

    @Test
    public void testMmulOffset() {
        IComplexNDArray three = Nd4j.createComplex(Nd4j.create(new double[]{3.0, 4.0}, new int[]{2}));
        IComplexNDArray test = Nd4j.createComplex(Nd4j.create(Nd4j.linspace(1, 30, 30).data(), new int[]{3, 5, 2}));
        IComplexNDArray sliceRow = test.slice(0).getRow(1);
        Assert.assertEquals((Object)three, (Object)sliceRow);
        IComplexNDArray twoSix = Nd4j.createComplex(Nd4j.create(new double[]{2.0, 6.0}, new int[]{2, 1}));
        IComplexNDArray threeTwoSix = three.mmul(twoSix);
        IComplexNDArray sliceRowTwoSix = sliceRow.mmul(twoSix);
        this.verifyElements(three, sliceRow);
        Assert.assertEquals((Object)threeTwoSix, (Object)sliceRowTwoSix);
    }

    @Test
    public void testTwoByTwoMmul() {
        Nd4j.factory().setOrder('f');
        IComplexNDArray oneThroughFour = Nd4j.createComplex(Nd4j.linspace(1, 4, 4).reshape(2, 2));
        IComplexNDArray fiveThroughEight = Nd4j.createComplex(Nd4j.linspace(5, 8, 4).reshape(2, 2));
        IComplexNDArray solution = Nd4j.createComplex(Nd4j.create(new double[][]{{23.0, 31.0}, {34.0, 46.0}}));
        IComplexNDArray test = oneThroughFour.mmul(fiveThroughEight);
        Assert.assertEquals((Object)solution, (Object)test);
    }

    @Test
    public void testCopy() {
        IComplexNDArray ones = Nd4j.complexOnes(2);
        IComplexNDArray zeros = Nd4j.complexZeros(2);
        Nd4j.getBlasWrapper().copy(ones, zeros);
        Assert.assertEquals((Object)ones, (Object)zeros);
    }

    @Test
    public void testRealConversion() {
        IComplexNDArray arr = Nd4j.createComplex(1, 5);
        INDArray arr1 = Nd4j.create(1, 5);
        Assert.assertEquals((Object)arr, (Object)Nd4j.createComplex(arr1));
        IComplexNDArray arr3 = Nd4j.complexLinSpace(1, 6, 6).reshape(2, 3);
        INDArray linspace = Nd4j.linspace(1, 6, 6).reshape(2, 3);
        Assert.assertEquals((Object)arr3, (Object)Nd4j.createComplex(linspace));
    }

    @Test
    public void testMmul() {
        Nd4j.dtype = DataBuffer.Type.FLOAT;
        Nd4j.factory().setOrder('f');
        DataBuffer data = Nd4j.linspace(1, 10, 10).data();
        IComplexNDArray n = Nd4j.createComplex(Nd4j.create(data, new int[]{10}));
        IComplexNDArray transposed = n.transpose();
        Assert.assertEquals((Object)true, (Object)n.isRowVector());
        Assert.assertEquals((Object)true, (Object)transposed.isColumnVector());
        IComplexNDArray innerProduct = n.mmul(transposed);
        INDArray scalar = Nd4j.scalar(385.0f);
        Assert.assertEquals((Object)scalar, (Object)innerProduct.getReal());
        IComplexNDArray outerProduct = transposed.mmul(n);
        Assert.assertEquals((Object)true, (Object)Shape.shapeEquals(new int[]{10, 10}, outerProduct.shape()));
        IComplexNDArray vectorVector = Nd4j.createComplex(Nd4j.create(new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 0.0, 2.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0, 30.0, 0.0, 3.0, 6.0, 9.0, 12.0, 15.0, 18.0, 21.0, 24.0, 27.0, 30.0, 33.0, 36.0, 39.0, 42.0, 45.0, 0.0, 4.0, 8.0, 12.0, 16.0, 20.0, 24.0, 28.0, 32.0, 36.0, 40.0, 44.0, 48.0, 52.0, 56.0, 60.0, 0.0, 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 55.0, 60.0, 65.0, 70.0, 75.0, 0.0, 6.0, 12.0, 18.0, 24.0, 30.0, 36.0, 42.0, 48.0, 54.0, 60.0, 66.0, 72.0, 78.0, 84.0, 90.0, 0.0, 7.0, 14.0, 21.0, 28.0, 35.0, 42.0, 49.0, 56.0, 63.0, 70.0, 77.0, 84.0, 91.0, 98.0, 105.0, 0.0, 8.0, 16.0, 24.0, 32.0, 40.0, 48.0, 56.0, 64.0, 72.0, 80.0, 88.0, 96.0, 104.0, 112.0, 120.0, 0.0, 9.0, 18.0, 27.0, 36.0, 45.0, 54.0, 63.0, 72.0, 81.0, 90.0, 99.0, 108.0, 117.0, 126.0, 135.0, 0.0, 10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0, 110.0, 120.0, 130.0, 140.0, 150.0, 0.0, 11.0, 22.0, 33.0, 44.0, 55.0, 66.0, 77.0, 88.0, 99.0, 110.0, 121.0, 132.0, 143.0, 154.0, 165.0, 0.0, 12.0, 24.0, 36.0, 48.0, 60.0, 72.0, 84.0, 96.0, 108.0, 120.0, 132.0, 144.0, 156.0, 168.0, 180.0, 0.0, 13.0, 26.0, 39.0, 52.0, 65.0, 78.0, 91.0, 104.0, 117.0, 130.0, 143.0, 156.0, 169.0, 182.0, 195.0, 0.0, 14.0, 28.0, 42.0, 56.0, 70.0, 84.0, 98.0, 112.0, 126.0, 140.0, 154.0, 168.0, 182.0, 196.0, 210.0, 0.0, 15.0, 30.0, 45.0, 60.0, 75.0, 90.0, 105.0, 120.0, 135.0, 150.0, 165.0, 180.0, 195.0, 210.0, 225.0}, new int[]{16, 16}));
        IComplexNDArray n1 = Nd4j.createComplex(Nd4j.create(Nd4j.linspace(0, 15, 16).data(), new int[]{16}));
        IComplexNDArray k1 = n1.transpose();
        IComplexNDArray testVectorVector = k1.mmul(n1);
        Assert.assertEquals((Object)vectorVector, (Object)testVectorVector);
        IComplexNDArray M2 = Nd4j.createComplex(new double[]{1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.30901699437494745, -0.9510565162951535, -0.8090169943749473, -0.5877852522924732, -0.8090169943749478, 0.5877852522924727, 0.30901699437494723, 0.9510565162951536, 1.0, 0.0, -0.8090169943749473, -0.5877852522924732, 0.30901699437494723, 0.9510565162951536, 0.30901699437494856, -0.9510565162951532, -0.8090169943749477, 0.5877852522924728, 1.0, 0.0, -0.8090169943749478, 0.5877852522924727, 0.30901699437494856, -0.9510565162951532, 0.309016994374947, 0.9510565162951538, -0.809016994374946, -0.587785252292475, 1.0, 0.0, 0.30901699437494723, 0.9510565162951536, -0.8090169943749477, 0.5877852522924728, -0.809016994374946, -0.587785252292475, 0.3090169943749482, -0.9510565162951533}, new int[]{5, 5});
        INDArray n2 = Nd4j.create(Nd4j.linspace(1, 30, 30).data(), new int[]{3, 5, 2});
        INDArray swapped = n2.swapAxes(n2.shape().length - 1, 1);
        INDArray firstSlice = swapped.slice(0).slice(0);
        IComplexNDArray testSlice = Nd4j.createComplex(firstSlice);
        IComplexNDArray testNoOffset = Nd4j.createComplex(new double[]{1.0, 0.0, 4.0, 0.0, 7.0, 0.0, 10.0, 0.0, 13.0, 0.0}, new int[]{5});
        Assert.assertEquals((Object)testSlice, (Object)testNoOffset);
        IComplexNDArray testSliceM2 = testSlice.mmul(M2);
        IComplexNDArray testNofOffsetM2 = testNoOffset.mmul(M2);
        Assert.assertEquals((Object)testSliceM2, (Object)testNofOffsetM2);
    }

    @Test
    public void testTranspose() {
        IComplexNDArray ndArray = Nd4j.createComplex(new double[]{1.0, 0.0, 2.0, 0.0, 3.0, 0.0, 4.0, 0.0, 5.0, 0.0, 6.0, 0.0, 6.999999999999999, 0.0, 8.0, 0.0, 9.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, new int[]{16, 1});
        IComplexNDArray transposed2 = ndArray.transpose();
        Assert.assertEquals((long)16L, (long)transposed2.columns());
    }

    @Test
    public void testConjugate() {
        IComplexNDArray negative = Nd4j.createComplex(new double[]{1.0, -1.0, 2.0, -1.0}, new int[]{2});
        IComplexNDArray positive = Nd4j.createComplex(new double[]{1.0, 1.0, 2.0, 1.0}, new int[]{2});
        Assert.assertEquals((Object)negative, (Object)positive.conj());
    }

    @Test
    public void testGetRow() {
        IComplexNDArray arr = Nd4j.createComplex(new int[]{3, 2});
        IComplexNDArray row = Nd4j.createComplex(new double[]{1.0, 0.0, 2.0, 0.0}, new int[]{2});
        arr.putRow(0, row);
        IComplexNDArray firstRow = arr.getRow(0);
        Assert.assertEquals((Object)true, (Object)Shape.shapeEquals(new int[]{2}, firstRow.shape()));
        IComplexNDArray testRow = arr.getRow(0);
        Assert.assertEquals((Object)row, (Object)testRow);
        IComplexNDArray row1 = Nd4j.createComplex(new double[]{3.0, 0.0, 4.0, 0.0}, new int[]{2});
        arr.putRow(1, row1);
        Assert.assertEquals((Object)true, (Object)Shape.shapeEquals(new int[]{2}, arr.getRow(0).shape()));
        IComplexNDArray testRow1 = arr.getRow(1);
        Assert.assertEquals((Object)row1, (Object)testRow1);
        INDArray fourTwoTwo = Nd4j.linspace(1, 16, 16).reshape(4, 2, 2);
        IComplexNDArray multiRow = Nd4j.createComplex(fourTwoTwo);
        IComplexNDArray test = Nd4j.createComplex(Nd4j.create(new double[]{7.0, 8.0}, new int[]{1, 2}));
        IComplexNDArray multiRowSlice1 = multiRow.slice(0);
        IComplexNDArray multiRowSlice = multiRow.slice(1);
        IComplexNDArray testMultiRow = multiRowSlice.getRow(1);
        Assert.assertEquals((Object)test, (Object)testMultiRow);
    }

    @Test
    public void testMultiDimensionalCreation() {
        INDArray fourTwoTwo = Nd4j.linspace(1, 16, 16).reshape(4, 2, 2);
        IComplexNDArray multiRow = Nd4j.createComplex(fourTwoTwo);
        multiRow.toString();
        Assert.assertEquals((Object)fourTwoTwo, (Object)multiRow.getReal());
    }

    @Test
    public void testLinearIndex() {
        IComplexNDArray n = Nd4j.createComplex(Nd4j.create(Nd4j.linspace(1, 8, 8).data(), new int[]{8}));
        for (int i = 0; i < n.length(); ++i) {
            int linearIndex = n.linearIndex(i);
            Assert.assertEquals((long)(i * 2), (long)linearIndex);
            IComplexDouble d = (IComplexDouble)n.getScalar(i).element();
            double curr = d.realComponent();
            Assert.assertEquals((double)(i + 1), (double)curr, (double)0.1);
        }
    }

    @Test
    public void testGetComplex() {
        IComplexNDArray arr = Nd4j.createComplex(Nd4j.create(new DoubleBuffer(new double[]{1.0, 2.0, 3.0, 4.0, 5.0})));
        IComplexNumber num = arr.getComplex(4);
        Assert.assertEquals((Object)Nd4j.createDouble(5.0, 0.0), (Object)num);
        IComplexNDArray matrix = Nd4j.complexLinSpace(1, 10, 10).reshape(2, 5);
        IComplexNDArray slice = matrix.slice(0);
        IComplexNDArray assertion = Nd4j.complexLinSpace(1, 5, 5);
        Assert.assertEquals((Object)assertion, (Object)slice);
        IComplexNDArray assert2 = Nd4j.complexLinSpace(6, 10, 5);
        Assert.assertEquals((Object)assert2, (Object)matrix.slice(1));
    }

    @Test
    public void testNdArrayConstructor() {
        IComplexNDArray result = Nd4j.createComplex(Nd4j.create(new double[]{2.0, 6.0}, new int[]{1, 2}));
        result.toString();
    }

    @Test
    public void testGetColumn() {
        IComplexNDArray arr = Nd4j.createComplex(Nd4j.create(Nd4j.linspace(1, 8, 8).data(), new int[]{2, 4}));
        IComplexNDArray column2 = arr.getColumn(1);
        IComplexNDArray result = Nd4j.createComplex(Nd4j.create(new double[]{2.0, 6.0}, new int[]{1, 2}));
        Assert.assertEquals((Object)result, (Object)column2);
        Assert.assertEquals((Object)true, (Object)Shape.shapeEquals(new int[]{2}, column2.shape()));
        IComplexNDArray column = Nd4j.createComplex(new double[]{11.0, 0.0, 12.0, 0.0}, new int[]{2});
        arr.putColumn(1, column);
        IComplexNDArray firstColumn = arr.getColumn(1);
        Assert.assertEquals((Object)column, (Object)firstColumn);
        IComplexNDArray column1 = Nd4j.createComplex(new double[]{5.0, 0.0, 6.0, 0.0}, new int[]{2});
        arr.putColumn(1, column1);
        Assert.assertEquals((Object)true, (Object)Shape.shapeEquals(new int[]{2}, arr.getColumn(1).shape()));
        IComplexNDArray testC = arr.getColumn(1);
        Assert.assertEquals((Object)column1, (Object)testC);
        IComplexNDArray multiSlice = Nd4j.createComplex(Nd4j.create(Nd4j.linspace(1, 32, 32).data(), new int[]{4, 4, 2}));
        IComplexNDArray testColumn = Nd4j.createComplex(Nd4j.create(new double[]{10.0, 12.0, 14.0, 16.0}, new int[]{4}));
        IComplexNDArray sliceColumn = multiSlice.slice(1).getColumn(1);
        Assert.assertEquals((Object)sliceColumn, (Object)testColumn);
        IComplexNDArray testColumn2 = Nd4j.createComplex(Nd4j.create(new double[]{17.0, 19.0, 21.0, 23.0}, new int[]{4}));
        IComplexNDArray testSlice2 = multiSlice.slice(2).getColumn(0);
        Assert.assertEquals((Object)testColumn2, (Object)testSlice2);
        IComplexNDArray testColumn3 = Nd4j.createComplex(Nd4j.create(new double[]{18.0, 20.0, 22.0, 24.0}, new int[]{4}));
        IComplexNDArray testSlice3 = multiSlice.slice(2).getColumn(1);
        Assert.assertEquals((Object)testColumn3, (Object)testSlice3);
    }

    @Test
    public void testGetIndexing() {
        Nd4j.MAX_SLICES_TO_PRINT = Integer.MAX_VALUE;
        Nd4j.MAX_ELEMENTS_PER_SLICE = Integer.MAX_VALUE;
        IComplexNDArray tenByTen = Nd4j.complexLinSpace(1, 100, 100).reshape(10, 10);
        IComplexNDArray thirtyToSixty = (IComplexNDArray)Transforms.round(Nd4j.complexLinSpace(31, 60, 30)).reshape(3, 10);
        IComplexNDArray test = tenByTen.get(NDArrayIndex.interval(3, 6), NDArrayIndex.interval(0, tenByTen.columns()));
        Assert.assertEquals((Object)thirtyToSixty, (Object)test);
    }

    @Test
    public void testPutAndGet() {
        IComplexNDArray multiRow = Nd4j.createComplex(2, 2);
        multiRow.putScalar(0, 0, Nd4j.createComplexNumber(1, 0));
        multiRow.putScalar(0, 1, Nd4j.createComplexNumber(2, 0));
        multiRow.putScalar(1, 0, Nd4j.createComplexNumber(3, 0));
        multiRow.putScalar(1, 1, Nd4j.createComplexNumber(4, 0));
        Assert.assertEquals((Object)Nd4j.createComplexNumber(1, 0), (Object)multiRow.getComplex(0, 0));
        Assert.assertEquals((Object)Nd4j.createComplexNumber(2, 0), (Object)multiRow.getComplex(0, 1));
        Assert.assertEquals((Object)Nd4j.createComplexNumber(3, 0), (Object)multiRow.getComplex(1, 0));
        Assert.assertEquals((Object)Nd4j.createComplexNumber(4, 0), (Object)multiRow.getComplex(1, 1));
        IComplexNDArray arr = Nd4j.createComplex(Nd4j.create(new double[]{1.0, 2.0, 3.0, 4.0}, new int[]{2, 2}));
        Assert.assertEquals((long)4L, (long)arr.length());
        Assert.assertEquals((long)8L, (long)arr.data().length());
        arr.put(1, 1, Nd4j.scalar(5.0));
        IComplexNumber n1 = arr.getComplex(1, 1);
        IComplexNumber n2 = arr.getComplex(1, 1);
        Assert.assertEquals((double)5.0, (double)n1.realComponent().doubleValue(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)n2.imaginaryComponent().doubleValue(), (double)0.1);
    }

    @Test
    public void testGetReal() {
        DataBuffer data = Nd4j.linspace(1, 8, 8).data();
        int[] shape = new int[]{8};
        IComplexNDArray arr = Nd4j.createComplex(shape);
        for (int i = 0; i < arr.length(); ++i) {
            arr.put(i, Nd4j.scalar(data.getFloat(i)));
        }
        INDArray arr2 = Nd4j.create(data, shape);
        Assert.assertEquals((Object)arr2, (Object)arr.getReal());
        INDArray ones = Nd4j.ones(10);
        IComplexNDArray n2 = Nd4j.complexOnes(10);
        Assert.assertEquals((Object)ones, (Object)n2.getReal());
    }

    @Test
    public void testBroadcast() {
        IComplexNDArray arr = Nd4j.complexLinSpace(1, 5, 5);
        IComplexNDArray arrs = arr.broadcast(new int[]{5, 5});
        IComplexNDArray arrs3 = Nd4j.createComplex(5, 5);
        Assert.assertTrue((boolean)Arrays.equals(arrs.shape(), arrs3.shape()));
        for (int i = 0; i < arrs.slices(); ++i) {
            arrs3.putSlice(i, arr);
        }
        Assert.assertEquals((Object)arrs3, (Object)arrs);
    }

    @Test
    public void testBasicOperations() {
        IComplexNDArray arr = Nd4j.createComplex(new double[]{0.0, 1.0, 2.0, 1.0, 1.0, 2.0, 3.0, 4.0}, new int[]{2, 2});
        IComplexDouble scalar = (IComplexDouble)arr.sum(Integer.MAX_VALUE).element();
        double sum = scalar.realComponent();
        Assert.assertEquals((double)6.0, (double)sum, (double)0.1);
        arr.addi(1);
        scalar = (IComplexDouble)arr.sum(Integer.MAX_VALUE).element();
        sum = scalar.realComponent();
        Assert.assertEquals((double)10.0, (double)sum, (double)0.1);
        arr.subi(Nd4j.createDouble(1.0, 0.0));
        scalar = (IComplexDouble)arr.sum(Integer.MAX_VALUE).element();
        sum = scalar.realComponent();
        Assert.assertEquals((double)6.0, (double)sum, (double)0.1);
    }

    @Test
    public void testElementWiseOps() {
        IComplexNDArray n1 = Nd4j.complexScalar(1);
        IComplexNDArray n2 = Nd4j.complexScalar(2);
        Assert.assertEquals((Object)Nd4j.complexScalar(3), (Object)n1.add(n2));
        Assert.assertFalse((boolean)n1.add(n2).equals(n1));
        IComplexNDArray n3 = Nd4j.complexScalar(3);
        IComplexNDArray n4 = Nd4j.complexScalar(4);
        IComplexNDArray subbed = n4.sub(n3);
        IComplexNDArray mulled = n4.mul(n3);
        IComplexNDArray div = n4.div(n3);
        Assert.assertFalse((boolean)subbed.equals(n4));
        Assert.assertFalse((boolean)mulled.equals(n4));
        Assert.assertEquals((Object)Nd4j.complexScalar(1), (Object)subbed);
        Assert.assertEquals((Object)Nd4j.complexScalar(12), (Object)mulled);
        Assert.assertEquals((Object)Nd4j.complexScalar(1.3333333333333333), (Object)div);
        IComplexNDArray multiDimensionElementWise = Nd4j.createComplex(Nd4j.create(Nd4j.linspace(1, 24, 24).data(), new int[]{4, 3, 2}));
        IComplexDouble sum2 = (IComplexDouble)multiDimensionElementWise.sum(Integer.MAX_VALUE).element();
        Assert.assertEquals((Object)sum2, (Object)Nd4j.createDouble(300.0, 0.0));
        IComplexNDArray added = multiDimensionElementWise.add(Nd4j.complexScalar(1));
        IComplexDouble sum3 = (IComplexDouble)added.sum(Integer.MAX_VALUE).element();
        Assert.assertEquals((Object)sum3, (Object)Nd4j.createDouble(324.0, 0.0));
    }

    @Test
    public void testFlatten() {
        IComplexNDArray arr = Nd4j.createComplex(Nd4j.create(Nd4j.linspace(1, 4, 4).data(), new int[]{2, 2}));
        IComplexNDArray flattened = arr.ravel();
        Assert.assertEquals((long)arr.length(), (long)flattened.length());
        Assert.assertTrue((boolean)Shape.shapeEquals(new int[]{1, 4}, flattened.shape()));
        for (int i = 0; i < arr.length(); ++i) {
            IComplexNumber get = (IComplexNumber)flattened.getScalar(i).element();
            Assert.assertEquals((double)(i + 1), (double)get.realComponent().doubleValue(), (double)0.1);
        }
    }

    @Test
    public void testMatrixGet() {
        IComplexNDArray arr = Nd4j.createComplex(Nd4j.linspace(1, 4, 4)).reshape(2, 2);
        IComplexNumber n1 = arr.getComplex(0, 0);
        IComplexNumber n2 = arr.getComplex(0, 1);
        IComplexNumber n3 = arr.getComplex(1, 0);
        IComplexNumber n4 = arr.getComplex(1, 1);
        Assert.assertEquals((double)1.0, (double)n1.realComponent().doubleValue(), (double)0.1);
        Assert.assertEquals((double)2.0, (double)n2.realComponent().doubleValue(), (double)0.1);
        Assert.assertEquals((double)3.0, (double)n3.realComponent().doubleValue(), (double)0.1);
        Assert.assertEquals((double)4.0, (double)n4.realComponent().doubleValue(), (double)0.1);
    }

    @Test
    public void testEndsForSlices() {
        IComplexNDArray arr = Nd4j.createComplex(Nd4j.create(Nd4j.linspace(1, 24, 24).data(), new int[]{4, 3, 2}));
        int[] endsForSlices = arr.endsForSlices();
        Assert.assertEquals((Object)true, (Object)Arrays.equals(new int[]{0, 12, 24, 36}, endsForSlices));
    }

    @Test
    public void testWrap() {
        IComplexNDArray vec;
        IComplexNDArray c;
        IComplexNDArray wrapped = c = Nd4j.createComplex(Nd4j.linspace(1, 4, 4).reshape(2, 2));
        Assert.assertEquals((Object)true, (Object)Arrays.equals(new int[]{2, 2}, wrapped.shape()));
        IComplexNDArray wrappedVector = vec = Nd4j.createComplex(Nd4j.linspace(1, 4, 4));
        Assert.assertEquals((Object)true, (Object)wrappedVector.isVector());
        Assert.assertEquals((Object)true, (Object)Shape.shapeEquals(new int[]{4}, wrappedVector.shape()));
    }

    protected void verifyElements(IComplexNDArray d, IComplexNDArray d2) {
        for (int i = 0; i < d.rows(); ++i) {
            for (int j = 0; j < d.columns(); ++j) {
                IComplexNumber test1 = d.getComplex(i, j);
                IComplexNumber test2 = d2.getComplex(i, j);
                Assert.assertEquals((double)test1.realComponent().doubleValue(), (double)test2.realComponent().doubleValue(), (double)1.0E-6);
                Assert.assertEquals((double)test1.imaginaryComponent().doubleValue(), (double)test2.imaginaryComponent().doubleValue(), (double)1.0E-6);
            }
        }
    }
}

