/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.rng;

import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.SynchronizedRandomGenerator;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.factory.Nd4j;

public class DefaultRandom
implements Random,
RandomGenerator {
    protected RandomGenerator randomGenerator;

    public DefaultRandom() {
        this(System.currentTimeMillis());
    }

    public DefaultRandom(long seed) {
        this.randomGenerator = new SynchronizedRandomGenerator((RandomGenerator)new MersenneTwister(seed));
    }

    public DefaultRandom(RandomGenerator randomGenerator) {
        this.randomGenerator = randomGenerator;
    }

    @Override
    public void setSeed(int seed) {
        this.getRandomGenerator().setSeed(seed);
    }

    @Override
    public void setSeed(int[] seed) {
        this.getRandomGenerator().setSeed(seed);
    }

    @Override
    public void setSeed(long seed) {
        this.getRandomGenerator().setSeed(seed);
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.getRandomGenerator().nextBytes(bytes);
    }

    @Override
    public int nextInt() {
        return this.getRandomGenerator().nextInt();
    }

    @Override
    public int nextInt(int n) {
        return this.getRandomGenerator().nextInt(n);
    }

    @Override
    public long nextLong() {
        return this.getRandomGenerator().nextLong();
    }

    @Override
    public boolean nextBoolean() {
        return this.getRandomGenerator().nextBoolean();
    }

    @Override
    public float nextFloat() {
        return this.getRandomGenerator().nextFloat();
    }

    @Override
    public double nextDouble() {
        return this.getRandomGenerator().nextDouble();
    }

    @Override
    public double nextGaussian() {
        return this.getRandomGenerator().nextGaussian();
    }

    @Override
    public INDArray nextGaussian(int[] shape) {
        INDArray ret = Nd4j.create(shape);
        INDArray linear = ret.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            ret.putScalar(i, this.nextGaussian());
        }
        return ret;
    }

    @Override
    public INDArray nextDouble(int[] shape) {
        INDArray ret = Nd4j.create(shape);
        INDArray linear = ret.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, this.nextDouble());
        }
        return ret;
    }

    @Override
    public INDArray nextFloat(int[] shape) {
        INDArray ret = Nd4j.create(shape);
        INDArray linear = ret.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            ret.putScalar(i, this.nextFloat());
        }
        return ret;
    }

    @Override
    public INDArray nextInt(int[] shape) {
        INDArray ret = Nd4j.create(shape);
        INDArray linear = ret.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            ret.putScalar(i, this.nextInt());
        }
        return ret;
    }

    @Override
    public INDArray nextInt(int n, int[] shape) {
        INDArray ret = Nd4j.create(shape);
        INDArray linear = ret.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            ret.putScalar(i, this.nextInt(n));
        }
        return ret;
    }

    public synchronized RandomGenerator getRandomGenerator() {
        return this.randomGenerator;
    }
}

