/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ComplexUtil;

public class HardTanhDerivative
extends BaseTransformOp {
    public HardTanhDerivative(INDArray x, INDArray z) {
        super(x, z);
    }

    public HardTanhDerivative(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public HardTanhDerivative(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public HardTanhDerivative(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "hardtanh";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        if (origin.realComponent().doubleValue() < -1.0) {
            origin.set(-1, origin.imaginaryComponent().doubleValue());
        } else if (origin.realComponent().doubleValue() > 1.0) {
            origin.set(1, origin.imaginaryComponent().doubleValue());
        } else {
            origin = Nd4j.createDouble(1.0, 0.0).subi(ComplexUtil.pow(ComplexUtil.tanh(origin), 2.0));
        }
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        if (origin.realComponent().doubleValue() < -1.0) {
            origin.set(-1, origin.imaginaryComponent().doubleValue());
        } else if (origin.realComponent().doubleValue() > 1.0) {
            origin.set(1, origin.imaginaryComponent().doubleValue());
        } else {
            origin = Nd4j.createDouble(1.0, 0.0).subi(ComplexUtil.pow(ComplexUtil.tanh(origin), 2.0));
        }
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        if (origin.realComponent().doubleValue() < -1.0) {
            origin.set(-1, origin.imaginaryComponent().doubleValue());
        } else if (origin.realComponent().doubleValue() > 1.0) {
            origin.set(1, origin.imaginaryComponent().doubleValue());
        } else {
            origin = Nd4j.createDouble(1.0, 0.0).subi(ComplexUtil.pow(ComplexUtil.tanh(origin), 2.0));
        }
        return origin;
    }

    @Override
    public float op(float origin, float other) {
        return this.hardTanh(origin);
    }

    @Override
    public double op(double origin, double other) {
        return this.hardTanh(origin);
    }

    @Override
    public double op(double origin) {
        return this.hardTanh(origin);
    }

    @Override
    public float op(float origin) {
        return this.hardTanh(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        if (origin.realComponent().doubleValue() < -1.0) {
            origin.set(-1, origin.imaginaryComponent().doubleValue());
        } else if (origin.realComponent().doubleValue() > 1.0) {
            origin.set(1, origin.imaginaryComponent().doubleValue());
        } else {
            origin = Nd4j.createDouble(1.0, 0.0).subi(ComplexUtil.pow(ComplexUtil.tanh(origin), 2.0));
        }
        return origin;
    }

    private float hardTanh(float num) {
        return (float)this.hardTanh((double)num);
    }

    private double hardTanh(double num) {
        double tanh = FastMath.tanh((double)num);
        return tanh < -1.0 ? -1.0 : (1.0 - num > 1.0 ? 1.0 : 1.0 - num);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new HardTanhDerivative(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new HardTanhDerivative(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

