/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.accum.Bias;
import org.nd4j.linalg.api.ops.impl.accum.Mean;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ComplexUtil;

public class Variance
extends BaseAccumulation {
    private double mean;
    private double bias;
    private boolean biasCorrected = true;

    public Variance(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Variance(INDArray x, INDArray y, int n) {
        this(x, y, x, n);
    }

    public Variance(INDArray x) {
        this(x, null, x, x.length(), true);
    }

    public Variance(INDArray x, INDArray y) {
        super(x, y);
    }

    public Variance(INDArray x, INDArray y, INDArray z, int n, boolean biasCorrected) {
        super(x, y, z, n);
        this.biasCorrected = biasCorrected;
        this.init(x, y, z, n);
    }

    public Variance(INDArray x, INDArray y, int n, boolean biasCorrected) {
        super(x, y, n);
        this.biasCorrected = biasCorrected;
        this.init(x, y, this.z, n);
    }

    public Variance(INDArray x, boolean biasCorrected) {
        super(x);
        this.biasCorrected = biasCorrected;
        this.init(x, this.y, this.z, this.n);
    }

    public Variance(INDArray x, INDArray y, boolean biasCorrected) {
        super(x, y);
        this.biasCorrected = biasCorrected;
        this.init(x, y, x, x.length());
    }

    @Override
    public void update(Number result) {
        double dev = result.doubleValue() - this.mean;
        this.currentResult = this.currentResult().doubleValue() + FastMath.pow((double)dev, (int)2);
        if (this.numProcessed() == this.n()) {
            this.currentResult = this.biasCorrected ? Double.valueOf((this.currentResult.doubleValue() - FastMath.pow((double)this.bias, (double)2.0) / (double)this.n()) / ((double)this.n() - 1.0)) : Double.valueOf(this.currentResult().doubleValue() / (double)this.n);
        }
    }

    @Override
    public void update(IComplexNumber result) {
        IComplexNumber dev = result.sub(this.mean);
        this.currentComplexResult.addi(ComplexUtil.pow(dev, 2.0));
        if (this.numProcessed() == this.n()) {
            if (this.biasCorrected) {
                this.currentComplexResult = this.currentComplexResult.sub(ComplexUtil.pow(Nd4j.createComplexNumber(this.bias, 0), 2.0).div(Nd4j.createComplexNumber(this.n(), 0))).div(Nd4j.createComplexNumber((double)this.n() - 1.0, 0.0));
            } else {
                this.currentComplexResult.divi(this.n - 1);
            }
        }
    }

    @Override
    public String name() {
        return "var";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Variance(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Variance(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
        super.init(x, y, z, n);
        if (this.biasCorrected) {
            this.bias = Nd4j.getExecutioner().execAndReturn(new Bias(x)).currentResult().doubleValue();
        }
        this.mean = Nd4j.getExecutioner().execAndReturn(new Mean(x)).currentResult().doubleValue();
        this.extraArgs = new Object[]{this.zero(), this.bias, this.mean};
    }
}

