/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;

public class Min
extends BaseAccumulation {
    public Min(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Min(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public Min(INDArray x) {
        super(x);
    }

    public Min(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public void update(Number result) {
        if (result.doubleValue() < this.currentResult().doubleValue()) {
            this.currentResult = result;
        }
        ++this.numProcessed;
    }

    @Override
    public void update(IComplexNumber result) {
        if (result.absoluteValue().doubleValue() < this.currentResultComplex().absoluteValue().doubleValue()) {
            this.currentComplexResult = result;
        }
        ++this.numProcessed;
    }

    @Override
    public String name() {
        return "min";
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
        super.init(x, y, z, n);
        if (x instanceof IComplexNDArray) {
            IComplexNDArray complexX = (IComplexNDArray)x;
            this.currentComplexResult = complexX.getComplex(0);
            this.initialComplex = complexX.getComplex(0);
        } else {
            this.currentResult = x.getDouble(0);
            this.initial = x.getDouble(0);
        }
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Min(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Min(this.x.vectorAlongDimension(index, dimension));
    }
}

