/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer.test;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public abstract class FloatDataBufferTest {
    @Before
    public void before() {
        Nd4j.dtype = DataBuffer.Type.FLOAT;
    }

    @Test
    public void testGetSet() throws Exception {
        float[] d1 = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        DataBuffer d = Nd4j.createBuffer(d1);
        float[] d2 = d.asFloat();
        Assert.assertArrayEquals((float[])d1, (float[])d2, (float)0.1f);
    }

    @Test
    public void testDup() throws Exception {
        float[] d1 = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        DataBuffer d = Nd4j.createBuffer(d1);
        DataBuffer d2 = d.dup();
        Assert.assertEquals((Object)d, (Object)d2);
    }

    @Test
    public void testPut() throws Exception {
        float[] d1 = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        DataBuffer d = Nd4j.createBuffer(d1);
        d.put(0, 0.0);
        float[] result = new float[]{0.0f, 2.0f, 3.0f, 4.0f};
        d1 = d.asFloat();
        Assert.assertArrayEquals((float[])d1, (float[])result, (float)0.1f);
    }

    @Test
    public void testGetRange() throws Exception {
        DataBuffer buffer = Nd4j.linspace(1, 5, 5).data();
        float[] get = buffer.getFloatsAt(0, 3);
        float[] data = new float[]{1.0f, 2.0f, 3.0f};
        Assert.assertArrayEquals((float[])get, (float[])data, (float)0.1f);
        float[] get2 = buffer.asFloat();
        float[] allData = buffer.getFloatsAt(0, buffer.length());
        Assert.assertArrayEquals((float[])get2, (float[])allData, (float)0.1f);
    }

    @Test
    public void testGetOffsetRange() throws Exception {
        DataBuffer buffer = Nd4j.linspace(1, 5, 5).data();
        float[] get = buffer.getFloatsAt(1, 3);
        float[] data = new float[]{2.0f, 3.0f, 4.0f};
        Assert.assertArrayEquals((float[])get, (float[])data, (float)0.1f);
        float[] allButLast = new float[]{2.0f, 3.0f, 4.0f, 5.0f};
        float[] allData = buffer.getFloatsAt(1, buffer.length());
        Assert.assertArrayEquals((float[])allButLast, (float[])allData, (float)0.1f);
    }

    @Test
    public void testAssign() {
        INDArray oneTwo = Nd4j.create(new double[]{1.0, 2.0});
        INDArray threeFour = Nd4j.create(new double[]{3.0, 4.0});
        INDArray oneThroughFour = Nd4j.linspace(1, 4, 4);
        INDArray test = Nd4j.create(4);
        test.data().assign(oneTwo.data(), threeFour.data());
        Assert.assertEquals((Object)oneThroughFour, (Object)test);
    }
}

