/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer.test;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public abstract class DoubleDataBufferTest {
    @Before
    public void before() {
        Nd4j.dtype = DataBuffer.Type.DOUBLE;
    }

    @Test
    public void testGetSet() throws Exception {
        double[] d1 = new double[]{1.0, 2.0, 3.0, 4.0};
        DataBuffer d = Nd4j.createBuffer(d1);
        double[] d2 = d.asDouble();
        Assert.assertArrayEquals((double[])d1, (double[])d2, (double)0.1f);
    }

    @Test
    public void testDup() throws Exception {
        double[] d1 = new double[]{1.0, 2.0, 3.0, 4.0};
        DataBuffer d = Nd4j.createBuffer(d1);
        DataBuffer d2 = d.dup();
        Assert.assertEquals((Object)d, (Object)d2);
    }

    @Test
    public void testPut() throws Exception {
        double[] d1 = new double[]{1.0, 2.0, 3.0, 4.0};
        DataBuffer d = Nd4j.createBuffer(d1);
        d.put(0, 0.0);
        double[] result = new double[]{0.0, 2.0, 3.0, 4.0};
        d1 = d.asDouble();
        Assert.assertArrayEquals((double[])d1, (double[])result, (double)0.1f);
    }

    @Test
    public void testGetRange() throws Exception {
        DataBuffer buffer = Nd4j.linspace(1, 5, 5).data();
        double[] get = buffer.getDoublesAt(0, 3);
        double[] data = new double[]{1.0, 2.0, 3.0};
        Assert.assertArrayEquals((double[])get, (double[])data, (double)0.1f);
        double[] get2 = buffer.asDouble();
        double[] allData = buffer.getDoublesAt(0, buffer.length());
        Assert.assertArrayEquals((double[])get2, (double[])allData, (double)0.1f);
    }

    @Test
    public void testGetOffsetRange() throws Exception {
        DataBuffer buffer = Nd4j.linspace(1, 5, 5).data();
        double[] get = buffer.getDoublesAt(1, 3);
        double[] data = new double[]{2.0, 3.0, 4.0};
        Assert.assertArrayEquals((double[])get, (double[])data, (double)0.1f);
        double[] allButLast = new double[]{2.0, 3.0, 4.0, 5.0};
        double[] allData = buffer.getDoublesAt(1, buffer.length());
        Assert.assertArrayEquals((double[])allButLast, (double[])allData, (double)0.1f);
    }

    @Test
    public void testAssign() {
        INDArray oneTwo = Nd4j.create(new double[]{1.0, 2.0});
        INDArray threeFour = Nd4j.create(new double[]{3.0, 4.0});
        INDArray oneThroughFour = Nd4j.linspace(1, 4, 4);
        INDArray test = Nd4j.create(4);
        test.data().assign(oneTwo.data(), threeFour.data());
        Assert.assertEquals((Object)oneThroughFour, (Object)test);
    }
}

