/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.UUID;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.util.ArrayUtil;

public class IntBuffer
extends BaseDataBuffer {
    private int[] buffer;

    public IntBuffer(int[] buffer, boolean copy) {
        super(buffer.length);
        if (!copy) {
            this.buffer = buffer;
        } else {
            buffer = new int[buffer.length];
            System.arraycopy(buffer, 0, this.buffer, 0, this.buffer.length);
        }
    }

    public IntBuffer(int[] buffer) {
        this(buffer, true);
    }

    public IntBuffer(int length) {
        super(length);
    }

    @Override
    public void setData(int[] data) {
        this.buffer = data;
    }

    @Override
    public void setData(float[] data) {
        this.buffer = ArrayUtil.toInts(data);
    }

    @Override
    public void setData(double[] data) {
        this.buffer = ArrayUtil.toInts(data);
    }

    @Override
    public byte[] asBytes() {
        return new byte[0];
    }

    @Override
    public DataBuffer.Type dataType() {
        return DataBuffer.Type.INT;
    }

    @Override
    public float[] asFloat() {
        float[] ret = new float[this.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.buffer[i];
        }
        return ret;
    }

    @Override
    public int getElementSize() {
        return 4;
    }

    @Override
    public void assign(Number value, int offset) {
        for (int i = offset; i < this.length(); ++i) {
            this.buffer[i] = value.intValue();
        }
    }

    @Override
    public double[] asDouble() {
        double[] ret = new double[this.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.buffer[i];
        }
        return ret;
    }

    @Override
    public int[] asInt() {
        return this.buffer;
    }

    @Override
    public double getDouble(int i) {
        return this.buffer[i];
    }

    @Override
    public float getFloat(int i) {
        return this.buffer[i];
    }

    @Override
    public Number getNumber(int i) {
        return this.buffer[i];
    }

    @Override
    public void put(int i, float element) {
        this.buffer[i] = (int)element;
    }

    @Override
    public void put(int i, double element) {
        this.buffer[i] = (int)element;
    }

    @Override
    public void put(int i, int element) {
        this.buffer[i] = element;
    }

    @Override
    public int getInt(int ix) {
        return this.buffer[ix];
    }

    @Override
    public DataBuffer dup() {
        return new IntBuffer(ArrayUtil.copy(this.buffer));
    }

    @Override
    public void flush() {
        this.path = UUID.randomUUID().toString();
        if (this.memoryMappedBuffer != null) {
            return;
        }
        try {
            this.memoryMappedBuffer = new RandomAccessFile(this.path, "rw");
            long size = 8L * (long)this.length;
            for (long offset = 0L; offset < size; offset += 0x40000000L) {
                long size2 = Math.min(size - offset, 0x40000000L);
                this.mappings.add(this.memoryMappedBuffer.getChannel().map(FileChannel.MapMode.READ_WRITE, offset, size2));
            }
        }
        catch (IOException e) {
            try {
                if (this.memoryMappedBuffer != null) {
                    this.memoryMappedBuffer.close();
                }
            }
            catch (IOException e1) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException(e);
        }
        this.buffer = null;
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer = null;
        }
        if (this.memoryMappedBuffer != null) {
            try {
                this.mappings.clear();
                this.memoryMappedBuffer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

