/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer;

import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.UUID;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.util.ArrayUtil;

public class FloatBuffer
extends BaseDataBuffer {
    private float[] buffer;

    public FloatBuffer(int length) {
        super(length);
        this.buffer = new float[length];
    }

    public FloatBuffer(float[] buffer) {
        this(buffer, true);
    }

    public FloatBuffer(float[] buffer, boolean copy) {
        super(buffer.length);
        this.buffer = copy ? Arrays.copyOf(buffer, buffer.length) : buffer;
    }

    @Override
    public int getElementSize() {
        return 4;
    }

    @Override
    public void assign(Number value, int offset) {
        for (int i = offset; i < this.length(); ++i) {
            this.buffer[i] = value.floatValue();
        }
    }

    @Override
    public void setData(int[] data) {
        this.buffer = ArrayUtil.toFloats(data);
    }

    @Override
    public void setData(float[] data) {
        this.buffer = data;
    }

    @Override
    public void setData(double[] data) {
        this.buffer = ArrayUtil.toFloats(data);
    }

    @Override
    public byte[] asBytes() {
        byte[][] ret1 = new byte[this.length][];
        for (int i = 0; i < this.length; ++i) {
            ret1[i] = FloatBuffer.toByteArray(this.buffer[i]);
        }
        return Bytes.concat((byte[][])ret1);
    }

    @Override
    public DataBuffer.Type dataType() {
        return DataBuffer.Type.FLOAT;
    }

    @Override
    public float[] asFloat() {
        if (this.buffer == null) {
            this.buffer = new float[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.buffer[i] = this.getFloat(i);
            }
            try {
                this.mappings.clear();
                this.memoryMappedBuffer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.buffer;
    }

    @Override
    public double[] asDouble() {
        double[] ret = new double[this.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.buffer[i];
        }
        return ret;
    }

    @Override
    public int[] asInt() {
        int[] ret = new int[this.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (int)this.buffer[i];
        }
        return ret;
    }

    @Override
    public double getDouble(int i) {
        if (this.buffer != null) {
            return this.buffer[i];
        }
        long p = i * 8;
        int mapN = (int)(p / 0x40000000L);
        int offN = (int)(p % 0x40000000L);
        return ((ByteBuffer)this.mappings.get(mapN)).getDouble(offN);
    }

    @Override
    public float getFloat(int i) {
        return (float)this.getDouble(i);
    }

    @Override
    public Number getNumber(int i) {
        return (int)this.getDouble(i);
    }

    @Override
    public void put(int i, float element) {
        this.put(i, (double)element);
    }

    @Override
    public void put(int i, double element) {
        if (this.buffer != null) {
            this.buffer[i] = (float)element;
        } else {
            long p = i * 8;
            int mapN = (int)(p / 0x40000000L);
            int offN = (int)(p % 0x40000000L);
            ((ByteBuffer)this.mappings.get(mapN)).putDouble(offN, element);
        }
    }

    @Override
    public void put(int i, int element) {
        this.put(i, (double)element);
    }

    @Override
    public int getInt(int ix) {
        return (int)this.buffer[ix];
    }

    @Override
    public DataBuffer dup() {
        return new FloatBuffer(this.buffer);
    }

    @Override
    public void flush() {
        this.path = UUID.randomUUID().toString();
        if (this.memoryMappedBuffer != null) {
            return;
        }
        try {
            this.memoryMappedBuffer = new RandomAccessFile(this.path, "rw");
            long size = 8L * (long)this.length;
            for (long offset = 0L; offset < size; offset += 0x40000000L) {
                long size2 = Math.min(size - offset, 0x40000000L);
                this.mappings.add(this.memoryMappedBuffer.getChannel().map(FileChannel.MapMode.READ_WRITE, offset, size2));
            }
        }
        catch (IOException e) {
            try {
                if (this.memoryMappedBuffer != null) {
                    this.memoryMappedBuffer.close();
                }
            }
            catch (IOException e1) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException(e);
        }
        this.buffer = null;
    }

    @Override
    public void destroy() {
        if (this.buffer != null) {
            this.buffer = null;
        }
        if (this.memoryMappedBuffer != null) {
            try {
                this.mappings.clear();
                this.memoryMappedBuffer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatBuffer)) {
            return false;
        }
        FloatBuffer that = (FloatBuffer)o;
        return Arrays.equals(this.buffer, that.buffer);
    }

    public int hashCode() {
        return this.buffer != null ? Arrays.hashCode(this.buffer) : 0;
    }

    public String toString() {
        return "FloatBuffer{buffer=" + Arrays.toString(this.buffer) + '}';
    }
}

