/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer;

import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseDataBuffer
implements DataBuffer {
    public static final int MAPPING_SIZE = 0x40000000;
    protected final List<ByteBuffer> mappings = new ArrayList<ByteBuffer>();
    protected int length;
    protected String path;
    protected transient RandomAccessFile memoryMappedBuffer;
    protected Collection<String> referencing = Collections.synchronizedSet(new HashSet());
    protected transient WeakReference<DataBuffer> ref;
    protected boolean isPersist = false;

    @Override
    public void persist() {
        this.isPersist = true;
    }

    @Override
    public boolean isPersist() {
        return this.isPersist;
    }

    protected BaseDataBuffer(int length) {
        this.length = length;
        this.ref = new WeakReference<DataBuffer>(this, Nd4j.bufferRefQueue());
    }

    public static byte[] toByteArray(double value) {
        byte[] bytes = new byte[8];
        ByteBuffer.wrap(bytes).putDouble(value);
        return bytes;
    }

    public static byte[] toByteArray(float value) {
        byte[] bytes = new byte[4];
        ByteBuffer.wrap(bytes).putFloat(value);
        return bytes;
    }

    public static byte[] toByteArray(int value) {
        byte[] bytes = new byte[4];
        ByteBuffer.wrap(bytes).putFloat(value);
        return bytes;
    }

    public static double toDouble(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getDouble();
    }

    public static int toInt(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }

    public static float toFloat(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getFloat();
    }

    @Override
    public void removeReferencing(String id) {
        this.referencing.remove(id);
    }

    @Override
    public Collection<String> references() {
        return this.referencing;
    }

    @Override
    public void addReferencing(String id) {
        this.referencing.add(id);
    }

    @Override
    public void assign(int[] indices, float[] data, boolean contiguous, int inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if (indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], data[i]);
        }
    }

    @Override
    public void assign(int[] indices, double[] data, boolean contiguous, int inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if (indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        for (int i = 0; i < indices.length; i += inc) {
            this.put(indices[i], data[i]);
        }
    }

    @Override
    public void assign(DataBuffer data) {
        if (data.length() != this.length()) {
            throw new IllegalArgumentException("Unable to assign buffer of length " + data.length() + " to this buffer of length " + this.length());
        }
        for (int i = 0; i < data.length(); ++i) {
            this.put(i, data.getDouble(i));
        }
    }

    @Override
    public void assign(int[] indices, float[] data, boolean contiguous) {
        this.assign(indices, data, contiguous, 1);
    }

    @Override
    public void assign(int[] indices, double[] data, boolean contiguous) {
        this.assign(indices, data, contiguous, 1);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void assign(Number value) {
        this.assign(value, 0);
    }

    @Override
    public double[] getDoublesAt(int offset, int length) {
        return this.getDoublesAt(offset, 1, length);
    }

    @Override
    public float[] getFloatsAt(int offset, int inc, int length) {
        if (offset + length > this.length()) {
            length -= offset;
        }
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getFloat(i + offset);
        }
        return ret;
    }

    @Override
    public double[] getDoublesAt(int offset, int inc, int length) {
        if (offset + length > this.length()) {
            length -= offset;
        }
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getDouble(i + offset);
        }
        return ret;
    }

    @Override
    public float[] getFloatsAt(int offset, int length) {
        return this.getFloatsAt(offset, 1, length);
    }

    @Override
    public IComplexFloat getComplexFloat(int i) {
        return Nd4j.createFloat(this.getFloat(i), this.getFloat(i + 1));
    }

    @Override
    public IComplexDouble getComplexDouble(int i) {
        return Nd4j.createDouble(this.getDouble(i), this.getDouble(i + 1));
    }

    @Override
    public IComplexNumber getComplex(int i) {
        return this.dataType() == DataBuffer.Type.FLOAT ? this.getComplexFloat(i) : this.getComplexDouble(i);
    }

    @Override
    public void put(int i, IComplexNumber result) {
        this.put(i, result.realComponent().doubleValue());
        this.put(i + 1, result.imaginaryComponent().doubleValue());
    }

    @Override
    public void assign(int[] offsets, int[] strides, DataBuffer ... buffers) {
        this.assign(offsets, strides, this.length(), buffers);
    }

    @Override
    public void assign(int[] offsets, int[] strides, int n, DataBuffer ... buffers) {
        if (offsets.length != strides.length || strides.length != buffers.length) {
            throw new IllegalArgumentException("Unable to assign buffers, please specify equal lengths strides, offsets, and buffers");
        }
        int length = 0;
        for (int i = 0; i < buffers.length; ++i) {
            length += buffers[i].length();
        }
        if (length != n) {
            throw new IllegalArgumentException("Buffers must fill up specified length " + n);
        }
        int count = 0;
        for (int i = 0; i < buffers.length; ++i) {
            for (int j = offsets[i]; j < buffers[i].length(); j += strides[i]) {
                this.put(count++, buffers[i].getDouble(j));
            }
        }
        if (count != n) {
            throw new IllegalArgumentException("Strides and offsets didn't match up to length " + n);
        }
    }

    @Override
    public void assign(DataBuffer ... buffers) {
        int[] offsets = new int[buffers.length];
        int[] strides = new int[buffers.length];
        for (int i = 0; i < strides.length; ++i) {
            strides[i] = 1;
        }
        this.assign(offsets, strides, buffers);
    }
}

