/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.fft;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.fft.FFTInstance;
import org.nd4j.linalg.fft.VectorFFT;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.ComplexNDArrayUtil;

public abstract class BaseFFTInstance
implements FFTInstance {
    @Override
    public IComplexNDArray fft(INDArray transform, int numElements) {
        IComplexNDArray inputC = Nd4j.createComplex(transform);
        if (inputC.isVector()) {
            return new VectorFFT(inputC.length()).apply(inputC);
        }
        return this.rawfft(inputC, numElements, inputC.shape().length - 1);
    }

    @Override
    public IComplexNDArray fft(IComplexNDArray inputC) {
        if (inputC.isVector()) {
            return new VectorFFT(inputC.length()).apply(inputC);
        }
        return this.rawfft(inputC, inputC.size(inputC.shape().length - 1), inputC.shape().length - 1);
    }

    @Override
    public IComplexNDArray fft(INDArray input) {
        IComplexNDArray inputC = Nd4j.createComplex(input);
        return this.fft(inputC);
    }

    @Override
    public IComplexNDArray fft(IComplexNDArray inputC, int numElements) {
        return this.fft(inputC, numElements, inputC.shape().length - 1);
    }

    @Override
    public IComplexNDArray ifftn(INDArray transform, int dimension, int numElements) {
        return this.ifftn(Nd4j.createComplex(transform), dimension, numElements);
    }

    @Override
    public IComplexNDArray irfftn(IComplexNDArray arr) {
        int[] shape = arr.shape();
        IComplexNDArray ret = arr.dup();
        for (int i = 0; i < shape.length - 1; ++i) {
            ret = this.ifftn(ret, i, shape[i]);
        }
        return this.irfft(ret, 0);
    }

    @Override
    public IComplexNDArray irfft(IComplexNDArray arr, int dimension) {
        return this.fftn(arr, arr.size(dimension), dimension);
    }

    @Override
    public IComplexNDArray irfft(IComplexNDArray arr) {
        return arr;
    }

    @Override
    public IComplexNDArray ifftn(IComplexNDArray transform, int dimension, int numElements) {
        if (numElements < 1) {
            throw new IllegalArgumentException("No elements specified");
        }
        int[] finalShape = ArrayUtil.replace(transform.shape(), dimension, numElements);
        int[] axes = ArrayUtil.range(0, finalShape.length);
        IComplexNDArray result = transform.dup();
        int desiredElementsAlongDimension = result.size(dimension);
        if (numElements > desiredElementsAlongDimension) {
            result = ComplexNDArrayUtil.padWithZeros(result, finalShape);
        } else if (numElements < desiredElementsAlongDimension) {
            result = ComplexNDArrayUtil.truncate(result, numElements, dimension);
        }
        return this.rawifftn(result, finalShape, axes);
    }

    @Override
    public IComplexNDArray fftn(IComplexNDArray transform, int dimension, int numElements) {
        if (numElements < 1) {
            throw new IllegalArgumentException("No elements specified");
        }
        int[] finalShape = ArrayUtil.replace(transform.shape(), dimension, numElements);
        int[] axes = ArrayUtil.range(0, finalShape.length);
        IComplexNDArray result = transform.dup();
        int desiredElementsAlongDimension = result.size(dimension);
        if (numElements > desiredElementsAlongDimension) {
            result = ComplexNDArrayUtil.padWithZeros(result, finalShape);
        } else if (numElements < desiredElementsAlongDimension) {
            result = ComplexNDArrayUtil.truncate(result, numElements, dimension);
        }
        return this.rawfftn(result, finalShape, axes);
    }

    @Override
    public IComplexNDArray fftn(INDArray transform, int dimension, int numElements) {
        return this.fftn(Nd4j.createComplex(transform), dimension, numElements);
    }

    @Override
    public IComplexNDArray fftn(INDArray transform) {
        return this.fftn(transform, transform.shape().length - 1, transform.shape()[transform.shape().length - 1]);
    }

    @Override
    public IComplexNDArray fftn(IComplexNDArray transform) {
        return this.fftn(transform, transform.shape().length - 1, transform.shape()[transform.shape().length - 1]);
    }

    @Override
    public IComplexNDArray ifftn(IComplexNDArray transform, int dimension) {
        return this.ifftn(transform, dimension, transform.shape()[dimension]);
    }

    @Override
    public IComplexNDArray ifftn(IComplexNDArray transform) {
        return this.ifftn(transform, transform.shape().length - 1, transform.size(transform.shape().length - 1));
    }

    @Override
    public IComplexNDArray ifftn(INDArray transform) {
        return this.ifftn(transform, transform.shape().length - 1, transform.size(transform.shape().length - 1));
    }

    @Override
    public IComplexNDArray rawifftn(IComplexNDArray transform, int[] shape, int[] axes) {
        assert (shape.length > 0) : "Shape length must be > 0";
        assert (shape.length == axes.length) : "Axes and shape must be the same length";
        IComplexNDArray result = transform.dup();
        for (int i = shape.length - 1; i >= 0; --i) {
            result = this.ifft(result, shape[i], axes[i]);
        }
        return result;
    }

    @Override
    public IComplexNDArray rawfftn(IComplexNDArray transform, int[] shape, int[] axes) {
        IComplexNDArray result = transform.dup();
        for (int i = shape.length - 1; i >= 0; --i) {
            result = this.fft(result, shape[i], axes[i]);
        }
        return result;
    }

    @Override
    public IComplexNDArray rawifft(IComplexNDArray transform, int dimension) {
        return this.rawifft(transform, transform.shape()[dimension], dimension);
    }
}

