/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.ops.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.ops.BaseElementWiseOp;
import org.nd4j.linalg.util.ComplexUtil;

public class Exp
extends BaseElementWiseOp {
    public Object apply(INDArray from, Object value, int i) {
        if (value instanceof IComplexNumber) {
            IComplexNumber c = (IComplexNumber)value;
            return ComplexUtil.exp(c);
        }
        if (from.data().dataType() == 1) {
            double val = (Double)value;
            return FastMath.exp((double)val);
        }
        double val = (Double)value;
        if (val < 0.0) {
            double ret = FastMath.exp((double)val);
            return ret;
        }
        return Math.exp(val);
    }

    public double exp(double val) {
        long tmp = (long)(1512775.0 * val) + 0x3FF00000L;
        long mantissa = tmp & 0xFFFFFL;
        int error = (int)mantissa >> 7;
        error = (int)((long)error - mantissa * mantissa) / 186;
        return Double.longBitsToDouble(tmp - (long)error << 32);
    }
}

