/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.fft;

import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class FFT {
    public static IComplexNDArray fft(INDArray transform, int numElements) {
        return Nd4j.getFFt().fft(transform, numElements);
    }

    public static IComplexNDArray fft(IComplexNDArray inputC) {
        return Nd4j.getFFt().fft(inputC);
    }

    public static IComplexNDArray fft(INDArray input) {
        return Nd4j.getFFt().fft(input);
    }

    public static IComplexNDArray fft(INDArray transform, int numElements, int dimension) {
        return Nd4j.getFFt().fft(transform, numElements, dimension);
    }

    public static IComplexNDArray fft(IComplexNDArray inputC, int numElements) {
        return Nd4j.getFFt().fft(inputC, numElements, inputC.shape().length - 1);
    }

    public static IComplexNDArray fft(IComplexNDArray inputC, int numElements, int dimension) {
        return Nd4j.getFFt().fft(inputC, numElements, dimension);
    }

    public static IComplexNDArray ifft(INDArray transform, int numElements, int dimension) {
        return Nd4j.getFFt().ifft(transform, numElements, dimension);
    }

    public static IComplexNDArray ifft(IComplexNDArray inputC) {
        return Nd4j.getFFt().ifft(inputC);
    }

    public static IComplexNDArray ifft(INDArray transform, int numElements) {
        return Nd4j.getFFt().ifft(transform, numElements);
    }

    public static IComplexNDArray ifft(IComplexNDArray inputC, int numElements, int dimension) {
        return Nd4j.getFFt().ifft(inputC, numElements, dimension);
    }

    public static IComplexNDArray ifftn(INDArray transform, int dimension, int numElements) {
        return Nd4j.getFFt().ifftn(Nd4j.createComplex(transform), dimension, numElements);
    }

    public static IComplexNDArray irfftn(IComplexNDArray arr) {
        return Nd4j.getFFt().irfftn(arr);
    }

    public static IComplexNDArray irfft(IComplexNDArray arr, int dimension) {
        return Nd4j.getFFt().irfft(arr, dimension);
    }

    public static IComplexNDArray irfft(IComplexNDArray arr) {
        return Nd4j.getFFt().irfft(arr);
    }

    public static IComplexNDArray ifftn(IComplexNDArray transform, int dimension, int numElements) {
        return Nd4j.getFFt().ifftn(transform, dimension, numElements);
    }

    public static IComplexNDArray fftn(IComplexNDArray transform, int dimension, int numElements) {
        return Nd4j.getFFt().fftn(transform, dimension, numElements);
    }

    public static IComplexNDArray fftn(INDArray transform, int dimension, int numElements) {
        return Nd4j.getFFt().fftn(Nd4j.createComplex(transform), dimension, numElements);
    }

    public static IComplexNDArray fftn(INDArray transform) {
        return Nd4j.getFFt().fftn(transform, transform.shape().length - 1, transform.shape()[transform.shape().length - 1]);
    }

    public static IComplexNDArray fftn(IComplexNDArray transform) {
        return Nd4j.getFFt().fftn(transform, transform.shape().length - 1, transform.shape()[transform.shape().length - 1]);
    }

    public static IComplexNDArray ifftn(IComplexNDArray transform, int dimension) {
        return Nd4j.getFFt().ifftn(transform, dimension, transform.shape()[dimension]);
    }

    public static IComplexNDArray ifftn(IComplexNDArray transform) {
        return Nd4j.getFFt().ifftn(transform);
    }

    public static IComplexNDArray ifftn(INDArray transform) {
        return Nd4j.getFFt().ifftn(transform);
    }

    public static IComplexNDArray rawifftn(IComplexNDArray transform, int[] shape, int[] axes) {
        return Nd4j.getFFt().rawifftn(transform, shape, axes);
    }

    public static IComplexNDArray rawfftn(IComplexNDArray transform, int[] shape, int[] axes) {
        return Nd4j.getFFt().rawfftn(transform, shape, axes);
    }

    public static IComplexNDArray rawfft(IComplexNDArray transform, int n, int dimension) {
        return Nd4j.getFFt().rawfft(transform, n, dimension);
    }

    public static IComplexNDArray rawifft(IComplexNDArray transform, int n, int dimension) {
        return Nd4j.getFFt().rawifft(transform, n, dimension);
    }

    public static IComplexNDArray rawifft(IComplexNDArray transform, int dimension) {
        return Nd4j.getFFt().rawifft(transform, transform.shape()[dimension], dimension);
    }
}

