/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ndarray;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.Triple;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DoubleBuffer;
import org.nd4j.linalg.api.buffer.FloatBuffer;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.dimensionfunctions.DimensionFunctions;
import org.nd4j.linalg.api.ndarray.DimensionSlice;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.SliceOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.Indices;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.ops.reduceops.Ops;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.IterationResult;
import org.nd4j.linalg.util.LinAlgExceptions;
import org.nd4j.linalg.util.Shape;

public abstract class BaseNDArray
implements INDArray {
    protected int[] shape;
    protected int[] stride;
    protected int offset = 0;
    protected char ordering;
    protected DataBuffer data;
    protected int rows;
    protected int columns;
    protected int length;
    protected INDArray linearView;

    public BaseNDArray() {
    }

    public BaseNDArray(DataBuffer buffer) {
        this.data = buffer;
        this.initShape(new int[]{1, buffer.length()});
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, int[] stride, int offset, char ordering) {
        this.data = buffer;
        if (ArrayUtil.prod(shape) > buffer.length()) {
            throw new IllegalArgumentException("Shape must be <= buffer length");
        }
        this.stride = stride;
        this.offset = offset;
        this.ordering = ordering;
        this.initShape(shape);
    }

    public BaseNDArray(double[][] data) {
        this(data.length, data[0].length);
        int r;
        for (r = 0; r < this.rows; ++r) {
            assert (data[r].length == this.columns);
        }
        this.data = Nd4j.createBuffer(this.length);
        for (r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                this.putScalar(new int[]{r, c}, data[r][c]);
            }
        }
    }

    public BaseNDArray(int[] shape, DataBuffer buffer) {
        this.data = buffer;
        this.initShape(shape);
    }

    public BaseNDArray(float[] data, int[] shape, char ordering) {
        this(data, shape, 0, ordering);
    }

    public BaseNDArray(float[] data, int[] shape, int offset, char ordering) {
        this(data, shape, ordering == 'c' ? ArrayUtil.calcStrides(shape) : ArrayUtil.calcStridesFortran(shape), offset);
    }

    public BaseNDArray(int[] shape, int[] stride, int offset, char ordering) {
        this(Nd4j.createBuffer(ArrayUtil.prod(shape)), shape, stride, offset, ordering);
    }

    public BaseNDArray(int[] shape, int[] stride, char ordering) {
        this(shape, stride, 0, ordering);
    }

    public BaseNDArray(int[] shape, int offset, char ordering) {
        this(shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    public BaseNDArray(int[] shape) {
        this(shape, 0, Nd4j.order().charValue());
    }

    public BaseNDArray(int newRows, int newColumns, char ordering) {
        this.ordering = ordering;
        this.initShape(new int[]{newRows, newColumns});
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, char ordering) {
        this(slices, shape, Nd4j.getStrides(shape), ordering);
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, int[] stride, char ordering) {
        DataBuffer ret = slices.get(0).data().dataType() == 1 ? Nd4j.createBuffer(new float[ArrayUtil.prod(shape)]) : Nd4j.createBuffer(new double[ArrayUtil.prod(shape)]);
        this.stride = stride;
        this.ordering = ordering;
        this.data = ret;
        this.initShape(shape);
        for (int i = 0; i < this.slices(); ++i) {
            this.putSlice(i, slices.get(i));
        }
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, char ordering) {
        this(data, shape, stride, 0, ordering);
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        this.offset = offset;
        this.stride = stride;
        this.ordering = ordering;
        this.initShape(shape);
        if (data != null && data.length > 0) {
            this.data = Nd4j.createBuffer(data);
            if (offset >= data.length) {
                throw new IllegalArgumentException("invalid offset: must be < data.length");
            }
        }
    }

    public BaseNDArray(DataBuffer data, int[] shape, int[] stride, int offset) {
        this.data = data;
        this.stride = stride;
        this.offset = offset;
        this.ordering = Nd4j.order().charValue();
        this.initShape(shape);
    }

    public BaseNDArray(DataBuffer data, int[] shape) {
        this(data, shape, Nd4j.getStrides(shape), 0, Nd4j.order().charValue());
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, int offset) {
        this(buffer, shape, Nd4j.getStrides(shape), offset);
    }

    public BaseNDArray(double[] data, int[] shape, char ordering) {
        this(new DoubleBuffer(data), shape, (int)ordering);
    }

    public BaseNDArray(double[] data, int[] shape, int[] stride, int offset, char ordering) {
        this(new DoubleBuffer(data), shape, stride, offset, ordering);
    }

    public BaseNDArray(float[] data, char order) {
        this(new FloatBuffer(data), order);
    }

    public BaseNDArray(FloatBuffer floatBuffer, char order) {
        this(floatBuffer, new int[]{floatBuffer.length()}, Nd4j.getStrides(new int[]{floatBuffer.length()}), 0, order);
    }

    @Override
    public INDArray linearViewColumnOrder() {
        return Nd4j.create(this.data, new int[]{this.length, 1}, this.offset());
    }

    @Override
    public INDArray linearView() {
        if (this.isVector()) {
            return this;
        }
        if (this.linearView == null) {
            this.linearView = Nd4j.create(this.data, new int[]{this.length}, this.offset());
        }
        return this.linearView;
    }

    public BaseNDArray(float[] data, int[] shape) {
        this(data, shape, 0);
    }

    public BaseNDArray(float[] data, int[] shape, int offset) {
        this(data, shape, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(int[] shape, int[] stride, int offset) {
        this(new float[ArrayUtil.prod(shape)], shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(int[] shape, int[] stride) {
        this(shape, stride, 0);
    }

    public BaseNDArray(int[] shape, int offset) {
        this(shape, ArrayUtil.calcStrides(shape), offset);
    }

    public BaseNDArray(int[] shape, char ordering) {
        this(shape, 0, ordering);
    }

    public BaseNDArray(int newRows, int newColumns) {
        this(newRows, newColumns, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, int[] shape) {
        this(slices, shape, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, int[] stride) {
        this(slices, shape, stride, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride) {
        this(data, shape, stride, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, int offset) {
        this(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data) {
        this.data = Nd4j.createBuffer(data);
    }

    public BaseNDArray(float[][] data) {
        this(data.length, data[0].length);
        int r;
        for (r = 0; r < this.rows; ++r) {
            assert (data[r].length == this.columns);
        }
        this.data = Nd4j.createBuffer(this.length);
        for (r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                this.putScalar(new int[]{r, c}, data[r][c]);
            }
        }
    }

    @Override
    public void setData(float[] data) {
        this.data = Nd4j.createBuffer(data);
    }

    @Override
    public int majorStride() {
        return this.stride[0];
    }

    @Override
    public int secondaryStride() {
        if (this.stride.length >= 2) {
            if (this.ordering == 'c') {
                if (this.isColumnVector()) {
                    return this.majorStride();
                }
                return this.stride[1];
            }
            return this.majorStride();
        }
        return this.majorStride();
    }

    @Override
    public int vectorsAlongDimension(int dimension) {
        if (dimension >= this.shape.length) {
            return this.length / this.size(this.shape.length - 1);
        }
        return this.length / this.size(dimension);
    }

    @Override
    public INDArray vectorAlongDimension(int index, int dimension) {
        assert (dimension <= this.shape.length) : "Invalid dimension " + dimension;
        if (dimension > this.shape().length - 1) {
            dimension = this.shape.length - 1;
        }
        if (this.ordering == 'c') {
            if (dimension == this.shape.length - 1 && dimension != 0) {
                return Nd4j.create(this.data, new int[]{this.shape[dimension]}, new int[]{this.stride[this.shape.length - 1]}, this.offset + index * this.stride[dimension - 1]);
            }
            if (dimension == 0) {
                return Nd4j.create(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index);
            }
            if (this.size(dimension) == 1) {
                return Nd4j.create(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index);
            }
            return Nd4j.create(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index * this.stride[0]);
        }
        if (this.ordering == 'f') {
            if (dimension == this.shape.length - 1 && dimension != 0) {
                if (this.size(dimension) == 1) {
                    return Nd4j.create(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index);
                }
                return Nd4j.create(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index * this.stride[dimension - 1]);
            }
            if (this.size(dimension) == 1) {
                return Nd4j.create(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index);
            }
            return Nd4j.create(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index * this.stride[this.stride.length - 1]);
        }
        throw new IllegalStateException("Illegal ordering..none declared");
    }

    @Override
    public INDArray cumsumi(int dimension) {
        if (this.isVector()) {
            double s = 0.0;
            for (int i = 0; i < this.length; ++i) {
                this.putScalar(i, s += this.getDouble(i));
            }
        } else {
            if (dimension == Integer.MAX_VALUE || dimension == this.shape.length - 1) {
                INDArray flattened = this.ravel().dup();
                double prevVal = flattened.getDouble(0);
                for (int i = 1; i < flattened.length(); ++i) {
                    double d = prevVal + flattened.getDouble(i);
                    flattened.putScalar(i, d);
                    prevVal = d;
                }
                return flattened;
            }
            for (int i = 0; i < this.vectorsAlongDimension(dimension); ++i) {
                INDArray vec = this.vectorAlongDimension(i, dimension);
                vec.cumsumi(0);
            }
        }
        return this;
    }

    @Override
    public INDArray cumsum(int dimension) {
        return this.dup().cumsumi(dimension);
    }

    @Override
    public INDArray assign(INDArray arr) {
        LinAlgExceptions.assertSameShape(this, arr);
        INDArray other = arr.linearView();
        INDArray thisArr = this.linearView();
        for (int i = 0; i < other.length(); ++i) {
            thisArr.putScalar(i, other.getDouble(i));
        }
        return this;
    }

    @Override
    public INDArray putScalar(int i, double value) {
        int idx = this.linearIndex(i);
        this.data.put(idx, value);
        return this;
    }

    @Override
    public INDArray putScalar(int i, float value) {
        int idx = this.linearIndex(i);
        this.data.put(idx, value);
        return this;
    }

    @Override
    public INDArray putScalar(int i, int value) {
        int idx = this.linearIndex(i);
        this.data.put(idx, value);
        return this;
    }

    @Override
    public INDArray putScalar(int[] indexes, double value) {
        int ix = this.offset;
        for (int i = 0; i < this.shape.length; ++i) {
            ix += indexes[i] * this.stride[i];
        }
        this.data.put(ix, value);
        return this;
    }

    @Override
    public INDArray putScalar(int[] indexes, float value) {
        int ix = this.offset;
        for (int i = 0; i < this.shape.length; ++i) {
            ix += indexes[i] * this.stride[i];
        }
        this.data.put(ix, value);
        return this;
    }

    @Override
    public INDArray putScalar(int[] indexes, int value) {
        int ix = this.offset;
        for (int i = 0; i < this.shape.length; ++i) {
            ix += indexes[i] * this.stride[i];
        }
        this.data.put(ix, value);
        return this;
    }

    @Override
    public INDArray eps(Number other) {
        return this.dup().epsi(other);
    }

    @Override
    public INDArray epsi(Number other) {
        INDArray linearView = this.linearView();
        double otherVal = other.doubleValue();
        for (int i = 0; i < linearView.length(); ++i) {
            double val = linearView.getDouble(i);
            double diff = Math.abs(val - otherVal);
            if (diff <= Nd4j.EPS_THRESHOLD) {
                linearView.putScalar(i, 1);
                continue;
            }
            linearView.putScalar(i, 0);
        }
        return this;
    }

    @Override
    public INDArray eps(INDArray other) {
        return this.dup().epsi(other);
    }

    @Override
    public INDArray epsi(INDArray other) {
        INDArray linearView = this.linearView();
        INDArray otherLinearView = other.linearView();
        for (int i = 0; i < linearView.length(); ++i) {
            double otherVal;
            double val = linearView.getDouble(i);
            double diff = Math.abs(val - (otherVal = otherLinearView.getDouble(i)));
            if (diff <= Nd4j.EPS_THRESHOLD) {
                linearView.putScalar(i, 1);
                continue;
            }
            linearView.putScalar(i, 0);
        }
        return this;
    }

    @Override
    public INDArray lt(Number other) {
        return this.dup().lti(other);
    }

    @Override
    public INDArray lti(Number other) {
        INDArray linear = this.linearView();
        double val = other.doubleValue();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getDouble(i) < val ? 1 : 0);
        }
        return this;
    }

    @Override
    public INDArray eq(Number other) {
        return this.dup().eqi(other);
    }

    @Override
    public INDArray eqi(Number other) {
        INDArray linear = this.linearView();
        double val = other.doubleValue();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getDouble(i) == val ? 1 : 0);
        }
        return this;
    }

    @Override
    public INDArray gt(Number other) {
        return this.dup().gti(other);
    }

    @Override
    public INDArray gti(Number other) {
        INDArray linear = this.linearView();
        double val = other.doubleValue();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getDouble(i) > val ? 1 : 0);
        }
        return this;
    }

    @Override
    public INDArray lt(INDArray other) {
        return this.dup().lti(other);
    }

    @Override
    public INDArray lti(INDArray other) {
        INDArray linear = this.linearView();
        INDArray otherLinear = other.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getDouble(i) < otherLinear.getDouble(i) ? 1 : 0);
        }
        return this;
    }

    @Override
    public INDArray neq(Number other) {
        return this.dup().neqi(other);
    }

    @Override
    public INDArray neqi(Number other) {
        INDArray linear = this.linearView();
        double val = other.doubleValue();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getDouble(i) != val ? 1 : 0);
        }
        return this;
    }

    @Override
    public INDArray neq(INDArray other) {
        return this.dup().neqi(other);
    }

    @Override
    public INDArray neqi(INDArray other) {
        INDArray linear = this.linearView();
        INDArray otherLinear = other.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getDouble(i) != otherLinear.getDouble(i) ? 1 : 0);
        }
        return this;
    }

    @Override
    public INDArray eq(INDArray other) {
        return this.dup().eqi(other);
    }

    @Override
    public INDArray eqi(INDArray other) {
        INDArray linear = this.linearView();
        INDArray otherLinear = other.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getDouble(i) == otherLinear.getDouble(i) ? 1 : 0);
        }
        return this;
    }

    @Override
    public INDArray gt(INDArray other) {
        return this.dup().gti(other);
    }

    @Override
    public INDArray gti(INDArray other) {
        INDArray linear = this.linearView();
        INDArray otherLinear = other.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getDouble(i) > otherLinear.getDouble(i) ? 1 : 0);
        }
        return this;
    }

    @Override
    public INDArray neg() {
        return this.dup().negi();
    }

    @Override
    public INDArray negi() {
        return Transforms.neg(this, false);
    }

    @Override
    public INDArray rdiv(Number n, INDArray result) {
        return this.dup().rdivi(n, result);
    }

    @Override
    public INDArray rdivi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        INDArray linear = this.linearView();
        INDArray resultLinear = result == this ? linear : result.linearView();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, n.doubleValue() / linear.getDouble(i));
        }
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray rsub(Number n, INDArray result) {
        return this.dup().rsubi(n, result);
    }

    @Override
    public INDArray rsubi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        INDArray linear = this.linearView();
        INDArray resultLinear = result == this ? linear : result.linearView();
        double val = n.doubleValue();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, val - linear.getDouble(i));
        }
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray div(Number n, INDArray result) {
        return this.dup().divi(n, result);
    }

    @Override
    public INDArray divi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        INDArray linear = this.linearView();
        INDArray resultLinear = result == this ? linear : result.linearView();
        double val = n.doubleValue();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, linear.getDouble(i) / val);
        }
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray mul(Number n, INDArray result) {
        return this.dup().muli(n, result);
    }

    @Override
    public INDArray muli(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        INDArray linear = this.linearView();
        INDArray resultLinear = result == this ? linear : result.linearView();
        double val = n.doubleValue();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, linear.getDouble(i) * val);
        }
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray sub(Number n, INDArray result) {
        return this.dup().subi(n, result);
    }

    @Override
    public INDArray subi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        INDArray linear = this.linearView();
        INDArray resultLinear = result == this ? linear : result.linearView();
        double val = n.doubleValue();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, linear.getDouble(i) - val);
        }
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray add(Number n, INDArray result) {
        return this.dup().addi(n, result);
    }

    @Override
    public INDArray addi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        INDArray linear = this.linearView();
        INDArray resultLinear = result == this ? linear : result.linearView();
        double val = n.doubleValue();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, linear.getDouble(i) + val);
        }
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray getScalar(int row, int column) {
        return this.getScalar(new int[]{row, column});
    }

    @Override
    public INDArray dup() {
        INDArray ret = Nd4j.create(this.shape());
        INDArray linear = this.linearView();
        INDArray retLinear = ret.linearView();
        for (int i = 0; i < ret.length(); ++i) {
            double put = linear.getDouble(i);
            if (Double.isNaN(put)) {
                put = Nd4j.EPS_THRESHOLD;
            }
            retLinear.putScalar(i, put);
        }
        return ret;
    }

    @Override
    public int getInt(int ... indices) {
        int ix = this.offset;
        for (int i = 0; i < indices.length; ++i) {
            ix += indices[i] * this.stride[i];
        }
        return this.data.getInt(ix);
    }

    @Override
    public double getDouble(int ... indices) {
        int ix = this.offset;
        for (int i = 0; i < indices.length; ++i) {
            ix += indices[i] * this.stride[i];
        }
        return this.data.getDouble(ix);
    }

    @Override
    public float getFloat(int ... indices) {
        int ix = this.offset;
        for (int i = 0; i < indices.length; ++i) {
            ix += indices[i] * this.stride[i];
        }
        return this.data.getFloat(ix);
    }

    @Override
    public boolean isScalar() {
        if (this.shape.length == 0) {
            return true;
        }
        if (this.shape.length == 1 && this.shape[0] == 1) {
            return true;
        }
        if (this.shape.length >= 2) {
            for (int i = 0; i < this.shape.length; ++i) {
                if (this.shape[i] == 1) continue;
                return false;
            }
        }
        return this.length == 1;
    }

    @Override
    public INDArray put(int[] indices, INDArray element) {
        if (!element.isScalar()) {
            throw new IllegalArgumentException("Unable to insert anything but a scalar");
        }
        int ix = this.offset;
        for (int i = 0; i < indices.length; ++i) {
            ix += indices[i] * this.stride[i];
        }
        this.data.put(ix, element.getDouble(0));
        return this;
    }

    @Override
    public INDArray put(int i, int j, INDArray element) {
        return this.put(new int[]{i, j}, element);
    }

    @Override
    public INDArray put(int i, int j, Number element) {
        return this.putScalar(new int[]{i, j}, element.doubleValue());
    }

    @Override
    public INDArray putSlice(int slice, INDArray put) {
        if (this.isScalar()) {
            assert (put.isScalar()) : "Invalid dimension. Can only insert a scalar in to another scalar";
            this.put(0, put.getScalar(0));
            return this;
        }
        if (this.isVector()) {
            assert (put.isScalar() || put.isVector() && put.length() == this.length()) : "Invalid dimension on insertion. Can only insert scalars input vectors";
            if (put.isScalar()) {
                this.putScalar(slice, put.getDouble(0));
            } else {
                for (int i = 0; i < this.length(); ++i) {
                    this.putScalar(i, put.getDouble(i));
                }
            }
            return this;
        }
        this.assertSlice(put, slice);
        INDArray view = this.slice(slice);
        if (put.isScalar()) {
            this.putScalar(slice, put.getDouble(0));
        } else if (put.isVector()) {
            for (int i = 0; i < put.length(); ++i) {
                view.putScalar(i, put.getDouble(i));
            }
        } else if (put.shape().length == 2) {
            for (int i = 0; i < put.rows(); ++i) {
                for (int j = 0; j < put.columns(); ++j) {
                    view.put(i, j, put.getDouble(i, j));
                }
            }
        } else {
            assert (put.slices() == view.slices()) : "Slices must be equivalent.";
            for (int i = 0; i < put.slices(); ++i) {
                view.slice(i).putSlice(i, view.slice(i));
            }
        }
        return this;
    }

    protected void assertSlice(INDArray put, int slice) {
        assert (slice <= this.slices()) : "Invalid slice specified " + slice;
        int[] sliceShape = put.shape();
        int[] requiredShape = ArrayUtil.removeIndex(this.shape(), 0);
        if (put.isScalar()) {
            return;
        }
        if (Shape.isColumnVectorShape(sliceShape)) {
            return;
        }
        assert (Shape.shapeEquals(sliceShape, requiredShape)) : String.format("Invalid shape size of %s . Should have been %s ", Arrays.toString(sliceShape), Arrays.toString(requiredShape));
    }

    @Override
    public boolean isMatrix() {
        return this.shape().length == 2 && this.shape[0] != 1 && this.shape[1] != 1;
    }

    @Override
    public INDArray reduce(Ops.DimensionOp op, int dimension) {
        if (this.isScalar()) {
            return this;
        }
        if (this.isVector()) {
            return Nd4j.scalar(this.reduceVector(op, this));
        }
        int[] shape = ArrayUtil.removeIndex(this.shape, dimension);
        if (dimension == 0) {
            double[] data2 = new double[ArrayUtil.prod(shape)];
            int dataIter = 0;
            int numTimes = ArrayUtil.prod(shape);
            for (int offset = this.offset; offset < numTimes; ++offset) {
                double reduce = this.op(dimension, offset, op);
                data2[dataIter++] = reduce;
            }
            return Nd4j.create(data2, shape);
        }
        double[] data2 = new double[ArrayUtil.prod(shape)];
        int dataIter = 0;
        int[] sliceIndices = this.endsForSlices();
        int currOffset = 0;
        int numTimes = ArrayUtil.prod(shape);
        for (int offset = this.offset; offset < numTimes && dataIter < data2.length && currOffset < sliceIndices.length; ++offset) {
            IterationResult pair = this.op(dimension, offset, op, sliceIndices[currOffset]);
            double reduce = pair.getResult();
            data2[dataIter++] = reduce;
            if (!pair.isNextSlice()) continue;
            offset = sliceIndices[currOffset];
            numTimes += sliceIndices[currOffset];
            ++currOffset;
        }
        return Nd4j.create(data2, shape);
    }

    public DimensionSlice vectorForDimensionAndOffset(int dimension, int offset) {
        if (this.isScalar() && dimension == 0 && offset == 0) {
            return new DimensionSlice(false, this.getScalar(offset), new int[]{offset});
        }
        if (this.isVector()) {
            if (dimension == 0) {
                int[] indices = new int[this.length];
                for (int i = 0; i < indices.length; ++i) {
                    indices[i] = i;
                }
                return new DimensionSlice(false, this.dup(), indices);
            }
            if (dimension == 1) {
                return new DimensionSlice(false, this.getScalar(offset), new int[]{offset});
            }
            throw new IllegalArgumentException("Illegal dimension for vector " + dimension);
        }
        int count = 0;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        INDArray ret = Nd4j.create(new int[]{this.shape[dimension]});
        int j = offset;
        while (count < this.shape[dimension]) {
            double d = this.data.getDouble(j);
            ret.putScalar(count++, d);
            indices.add(j);
            j += this.stride[dimension];
        }
        return new DimensionSlice(false, ret, ArrayUtil.toArray(indices));
    }

    private IterationResult op(int dimension, int offset, Ops.DimensionOp op, int currOffsetForSlice) {
        double[] dim = new double[this.shape[dimension]];
        int count = 0;
        boolean newSlice = false;
        int j = offset;
        while (count < dim.length) {
            double d = this.data.getDouble(j);
            dim[count++] = d;
            if (j >= currOffsetForSlice) {
                newSlice = true;
            }
            j += this.stride[dimension];
        }
        return new IterationResult(this.reduceVector(op, Nd4j.create(dim)), newSlice);
    }

    private double op(int dimension, int offset, Ops.DimensionOp op) {
        double[] dim = new double[this.shape[dimension]];
        int count = 0;
        int j = offset;
        while (count < dim.length) {
            double d = this.data.getDouble(j);
            dim[count++] = d;
            j += this.stride[dimension];
        }
        return this.reduceVector(op, Nd4j.create(dim));
    }

    @Override
    public int index(int row, int column) {
        if (!this.isMatrix()) {
            if (this.isColumnVector()) {
                int idx = this.linearIndex(row);
                return idx;
            }
            if (this.isRowVector()) {
                int idx = this.linearIndex(column);
                return idx;
            }
            throw new IllegalStateException("Unable to getFromOrigin row/column from a non matrix");
        }
        return this.offset + (row * this.stride[0] + column * this.stride[1]);
    }

    protected INDArray newShape(int[] newShape, char ordering) {
        if (Arrays.equals(newShape, this.shape())) {
            return this;
        }
        if (Shape.isVector(newShape) && this.isVector()) {
            if (this.isRowVector() && Shape.isColumnVectorShape(newShape)) {
                return Nd4j.create(this.data, newShape, new int[]{this.stride[0], 1}, this.offset);
            }
            if (this.isColumnVector() && Shape.isRowVectorShape(newShape)) {
                return Nd4j.create(this.data, newShape, new int[]{this.stride[1]}, this.offset);
            }
        }
        INDArray newCopy = this;
        int[] newStrides = null;
        if (this.shape().length > 1 && (ordering == 'c' && this.ordering != 'c' || ordering == 'f' && this.ordering != 'f') && (newStrides = this.noCopyReshape(newShape, ordering)) == null) {
            newCopy = Nd4j.create(this.shape(), ordering);
            for (int i = 0; i < this.vectorsAlongDimension(0); ++i) {
                INDArray copyFrom = this.vectorAlongDimension(i, 0);
                INDArray copyTo = newCopy.vectorAlongDimension(i, 0);
                for (int j = 0; j < copyFrom.length(); ++j) {
                    copyTo.putScalar(j, copyFrom.getDouble(i));
                }
            }
        }
        if (newStrides == null) {
            newStrides = Nd4j.getStrides(newShape);
        }
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(newCopy.data(), newShape, newStrides, this.offset);
        }
        return Nd4j.create(newCopy.data(), newShape, newStrides, this.offset);
    }

    protected int[] noCopyReshape(int[] newShape, char ordering) {
        int oi;
        ArrayList<Integer> oldDims = new ArrayList<Integer>();
        ArrayList<Integer> oldStrides = new ArrayList<Integer>();
        for (int i = 0; i < this.shape.length; ++i) {
            if (this.size(i) == 1) continue;
            oldDims.add(this.size(i));
            oldStrides.add(this.stride[i]);
        }
        int np = 1;
        for (int ni = 0; ni < newShape.length; ++ni) {
            np *= newShape[ni];
        }
        int op = 1;
        for (oi = 0; oi < oldDims.size(); ++oi) {
            op *= ((Integer)oldDims.get(oi)).intValue();
        }
        if (np != op) {
            return null;
        }
        if (np == 0) {
            return null;
        }
        oi = 0;
        int oj = 1;
        int ni = 0;
        int nj = 1;
        ArrayList<Integer> newStrides = new ArrayList<Integer>();
        while (ni < newShape.length && oi < oldDims.size()) {
            int nk;
            np = newShape[ni];
            op = (Integer)oldDims.get(oi);
            while (np != op) {
                if (np < op) {
                    np *= newShape[nj++];
                    continue;
                }
                op *= ((Integer)oldDims.get(oj++)).intValue();
            }
            for (int ok = oi; ok < oj - 1; ++ok) {
                if (!(ordering == 'f' ? (Integer)oldStrides.get(ok + 1) != (Integer)oldDims.get(ok) * (Integer)oldStrides.get(ok) : (Integer)oldStrides.get(ok) != (Integer)oldDims.get(ok + 1) * (Integer)oldStrides.get(ok + 1))) continue;
                return null;
            }
            if (ordering == 'f') {
                newStrides.set(ni, (Integer)oldStrides.get(oi));
                for (nk = ni + 1; nk < nj; ++nk) {
                    newStrides.set(nk, (Integer)newStrides.get(nk - 1) * newShape[nk - 1]);
                }
            } else {
                newStrides.set(nj - 1, (Integer)oldStrides.get(oj - 1));
                for (nk = nj - 1; nk > ni; --nk) {
                    newStrides.set(nk - 1, (Integer)newStrides.get(nk) * newShape[nk]);
                }
            }
            ni = nj++;
            oi = oj++;
        }
        int lastStride = ni >= 1 ? (Integer)newStrides.get(ni - 1) : this.length;
        if (ordering == 'f') {
            lastStride *= newShape[ni - 1];
        }
        for (int nk = ni; nk < newShape.length; ++nk) {
            newStrides.set(nk, lastStride);
        }
        return ArrayUtil.toArray(newStrides);
    }

    protected double reduceVector(Ops.DimensionOp op, INDArray vector) {
        switch (op) {
            case SUM: {
                return vector.sum(Integer.MAX_VALUE).getDouble(0);
            }
            case MEAN: {
                return vector.mean(Integer.MAX_VALUE).getDouble(0);
            }
            case MIN: {
                return vector.min(Integer.MAX_VALUE).getDouble(0);
            }
            case MAX: {
                return vector.max(Integer.MAX_VALUE).getDouble(0);
            }
            case NORM_1: {
                return vector.norm1(Integer.MAX_VALUE).getDouble(0);
            }
            case NORM_2: {
                return vector.norm2(Integer.MAX_VALUE).getDouble(0);
            }
            case NORM_MAX: {
                return vector.normmax(Integer.MAX_VALUE).getDouble(0);
            }
        }
        throw new IllegalArgumentException("Illegal operation");
    }

    @Override
    public double squaredDistance(INDArray other) {
        double sd = 0.0;
        for (int i = 0; i < this.length; ++i) {
            double d = this.getDouble(i) - other.getDouble(i);
            sd += d * d;
        }
        return sd;
    }

    @Override
    public double distance2(INDArray other) {
        return Math.sqrt(this.squaredDistance(other));
    }

    @Override
    public double distance1(INDArray other) {
        return other.sub(this).sum(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public INDArray put(NDArrayIndex[] indices, INDArray element) {
        block12: {
            block11: {
                if (!Indices.isContiguous(indices)) break block11;
                INDArray get = this.get(indices);
                INDArray linear = get.linearView();
                if (element.isScalar()) {
                    for (int i = 0; i < linear.length(); ++i) {
                        linear.putScalar(i, element.getDouble(0));
                    }
                }
                if (!Shape.shapeEquals(element.shape(), get.shape()) && element.length() > get.length()) break block12;
                INDArray elementLinear = element.linearView();
                for (int i = 0; i < elementLinear.length(); ++i) {
                    linear.putScalar(i, elementLinear.getDouble(i));
                }
                break block12;
            }
            if (this.isVector()) {
                assert (indices.length == 1) : "Indices must only be of length 1.";
                assert (element.isScalar() || element.isVector()) : "Unable to assign elements. Element is not a vector.";
                assert (indices[0].length() == element.length()) : "Number of specified elements in index does not match length of element.";
                int[] assign = indices[0].indices();
                for (int i = 0; i < element.length(); ++i) {
                    this.putScalar(assign[i], element.getDouble(i));
                }
                return this;
            }
            if (element.isVector()) {
                this.slice(indices[0].indices()[0]).put(Arrays.copyOfRange(indices, 1, indices.length), element);
            } else {
                for (int i = 0; i < element.slices(); ++i) {
                    INDArray slice = this.slice(indices[0].indices()[i]);
                    slice.put(Arrays.copyOfRange(indices, 1, indices.length), element.slice(i));
                }
            }
        }
        return this;
    }

    @Override
    public INDArray put(NDArrayIndex[] indices, Number element) {
        return this.put(indices, Nd4j.scalar(element));
    }

    @Override
    public void iterateOverAllColumns(SliceOp op) {
        if (this.isVector()) {
            op.operate(this);
        } else if (this.isMatrix()) {
            for (int i = 0; i < this.columns(); ++i) {
                op.operate(this.getColumn(i));
            }
        } else {
            for (int i = 0; i < this.slices(); ++i) {
                this.slice(i).iterateOverAllRows(op);
            }
        }
    }

    @Override
    public void iterateOverAllRows(SliceOp op) {
        if (this.isVector()) {
            op.operate(this);
        } else if (this.isMatrix()) {
            for (int i = 0; i < this.rows(); ++i) {
                op.operate(this.getRow(i));
            }
        } else {
            for (int i = 0; i < this.slices(); ++i) {
                this.slice(i).iterateOverAllRows(op);
            }
        }
    }

    @Override
    public INDArray swapAxes(int dimension, int with) {
        int[] shape = ArrayUtil.range(0, this.shape().length);
        shape[dimension] = with;
        shape[with] = dimension;
        return this.permute(shape);
    }

    @Override
    public int[] endsForSlices() {
        int[] ret = new int[this.slices()];
        int currOffset = this.offset + this.stride[0] - 1;
        for (int i = 0; i < this.slices(); ++i) {
            ret[i] = currOffset;
            currOffset += this.stride[0];
        }
        return ret;
    }

    @Override
    public DataBuffer data() {
        return this.data;
    }

    @Override
    public void setData(DataBuffer data) {
        this.data = data;
    }

    @Override
    public int slices() {
        if (this.shape.length < 1) {
            return 0;
        }
        return this.shape[0];
    }

    @Override
    public INDArray subArray(int[] offsets, int[] shape, int[] stride) {
        int n = shape.length;
        if (shape.length < 1) {
            return Nd4j.create(Nd4j.createBuffer(shape));
        }
        if (offsets.length != n) {
            throw new IllegalArgumentException("Invalid offset " + Arrays.toString(offsets));
        }
        if (shape.length != n) {
            throw new IllegalArgumentException("Invalid shape " + Arrays.toString(shape));
        }
        if (Arrays.equals(shape, this.shape)) {
            if (ArrayUtil.isZero(offsets)) {
                return this;
            }
            throw new IllegalArgumentException("Invalid subArray offsets");
        }
        int offset = this.offset + ArrayUtil.dotProduct(offsets, this.stride);
        return Nd4j.create(this.data, Arrays.copyOf(shape, shape.length), stride, offset, this.ordering);
    }

    @Override
    public INDArray cond(Condition condition) {
        return this.dup().condi(condition);
    }

    @Override
    public INDArray condi(Condition condition) {
        INDArray linear = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            boolean met = condition.apply(linear.getDouble(i));
            linear.putScalar(i, met ? 1 : 0);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void iterateOverDimension(int dimension, SliceOp op, boolean modify) {
        if (dimension >= this.shape.length) {
            throw new IllegalArgumentException("Unable to remove dimension  " + dimension + " was >= shape length");
        }
        if (this.isScalar()) {
            if (dimension > 0) {
                throw new IllegalArgumentException("Dimension must be 0 for a scalar");
            }
            DimensionSlice slice = this.vectorForDimensionAndOffset(0, 0);
            op.operate(slice);
            if (!modify || slice.getIndices() == null) return;
            INDArray result = (INDArray)slice.getResult();
            for (int i = 0; i < slice.getIndices().length; ++i) {
                this.data.put(slice.getIndices()[i], result.getDouble(i));
            }
            return;
        } else if (this.isVector()) {
            if (dimension == 0) {
                DimensionSlice slice = this.vectorForDimensionAndOffset(0, 0);
                op.operate(slice);
                if (!modify || slice.getIndices() == null) return;
                INDArray result = (INDArray)slice.getResult();
                for (int i = 0; i < slice.getIndices().length; ++i) {
                    this.data.put(slice.getIndices()[i], result.getDouble(i));
                }
                return;
            } else {
                if (dimension != 1) throw new IllegalArgumentException("Illegal dimension for vector " + dimension);
                for (int i = 0; i < this.length; ++i) {
                    DimensionSlice slice = this.vectorForDimensionAndOffset(dimension, i);
                    op.operate(slice);
                    if (!modify || slice.getIndices() == null) continue;
                    INDArray result = (INDArray)slice.getResult();
                    for (int j = 0; j < slice.getIndices().length; ++j) {
                        this.data.put(slice.getIndices()[j], result.getDouble(j));
                    }
                }
            }
            return;
        } else {
            int vectors = this.vectorsAlongDimension(dimension);
            for (int i = 0; i < vectors; ++i) {
                INDArray vector = this.vectorAlongDimension(i, dimension);
                op.operate(vector);
            }
        }
    }

    @Override
    public void setStride(int[] stride) {
        this.stride = stride;
    }

    protected void initShape(int[] shape) {
        this.shape = shape;
        if (this.shape.length == 1) {
            this.rows = 1;
            this.columns = this.shape[0];
        } else if (this.shape().length == 2) {
            if (shape[0] == 1) {
                this.shape = new int[1];
                this.shape[0] = shape[1];
                this.rows = 1;
                this.columns = shape[1];
                if (this.stride != null && this.ordering == 'f') {
                    this.stride = new int[]{ArrayUtil.nonOneStride(this.stride)};
                }
            } else {
                this.rows = shape[0];
                this.columns = shape[1];
            }
        } else if (this.shape.length == 1) {
            this.columns = this.shape[0];
            this.rows = 1;
        }
        if (this.ordering == '\u0000') {
            this.ordering = Nd4j.order().charValue();
        }
        this.length = ArrayUtil.prod(this.shape);
        if (this.stride == null) {
            this.stride = this.ordering == 'f' ? ArrayUtil.calcStridesFortran(shape) : ArrayUtil.calcStrides(this.shape);
        }
        if (this.stride.length != this.shape.length) {
            this.stride = this.ordering == 'f' ? ArrayUtil.calcStridesFortran(this.shape) : ArrayUtil.calcStrides(this.shape);
        }
    }

    @Override
    public INDArray getScalar(int i) {
        if (!this.isVector() && !this.isScalar()) {
            throw new IllegalArgumentException("Unable to do linear indexing with dimensions greater than 1");
        }
        int idx = this.linearIndex(i);
        return Nd4j.scalar(this.data.getDouble(idx));
    }

    protected void assertColumnVector(INDArray column) {
        assert (column.isColumnVector() || column.columns() == this.columns() && column.rows() == 1) : "Must only add a column vector";
        assert (column.length() == this.rows() || column.columns() == this.columns() && column.rows() == 1) : "Illegal column vector must have the same length as the number of rows in this ndarray";
    }

    protected INDArray doColumnWise(INDArray columnVector, char operation) {
        if (this.rows() == 1 && columnVector.isScalar()) {
            switch (operation) {
                case 'a': {
                    this.addi(columnVector.getDouble(0));
                    break;
                }
                case 's': {
                    this.subi(columnVector.getDouble(0));
                    break;
                }
                case 'm': {
                    this.muli(columnVector.getDouble(0));
                    break;
                }
                case 'd': {
                    this.divi(columnVector.getDouble(0));
                    break;
                }
                case 'h': {
                    this.rsubi(columnVector.getDouble(0));
                    break;
                }
                case 't': {
                    this.rdivi(columnVector.getDouble(0));
                }
            }
            return this;
        }
        this.assertColumnVector(columnVector);
        block16: for (int i = 0; i < this.columns(); ++i) {
            INDArray slice = this.slice(i, 0);
            switch (operation) {
                case 'a': {
                    slice.addi(columnVector);
                    continue block16;
                }
                case 's': {
                    slice.subi(columnVector);
                    continue block16;
                }
                case 'm': {
                    slice.muli(columnVector);
                    continue block16;
                }
                case 'd': {
                    slice.divi(columnVector);
                    continue block16;
                }
                case 'h': {
                    slice.rsubi(columnVector);
                    continue block16;
                }
                case 't': {
                    slice.rdivi(columnVector);
                }
            }
        }
        return this;
    }

    protected void assertRowVector(INDArray rowVector) {
        assert (rowVector.isRowVector() || rowVector.rows() == this.rows() && rowVector.columns() == 1) : "Must only add a row vector";
        assert (rowVector.length() == this.columns() || rowVector.rows() == this.rows() && rowVector.columns() == 1) : "Illegal row vector must have the same length as the number of rows in this ndarray";
    }

    protected INDArray doRowWise(INDArray rowVector, char operation) {
        if (this.columns() == 1 && rowVector.isScalar()) {
            switch (operation) {
                case 'a': {
                    this.addi(rowVector.getDouble(0));
                    break;
                }
                case 's': {
                    this.subi(rowVector.getDouble(0));
                    break;
                }
                case 'm': {
                    this.muli(rowVector.getDouble(0));
                    break;
                }
                case 'd': {
                    this.divi(rowVector.getDouble(0));
                    break;
                }
                case 'h': {
                    this.rsubi(rowVector.getDouble(0));
                    break;
                }
                case 't': {
                    this.rdivi(rowVector.getDouble(0));
                }
            }
            return this;
        }
        this.assertRowVector(rowVector);
        block16: for (int i = 0; i < this.rows(); ++i) {
            switch (operation) {
                case 'a': {
                    this.getRow(i).addi(rowVector);
                    continue block16;
                }
                case 's': {
                    this.getRow(i).subi(rowVector);
                    continue block16;
                }
                case 'm': {
                    this.getRow(i).muli(rowVector);
                    continue block16;
                }
                case 'd': {
                    this.getRow(i).divi(rowVector);
                    continue block16;
                }
                case 'h': {
                    this.getRow(i).rsubi(rowVector);
                    continue block16;
                }
                case 't': {
                    this.getRow(i).rdivi(rowVector);
                }
            }
        }
        return this;
    }

    @Override
    public INDArray rdiviColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 't');
    }

    @Override
    public INDArray rdivColumnVector(INDArray columnVector) {
        return this.dup().rdiviColumnVector(columnVector);
    }

    @Override
    public INDArray rdiviRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 't');
    }

    @Override
    public INDArray rdivRowVector(INDArray rowVector) {
        return this.dup().rdiviRowVector(rowVector);
    }

    @Override
    public INDArray rsubiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'h');
    }

    @Override
    public INDArray rsubColumnVector(INDArray columnVector) {
        return this.dup().rsubiColumnVector(columnVector);
    }

    @Override
    public INDArray rsubiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'h');
    }

    @Override
    public INDArray rsubRowVector(INDArray rowVector) {
        return this.dup().rsubiRowVector(rowVector);
    }

    @Override
    public INDArray put(int i, INDArray element) {
        if (element == null) {
            throw new IllegalArgumentException("Unable to insert null element");
        }
        assert (element.isScalar()) : "Unable to insert non scalar element";
        int idx = this.linearIndex(i);
        this.data.put(idx, element.getDouble(0));
        return this;
    }

    @Override
    public INDArray diviColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'd');
    }

    @Override
    public INDArray divColumnVector(INDArray columnVector) {
        return this.dup().diviColumnVector(columnVector);
    }

    @Override
    public INDArray diviRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'd');
    }

    @Override
    public INDArray divRowVector(INDArray rowVector) {
        return this.dup().diviRowVector(rowVector);
    }

    @Override
    public INDArray muliColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'm');
    }

    @Override
    public INDArray mulColumnVector(INDArray columnVector) {
        return this.dup().muliColumnVector(columnVector);
    }

    @Override
    public INDArray muliRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'm');
    }

    @Override
    public INDArray mulRowVector(INDArray rowVector) {
        return this.dup().muliRowVector(rowVector);
    }

    @Override
    public INDArray subiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 's');
    }

    @Override
    public INDArray subColumnVector(INDArray columnVector) {
        return this.dup().subiColumnVector(columnVector);
    }

    @Override
    public INDArray subiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 's');
    }

    @Override
    public INDArray subRowVector(INDArray rowVector) {
        return this.dup().subiRowVector(rowVector);
    }

    @Override
    public INDArray addiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'a');
    }

    @Override
    public INDArray addColumnVector(INDArray columnVector) {
        return this.dup().addiColumnVector(columnVector);
    }

    @Override
    public INDArray addiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'a');
    }

    @Override
    public INDArray addRowVector(INDArray rowVector) {
        return this.dup().addiRowVector(rowVector);
    }

    @Override
    public INDArray mmul(INDArray other) {
        int[] shape = new int[]{this.rows(), other.columns()};
        char order = Nd4j.factory().order();
        boolean switchedOrder = false;
        if (order != 'f') {
            Nd4j.factory().setOrder('f');
            switchedOrder = true;
        }
        INDArray result = Nd4j.create(shape, other.data().dataType());
        if (switchedOrder && order != 'f') {
            Nd4j.factory().setOrder('c');
        }
        return this.mmuli(other, result);
    }

    @Override
    public INDArray mmul(INDArray other, INDArray result) {
        return this.dup().mmuli(other, result);
    }

    @Override
    public INDArray div(INDArray other) {
        return this.dup().divi(other);
    }

    @Override
    public INDArray div(INDArray other, INDArray result) {
        return this.dup().divi(other, result);
    }

    @Override
    public INDArray mul(INDArray other) {
        return this.dup().muli(other);
    }

    @Override
    public INDArray mul(INDArray other, INDArray result) {
        return this.dup().muli(other, result);
    }

    @Override
    public INDArray sub(INDArray other) {
        return this.dup().subi(other);
    }

    @Override
    public INDArray sub(INDArray other, INDArray result) {
        return this.dup().subi(other, result);
    }

    @Override
    public INDArray add(INDArray other) {
        return this.dup().addi(other);
    }

    @Override
    public INDArray add(INDArray other, INDArray result) {
        return this.dup().addi(other, result);
    }

    @Override
    public INDArray mmuli(INDArray other) {
        return this.dup().mmuli(other, this);
    }

    @Override
    public INDArray mmuli(INDArray other, INDArray result) {
        INDArray otherArray = other;
        INDArray resultArray = result;
        if (other.shape().length > 2) {
            for (int i = 0; i < other.slices(); ++i) {
                result.putSlice(i, this.slice(i).mmul(other.slice(i)));
            }
            return result;
        }
        LinAlgExceptions.assertMultiplies(this, other);
        if (other.isScalar()) {
            return this.muli(otherArray.getDouble(0), resultArray);
        }
        if (this.isScalar()) {
            return otherArray.muli(this.getDouble(0), resultArray);
        }
        if (result == this || result == other) {
            INDArray temp = Nd4j.create(resultArray.shape(), ArrayUtil.calcStridesFortran(resultArray.shape()));
            if (otherArray.columns() == 1) {
                if (this.data.dataType() == 0) {
                    Nd4j.getBlasWrapper().gemv(1.0, this, otherArray, 0.0, temp);
                } else {
                    Nd4j.getBlasWrapper().gemv(1.0f, this, otherArray, 0.0f, temp);
                }
            } else if (this.data.dataType() == 0) {
                Nd4j.getBlasWrapper().gemm(1.0, this, otherArray, 0.0, temp);
            } else {
                Nd4j.getBlasWrapper().gemm(1.0f, this, otherArray, 0.0f, temp);
            }
            Nd4j.getBlasWrapper().copy(temp, resultArray);
        } else if (otherArray.columns() == 1) {
            if (this.data.dataType() == 0) {
                Nd4j.getBlasWrapper().gemv(1.0, this, otherArray, 0.0, resultArray);
            } else {
                Nd4j.getBlasWrapper().gemv(1.0f, this, otherArray, 0.0f, resultArray);
            }
        } else if (this.data.dataType() == 0) {
            Nd4j.getBlasWrapper().gemm(1.0, this, otherArray, 0.0, resultArray);
        } else {
            Nd4j.getBlasWrapper().gemm(1.0f, this, otherArray, 0.0f, resultArray);
        }
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(resultArray);
        }
        return resultArray;
    }

    @Override
    public INDArray divi(INDArray other) {
        return this.divi(other, (INDArray)this);
    }

    @Override
    public INDArray divi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.divi(other.getDouble(0), result);
        }
        if (this.isScalar()) {
            return other.divi(this.getDouble(0), result);
        }
        INDArray otherLinear = other.linearView();
        INDArray resultLinear = result.linearView();
        INDArray linearView = this.linearView();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, linearView.getDouble(i) / otherLinear.getDouble(i));
        }
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray muli(INDArray other) {
        return this.muli(other, (INDArray)this);
    }

    @Override
    public INDArray muli(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.muli(other.getDouble(0), result);
        }
        if (this.isScalar()) {
            return other.muli(this.getDouble(0), result);
        }
        INDArray otherLinear = other.linearView();
        INDArray resultLinear = result.linearView();
        INDArray linearView = this.linearView();
        for (int i = 0; i < this.length; ++i) {
            resultLinear.putScalar(i, linearView.getDouble(i) * otherLinear.getDouble(i));
        }
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray subi(INDArray other) {
        return this.subi(other, (INDArray)this);
    }

    @Override
    public INDArray subi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.subi(other.getDouble(0), result);
        }
        if (this.isScalar()) {
            return other.rsubi(this.getDouble(0), result);
        }
        if (result == this) {
            if (this.data.dataType() == 0) {
                Nd4j.getBlasWrapper().axpy(-1.0, other, result);
            } else {
                Nd4j.getBlasWrapper().axpy(-1.0f, other, result);
            }
        } else if (result == other) {
            if (this.data.dataType() == 0) {
                Nd4j.getBlasWrapper().scal(-1.0, result);
                Nd4j.getBlasWrapper().axpy(1.0, this, result);
            } else {
                Nd4j.getBlasWrapper().scal(-1.0f, result);
                Nd4j.getBlasWrapper().axpy(1.0f, this, result);
            }
        } else if (this.data.dataType() == 1) {
            Nd4j.getBlasWrapper().copy(this, result);
            Nd4j.getBlasWrapper().axpy(-1.0f, other, result);
        } else {
            Nd4j.getBlasWrapper().copy(this, result);
            Nd4j.getBlasWrapper().axpy(-1.0, other, result);
        }
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray addi(INDArray other) {
        return this.addi(other, (INDArray)this);
    }

    @Override
    public INDArray addi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return result.addi(other.getDouble(0), result);
        }
        if (this.isScalar()) {
            return other.addi(this.getDouble(0), result);
        }
        if (result == this) {
            if (this.data.dataType() == 0) {
                Nd4j.getBlasWrapper().axpy(1.0, other, result);
            } else {
                Nd4j.getBlasWrapper().axpy(1.0f, other, result);
            }
        } else if (result == other) {
            if (this.data.dataType() == 0) {
                Nd4j.getBlasWrapper().axpy(1.0, this, result);
            } else {
                Nd4j.getBlasWrapper().axpy(1.0f, this, result);
            }
        } else {
            INDArray resultLinear = result.linearView();
            INDArray otherLinear = other.linearView();
            INDArray linear = this.linearView();
            for (int i = 0; i < resultLinear.length(); ++i) {
                resultLinear.putScalar(i, otherLinear.getDouble(i) + linear.getDouble(i));
            }
        }
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray normmax(int dimension) {
        Triple<SliceOp, INDArray, int[]> pair = this.getOp(new AtomicInteger(0), DimensionFunctions.normmax(dimension), dimension);
        return this.doDimensionWise(DimensionFunctions.normmax(), (SliceOp)pair.getLeft(), (INDArray)pair.getMiddle(), (int[])pair.getRight(), dimension, false);
    }

    @Override
    public INDArray rdiv(INDArray other) {
        return this.dup().rdivi(other);
    }

    @Override
    public INDArray rdivi(INDArray other) {
        return this.rdivi(other, (INDArray)this);
    }

    @Override
    public INDArray rdiv(INDArray other, INDArray result) {
        return this.dup().rdivi(other, result);
    }

    @Override
    public INDArray rdivi(INDArray other, INDArray result) {
        return other.divi(this, result);
    }

    @Override
    public INDArray rsub(INDArray other, INDArray result) {
        return this.dup().rsubi(other, result);
    }

    @Override
    public INDArray rsub(INDArray other) {
        return this.dup().rsubi(other);
    }

    @Override
    public INDArray rsubi(INDArray other) {
        return this.rsubi(other, (INDArray)this);
    }

    @Override
    public INDArray rsubi(INDArray other, INDArray result) {
        return other.subi(this, result);
    }

    @Override
    public INDArray assign(Number value) {
        INDArray one = this.linearView();
        for (int i = 0; i < one.length(); ++i) {
            one.putScalar(i, value.doubleValue());
        }
        return this;
    }

    @Override
    public int linearIndex(int i) {
        int realStride = this.stride[0];
        int idx = this.offset + i * realStride;
        if (this.data != null && idx >= this.data.length()) {
            throw new IllegalArgumentException("Illegal index " + idx + " derived from " + i + " with offset of " + this.offset + " and stride of " + realStride);
        }
        return idx;
    }

    @Override
    public INDArray slice(int slice) {
        if (this.shape.length == 0) {
            throw new IllegalArgumentException("Can't slice a 0-d NDArray");
        }
        if (this.shape.length == 1) {
            if (this.size(0) == 1) {
                return Nd4j.create(this.data, ArrayUtil.empty(), ArrayUtil.empty(), this.offset + slice);
            }
            return Nd4j.create(this.data, ArrayUtil.empty(), ArrayUtil.empty(), this.offset + slice * this.stride[0]);
        }
        if (this.shape.length == 2) {
            if (this.size(0) == 1) {
                INDArray slice2 = Nd4j.create(this.data, ArrayUtil.of(this.shape[1]), Arrays.copyOfRange(this.stride, 1, this.stride.length), this.offset + slice, this.ordering);
                return slice2;
            }
            INDArray slice2 = Nd4j.create(this.data, ArrayUtil.of(this.shape[1]), Arrays.copyOfRange(this.stride, 1, this.stride.length), this.offset + slice * this.stride[0], this.ordering);
            return slice2;
        }
        int offset = this.offset + slice * this.stride[0];
        if (this.size(0) == 1) {
            INDArray slice2 = Nd4j.create(this.data, Arrays.copyOfRange(this.shape, 1, this.shape.length), Arrays.copyOfRange(this.stride, 1, this.stride.length), offset, this.ordering);
            return slice2;
        }
        INDArray slice2 = Nd4j.create(this.data, Arrays.copyOfRange(this.shape, 1, this.shape.length), Arrays.copyOfRange(this.stride, 1, this.stride.length), offset, this.ordering);
        return slice2;
    }

    @Override
    public INDArray slice(int slice, int dimension) {
        if (this.shape.length == 2) {
            if (dimension == 1) {
                return this.getRow(slice);
            }
            if (dimension == 0) {
                return this.getColumn(slice);
            }
            throw new IllegalAccessError("Illegal dimension for matrix");
        }
        if (slice == this.shape.length - 1) {
            return this.slice(dimension);
        }
        INDArray slice2 = Nd4j.create(this.data, ArrayUtil.removeIndex(this.shape, dimension), ArrayUtil.removeIndex(this.stride, dimension), this.offset + slice * this.stride[dimension], this.ordering);
        return slice2;
    }

    @Override
    public INDArray getScalar(int ... indexes) {
        int ix = this.offset;
        for (int i = 0; i < indexes.length; ++i) {
            ix += indexes[i] * this.stride[i];
        }
        if (ix >= this.data.length()) {
            throw new IllegalArgumentException("Illegal index " + Arrays.toString(indexes));
        }
        return Nd4j.scalar(this.data.getDouble(ix));
    }

    @Override
    public INDArray rdiv(Number n) {
        return this.dup().rdivi(n);
    }

    @Override
    public INDArray rdivi(Number n) {
        return this.rdivi(n, (INDArray)this);
    }

    @Override
    public INDArray rsub(Number n) {
        return this.dup().rsubi(n);
    }

    @Override
    public INDArray rsubi(Number n) {
        return this.rsubi(n, (INDArray)this);
    }

    @Override
    public INDArray div(Number n) {
        return this.dup().divi(n);
    }

    @Override
    public INDArray divi(Number n) {
        return this.divi(n, (INDArray)this);
    }

    @Override
    public INDArray mul(Number n) {
        return this.dup().muli(n);
    }

    @Override
    public INDArray muli(Number n) {
        return this.muli(n, (INDArray)this);
    }

    @Override
    public INDArray sub(Number n) {
        return this.dup().subi(n);
    }

    @Override
    public INDArray subi(Number n) {
        return this.subi(n, (INDArray)this);
    }

    @Override
    public INDArray add(Number n) {
        return this.dup().addi(n);
    }

    @Override
    public INDArray addi(Number n) {
        return this.addi(n, (INDArray)this);
    }

    @Override
    public INDArray repmat(int[] shape) {
        int[] nArray;
        int[] newShape = new int[shape.length];
        assert (shape.length <= newShape.length) : "Illegal shape: The passed in shape must be <= the current shape length";
        if (this.isRowVector()) {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = this.shape[0];
        } else {
            nArray = Arrays.copyOf(this.shape, 2);
        }
        int[] oldShape = nArray;
        for (int i = 0; i < newShape.length; ++i) {
            newShape[i] = i < this.shape.length ? oldShape[i] * shape[i] : oldShape[i];
        }
        INDArray result = Nd4j.create(newShape);
        if (this.isScalar()) {
            for (int i = 0; i < result.length(); ++i) {
                result.put(i, this.getScalar(0));
            }
        } else if (this.isRowVector()) {
            if (Shape.isColumnVectorShape(newShape)) {
                return this.transpose();
            }
            if (Shape.isMatrix(newShape)) {
                INDArray ret = Nd4j.create(newShape);
                for (int i = 0; i < ret.rows(); ++i) {
                    ret.putRow(i, this);
                }
                return ret;
            }
        } else if (this.isMatrix()) {
            for (int c = 0; c < this.shape()[1]; ++c) {
                for (int r = 0; r < this.shape()[0]; ++r) {
                    for (int i = 0; i < this.rows(); ++i) {
                        for (int j = 0; j < this.columns(); ++j) {
                            result.put(r * this.rows() + i, c * this.columns() + j, this.getScalar(i, j));
                        }
                    }
                }
            }
        } else {
            int[] sliceRepmat = ArrayUtil.removeIndex(shape, 0);
            for (int i = 0; i < result.slices(); ++i) {
                result.putSlice(i, this.repmat(sliceRepmat));
            }
        }
        INDArray ret = result;
        return ret;
    }

    @Override
    public INDArray putRow(int row, INDArray toPut) {
        assert (toPut.isVector() && toPut.length() == this.columns) : "Illegal length for row " + toPut.length() + " should have been " + this.columns;
        INDArray r = this.getRow(row);
        for (int i = 0; i < r.length(); ++i) {
            r.putScalar(i, toPut.getDouble(i));
        }
        return this;
    }

    @Override
    public INDArray putColumn(int column, INDArray toPut) {
        assert (toPut.isVector() && toPut.length() == this.rows()) : "Illegal length for row " + toPut.length() + " should have been " + this.rows();
        INDArray r = this.getColumn(column);
        for (int i = 0; i < r.length(); ++i) {
            r.putScalar(i, toPut.getDouble(i));
        }
        return this;
    }

    @Override
    public <E> E getElement(int i) {
        int idx = this.linearIndex(i);
        if (idx < 0) {
            throw new IllegalStateException("Illegal index " + i);
        }
        return this.data.getElement(idx);
    }

    @Override
    public <E> E getElement(int i, int j) {
        int idx = this.index(i, j);
        return this.data.getElement(idx);
    }

    @Override
    public double getDouble(int i) {
        int idx = this.linearIndex(i);
        if (idx < 0) {
            throw new IllegalStateException("Illegal index " + i);
        }
        return this.data.getDouble(idx);
    }

    @Override
    public double getDouble(int i, int j) {
        int idx = this.index(i, j);
        return this.data.getDouble(idx);
    }

    @Override
    public float getFloat(int i) {
        int idx = this.linearIndex(i);
        if (idx < 0) {
            throw new IllegalStateException("Illegal index " + i);
        }
        return this.data.getFloat(idx);
    }

    @Override
    public float getFloat(int i, int j) {
        int idx = this.index(i, j);
        return this.data.getFloat(idx);
    }

    public static int getIndex(int offset, int[] stride, int ... indexes) {
        if (stride.length > indexes.length) {
            throw new IllegalArgumentException("Invalid number of items in stride array: should be <= number of indexes");
        }
        int ix = offset;
        for (int i = 0; i < indexes.length; ++i) {
            ix += indexes[i] * stride[i];
        }
        return ix;
    }

    @Override
    public INDArray transpose() {
        if (this.isRowVector()) {
            return Nd4j.create(this.data, new int[]{this.shape[0], 1}, this.offset);
        }
        if (this.isColumnVector()) {
            return Nd4j.create(this.data, new int[]{this.shape[0]}, this.offset);
        }
        if (this.isMatrix()) {
            INDArray reverse = Nd4j.create(new int[]{this.shape[1], this.shape[0]});
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    reverse.putScalar(new int[]{j, i}, this.getDouble(i, j));
                }
            }
            return reverse;
        }
        INDArray ret = this.permute(ArrayUtil.range(this.shape.length - 1, -1));
        return ret;
    }

    @Override
    public INDArray reshape(int[] shape) {
        assert (ArrayUtil.prod(shape) == ArrayUtil.prod(this.shape())) : "Illegal reshape must be of same length as data";
        return this.newShape(shape, this.ordering);
    }

    @Override
    public void checkDimensions(INDArray other) {
        assert (Arrays.equals(this.shape, other.shape())) : " Other array should have been shape: " + Arrays.toString(this.shape) + " but was " + Arrays.toString(other.shape());
        assert (Arrays.equals(this.stride, other.stride())) : " Other array should have been stride: " + Arrays.toString(this.stride) + " but was " + Arrays.toString(other.stride());
        assert (this.offset == other.offset()) : "Offset of this array is " + this.offset + " but other was " + other.offset();
    }

    @Override
    public INDArray prod(int dimension) {
        Triple<SliceOp, INDArray, int[]> pair = this.getOp(new AtomicInteger(0), DimensionFunctions.prod(dimension), dimension);
        return this.doDimensionWise(DimensionFunctions.prod(), (SliceOp)pair.getLeft(), (INDArray)pair.getMiddle(), (int[])pair.getRight(), dimension, false);
    }

    @Override
    public INDArray mean(int dimension) {
        Triple<SliceOp, INDArray, int[]> pair = this.getOp(new AtomicInteger(0), DimensionFunctions.mean(dimension), dimension);
        return this.doDimensionWise(DimensionFunctions.mean(), (SliceOp)pair.getLeft(), (INDArray)pair.getMiddle(), (int[])pair.getRight(), dimension, false);
    }

    @Override
    public INDArray var(int dimension) {
        Triple<SliceOp, INDArray, int[]> pair = this.getOp(new AtomicInteger(0), DimensionFunctions.var(dimension), dimension);
        return this.doDimensionWise(DimensionFunctions.var(), (SliceOp)pair.getLeft(), (INDArray)pair.getMiddle(), (int[])pair.getRight(), dimension, false);
    }

    @Override
    public INDArray max(int dimension) {
        Triple<SliceOp, INDArray, int[]> pair = this.getOp(new AtomicInteger(0), DimensionFunctions.max(dimension), dimension);
        return this.doDimensionWise(DimensionFunctions.max(), (SliceOp)pair.getLeft(), (INDArray)pair.getMiddle(), (int[])pair.getRight(), dimension, false);
    }

    @Override
    public INDArray min(int dimension) {
        Triple<SliceOp, INDArray, int[]> pair = this.getOp(new AtomicInteger(0), DimensionFunctions.min(dimension), dimension);
        return this.doDimensionWise(DimensionFunctions.min(), (SliceOp)pair.getLeft(), (INDArray)pair.getMiddle(), (int[])pair.getRight(), dimension, false);
    }

    @Override
    public INDArray sum(int dimension) {
        Triple<SliceOp, INDArray, int[]> pair = this.getOp(new AtomicInteger(0), DimensionFunctions.sum(dimension), dimension);
        return this.doDimensionWise(DimensionFunctions.sum(), (SliceOp)pair.getLeft(), (INDArray)pair.getMiddle(), (int[])pair.getRight(), dimension, false);
    }

    @Override
    public INDArray norm1(int dimension) {
        Triple<SliceOp, INDArray, int[]> pair = this.getOp(new AtomicInteger(0), DimensionFunctions.norm1(dimension), dimension);
        return this.doDimensionWise(DimensionFunctions.norm1(), (SliceOp)pair.getLeft(), (INDArray)pair.getMiddle(), (int[])pair.getRight(), dimension, false);
    }

    @Override
    public INDArray std(int dimension) {
        Triple<SliceOp, INDArray, int[]> pair = this.getOp(new AtomicInteger(0), DimensionFunctions.std(dimension), dimension);
        return this.doDimensionWise(DimensionFunctions.std(), (SliceOp)pair.getLeft(), (INDArray)pair.getMiddle(), (int[])pair.getRight(), dimension, false);
    }

    @Override
    public INDArray norm2(int dimension) {
        Triple<SliceOp, INDArray, int[]> pair = this.getOp(new AtomicInteger(0), DimensionFunctions.norm2(dimension), dimension);
        return this.doDimensionWise(DimensionFunctions.norm2(), (SliceOp)pair.getLeft(), (INDArray)pair.getMiddle(), (int[])pair.getRight(), dimension, false);
    }

    private Triple<SliceOp, INDArray, int[]> getOp(final AtomicInteger i, final Function<INDArray, INDArray> func, int dimension) {
        int[] nArray;
        if (this.shape().length == 1 || dimension == Integer.MAX_VALUE) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            nArray = ArrayUtil.removeIndex(this.shape(), dimension);
        }
        int[] shape = nArray;
        final INDArray put = Nd4j.create(new int[]{ArrayUtil.prod(shape)});
        SliceOp op = new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                INDArray arr2 = (INDArray)nd.getResult();
                put.put(i.get(), (INDArray)func.apply((Object)arr2));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                put.put(i.get(), (INDArray)func.apply((Object)nd));
                i.incrementAndGet();
            }
        };
        return Triple.of((Object)op, (Object)put, (Object)shape);
    }

    @Override
    public int columns() {
        if (this.isMatrix()) {
            if (this.shape().length > 2) {
                return Shape.squeeze(this.shape)[1];
            }
            if (this.shape().length == 2) {
                return this.shape[1];
            }
        }
        if (this.isVector()) {
            if (this.isColumnVector()) {
                return 1;
            }
            return this.shape[0];
        }
        throw new IllegalStateException("Unable to getFromOrigin number of of rows for a non 2d matrix");
    }

    @Override
    public int rows() {
        if (this.isMatrix()) {
            if (this.shape().length > 2) {
                return Shape.squeeze(this.shape)[0];
            }
            if (this.shape().length == 2) {
                return this.shape[0];
            }
        } else if (this.isVector()) {
            if (this.isRowVector()) {
                return 1;
            }
            return this.shape[0];
        }
        throw new IllegalStateException("Unable to get number of of rows for a non 2d matrix");
    }

    protected INDArray doDimensionWise(Function<INDArray, INDArray> baseCase, SliceOp sliceOp, INDArray arr, int[] newShape, int dimension, boolean modify) {
        if (dimension == Integer.MAX_VALUE || this.isVector()) {
            return (INDArray)baseCase.apply((Object)this.linearView());
        }
        this.iterateOverDimension(dimension, sliceOp, modify);
        return arr.reshape(newShape);
    }

    @Override
    public INDArray ravel() {
        INDArray ret = Nd4j.create(this.length, this.ordering);
        int dimension = this.shape.length == 2 ? 1 : this.shape.length;
        int count = 0;
        for (int i = 0; i < this.vectorsAlongDimension(dimension); ++i) {
            INDArray vec = this.vectorAlongDimension(i, dimension);
            for (int j = 0; j < vec.length(); ++j) {
                ret.putScalar(count++, vec.getDouble(j));
            }
        }
        return ret;
    }

    @Override
    public void sliceVectors(List<INDArray> list) {
        if (this.isVector()) {
            list.add(this);
        } else {
            for (int i = 0; i < this.slices(); ++i) {
                this.slice(i).sliceVectors(list);
            }
        }
    }

    @Override
    public INDArray reshape(int newRows, int newColumns) {
        assert (newRows * newColumns == this.length) : "Illegal new shape " + newRows + " x " + newColumns;
        return this.reshape(new int[]{newRows, newColumns});
    }

    @Override
    public INDArray getColumn(int c) {
        if (this.shape.length == 2) {
            if (this.ordering == 'c') {
                INDArray ret = Nd4j.create(this.data, new int[]{this.shape[0], 1}, new int[]{this.stride[0], 1}, this.offset + c, this.ordering);
                return ret;
            }
            INDArray ret = Nd4j.create(this.data, new int[]{this.shape[0], 1}, new int[]{this.stride[0], 1}, this.offset + c * this.rows(), this.ordering);
            return ret;
        }
        if (this.isColumnVector() && c == 0) {
            return this;
        }
        throw new IllegalArgumentException("Unable to getFloat scalar column of non 2d matrix");
    }

    @Override
    public INDArray getRows(int[] rindices) {
        INDArray rows = Nd4j.create(rindices.length, this.columns());
        for (int i = 0; i < rindices.length; ++i) {
            rows.putRow(i, this.getRow(rindices[i]));
        }
        return rows;
    }

    @Override
    public INDArray get(NDArrayIndex ... indexes) {
        indexes = Indices.adjustIndices(this.shape(), indexes);
        int[] offsets = Indices.offsets(indexes);
        int[] shape = Indices.shape(this.shape(), indexes);
        if (!Indices.isContiguous(indexes)) {
            INDArray ret = Nd4j.create(shape);
            if (ret.isVector() && this.isVector()) {
                int[] indices = indexes[0].indices();
                for (int i = 0; i < ret.length(); ++i) {
                    ret.putScalar(i, this.getDouble(indices[i]));
                }
                return ret;
            }
            if (!ret.isVector()) {
                for (int i = 0; i < ret.slices(); ++i) {
                    INDArray putSlice = this.slice(i).get(Arrays.copyOfRange(indexes, 1, indexes.length));
                    ret.putSlice(i, putSlice);
                }
            } else {
                INDArray putSlice = this.slice(0).get(Arrays.copyOfRange(indexes, 1, indexes.length));
                ret.putSlice(0, putSlice);
            }
            return ret;
        }
        if (ArrayUtil.prod(shape) > this.length()) {
            return this;
        }
        int[] strides = null;
        strides = ArrayUtil.copy(this.stride());
        if (offsets.length != shape.length) {
            offsets = Arrays.copyOfRange(offsets, 0, shape.length);
        }
        if (strides.length != shape.length) {
            strides = Arrays.copyOfRange(strides, 0, shape.length);
        }
        return this.subArray(offsets, shape, strides);
    }

    @Override
    public INDArray getColumns(int[] cindices) {
        INDArray rows = Nd4j.create(this.rows(), cindices.length);
        for (int i = 0; i < cindices.length; ++i) {
            rows.putColumn(i, this.getColumn(cindices[i]));
        }
        return rows;
    }

    @Override
    public INDArray getRow(int r) {
        if (this.shape.length == 2) {
            if (this.ordering == 'c') {
                INDArray ret = Nd4j.create(this.data, new int[]{this.shape[1]}, new int[]{this.stride[1]}, this.offset + r * this.columns(), this.ordering);
                return ret;
            }
            INDArray ret = Nd4j.create(this.data, new int[]{this.shape[1]}, new int[]{this.stride[1]}, this.offset + r, this.ordering);
            return ret;
        }
        if (this.isRowVector() && r == 0) {
            return this;
        }
        throw new IllegalArgumentException("Unable to getFloat row of non 2d matrix");
    }

    public boolean equals(Object o) {
        INDArray n = null;
        if (!(o instanceof INDArray)) {
            return false;
        }
        if (n == null) {
            n = (INDArray)o;
        }
        if (this.isScalar() && n.isScalar()) {
            double val2;
            if (this.data.dataType() == 1) {
                double val22;
                double val = this.getDouble(0);
                return Math.abs(val - (val22 = n.getDouble(0))) < 1.0E-6;
            }
            double val = this.getDouble(0);
            return Math.abs(val - (val2 = n.getDouble(0))) < 1.0E-6;
        }
        if (this.isVector() && n.isVector()) {
            for (int i = 0; i < this.length; ++i) {
                double comp;
                double curr;
                if (!(this.data.dataType() == 1 ? Math.abs((curr = this.getDouble(i)) - (comp = n.getDouble(i))) > 0.001 : Math.abs((curr = this.getDouble(i)) - (comp = n.getDouble(i))) > 0.001)) continue;
                return false;
            }
            return true;
        }
        if (!Shape.shapeEquals(this.shape(), n.shape())) {
            return false;
        }
        if (this.slices() != n.slices()) {
            return false;
        }
        for (int i = 0; i < this.slices(); ++i) {
            INDArray nSlice;
            INDArray slice = this.slice(i);
            if (slice.equals(nSlice = n.slice(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] shape() {
        return this.shape;
    }

    @Override
    public int[] stride() {
        return this.stride;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public char ordering() {
        return this.ordering;
    }

    @Override
    public int size(int dimension) {
        if (this.isScalar()) {
            if (dimension == 0) {
                return this.length;
            }
            throw new IllegalArgumentException("Illegal dimension for scalar " + dimension);
        }
        if (this.isVector()) {
            if (dimension == 0) {
                return this.length;
            }
            if (dimension == 1) {
                return 1;
            }
        }
        return this.shape[dimension];
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public INDArray broadcast(int[] shape) {
        if (Shape.shapeEquals(shape, this.shape())) {
            return this;
        }
        boolean compatible = true;
        int count = shape.length - 1;
        int thisCount = this.shape.length - 1;
        for (int i = shape.length - 1; i > 0 && count >= 0 && thisCount >= 0; --count, --thisCount, --i) {
            if (shape[count] == this.shape()[thisCount] || shape[count] == 1 || this.shape()[thisCount] == 1) continue;
            compatible = false;
            break;
        }
        if (!compatible) {
            throw new IllegalArgumentException("Incompatible broadcast from " + Arrays.toString(this.shape()) + " to " + Arrays.toString(shape));
        }
        if (this.isScalar()) {
            INDArray ret = Nd4j.valueArrayOf(shape, this.getDouble(0));
            return ret;
        }
        if (this.isColumnVector() && Shape.isMatrix(shape)) {
            INDArray ret = Nd4j.create(shape);
            for (int i = 0; i < ret.columns(); ++i) {
                ret.putColumn(i, this.dup());
            }
            return ret;
        }
        int[] retShape = new int[shape.length];
        for (int i = 0; i < retShape.length; ++i) {
            retShape[i] = i < this.shape().length ? Math.max(shape[i], this.shape()[i]) : shape[i];
        }
        INDArray ret = Nd4j.create(retShape);
        INDArray linear = ret.linearView();
        INDArray thisLinear = this.linearView();
        int bufferIdx = 0;
        for (int i = 0; i < ret.length(); ++i) {
            linear.putScalar(i, thisLinear.getDouble(bufferIdx));
            if (++bufferIdx < this.length()) continue;
            bufferIdx = 0;
        }
        return ret;
    }

    @Override
    public INDArray dimShuffle(Object[] rearrange, int[] newOrder, boolean[] broadCastable) {
        int i;
        assert (broadCastable.length == this.shape.length) : "The broadcastable dimensions must be the same length as the current shape";
        boolean broadcast = false;
        HashSet<Object> set = new HashSet<Object>();
        for (int i2 = 0; i2 < rearrange.length; ++i2) {
            set.add(rearrange[i2]);
            if (rearrange[i2] instanceof Integer) {
                Integer j = (Integer)rearrange[i2];
                if (j < broadCastable.length) continue;
                throw new IllegalArgumentException("Illegal dimension, dimension must be < broadcastable.length (aka the real dimensions");
            }
            if (rearrange[i2] instanceof Character) {
                Character c = (Character)rearrange[i2];
                if (c.charValue() != 'x') {
                    throw new IllegalArgumentException("Illegal input: Must be x");
                }
                broadcast = true;
                continue;
            }
            throw new IllegalArgumentException("Only characters and integers allowed");
        }
        if (!broadcast) {
            int[] ret = new int[rearrange.length];
            for (int i3 = 0; i3 < ret.length; ++i3) {
                ret[i3] = (Integer)rearrange[i3];
            }
            return this.permute(ret);
        }
        ArrayList<Integer> drop = new ArrayList<Integer>();
        for (int i4 = 0; i4 < broadCastable.length; ++i4) {
            if (set.contains(i4)) continue;
            if (broadCastable[i4]) {
                drop.add(i4);
                continue;
            }
            throw new IllegalArgumentException("We can't drop the given dimension because its not broadcastable");
        }
        int[] shuffle = new int[broadCastable.length];
        int count = 0;
        for (int i5 = 0; i5 < rearrange.length; ++i5) {
            if (!(rearrange[i5] instanceof Integer)) continue;
            shuffle[count++] = (Integer)rearrange[i5];
        }
        ArrayList<Integer> augment = new ArrayList<Integer>();
        for (int i6 = 0; i6 < rearrange.length; ++i6) {
            if (!(rearrange[i6] instanceof Character)) continue;
            augment.add(i6);
        }
        Integer[] augmentDims = augment.toArray(new Integer[1]);
        count = 0;
        int[] newShape = new int[shuffle.length + drop.size()];
        for (int i7 = 0; i7 < newShape.length; ++i7) {
            newShape[count++] = i7 < shuffle.length ? shuffle[i7] : (Integer)drop.get(i7);
        }
        INDArray ret = this.permute(newShape);
        ArrayList<Integer> newDims = new ArrayList<Integer>();
        int[] shape = Arrays.copyOfRange(ret.shape(), 0, shuffle.length);
        for (i = 0; i < shape.length; ++i) {
            newDims.add(shape[i]);
        }
        for (i = 0; i < augmentDims.length; ++i) {
            newDims.add(augmentDims[i], 1);
        }
        int[] toReshape = ArrayUtil.toArray(newDims);
        ret = ret.reshape(toReshape);
        return ret;
    }

    @Override
    public INDArray permute(int[] rearrange) {
        if (rearrange.length != this.shape.length) {
            return this.dup();
        }
        this.checkArrangeArray(rearrange);
        int[] newShape = this.doPermuteSwap(this.shape, rearrange);
        int[] newStride = this.doPermuteSwap(this.stride, rearrange);
        return Nd4j.create(this.data, newShape, newStride, this.offset, this.ordering == 'c' ? (char)'f' : 'c');
    }

    protected void copyRealTo(INDArray arr) {
        INDArray flattened = this.linearView();
        INDArray arrLinear = arr.linearView();
        for (int i = 0; i < flattened.length(); ++i) {
            arrLinear.putScalar(i, flattened.getDouble(i));
        }
    }

    protected int[] doPermuteSwap(int[] shape, int[] rearrange) {
        int[] ret = new int[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            ret[i] = shape[rearrange[i]];
        }
        return ret;
    }

    protected void checkArrangeArray(int[] arr) {
        int i;
        assert (arr.length == this.shape.length) : "Invalid rearrangement: number of arrangement != shape";
        for (i = 0; i < arr.length; ++i) {
            if (arr[i] >= arr.length) {
                throw new IllegalArgumentException("The specified dimensions can't be swapped. Given element " + i + " was >= number of dimensions");
            }
            if (arr[i] >= 0) continue;
            throw new IllegalArgumentException("Invalid dimension: " + i + " : negative value");
        }
        for (i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr.length; ++j) {
                if (i == j || arr[i] != arr[j]) continue;
                throw new IllegalArgumentException("Permute array must have unique elements");
            }
        }
    }

    @Override
    public boolean isVector() {
        return this.shape.length == 1 || this.shape.length == 1 && this.shape[0] == 1 || this.shape.length == 2 && (this.shape[0] == 1 || this.shape[1] == 1) && !this.isScalar();
    }

    @Override
    public boolean isSquare() {
        return this.isMatrix() && this.rows() == this.columns();
    }

    @Override
    public boolean isRowVector() {
        if (this.shape().length == 1) {
            return true;
        }
        if (this.isVector()) {
            return this.shape()[0] == 1;
        }
        return false;
    }

    @Override
    public boolean isColumnVector() {
        if (this.shape().length == 1) {
            return false;
        }
        if (this.isVector()) {
            return this.shape()[1] == 1;
        }
        return false;
    }

    public String toString() {
        if (this.isScalar()) {
            return this.element().toString();
        }
        if (this.isVector()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            int numElementsToPrint = Nd4j.MAX_ELEMENTS_PER_SLICE < 0 ? this.length : Nd4j.MAX_ELEMENTS_PER_SLICE;
            for (int i = 0; i < this.length; ++i) {
                int numElementsLeft;
                sb.append(this.getDouble(i));
                if (i < this.length - 1) {
                    sb.append(" ,");
                }
                if (i < numElementsToPrint || (numElementsLeft = this.length - i) <= numElementsToPrint) continue;
                i += numElementsLeft - numElementsToPrint - 1;
                sb.append(" ,... ,");
            }
            sb.append("]\n");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        int length = this.shape[0];
        sb.append("[");
        if (length > 0) {
            int slices;
            sb.append(this.slice(0).toString());
            int n = slices = Nd4j.MAX_SLICES_TO_PRINT > 0 ? Nd4j.MAX_SLICES_TO_PRINT : this.slices();
            if (slices > this.slices()) {
                slices = this.slices();
            }
            for (int i = 1; i < slices; ++i) {
                sb.append(this.slice(i).toString());
                if (i >= length - 1) continue;
                sb.append(" ,");
            }
        }
        sb.append("]\n");
        return sb.toString();
    }

    @Override
    public Object element() {
        if (!this.isScalar()) {
            throw new IllegalStateException("Unable to retrieve element from non scalar matrix");
        }
        if (this.data.dataType() == 1) {
            return Float.valueOf(this.data.getFloat(this.offset));
        }
        return this.data.getDouble(this.offset);
    }

    @Override
    public IComplexNDArray rdiv(IComplexNumber n) {
        return this.dup().rdivi(n);
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n) {
        return this.rdivi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray rsub(IComplexNumber n) {
        return this.dup().rsubi(n);
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n) {
        return this.rsubi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray div(IComplexNumber n) {
        return this.dup().divi(n);
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n) {
        return this.divi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray mul(IComplexNumber n) {
        return this.dup().muli(n);
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n) {
        return this.muli(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray sub(IComplexNumber n) {
        return this.dup().subi(n);
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n) {
        return this.subi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray add(IComplexNumber n) {
        return this.dup().addi(n);
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n) {
        return this.addi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray rdiv(IComplexNumber n, IComplexNDArray result) {
        return this.dup().rdivi(n, result);
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).rdivi(n, result);
    }

    @Override
    public IComplexNDArray rsub(IComplexNumber n, IComplexNDArray result) {
        return this.dup().rsubi(n, result);
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).rsubi(n, result);
    }

    @Override
    public IComplexNDArray div(IComplexNumber n, IComplexNDArray result) {
        return this.dup().divi(n, result);
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).divi(n, result);
    }

    @Override
    public IComplexNDArray mul(IComplexNumber n, IComplexNDArray result) {
        return this.dup().muli(n, result);
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).muli(n, result);
    }

    @Override
    public IComplexNDArray sub(IComplexNumber n, IComplexNDArray result) {
        return this.dup().subi(n, result);
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).subi(n, result);
    }

    @Override
    public IComplexNDArray add(IComplexNumber n, IComplexNDArray result) {
        return this.dup().addi(n, result);
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).addi(n, result);
    }
}

