/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.ops.reduceops.scalarops;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.ops.reduceops.scalarops.BaseScalarOp;
import org.nd4j.linalg.ops.reduceops.scalarops.Mean;

public class Variance
extends BaseScalarOp {
    public Variance() {
        super(1.0);
    }

    public double var(INDArray arr) {
        double mean = new Mean().apply(arr);
        double accum = 0.0;
        double dev = 0.0;
        double accum2 = 0.0;
        for (int i = 0; i < arr.length(); ++i) {
            dev = arr.getDouble(i) - mean;
            accum += dev * dev;
            accum2 += dev;
        }
        double len = arr.length();
        return (accum - accum2 * accum2 / len) / (len - 1.0);
    }

    @Override
    public Double apply(INDArray input) {
        return this.var(input);
    }

    @Override
    public double accumulate(INDArray arr, int i, double soFar) {
        return 0.0;
    }
}

