/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import com.google.common.base.Function;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.conditions.Condition;

public class BooleanIndexing {
    public static boolean and(IComplexNDArray n, Condition cond) {
        boolean ret = true;
        IComplexNDArray linear = n.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            ret = ret && cond.apply(linear.getComplex(i)) != false;
        }
        return ret;
    }

    public static boolean or(IComplexNDArray n, Condition cond) {
        boolean ret = true;
        IComplexNDArray linear = n.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            ret = ret || cond.apply(linear.getComplex(i)) != false;
        }
        return ret;
    }

    public static boolean and(INDArray n, Condition cond) {
        boolean ret = true;
        INDArray linear = n.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            ret = ret && cond.apply(Float.valueOf(linear.getFloat(i))) != false;
        }
        return ret;
    }

    public static boolean or(INDArray n, Condition cond) {
        boolean ret = true;
        INDArray linear = n.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            ret = ret || cond.apply(Float.valueOf(linear.getFloat(i))) != false;
        }
        return ret;
    }

    public static void applyWhere(INDArray to, Condition condition, Function<Number, Number> function) {
        INDArray linear = to.linearView();
        for (int i = 0; i < linear.linearView().length(); ++i) {
            if (linear.data().dataType().equals("float")) {
                if (!condition.apply(Float.valueOf(linear.getFloat(i))).booleanValue()) continue;
                linear.putScalar(i, ((Number)function.apply((Object)Float.valueOf(linear.getFloat(i)))).floatValue());
                continue;
            }
            if (!condition.apply(linear.getDouble(i)).booleanValue()) continue;
            linear.putScalar(i, ((Number)function.apply((Object)linear.getDouble(i))).doubleValue());
        }
    }

    public static void applyWhere(IComplexNDArray to, Condition condition, Function<IComplexNumber, IComplexNumber> function) {
        IComplexNDArray linear = to.linearView();
        for (int i = 0; i < linear.linearView().length(); ++i) {
            if (!condition.apply(Float.valueOf(linear.getFloat(i))).booleanValue()) continue;
            linear.putScalar(i, (IComplexNumber)function.apply((Object)linear.getComplex(i)));
        }
    }
}

