/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import com.google.common.primitives.Ints;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Random;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class ArrayUtil {
    public static int[] randomPermutation(int size) {
        int j;
        Random r = new Random();
        int[] result = new int[size];
        for (j = 0; j < size; ++j) {
            result[j] = j + 1;
        }
        for (j = size - 1; j > 0; --j) {
            int k = r.nextInt(j);
            int temp = result[j];
            result[j] = result[k];
            result[k] = temp;
        }
        return result;
    }

    public static INDArray toNDArray(int[][] nums) {
        double[] doubles = ArrayUtil.toDoubles(nums);
        INDArray create = Nd4j.create(doubles, new int[]{1, nums.length});
        return create;
    }

    public static INDArray toNDArray(int[] nums) {
        double[] doubles = ArrayUtil.toDoubles(nums);
        INDArray create = Nd4j.create(doubles, new int[]{1, nums.length});
        return create;
    }

    public static int[] toInts(INDArray n) {
        if (n instanceof IComplexNDArray) {
            throw new IllegalArgumentException("Unable to convert complex array");
        }
        n = n.reshape(new int[]{1, n.length()});
        int[] ret = new int[n.length()];
        for (int i = 0; i < n.length(); ++i) {
            ret[i] = (int)n.get(i);
        }
        return ret;
    }

    public static int prod(int[] mult) {
        int ret = 1;
        for (int i = 0; i < mult.length; ++i) {
            ret *= mult[i];
        }
        return ret;
    }

    public static boolean equals(float[] data, double[] data2) {
        if (data.length != data2.length) {
            return false;
        }
        for (int i = 0; i < data.length; ++i) {
            double equals = Math.abs(data2[i] - (double)data[i]);
            if (!(equals > 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    public static int[] consArray(int a, int[] as) {
        int len = as.length;
        int[] nas = new int[len + 1];
        nas[0] = a;
        System.arraycopy(as, 0, nas, 1, len);
        return nas;
    }

    public static boolean isZero(int[] as) {
        for (int i = 0; i < as.length; ++i) {
            if (as[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean anyMore(int[] target, int[] test) {
        assert (target.length == test.length) : "Unable to compare: different sizes";
        for (int i = 0; i < target.length; ++i) {
            if (target[i] <= test[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean anyLess(int[] target, int[] test) {
        assert (target.length == test.length) : "Unable to compare: different sizes";
        for (int i = 0; i < target.length; ++i) {
            if (target[i] >= test[i]) continue;
            return true;
        }
        return false;
    }

    public static int dotProduct(int[] xs, int[] ys) {
        int result = 0;
        int n = xs.length;
        if (ys.length != n) {
            throw new IllegalArgumentException("Different array sizes");
        }
        for (int i = 0; i < n; ++i) {
            result += xs[i] * ys[i];
        }
        return result;
    }

    public static int[] empty() {
        return new int[0];
    }

    public static int[] of(int ... arr) {
        return arr;
    }

    public static int[] copy(int[] copy) {
        int[] ret = new int[copy.length];
        System.arraycopy(copy, 0, ret, 0, ret.length);
        return ret;
    }

    public static double[] doubleCopyOf(float[] data) {
        double[] ret = new double[data.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = data[i];
        }
        return ret;
    }

    public static float[] floatCopyOf(double[] data) {
        if (data.length == 0) {
            return new float[1];
        }
        float[] ret = new float[data.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (float)data[i];
        }
        return ret;
    }

    public static double[] range(double[] data, int to) {
        return ArrayUtil.range(data, to, 1);
    }

    public static double[] range(double[] data, int to, int stride) {
        return ArrayUtil.range(data, to, stride, 1);
    }

    public static double[] range(double[] data, int to, int stride, int numElementsEachStride) {
        double[] ret = new double[to];
        int count = 0;
        for (int i = 0; i < data.length; i += stride) {
            for (int j = 0; j < numElementsEachStride && i + j < data.length && count < ret.length; ++j) {
                ret[count++] = data[i + j];
            }
        }
        return ret;
    }

    public static int[] toArray(List<Integer> list) {
        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static double[] toArrayDouble(List<Double> list) {
        double[] ret = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static int[] range(int from, int to, int increment) {
        int[] ret;
        block3: {
            block2: {
                int diff = Math.abs(from - to);
                ret = new int[diff];
                if (from >= to) break block2;
                int count = 0;
                for (int i = from; i < to; i += increment) {
                    ret[count++] = i;
                }
                break block3;
            }
            if (from <= to) break block3;
            int count = 0;
            for (int i = from; i > to; i -= increment) {
                ret[count++] = i;
            }
        }
        return ret;
    }

    public static int[] range(int from, int to) {
        return ArrayUtil.range(from, to, 1);
    }

    public static double[] toDoubles(int[] ints) {
        double[] ret = new double[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = ints[i];
        }
        return ret;
    }

    public static double[] toDoubles(int[][] ints) {
        return ArrayUtil.toDoubles(Ints.concat((int[][])ints));
    }

    public static float[] toFloats(int[] ints) {
        float[] ret = new float[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = ints[i];
        }
        return ret;
    }

    public static int[] replace(int[] data, int index, int newValue) {
        int[] copy = ArrayUtil.copy(data);
        copy[index] = newValue;
        return copy;
    }

    public static int[] removeIndex(int[] data, int index) {
        if (index >= data.length) {
            throw new IllegalArgumentException("Unable to remove index " + index + " was >= data.length");
        }
        if (data == null) {
            return null;
        }
        if (data.length < 1) {
            return data;
        }
        if (index < 0) {
            return data;
        }
        int len = data.length;
        int[] result = new int[len - 1];
        System.arraycopy(data, 0, result, 0, index);
        System.arraycopy(data, index + 1, result, index, len - index - 1);
        return result;
    }

    public static Integer[] removeIndex(Integer[] data, int index) {
        if (data == null) {
            return null;
        }
        if (data.length < 1) {
            return data;
        }
        int len = data.length;
        Integer[] result = new Integer[len - 1];
        System.arraycopy(data, 0, result, 0, index);
        System.arraycopy(data, index + 1, result, index, len - index - 1);
        return result;
    }

    public static int[] calcStridesFortran(int[] shape, int startNum) {
        int dimensions = shape.length;
        int[] stride = new int[dimensions];
        int st = startNum;
        for (int j = 0; j < stride.length; ++j) {
            stride[j] = st;
            st *= shape[j];
        }
        return stride;
    }

    public static int[] calcStridesFortran(int[] shape) {
        return ArrayUtil.calcStridesFortran(shape, 1);
    }

    public static int[] calcStrides(int[] shape, int startValue) {
        int dimensions = shape.length;
        int[] stride = new int[dimensions];
        int st = startValue;
        for (int j = dimensions - 1; j >= 0; --j) {
            stride[j] = st;
            st *= shape[j];
        }
        return stride;
    }

    public static int[] plus(int[] ints, int mult) {
        int[] ret = new int[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = ints[i] + mult;
        }
        return ret;
    }

    public static int[] times(int[] ints, int mult) {
        int[] ret = new int[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = ints[i] * mult;
        }
        return ret;
    }

    public static int[] times(int[] ints, int[] mult) {
        assert (ints.length == mult.length) : "Ints and mult must be the same length";
        int[] ret = new int[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            ret[i] = ints[i] * mult[i];
        }
        return ret;
    }

    public static int nonOneStride(int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == 1) continue;
            return arr[i];
        }
        return 1;
    }

    public static int[] calcStrides(int[] shape) {
        return ArrayUtil.calcStrides(shape, 1);
    }

    public static int[] reverseCopy(int[] e) {
        if (e.length < 1) {
            return e;
        }
        int[] copy = new int[e.length];
        for (int i = 0; i <= e.length / 2; ++i) {
            int temp = e[i];
            copy[i] = e[e.length - i - 1];
            copy[e.length - i - 1] = temp;
        }
        return copy;
    }

    public static double[] read(int length, DataInputStream dis) throws IOException {
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = dis.readDouble();
        }
        return ret;
    }

    public static void write(double[] data, DataOutputStream dos) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            dos.writeDouble(data[i]);
        }
    }

    public static float[] readFloat(int length, DataInputStream dis) throws IOException {
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = dis.readFloat();
        }
        return ret;
    }

    public static void write(float[] data, DataOutputStream dos) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            dos.writeFloat(data[i]);
        }
    }

    public static void assertSquare(double[] ... d) {
        if (d.length > 2) {
            for (int i = 0; i < d.length; ++i) {
                ArrayUtil.assertSquare(new double[][]{d[i]});
            }
        } else {
            int firstLength = d[0].length;
            for (int i = 1; i < d.length; ++i) {
                assert (d[i].length == firstLength);
            }
        }
    }

    public static void reverse(int[] e) {
        for (int i = 0; i <= e.length / 2; ++i) {
            int temp = e[i];
            e[i] = e[e.length - i - 1];
            e[e.length - i - 1] = temp;
        }
    }

    public static float[] reverseCopy(float[] e) {
        float[] copy = new float[e.length];
        for (int i = 0; i <= e.length / 2; ++i) {
            float temp = e[i];
            copy[i] = e[e.length - i - 1];
            copy[e.length - i - 1] = temp;
        }
        return copy;
    }

    public static <E> E[] reverseCopy(E[] e) {
        Object[] copy = new Object[e.length];
        for (int i = 0; i <= e.length / 2; ++i) {
            E temp = e[i];
            copy[i] = e[e.length - i - 1];
            copy[e.length - i - 1] = temp;
        }
        return copy;
    }

    public static <E> void reverse(E[] e) {
        for (int i = 0; i <= e.length / 2; ++i) {
            E temp = e[i];
            e[i] = e[e.length - i - 1];
            e[e.length - i - 1] = temp;
        }
    }

    public static int[] flatten(int[][] arr) {
        int[] ret = new int[arr.length * arr[0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                ret[count++] = arr[i][j];
            }
        }
        return ret;
    }

    public static double[] flatten(double[][] arr) {
        double[] ret = new double[arr.length * arr[0].length];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                ret[count++] = arr[i][j];
            }
        }
        return ret;
    }

    public static double[][] toDouble(int[][] arr) {
        double[][] ret = new double[arr.length][arr[0].length];
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                ret[i][j] = arr[i][j];
            }
        }
        return ret;
    }

    public static float[] combineFloat(List<float[]> nums) {
        int length = 0;
        for (int i = 0; i < nums.size(); ++i) {
            length += nums.get(i).length;
        }
        float[] ret = new float[length];
        int count = 0;
        for (float[] i : nums) {
            for (int j = 0; j < i.length; ++j) {
                ret[count++] = i[j];
            }
        }
        return ret;
    }

    public static float[] combine(List<float[]> nums) {
        int length = 0;
        for (int i = 0; i < nums.size(); ++i) {
            length += nums.get(i).length;
        }
        float[] ret = new float[length];
        int count = 0;
        for (float[] i : nums) {
            for (int j = 0; j < i.length; ++j) {
                ret[count++] = i[j];
            }
        }
        return ret;
    }

    public static double[] combineDouble(List<double[]> nums) {
        int length = 0;
        for (int i = 0; i < nums.size(); ++i) {
            length += nums.get(i).length;
        }
        double[] ret = new double[length];
        int count = 0;
        for (double[] i : nums) {
            for (int j = 0; j < i.length; ++j) {
                ret[count++] = i[j];
            }
        }
        return ret;
    }

    public static double[] combine(float[] ... ints) {
        int length = 0;
        for (int i = 0; i < ints.length; ++i) {
            length += ints[i].length;
        }
        double[] ret = new double[length];
        int count = 0;
        for (float[] i : ints) {
            for (int j = 0; j < i.length; ++j) {
                ret[count++] = i[j];
            }
        }
        return ret;
    }

    public static int[] combine(int[] ... ints) {
        int length = 0;
        for (int i = 0; i < ints.length; ++i) {
            length += ints[i].length;
        }
        int[] ret = new int[length];
        int count = 0;
        for (int[] i : ints) {
            for (int j = 0; j < i.length; ++j) {
                ret[count++] = i[j];
            }
        }
        return ret;
    }

    public static <E> E[] combine(E[] ... arrs) {
        int length = 0;
        for (int i = 0; i < arrs.length; ++i) {
            length += arrs[i].length;
        }
        Object[] ret = (Object[])Array.newInstance(arrs[0][0].getClass(), length);
        int count = 0;
        for (E[] i : arrs) {
            for (int j = 0; j < i.length; ++j) {
                ret[count++] = i[j];
            }
        }
        return ret;
    }

    public static int[] toOutcomeArray(int outcome, int numOutcomes) {
        int[] nums = new int[numOutcomes];
        nums[outcome] = 1;
        return nums;
    }
}

