/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.complex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.BaseNDArray;
import org.nd4j.linalg.api.ndarray.DimensionSlice;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.SliceOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.Indices;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.ops.reduceops.Ops;
import org.nd4j.linalg.ops.reduceops.complex.ComplexOps;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.ComplexIterationResult;
import org.nd4j.linalg.util.LinAlgExceptions;
import org.nd4j.linalg.util.Shape;

public abstract class BaseComplexNDArray
extends BaseNDArray
implements IComplexNDArray {
    public BaseComplexNDArray() {
    }

    public BaseComplexNDArray(float[] data) {
        super(data);
    }

    public BaseComplexNDArray(float[] data, int[] shape, char ordering) {
        this(data, shape, Nd4j.getComplexStrides(shape, ordering), 0, Character.valueOf(ordering));
    }

    public BaseComplexNDArray(int[] shape, int offset, char ordering) {
        this(new float[ArrayUtil.prod(shape) * 2], shape, Nd4j.getComplexStrides(shape, ordering), offset, Character.valueOf(ordering));
    }

    public BaseComplexNDArray(int[] shape) {
        this(new float[ArrayUtil.prod(shape) * 2], shape, Nd4j.getComplexStrides(shape));
    }

    public BaseComplexNDArray(float[] data, int[] shape, int[] stride, char ordering) {
        this(data, shape, stride, 0, Character.valueOf(ordering));
    }

    public BaseComplexNDArray(int[] shape, char ordering) {
        this(new float[ArrayUtil.prod(shape) * 2], shape, Nd4j.getComplexStrides(shape, ordering), ordering);
    }

    public BaseComplexNDArray(INDArray m, int[] stride, char ordering) {
        this(m.shape(), stride, ordering);
        this.copyFromReal(m);
    }

    public BaseComplexNDArray(INDArray m, char ordering) {
        this(m.shape(), ordering);
        this.copyFromReal(m);
    }

    public BaseComplexNDArray(INDArray m) {
        this(m, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(INDArray m, int[] stride) {
        this(m, stride, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(List<IComplexNDArray> slices, int[] shape, int[] stride) {
        this(slices, shape, stride, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(List<IComplexNDArray> slices, int[] shape, int[] stride, char ordering) {
        this(new float[ArrayUtil.prod(shape) * 2]);
        ArrayList<IComplexNumber> list = new ArrayList<IComplexNumber>();
        for (int i = 0; i < slices.size(); ++i) {
            IComplexNDArray flattened = slices.get(i).ravel();
            for (int j = 0; j < flattened.length(); ++j) {
                list.add(flattened.getComplex(j));
            }
        }
        this.ordering = ordering;
        this.data = new float[ArrayUtil.prod(shape) * 2];
        this.stride = stride;
        this.initShape(shape);
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            this.putScalar(count, (IComplexNumber)list.get(i));
            ++count;
        }
        this.linearView = Nd4j.createComplex(this.data, new int[]{1, this.length}, this.offset());
    }

    public BaseComplexNDArray(List<IComplexNDArray> slices, int[] shape, char ordering) {
        this(slices, shape, ordering == 'c' ? ArrayUtil.calcStrides(shape, 2) : ArrayUtil.calcStridesFortran(shape, 2), ordering);
    }

    public BaseComplexNDArray(float[] data, int[] shape, int[] stride, int offset, Character order) {
        this.data = data;
        this.stride = stride;
        this.offset = offset;
        this.ordering = order.charValue();
        this.initShape(shape);
    }

    protected void copyFromReal(INDArray real) {
        INDArray linear = real.linearView();
        IComplexNDArray thisLinear = this.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            thisLinear.putScalar(i, (IComplexNumber)Nd4j.createComplexNumber(Float.valueOf(linear.get(i)), 0));
        }
    }

    @Override
    protected void copyRealTo(INDArray arr) {
        INDArray linear = arr.linearView();
        IComplexNDArray thisLinear = this.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            arr.putScalar(i, (Number)thisLinear.getReal(i));
        }
    }

    @Override
    public IComplexNDArray linearView() {
        if (this.isVector()) {
            return this;
        }
        if (this.linearView == null) {
            this.linearView = Nd4j.createComplex(this.data, new int[]{1, this.length}, this.offset());
        }
        return (IComplexNDArray)this.linearView;
    }

    public BaseComplexNDArray(List<IComplexNDArray> slices, int[] shape) {
        this(slices, shape, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(IComplexNumber[] newData, int[] shape) {
        super(new float[ArrayUtil.prod(shape) * 2]);
        this.initShape(shape);
        for (int i = 0; i < this.length; ++i) {
            this.put(i, (IComplexNumber)newData[i].asDouble());
        }
    }

    public BaseComplexNDArray(IComplexNumber[] newData, int[] shape, int[] stride) {
        super(new float[ArrayUtil.prod(shape) * 2]);
        this.stride = stride;
        this.initShape(shape);
        for (int i = 0; i < this.length; ++i) {
            this.put(i, (IComplexNumber)newData[i].asDouble());
        }
    }

    public BaseComplexNDArray(IComplexNumber[] newData, int[] shape, char ordering) {
        super(new float[ArrayUtil.prod(shape) * 2]);
        this.ordering = ordering;
        this.initShape(shape);
        for (int i = 0; i < this.length; ++i) {
            this.put(i, newData[i]);
        }
    }

    public BaseComplexNDArray(float[] data, int[] shape, int[] stride) {
        this(data, shape, stride, 0, Nd4j.order());
    }

    public BaseComplexNDArray(float[] data, int[] shape) {
        this(data, shape, 0);
    }

    public BaseComplexNDArray(float[] data, int[] shape, int offset, char ordering) {
        this(data, shape, ordering == 'c' ? ArrayUtil.calcStrides(shape, 2) : ArrayUtil.calcStridesFortran(shape, 2), offset, Character.valueOf(ordering));
    }

    public BaseComplexNDArray(float[] data, int[] shape, int offset) {
        this(data, shape, offset, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(int[] shape, int[] stride, int offset) {
        this(new float[ArrayUtil.prod(shape) * 2], shape, stride, offset);
    }

    public BaseComplexNDArray(int[] shape, int[] stride, int offset, char ordering) {
        this(new float[ArrayUtil.prod(shape) * 2], shape, stride, offset);
        this.ordering = ordering;
    }

    public BaseComplexNDArray(int[] shape, int[] stride, char ordering) {
        this(shape, stride, 0, ordering);
    }

    public BaseComplexNDArray(int[] shape, int[] stride) {
        this(shape, stride, 0);
    }

    public BaseComplexNDArray(int[] shape, int offset) {
        this(shape, offset, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(int newRows, int newColumns) {
        this(new int[]{newRows, newColumns});
    }

    public BaseComplexNDArray(int newRows, int newColumns, char ordering) {
        this(new int[]{newRows, newColumns}, ordering);
    }

    public BaseComplexNDArray(float[] data, int[] shape, int[] stride, int offset) {
        this(data, shape, stride, offset, Nd4j.order());
    }

    @Override
    public IComplexNumber getComplex(int i, IComplexNumber result) {
        IComplexNumber d = this.getComplex(i);
        return result.set(d.realComponent(), d.imaginaryComponent());
    }

    @Override
    public IComplexNumber getComplex(int i, int j, IComplexNumber result) {
        IComplexNumber d = this.getComplex(i, j);
        return result.set(d.realComponent(), d.imaginaryComponent());
    }

    @Override
    public IComplexNDArray putScalar(int j, int i, IComplexNumber conji) {
        int idx = this.index(j, i);
        this.data[idx] = conji.realComponent().floatValue();
        this.data[idx + 1] = conji.imaginaryComponent().floatValue();
        return this;
    }

    @Override
    public IComplexNDArray eps(Number other) {
        return this.dup().epsi(other);
    }

    @Override
    public IComplexNDArray eps(IComplexNumber other) {
        return null;
    }

    @Override
    public IComplexNDArray epsi(IComplexNumber other) {
        IComplexNDArray linear = this.linearView();
        float otherVal = other.realComponent().floatValue();
        for (int i = 0; i < this.linearView().length(); ++i) {
            IComplexNumber n = linear.getComplex(i);
            float real = n.realComponent().floatValue();
            float diff = Math.abs(real - otherVal);
            if (diff <= Nd4j.EPS_THRESHOLD) {
                linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(1.0, 0.0));
                continue;
            }
            linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(0.0, 0.0));
        }
        return this;
    }

    @Override
    public IComplexNDArray epsi(Number other) {
        IComplexNDArray linear = this.linearView();
        float otherVal = other.floatValue();
        for (int i = 0; i < this.linearView().length(); ++i) {
            IComplexNumber n = linear.getComplex(i);
            float real = n.realComponent().floatValue();
            float diff = Math.abs(real - otherVal);
            if (diff <= Nd4j.EPS_THRESHOLD) {
                linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(1.0, 0.0));
                continue;
            }
            linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(0.0, 0.0));
        }
        return this;
    }

    @Override
    public IComplexNDArray eps(INDArray other) {
        return this.dup().epsi(other);
    }

    @Override
    public IComplexNDArray epsi(INDArray other) {
        IComplexNDArray linear = this.linearView();
        if (other instanceof IComplexNDArray) {
            IComplexNDArray otherComplex = (IComplexNDArray)other;
            IComplexNDArray otherComplexLinear = otherComplex.linearView();
            for (int i = 0; i < this.linearView().length(); ++i) {
                float otherAbs;
                IComplexNumber n = linear.getComplex(i);
                IComplexNumber otherComplexNumber = otherComplexLinear.getComplex(i);
                float real = n.absoluteValue().floatValue();
                float diff = Math.abs(real - (otherAbs = otherComplexNumber.absoluteValue().floatValue()));
                if (diff <= Nd4j.EPS_THRESHOLD) {
                    linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(1.0, 0.0));
                    continue;
                }
                linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(0.0, 0.0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray lt(Number other) {
        return Nd4j.createComplex(super.lt(other));
    }

    @Override
    public IComplexNDArray lti(Number other) {
        return Nd4j.createComplex(super.lti(other));
    }

    @Override
    public IComplexNDArray eq(Number other) {
        return Nd4j.createComplex(super.eq(other));
    }

    @Override
    public IComplexNDArray eqi(Number other) {
        return Nd4j.createComplex(super.eqi(other));
    }

    @Override
    public IComplexNDArray gt(Number other) {
        return Nd4j.createComplex(super.gt(other));
    }

    @Override
    public IComplexNDArray gti(Number other) {
        return Nd4j.createComplex(super.gti(other));
    }

    @Override
    public IComplexNDArray lt(INDArray other) {
        return Nd4j.createComplex(super.lt(other));
    }

    @Override
    public IComplexNDArray lti(INDArray other) {
        return Nd4j.createComplex(super.lti(other));
    }

    @Override
    public IComplexNDArray eq(INDArray other) {
        return Nd4j.createComplex(super.eq(other));
    }

    @Override
    public IComplexNDArray eqi(INDArray other) {
        return Nd4j.createComplex(super.eqi(other));
    }

    @Override
    public IComplexNDArray gt(INDArray other) {
        return Nd4j.createComplex(super.gt(other));
    }

    @Override
    public IComplexNDArray gti(INDArray other) {
        return Nd4j.createComplex(super.gti(other));
    }

    @Override
    public IComplexNDArray rdiv(Number n, INDArray result) {
        return this.dup().rdivi(n, result);
    }

    @Override
    public IComplexNDArray rdivi(Number n, INDArray result) {
        return this.rdivi((IComplexNumber)Nd4j.createFloat(n.floatValue(), 0.0f), result);
    }

    @Override
    public IComplexNDArray rsub(Number n, INDArray result) {
        return this.dup().rsubi(n, result);
    }

    @Override
    public IComplexNDArray rsubi(Number n, INDArray result) {
        return this.rsubi((IComplexNumber)Nd4j.createFloat(n.floatValue(), 0.0f), result);
    }

    @Override
    public IComplexNDArray div(Number n, INDArray result) {
        return this.dup().divi(n, result);
    }

    @Override
    public IComplexNDArray divi(Number n, INDArray result) {
        return this.divi((IComplexNumber)Nd4j.createFloat(n.floatValue(), 0.0f), result);
    }

    @Override
    public IComplexNDArray mul(Number n, INDArray result) {
        return this.dup().muli(n, result);
    }

    @Override
    public IComplexNDArray muli(Number n, INDArray result) {
        return this.muli((IComplexNumber)Nd4j.createFloat(n.floatValue(), 0.0f), result);
    }

    @Override
    public IComplexNDArray sub(Number n, INDArray result) {
        return this.dup().subi(n, result);
    }

    @Override
    public IComplexNDArray subi(Number n, INDArray result) {
        return this.subi((IComplexNumber)Nd4j.createFloat(n.floatValue(), 0.0f), result);
    }

    @Override
    public IComplexNDArray add(Number n, INDArray result) {
        return this.dup().addi(n, result);
    }

    @Override
    public IComplexNDArray addi(Number n, INDArray result) {
        return this.addi((IComplexNumber)Nd4j.createFloat(n.floatValue(), 0.0f), result);
    }

    @Override
    public IComplexNDArray dup() {
        IComplexNDArray ret = Nd4j.createComplex(this.shape());
        IComplexNDArray linear = this.linearView();
        IComplexNDArray retLinear = ret.linearView();
        for (int i = 0; i < ret.length(); ++i) {
            retLinear.putScalar(i, linear.getComplex(i));
        }
        return ret;
    }

    @Override
    public float squaredDistance(INDArray other) {
        float sd = 0.0f;
        for (int i = 0; i < this.length; ++i) {
            IComplexNumber diff = (IComplexNumber)this.getScalar(i).sub(other.getScalar(i)).element();
            double d = (Double)diff.absoluteValue();
            sd = (float)((double)sd + d * d);
        }
        return sd;
    }

    @Override
    public float distance2(INDArray other) {
        return (float)Math.sqrt(this.squaredDistance(other));
    }

    @Override
    public float distance1(INDArray other) {
        float d = 0.0f;
        for (int i = 0; i < this.length; ++i) {
            IComplexNumber n = (IComplexNumber)this.getScalar(i).sub(other.getScalar(i)).element();
            d = (float)((double)d + n.absoluteValue().doubleValue());
        }
        return d;
    }

    @Override
    public INDArray put(NDArrayIndex[] indices, INDArray element) {
        return null;
    }

    @Override
    public IComplexNDArray put(int i, int j, Number element) {
        return this.put(i, j, Nd4j.scalar(element));
    }

    @Override
    public IComplexNDArray put(int[] indexes, float value) {
        int ix = this.offset;
        if (indexes.length != this.shape.length) {
            throw new IllegalArgumentException("Unable to applyTransformToDestination values: number of indices must be equal to the shape");
        }
        for (int i = 0; i < this.shape.length; ++i) {
            ix += indexes[i] * this.stride[i];
        }
        this.data[ix] = value;
        return this;
    }

    @Override
    public IComplexNDArray putSlice(int slice, IComplexNDArray put) {
        if (this.isScalar()) {
            assert (put.isScalar()) : "Invalid dimension. Can only insert a scalar in to another scalar";
            this.put(0, put.get(0));
            return this;
        }
        if (this.isVector()) {
            assert (put.isScalar()) : "Invalid dimension on insertion. Can only insert scalars input vectors";
            this.put(slice, put.get(0));
            return this;
        }
        this.assertSlice(put, slice);
        IComplexNDArray view = this.slice(slice);
        if (put.isScalar()) {
            this.put(slice, put.get(0));
        } else if (put.isVector()) {
            for (int i = 0; i < put.length(); ++i) {
                view.putScalar(i, put.getComplex(i));
            }
        } else if (put.shape().length == 2) {
            for (int i = 0; i < put.rows(); ++i) {
                for (int j = 0; j < put.columns(); ++j) {
                    view.put(i, j, Float.valueOf(put.get(i, j)));
                }
            }
        } else {
            assert (put.slices() == view.slices()) : "Slices must be equivalent.";
            for (int i = 0; i < put.slices(); ++i) {
                view.slice(i).putSlice(i, view.slice(i));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray swapAxes(int dimension, int with) {
        int[] shape = ArrayUtil.range(0, this.shape().length);
        shape[dimension] = with;
        shape[with] = dimension;
        return this.permute(shape);
    }

    @Override
    public IComplexNDArray conji() {
        IComplexNDArray reshaped = this.linearView();
        IComplexDouble c = Nd4j.createDouble(0.0, 0.0);
        for (int i = 0; i < this.length; ++i) {
            IComplexNumber conj = reshaped.getComplex(i, c).conj();
            reshaped.putScalar(i, conj);
        }
        return this;
    }

    @Override
    public IComplexNDArray hermitian() {
        IComplexNDArray result = Nd4j.createComplex(this.shape());
        IComplexDouble c = Nd4j.createDouble(0.0, 0.0);
        for (int i = 0; i < this.slices(); ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.putScalar(j, i, this.getComplex(i, j, c).conji());
            }
        }
        return result;
    }

    @Override
    public IComplexNDArray conj() {
        return this.dup().conji();
    }

    @Override
    public INDArray getReal() {
        INDArray result = Nd4j.create(this.shape());
        IComplexNDArray linearView = this.linearView();
        INDArray linearRet = result.linearView();
        for (int i = 0; i < linearView.length(); ++i) {
            linearRet.putScalar(i, (Number)linearView.getReal(i));
        }
        return result;
    }

    @Override
    public double getImag(int i) {
        int linear = this.linearIndex(i);
        return this.data[linear + 1];
    }

    @Override
    public double getReal(int i) {
        int linear = this.linearIndex(i);
        return this.data[linear];
    }

    @Override
    public IComplexNDArray putReal(int rowIndex, int columnIndex, float value) {
        this.data[2 * this.index((int)rowIndex, (int)columnIndex) + this.offset] = value;
        return this;
    }

    @Override
    public int linearIndex(int i) {
        int realStride = this.majorStride();
        int idx = this.offset + i * realStride;
        if (idx >= this.data.length) {
            throw new IllegalArgumentException("Illegal index " + idx + " derived from " + i + " with offset of " + this.offset + " and stride of " + realStride);
        }
        return idx;
    }

    @Override
    public IComplexNDArray putImag(int rowIndex, int columnIndex, float value) {
        this.data[this.index((int)rowIndex, (int)columnIndex) + 1 + this.offset] = value;
        return this;
    }

    @Override
    public IComplexNDArray putReal(int i, float v) {
        int idx = this.linearIndex(i);
        this.data[idx] = v;
        return this;
    }

    @Override
    public IComplexNDArray putImag(int i, float v) {
        int idx = this.linearIndex(i);
        this.data[idx * 2 + 1] = v;
        return this;
    }

    @Override
    public IComplexNumber getComplex(int i) {
        int idx = this.linearIndex(i);
        return Nd4j.createDouble(this.data[idx], this.data[idx + 1]);
    }

    @Override
    public IComplexNumber getComplex(int i, int j) {
        int idx = this.index(i, j);
        return Nd4j.createDouble(this.data[idx], this.data[idx + 1]);
    }

    @Override
    public INDArray real() {
        INDArray ret = Nd4j.create(this.shape);
        this.copyRealTo(ret);
        return ret;
    }

    @Override
    public INDArray imag() {
        INDArray ret = Nd4j.create(this.shape);
        Nd4j.getBlasWrapper().dcopy(this.length, this.data, 1, 2, ret.data(), 0, 1);
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void iterateOverDimension(int dimension, SliceOp op, boolean modify) {
        if (this.isScalar()) {
            if (dimension > 1) {
                throw new IllegalArgumentException("Dimension must be 0 for a scalar");
            }
            DimensionSlice slice = this.vectorForDimensionAndOffset(0, 0);
            op.operate(slice);
            if (!modify || slice.getIndices() == null) return;
            IComplexNDArray result = (IComplexNDArray)slice.getResult();
            for (int i = 0; i < slice.getIndices().length; ++i) {
                this.data[slice.getIndices()[i]] = result.getComplex(i).realComponent().floatValue();
                this.data[slice.getIndices()[i] + 1] = result.getComplex(i).imaginaryComponent().floatValue();
            }
            return;
        } else if (this.isVector()) {
            if (dimension == 0) {
                DimensionSlice slice = this.vectorForDimensionAndOffset(0, 0);
                op.operate(slice);
                if (!modify || slice.getIndices() == null) return;
                IComplexNDArray result = (IComplexNDArray)slice.getResult();
                for (int i = 0; i < slice.getIndices().length; ++i) {
                    this.data[slice.getIndices()[i]] = result.getComplex(i).realComponent().floatValue();
                    this.data[slice.getIndices()[i] + 1] = result.getComplex(i).imaginaryComponent().floatValue();
                }
                return;
            } else {
                if (dimension != 1) throw new IllegalArgumentException("Illegal dimension for vector " + dimension);
                for (int i = 0; i < this.length; ++i) {
                    DimensionSlice slice = this.vectorForDimensionAndOffset(dimension, i);
                    op.operate(slice);
                    if (!modify || slice.getIndices() == null) continue;
                    IComplexNDArray result = (IComplexNDArray)slice.getResult();
                    for (int j = 0; j < slice.getIndices().length; ++j) {
                        this.data[slice.getIndices()[j]] = result.getComplex(j).realComponent().floatValue();
                        this.data[slice.getIndices()[j] + 1] = result.getComplex(j).imaginaryComponent().floatValue();
                    }
                }
            }
            return;
        } else {
            if (dimension >= this.shape.length) {
                throw new IllegalArgumentException("Unable to remove dimension  " + dimension + " was >= shape length");
            }
            int[] shape = ArrayUtil.removeIndex(this.shape, dimension);
            if (dimension == 0) {
                int numTimes = ArrayUtil.prod(shape);
                for (int offset = this.offset; offset < numTimes; offset += 2) {
                    DimensionSlice vector = this.vectorForDimensionAndOffset(dimension, offset);
                    op.operate(vector);
                    if (!modify || vector.getIndices() == null) continue;
                    IComplexNDArray result = (IComplexNDArray)vector.getResult();
                    for (int i = 0; i < vector.getIndices().length; ++i) {
                        this.data[vector.getIndices()[i]] = result.getComplex(i).realComponent().floatValue();
                        this.data[vector.getIndices()[i] + 1] = result.getComplex(i).imaginaryComponent().floatValue();
                    }
                }
                return;
            } else {
                float[] data2 = new float[ArrayUtil.prod(shape)];
                int dataIter = 0;
                int[] sliceIndices = this.endsForSlices();
                int currOffset = 0;
                int offset = this.offset;
                while (dataIter < data2.length && currOffset < sliceIndices.length) {
                    DimensionSlice pair = this.vectorForDimensionAndOffsetPair(dimension, offset, sliceIndices[currOffset]);
                    op.operate(pair);
                    if (modify && pair.getIndices() != null) {
                        IComplexNDArray result = (IComplexNDArray)pair.getResult();
                        for (int i = 0; i < pair.getIndices().length; ++i) {
                            this.data[pair.getIndices()[i]] = result.getComplex(i).realComponent().floatValue();
                            this.data[pair.getIndices()[i] + 1] = result.getComplex(i).imaginaryComponent().floatValue();
                        }
                    }
                    if (!pair.isNextSlice()) continue;
                    if (++currOffset >= sliceIndices.length) return;
                    offset = sliceIndices[currOffset];
                }
            }
        }
    }

    public DimensionSlice vectorForDimensionAndOffsetPair(int dimension, int offset, int currOffsetForSlice) {
        int count = 0;
        IComplexNDArray ret = Nd4j.createComplex(new int[]{this.shape[dimension]});
        boolean newSlice = false;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int j = offset;
        while (count < this.shape[dimension]) {
            IComplexDouble d = Nd4j.createDouble(this.data[j], this.data[j + 1]);
            indices.add(j);
            ret.putScalar(count++, (IComplexNumber)d);
            if (j >= currOffsetForSlice) {
                newSlice = true;
            }
            j += this.stride[dimension];
        }
        return new DimensionSlice(newSlice, ret, ArrayUtil.toArray(indices));
    }

    @Override
    public DimensionSlice vectorForDimensionAndOffset(int dimension, int offset) {
        if (this.isScalar() && dimension == 0 && offset == 0) {
            return new DimensionSlice(false, Nd4j.complexScalar(Float.valueOf(this.get(offset))), new int[]{offset});
        }
        if (this.isVector()) {
            if (dimension == 0) {
                int[] indices = new int[this.length];
                for (int i = 0; i < indices.length; ++i) {
                    indices[i] = i;
                }
                return new DimensionSlice(false, this.dup(), indices);
            }
            if (dimension == 1) {
                return new DimensionSlice(false, Nd4j.complexScalar(Float.valueOf(this.get(offset))), new int[]{offset});
            }
            throw new IllegalArgumentException("Illegal dimension for vector " + dimension);
        }
        int count = 0;
        IComplexNDArray ret = Nd4j.createComplex(new int[]{this.shape[dimension]});
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int j = offset;
        while (count < this.shape[dimension]) {
            IComplexDouble d = Nd4j.createDouble(this.data[j], this.data[j + 1]);
            ret.putScalar(count++, (IComplexNumber)d);
            indices.add(j);
            j += this.stride[dimension];
        }
        return new DimensionSlice(false, ret, ArrayUtil.toArray(indices));
    }

    @Override
    public IComplexNDArray put(int i, IComplexNDArray element) {
        if (element == null) {
            throw new IllegalArgumentException("Unable to insert null element");
        }
        assert (element.isScalar()) : "Unable to insert non scalar element";
        int idx = this.linearIndex(i);
        IComplexNumber n = element.getComplex(0);
        this.data[idx] = n.realComponent().floatValue();
        this.data[idx + 1] = n.imaginaryComponent().floatValue();
        return this;
    }

    private ComplexIterationResult op(int dimension, int offset, Ops.DimensionOp op, int currOffsetForSlice) {
        float[] dim = new float[this.shape[dimension]];
        int count = 0;
        boolean newSlice = false;
        int j = offset;
        while (count < dim.length) {
            float d = this.data[j];
            dim[count++] = d;
            if (j >= currOffsetForSlice) {
                newSlice = true;
            }
            j += this.stride[dimension];
        }
        IComplexNDArray r = Nd4j.createComplex(dim);
        IComplexDouble r2 = this.reduceVector(op, r);
        return new ComplexIterationResult(newSlice, r2);
    }

    private IComplexNumber op(int dimension, int offset, Ops.DimensionOp op) {
        float[] dim = new float[this.shape[dimension]];
        int count = 0;
        int j = offset;
        while (count < dim.length) {
            float d = this.data[j];
            dim[count++] = d;
            j += this.stride[dimension];
        }
        return this.reduceVector(op, Nd4j.createComplex(dim));
    }

    private IComplexDouble reduceVector(Ops.DimensionOp op, IComplexNDArray vector) {
        switch (op) {
            case SUM: {
                return (IComplexDouble)vector.sum(Integer.MAX_VALUE).element();
            }
            case MEAN: {
                return (IComplexDouble)vector.mean(Integer.MAX_VALUE).element();
            }
            case NORM_1: {
                return Nd4j.createDouble((Double)vector.norm1(Integer.MAX_VALUE).element(), 0.0);
            }
            case NORM_2: {
                return Nd4j.createDouble((Double)vector.norm2(Integer.MAX_VALUE).element(), 0.0);
            }
            case NORM_MAX: {
                return Nd4j.createDouble((Double)vector.normmax(Integer.MAX_VALUE).element(), 0.0);
            }
        }
        throw new IllegalArgumentException("Illegal operation");
    }

    @Override
    public IComplexNDArray getScalar(int ... indexes) {
        int ix = this.offset;
        for (int i = 0; i < this.shape.length; ++i) {
            ix += indexes[i] * this.stride[i];
        }
        return Nd4j.scalar(Nd4j.createDouble(this.data[ix], this.data[ix + 1]));
    }

    @Override
    public void checkDimensions(INDArray other) {
    }

    @Override
    public int[] endsForSlices() {
        int[] ret = new int[this.slices()];
        int currOffset = this.offset;
        for (int i = 0; i < this.slices(); ++i) {
            ret[i] = currOffset;
            currOffset += this.stride[0];
        }
        return ret;
    }

    @Override
    public IComplexNDArray reduce(Ops.DimensionOp op, int dimension) {
        if (this.isScalar()) {
            return this;
        }
        if (this.isVector()) {
            return Nd4j.scalar(this.reduceVector(op, this));
        }
        int[] shape = ArrayUtil.removeIndex(this.shape, dimension);
        if (dimension == 0) {
            float[] data2 = new float[ArrayUtil.prod(shape) * 2];
            int dataIter = 0;
            int numTimes = ArrayUtil.prod(shape);
            for (int offset = this.offset; offset < numTimes; ++offset) {
                IComplexNumber reduce = this.op(dimension, offset, op);
                data2[dataIter++] = reduce.realComponent().floatValue();
                data2[dataIter++] = reduce.imaginaryComponent().floatValue();
            }
            return Nd4j.createComplex(data2, shape);
        }
        float[] data2 = new float[ArrayUtil.prod(shape)];
        int dataIter = 0;
        int[] sliceIndices = this.endsForSlices();
        int currOffset = 0;
        int numTimes = ArrayUtil.prod(shape);
        for (int offset = this.offset; offset < numTimes && dataIter < data2.length && currOffset < sliceIndices.length; ++offset) {
            ComplexIterationResult pair = this.op(dimension, offset, op, sliceIndices[currOffset]);
            IComplexNumber reduce = pair.getNumber();
            data2[dataIter++] = reduce.realComponent().floatValue();
            data2[dataIter++] = reduce.imaginaryComponent().floatValue();
            if (!pair.isNextIteration()) continue;
            offset = sliceIndices[currOffset];
            numTimes += sliceIndices[currOffset];
            ++currOffset;
        }
        return Nd4j.createComplex(data2, shape);
    }

    @Override
    public IComplexNDArray putSlice(int slice, INDArray put) {
        if (this.isScalar()) {
            assert (put.isScalar()) : "Invalid dimension. Can only insert a scalar in to another scalar";
            this.put(0, put.getScalar(0));
            return this;
        }
        if (this.isVector()) {
            assert (put.isScalar()) : "Invalid dimension on insertion. Can only insert scalars input vectors";
            this.put(slice, put.getScalar(0));
            return this;
        }
        this.assertSlice(put, slice);
        IComplexNDArray view = this.slice(slice);
        if (put.isScalar()) {
            this.put(slice, put.getScalar(0));
        } else if (put.isVector()) {
            for (int i = 0; i < put.length(); ++i) {
                view.put(i, put.getScalar(i));
            }
        } else if (put.shape().length == 2) {
            for (int i = 0; i < put.rows(); ++i) {
                for (int j = 0; j < put.columns(); ++j) {
                    view.put(i, j, Nd4j.scalar((IComplexNumber)put.getScalar(i, j).element()));
                }
            }
        } else {
            assert (put.slices() == view.slices()) : "Slices must be equivalent.";
            for (int i = 0; i < put.slices(); ++i) {
                view.slice(i).putSlice(i, view.slice(i));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray subArray(int[] offsets, int[] shape, int[] stride) {
        int n = shape.length;
        if (offsets.length != n) {
            throw new IllegalArgumentException("Invalid offset " + Arrays.toString(offsets));
        }
        if (shape.length != n) {
            throw new IllegalArgumentException("Invalid shape " + Arrays.toString(shape));
        }
        if (Arrays.equals(shape, this.shape)) {
            if (ArrayUtil.isZero(offsets)) {
                return this;
            }
            throw new IllegalArgumentException("Invalid subArray offsets");
        }
        return Nd4j.createComplex(this.data, Arrays.copyOf(shape, shape.length), stride, this.offset + ArrayUtil.dotProduct(offsets, stride));
    }

    @Override
    public IComplexNDArray put(int[] indices, INDArray element) {
        if (!element.isScalar()) {
            throw new IllegalArgumentException("Unable to insert anything but a scalar");
        }
        int ix = this.offset;
        if (indices.length != this.shape.length) {
            throw new IllegalArgumentException("Unable to applyTransformToDestination values: number of indices must be equal to the shape");
        }
        for (int i = 0; i < this.shape.length; ++i) {
            ix += indices[i] * this.stride[i];
        }
        if (element instanceof IComplexNDArray) {
            IComplexNumber element2 = (IComplexNumber)element.element();
            this.data[ix] = ((Float)element2.realComponent()).floatValue();
            this.data[ix + 1] = ((Float)element2.imaginaryComponent()).floatValue();
        } else {
            float element2;
            this.data[ix] = element2 = ((Float)element.element()).floatValue();
            this.data[ix + 1] = 0.0f;
        }
        return this;
    }

    @Override
    public IComplexNDArray put(int i, int j, INDArray element) {
        return this.put(new int[]{i, j}, element);
    }

    @Override
    public IComplexNDArray slice(int slice) {
        IComplexNDArray ret;
        int offset = this.offset + slice * this.stride[0];
        if (this.shape.length == 0) {
            throw new IllegalArgumentException("Can't slice a 0-d ComplexNDArray");
        }
        if (this.shape.length == 1) {
            ret = Nd4j.createComplex(this.data, ArrayUtil.empty(), ArrayUtil.empty(), offset, this.ordering);
        } else if (this.shape.length == 2) {
            ret = Nd4j.createComplex(this.data, ArrayUtil.of(this.shape[1]), Arrays.copyOfRange(this.stride, 1, this.stride.length), offset, this.ordering);
        } else {
            if (offset >= this.data.length) {
                throw new IllegalArgumentException("Offset index is > data.length");
            }
            ret = Nd4j.createComplex(this.data, Arrays.copyOfRange(this.shape, 1, this.shape.length), Arrays.copyOfRange(this.stride, 1, this.stride.length), offset, this.ordering);
        }
        ret.toString();
        return ret;
    }

    @Override
    public IComplexNDArray slice(int slice, int dimension) {
        int offset = this.offset + dimension * this.stride[slice];
        if (this.offset == 0) {
            offset *= 2;
        }
        if (this.shape.length == 2) {
            int st = this.stride[1];
            if (st == 1) {
                return Nd4j.createComplex(this.data, new int[]{this.shape[dimension]}, offset, this.ordering);
            }
            return Nd4j.createComplex(this.data, new int[]{this.shape[dimension]}, new int[]{st}, offset);
        }
        if (slice == 0) {
            return this.slice(dimension);
        }
        return Nd4j.createComplex(this.data, ArrayUtil.removeIndex(this.shape, dimension), ArrayUtil.removeIndex(this.stride, dimension), offset, this.ordering);
    }

    @Override
    protected void initShape(int[] shape) {
        this.shape = shape;
        if (this.shape.length == 1) {
            this.rows = 1;
            this.columns = this.shape[0];
        } else if (this.shape().length == 2) {
            if (shape[0] == 1) {
                this.shape = new int[1];
                this.shape[0] = shape[1];
                this.rows = 1;
                this.columns = shape[1];
            } else {
                this.rows = shape[0];
                this.columns = shape[1];
            }
        } else if (this.shape.length == 1) {
            this.columns = this.shape[0];
            this.rows = 1;
        }
        if (this.ordering == '\u0000') {
            this.ordering = Nd4j.order().charValue();
        }
        this.length = ArrayUtil.prod(this.shape);
        if (this.stride == null) {
            this.stride = this.ordering == 'f' ? ArrayUtil.calcStridesFortran(this.shape, 2) : ArrayUtil.calcStrides(this.shape, 2);
        }
        if (this.stride.length != this.shape.length) {
            this.stride = this.ordering == 'f' ? ArrayUtil.calcStridesFortran(this.shape, 2) : ArrayUtil.calcStrides(this.shape, 2);
        }
    }

    @Override
    protected IComplexNDArray newShape(int[] newShape, char ordering) {
        if (Arrays.equals(newShape, this.shape())) {
            return this;
        }
        if (Shape.isVector(newShape) && this.isVector()) {
            if (this.isRowVector() && Shape.isColumnVectorShape(newShape)) {
                return Nd4j.createComplex(this.data, newShape, new int[]{this.stride[0], 1}, this.offset);
            }
            if (this.isColumnVector() && Shape.isRowVectorShape(newShape)) {
                return Nd4j.createComplex(this.data, newShape, new int[]{this.stride[1]}, this.offset);
            }
        }
        INDArray newCopy = this;
        int[] newStrides = null;
        if (this.shape().length > 1 && (ordering == 'c' && this.ordering != 'c' || ordering == 'f' && this.ordering != 'f') && (newStrides = this.noCopyReshape(newShape, ordering)) == null) {
            newCopy = Nd4j.create(this.shape(), ordering);
            for (int i = 0; i < this.vectorsAlongDimension(0); ++i) {
                IComplexNDArray copyFrom = this.vectorAlongDimension(i, 0);
                INDArray copyTo = newCopy.vectorAlongDimension(i, 0);
                for (int j = 0; j < copyFrom.length(); ++j) {
                    copyTo.putScalar(j, (Number)Float.valueOf(copyFrom.get(i)));
                }
            }
        }
        if (newStrides == null) {
            newStrides = Nd4j.getComplexStrides(newShape, ordering);
        }
        return Nd4j.createComplex(newCopy.data(), newShape, newStrides, this.offset);
    }

    @Override
    public IComplexNDArray repmat(int[] shape) {
        int[] newShape = ArrayUtil.copy(this.shape());
        assert (shape.length <= newShape.length) : "Illegal shape: The passed in shape must be <= the current shape length";
        for (int i = 0; i < shape.length; ++i) {
            int n = i;
            newShape[n] = newShape[n] * shape[i];
        }
        IComplexNDArray result = Nd4j.createComplex(newShape);
        if (this.isScalar()) {
            for (int i = 0; i < result.length(); ++i) {
                result.put(i, this.getScalar(0));
            }
        } else if (this.isMatrix()) {
            for (int c = 0; c < this.shape()[1]; ++c) {
                for (int r = 0; r < this.shape()[0]; ++r) {
                    for (int i = 0; i < this.rows(); ++i) {
                        for (int j = 0; j < this.columns(); ++j) {
                            result.put(r * this.rows() + i, c * this.columns() + j, this.getScalar(i, j));
                        }
                    }
                }
            }
        } else {
            int[] sliceRepmat = ArrayUtil.removeIndex(shape, 0);
            for (int i = 0; i < result.slices(); ++i) {
                result.putSlice(i, this.repmat(sliceRepmat));
            }
        }
        return result;
    }

    @Override
    public IComplexNDArray assign(IComplexNDArray arr) {
        if (!arr.isScalar()) {
            LinAlgExceptions.assertSameShape(this, arr);
        }
        System.arraycopy(arr.data(), arr.offset(), this.data(), this.offset(), arr.length());
        IComplexNDArray linear = this.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, arr.getComplex(0));
        }
        return this;
    }

    @Override
    public IComplexNDArray getRows(int[] rindices) {
        INDArray rows = Nd4j.create(rindices.length, this.columns());
        for (int i = 0; i < rindices.length; ++i) {
            rows.putRow(i, this.getRow(rindices[i]));
        }
        return (IComplexNDArray)rows;
    }

    @Override
    public IComplexNDArray put(NDArrayIndex[] indices, IComplexNumber element) {
        return null;
    }

    @Override
    public IComplexNDArray put(NDArrayIndex[] indices, IComplexNDArray element) {
        return null;
    }

    @Override
    public IComplexNDArray put(NDArrayIndex[] indices, Number element) {
        return null;
    }

    @Override
    public IComplexNDArray putScalar(int i, IComplexNumber value) {
        int idx = this.linearIndex(i);
        this.data[idx] = value.realComponent().floatValue();
        this.data[idx + 1] = value.imaginaryComponent().floatValue();
        return this;
    }

    @Override
    public IComplexNDArray vectorAlongDimension(int index, int dimension) {
        assert (dimension <= this.shape.length) : "Invalid dimension " + dimension;
        if (this.ordering == 'c') {
            if (dimension == this.shape.length - 1 && dimension != 0) {
                if (this.size(dimension) == 1) {
                    return Nd4j.createComplex(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index * 2);
                }
                return Nd4j.createComplex(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index * 2 * this.stride[dimension - 1]);
            }
            if (dimension == 0) {
                return Nd4j.createComplex(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index * 2);
            }
            if (this.size(dimension) == 0) {
                return Nd4j.createComplex(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index * 2);
            }
            return Nd4j.createComplex(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index * 2 * this.stride[0]);
        }
        if (this.ordering == 'f') {
            if (dimension == this.shape.length - 1 && dimension != 0) {
                if (this.size(dimension) == 1) {
                    return Nd4j.createComplex(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index * 2);
                }
                return Nd4j.createComplex(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index * 2 * this.stride[0]);
            }
            if (this.size(dimension) == 1) {
                return Nd4j.createComplex(this.data, new int[]{1, this.shape[dimension]}, ArrayUtil.removeIndex(this.stride, 0), this.offset + index * 2);
            }
            return Nd4j.createComplex(this.data, new int[]{this.shape[dimension], 1}, new int[]{this.stride[dimension], 1}, this.offset + index * 2 * this.stride[0]);
        }
        throw new IllegalStateException("Illegal ordering..none declared");
    }

    @Override
    public IComplexNDArray cumsumi(int dimension) {
        if (this.isVector()) {
            IComplexDouble s = Nd4j.createDouble(0.0, 0.0);
            for (int i = 0; i < this.length; ++i) {
                s.addi((IComplexNumber)this.getScalar(i).element());
                this.putScalar(i, (IComplexNumber)s);
            }
        } else {
            if (dimension == Integer.MAX_VALUE || dimension == this.shape.length - 1) {
                IComplexNDArray flattened = this.ravel().dup();
                IComplexNumber prevVal = (IComplexNumber)flattened.getScalar(0).element();
                for (int i = 1; i < flattened.length(); ++i) {
                    IComplexNumber d = prevVal.add((IComplexNumber)flattened.getScalar(i).element());
                    flattened.putScalar(i, d);
                    prevVal = d;
                }
                return flattened;
            }
            for (int i = 0; i < this.vectorsAlongDimension(dimension); ++i) {
                IComplexNDArray vec = this.vectorAlongDimension(i, dimension);
                vec.cumsumi(0);
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray dimShuffle(Object[] rearrange, int[] newOrder, boolean[] broadCastable) {
        int i;
        assert (broadCastable.length == this.shape.length) : "The broadcastable dimensions must be the same length as the current shape";
        boolean broadcast = false;
        HashSet<Object> set = new HashSet<Object>();
        for (int i2 = 0; i2 < rearrange.length; ++i2) {
            set.add(rearrange[i2]);
            if (rearrange[i2] instanceof Integer) {
                Integer j = (Integer)rearrange[i2];
                if (j < broadCastable.length) continue;
                throw new IllegalArgumentException("Illegal dimension, dimension must be < broadcastable.length (aka the real dimensions");
            }
            if (rearrange[i2] instanceof Character) {
                Character c = (Character)rearrange[i2];
                if (c.charValue() != 'x') {
                    throw new IllegalArgumentException("Illegal input: Must be x");
                }
                broadcast = true;
                continue;
            }
            throw new IllegalArgumentException("Only characters and integers allowed");
        }
        if (!broadcast) {
            int[] ret = new int[rearrange.length];
            for (int i3 = 0; i3 < ret.length; ++i3) {
                ret[i3] = (Integer)rearrange[i3];
            }
            return this.permute(ret);
        }
        ArrayList<Integer> drop = new ArrayList<Integer>();
        for (int i4 = 0; i4 < broadCastable.length; ++i4) {
            if (set.contains(i4)) continue;
            if (broadCastable[i4]) {
                drop.add(i4);
                continue;
            }
            throw new IllegalArgumentException("We can't drop the given dimension because its not broadcastable");
        }
        int[] shuffle = new int[broadCastable.length];
        int count = 0;
        for (int i5 = 0; i5 < rearrange.length; ++i5) {
            if (!(rearrange[i5] instanceof Integer)) continue;
            shuffle[count++] = (Integer)rearrange[i5];
        }
        ArrayList<Integer> augment = new ArrayList<Integer>();
        for (int i6 = 0; i6 < rearrange.length; ++i6) {
            if (!(rearrange[i6] instanceof Character)) continue;
            augment.add(i6);
        }
        Integer[] augmentDims = augment.toArray(new Integer[1]);
        count = 0;
        int[] newShape = new int[shuffle.length + drop.size()];
        for (int i7 = 0; i7 < newShape.length; ++i7) {
            newShape[count++] = i7 < shuffle.length ? shuffle[i7] : (Integer)drop.get(i7);
        }
        IComplexNDArray ret = this.permute(newShape);
        ArrayList<Integer> newDims = new ArrayList<Integer>();
        int[] shape = Arrays.copyOfRange(ret.shape(), 0, shuffle.length);
        for (i = 0; i < shape.length; ++i) {
            newDims.add(shape[i]);
        }
        for (i = 0; i < augmentDims.length; ++i) {
            newDims.add(augmentDims[i], 1);
        }
        int[] toReshape = ArrayUtil.toArray(newDims);
        ret = ret.reshape(toReshape);
        return ret;
    }

    @Override
    public IComplexNDArray cumsum(int dimension) {
        return this.dup().cumsumi(dimension);
    }

    @Override
    public INDArray assign(INDArray arr) {
        return this.assign((IComplexNDArray)arr);
    }

    @Override
    public IComplexNDArray putScalar(int i, Number value) {
        return this.put(i, Nd4j.scalar(value));
    }

    @Override
    public INDArray putScalar(int[] i, Number value) {
        super.putScalar(i, value);
        return this.putScalar(i, (IComplexNumber)Nd4j.createComplexNumber(Float.valueOf(value.floatValue()), 0));
    }

    @Override
    public INDArray putScalar(int[] indexes, IComplexNumber complexNumber) {
        int ix = this.offset;
        for (int i = 0; i < this.shape.length; ++i) {
            ix += indexes[i] * this.stride[i];
        }
        this.data[ix] = complexNumber.asFloat().realComponent().floatValue();
        this.data[ix + 1] = complexNumber.asFloat().imaginaryComponent().floatValue();
        return this;
    }

    @Override
    public IComplexNDArray neg() {
        return this.dup().negi();
    }

    @Override
    public IComplexNDArray negi() {
        return Transforms.neg(this);
    }

    @Override
    public IComplexNDArray rdiv(Number n) {
        return this.rdiv(n, (INDArray)this);
    }

    @Override
    public IComplexNDArray rdivi(Number n) {
        return this.rdivi(n, (INDArray)this);
    }

    @Override
    public IComplexNDArray rsub(Number n) {
        return this.rsub(n, (INDArray)this);
    }

    @Override
    public IComplexNDArray rsubi(Number n) {
        return this.rsubi(n, (INDArray)this);
    }

    @Override
    public IComplexNDArray div(Number n) {
        return this.dup().divi(n);
    }

    @Override
    public IComplexNDArray divi(Number n) {
        return this.divi(Nd4j.complexScalar(n));
    }

    @Override
    public IComplexNDArray mul(Number n) {
        return this.dup().muli(n);
    }

    @Override
    public IComplexNDArray muli(Number n) {
        return this.muli(Nd4j.complexScalar(n));
    }

    @Override
    public IComplexNDArray sub(Number n) {
        return this.dup().subi(n);
    }

    @Override
    public IComplexNDArray subi(Number n) {
        return this.subi(Nd4j.complexScalar(n));
    }

    @Override
    public IComplexNDArray add(Number n) {
        return this.dup().addi(n);
    }

    @Override
    public IComplexNDArray addi(Number n) {
        return this.addi(Nd4j.complexScalar(n));
    }

    @Override
    public IComplexNDArray get(NDArrayIndex ... indexes) {
        indexes = Indices.adjustIndices(this.shape(), indexes);
        int[] offsets = Indices.offsets(indexes);
        int[] shape = Indices.shape(this.shape(), indexes);
        int[] strides = this.ordering == 'f' ? ArrayUtil.calcStridesFortran(shape, 2) : ArrayUtil.copy(this.stride());
        return this.subArray(offsets, shape, strides);
    }

    @Override
    public IComplexNDArray getColumns(int[] cindices) {
        IComplexNDArray rows = Nd4j.createComplex(this.rows(), cindices.length);
        for (int i = 0; i < cindices.length; ++i) {
            rows.putColumn(i, this.getColumn(cindices[i]));
        }
        return rows;
    }

    @Override
    public IComplexNDArray putRow(int row, INDArray toPut) {
        assert (toPut.isVector() && toPut.length() == this.columns) : "Illegal length for row " + toPut.length() + " should have been " + this.columns;
        IComplexNDArray r = this.getRow(row);
        if (toPut instanceof IComplexNDArray) {
            IComplexNDArray putComplex = (IComplexNDArray)toPut;
            for (int i = 0; i < r.length(); ++i) {
                r.putScalar(i, putComplex.getComplex(i));
            }
        } else {
            for (int i = 0; i < r.length(); ++i) {
                r.putScalar(i, (IComplexNumber)Nd4j.createDouble(toPut.get(i), 0.0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray putColumn(int column, INDArray toPut) {
        assert (toPut.isVector() && toPut.length() == this.rows) : "Illegal length for row " + toPut.length() + " should have been " + this.columns;
        IComplexNDArray r = this.getColumn(column);
        if (toPut instanceof IComplexNDArray) {
            IComplexNDArray putComplex = (IComplexNDArray)toPut;
            for (int i = 0; i < r.length(); ++i) {
                IComplexNumber n = putComplex.getComplex(i);
                r.putScalar(i, n);
            }
        } else {
            for (int i = 0; i < r.length(); ++i) {
                r.putScalar(i, (IComplexNumber)Nd4j.createDouble(toPut.get(i), 0.0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray getScalar(int row, int column) {
        return this.getScalar(new int[]{row, column});
    }

    @Override
    public IComplexNDArray getScalar(int i) {
        int idx = this.linearIndex(i);
        return Nd4j.scalar(Nd4j.createDouble(this.data[idx], this.data[idx + 1]));
    }

    @Override
    public IComplexNDArray put(int i, INDArray element) {
        if (element == null) {
            throw new IllegalArgumentException("Unable to insert null element");
        }
        assert (element.isScalar()) : "Unable to insert non scalar element";
        if (element instanceof IComplexNDArray) {
            IComplexNDArray n1 = (IComplexNDArray)element;
            IComplexNumber n = n1.getComplex(0);
            this.put(i, n);
        } else {
            this.put(i, element.get(0));
        }
        return this;
    }

    private void put(int i, float element) {
        int idx = this.linearIndex(i);
        this.data[idx] = element;
        this.data[idx + 1] = 0.0f;
    }

    public void put(int i, IComplexNumber element) {
        int idx = this.linearIndex(i);
        this.data[idx] = element.realComponent().floatValue();
        this.data[idx + 1] = element.imaginaryComponent().floatValue();
    }

    @Override
    public IComplexNDArray diviColumnVector(INDArray columnVector) {
        for (int i = 0; i < this.columns(); ++i) {
            this.getColumn(i).divi(columnVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray divColumnVector(INDArray columnVector) {
        return this.dup().diviColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray diviRowVector(INDArray rowVector) {
        for (int i = 0; i < this.rows(); ++i) {
            this.getRow(i).divi(rowVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray divRowVector(INDArray rowVector) {
        return this.dup().diviRowVector(rowVector);
    }

    @Override
    public IComplexNDArray muliColumnVector(INDArray columnVector) {
        for (int i = 0; i < this.columns(); ++i) {
            this.getColumn(i).muli(columnVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray mulColumnVector(INDArray columnVector) {
        return this.dup().muliColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray muliRowVector(INDArray rowVector) {
        for (int i = 0; i < this.rows(); ++i) {
            this.getRow(i).muli(rowVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray mulRowVector(INDArray rowVector) {
        return this.dup().muliRowVector(rowVector);
    }

    @Override
    public IComplexNDArray subiColumnVector(INDArray columnVector) {
        for (int i = 0; i < this.columns(); ++i) {
            this.getColumn(i).subi(columnVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray subColumnVector(INDArray columnVector) {
        return this.dup().subiColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray subiRowVector(INDArray rowVector) {
        for (int i = 0; i < this.rows(); ++i) {
            this.getRow(i).subi(rowVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray subRowVector(INDArray rowVector) {
        return this.dup().subiRowVector(rowVector);
    }

    @Override
    public IComplexNDArray addiColumnVector(INDArray columnVector) {
        for (int i = 0; i < this.columns(); ++i) {
            this.getColumn(i).addi(columnVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray addColumnVector(INDArray columnVector) {
        return this.dup().addiColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray addiRowVector(INDArray rowVector) {
        for (int i = 0; i < this.rows(); ++i) {
            this.getRow(i).addi(rowVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray addRowVector(INDArray rowVector) {
        return this.dup().addiRowVector(rowVector);
    }

    @Override
    public IComplexNDArray mmul(INDArray other) {
        int[] shape = new int[]{this.rows(), other.columns()};
        return this.mmuli(other, Nd4j.createComplex(shape));
    }

    @Override
    public IComplexNDArray mmul(INDArray other, INDArray result) {
        return this.dup().mmuli(other, result);
    }

    @Override
    public IComplexNDArray div(INDArray other) {
        return this.dup().divi(other);
    }

    @Override
    public IComplexNDArray div(INDArray other, INDArray result) {
        return this.dup().divi(other, result);
    }

    @Override
    public IComplexNDArray mul(INDArray other) {
        return this.dup().muli(other);
    }

    @Override
    public IComplexNDArray mul(INDArray other, INDArray result) {
        return this.dup().muli(other, result);
    }

    @Override
    public IComplexNDArray sub(INDArray other) {
        return this.dup().subi(other);
    }

    @Override
    public IComplexNDArray sub(INDArray other, INDArray result) {
        return this.dup().subi(other, result);
    }

    @Override
    public IComplexNDArray add(INDArray other) {
        return this.dup().addi(other);
    }

    @Override
    public IComplexNDArray add(INDArray other, INDArray result) {
        return this.dup().addi(other, result);
    }

    @Override
    public IComplexNDArray mmuli(INDArray other) {
        return this.mmuli(other, this);
    }

    @Override
    public IComplexNDArray mmuli(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.muli(other.getScalar(0), result);
        }
        LinAlgExceptions.assertMultiplies(this, other);
        IComplexNDArray otherArray = Nd4j.createComplex(other);
        IComplexNDArray resultArray = Nd4j.createComplex(result);
        if (result == this || result == other) {
            IComplexNDArray temp = Nd4j.createComplex(resultArray.shape(), ArrayUtil.calcStrides(resultArray.shape()));
            Nd4j.getBlasWrapper().gemm(Nd4j.createFloat(1.0f, 0.0f), this, otherArray, Nd4j.createFloat(0.0f, 0.0f), temp);
            Nd4j.getBlasWrapper().copy(temp, resultArray);
        } else {
            BaseComplexNDArray thisInput = this;
            Nd4j.getBlasWrapper().gemm(Nd4j.createFloat(1.0f, 0.0f), thisInput, otherArray, Nd4j.createFloat(0.0f, 0.0f), resultArray);
        }
        return resultArray;
    }

    @Override
    public IComplexNDArray divi(INDArray other) {
        return this.divi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray divi(INDArray other, INDArray result) {
        IComplexNDArray cOther = (IComplexNDArray)other;
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cOtherLinear = cOther.linearView();
        IComplexNDArray cResultLinear = cResult.linearView();
        if (other.isScalar()) {
            return this.divi(cOther.getComplex(0), result);
        }
        IComplexFloat c = Nd4j.createComplexNumber(0, 0);
        IComplexFloat d = Nd4j.createComplexNumber(0, 0);
        for (int i = 0; i < this.length; ++i) {
            cResultLinear.putScalar(i, linear.getComplex(i, c).divi(cOtherLinear.getComplex(i, d)));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray muli(INDArray other) {
        return this.muli(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray muli(INDArray other, INDArray result) {
        IComplexNDArray cOther = (IComplexNDArray)other;
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cOtherLinear = cOther.linearView();
        IComplexNDArray cResultLinear = cResult.linearView();
        if (other.isScalar()) {
            return this.muli(cOther.getComplex(0), result);
        }
        IComplexFloat c = Nd4j.createComplexNumber(0, 0);
        IComplexFloat d = Nd4j.createComplexNumber(0, 0);
        for (int i = 0; i < this.length; ++i) {
            cResultLinear.putScalar(i, linear.getComplex(i, c).muli(cOtherLinear.getComplex(i, d)));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray subi(INDArray other) {
        return this.subi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray subi(INDArray other, INDArray result) {
        IComplexNDArray cOther = (IComplexNDArray)other;
        IComplexNDArray cResult = (IComplexNDArray)result;
        if (other.isScalar()) {
            return this.subi(cOther.getComplex(0), result);
        }
        if (result == this) {
            Nd4j.getBlasWrapper().axpy(Nd4j.NEG_UNIT, cOther, cResult);
        } else if (result == other) {
            Nd4j.getBlasWrapper().scal(Nd4j.NEG_UNIT, cResult);
            Nd4j.getBlasWrapper().axpy(Nd4j.UNIT, this, cResult);
        } else {
            Nd4j.getBlasWrapper().copy(this, result);
            Nd4j.getBlasWrapper().axpy(Nd4j.NEG_UNIT, cOther, cResult);
        }
        return cResult;
    }

    @Override
    public IComplexNDArray addi(INDArray other) {
        return this.addi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray addi(INDArray other, INDArray result) {
        IComplexNDArray cOther = (IComplexNDArray)other;
        IComplexNDArray cResult = (IComplexNDArray)result;
        if (cOther.isScalar()) {
            return cResult.addi(cOther.getComplex(0), result);
        }
        if (this.isScalar()) {
            return cOther.addi(this.getComplex(0), result);
        }
        if (result == this) {
            Nd4j.getBlasWrapper().axpy(Nd4j.UNIT, cOther, cResult);
        } else if (result == other) {
            Nd4j.getBlasWrapper().axpy(Nd4j.UNIT, this, cResult);
        } else {
            INDArray resultLinear = result.linearView();
            INDArray otherLinear = other.linearView();
            IComplexNDArray linear = this.linearView();
            for (int i = 0; i < resultLinear.length(); ++i) {
                resultLinear.putScalar(i, (Number)Float.valueOf(otherLinear.get(i) + linear.get(i)));
            }
        }
        return (IComplexNDArray)result;
    }

    @Override
    public IComplexNDArray rdiv(IComplexNumber n, INDArray result) {
        return this.dup().rdivi(n, result);
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        for (int i = 0; i < this.length; ++i) {
            cResultLinear.putScalar(i, n.div(this.getComplex(i)));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray rsub(IComplexNumber n, INDArray result) {
        return this.dup().rsubi(n, result);
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        for (int i = 0; i < this.length; ++i) {
            cResultLinear.putScalar(i, n.sub(this.getComplex(i)));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray div(IComplexNumber n, INDArray result) {
        return this.dup().divi(n, result);
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        for (int i = 0; i < this.length; ++i) {
            cResultLinear.putScalar(i, this.getComplex(i).div(n));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray mul(IComplexNumber n, INDArray result) {
        return this.dup().muli(n, result);
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        for (int i = 0; i < this.length; ++i) {
            cResultLinear.putScalar(i, this.getComplex(i).mul(n));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray sub(IComplexNumber n, INDArray result) {
        return this.dup().subi(n, result);
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        IComplexNDArray linear = this.linearView();
        for (int i = 0; i < this.length; ++i) {
            cResultLinear.putScalar(i, linear.getComplex(i).sub(n));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray add(IComplexNumber n, INDArray result) {
        return this.dup().addi(n, result);
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n, INDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = (IComplexNDArray)result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, linear.getComplex(i).add(n));
        }
        return (IComplexNDArray)result;
    }

    @Override
    public IComplexNDArray rdiv(IComplexNumber n) {
        return this.dup().rdivi(n, this);
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n) {
        return this.rdivi(n, this);
    }

    @Override
    public IComplexNDArray rsub(IComplexNumber n) {
        return this.rsub(n, this);
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n) {
        return this.rsubi(n, this);
    }

    @Override
    public IComplexNDArray div(IComplexNumber n) {
        return this.div(n, this);
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n) {
        return this.divi(n, this);
    }

    @Override
    public IComplexNDArray mul(IComplexNumber n) {
        return this.dup().muli(n);
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n) {
        return this.muli(n, this);
    }

    @Override
    public IComplexNDArray sub(IComplexNumber n) {
        return this.dup().subi(n);
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n) {
        return this.subi(n, this);
    }

    @Override
    public IComplexNDArray add(IComplexNumber n) {
        return this.addi(n, this);
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n) {
        return this.addi(n, this);
    }

    @Override
    public IComplexNDArray transpose() {
        if (this.isRowVector()) {
            return Nd4j.createComplex(this.data, new int[]{this.shape[0], 1}, this.offset);
        }
        if (this.isColumnVector()) {
            return Nd4j.createComplex(this.data, new int[]{this.shape[0]}, this.offset);
        }
        if (this.isMatrix()) {
            IComplexNDArray reverse = Nd4j.createComplex(new int[]{this.shape[1], this.shape[0]});
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    reverse.putScalar(j, i, this.getComplex(i, j));
                }
            }
            return reverse;
        }
        IComplexNDArray ret = this.permute(ArrayUtil.range(this.shape.length - 1, -1));
        return ret;
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, linear.getComplex(i).addi(n));
        }
        return result;
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, linear.getComplex(i).subi(n));
        }
        return result;
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            IComplexNumber n3 = linear.getComplex(i);
            IComplexNumber num = n3.mul(n);
            cResult.putScalar(i, linear.getComplex(i).mul(n));
        }
        return result;
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, linear.getComplex(i).div(n));
        }
        return result;
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, n.sub(linear.getComplex(i)));
        }
        return result;
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, n.div(linear.getComplex(i)));
        }
        return result;
    }

    @Override
    public IComplexNDArray reshape(int[] shape) {
        return (IComplexNDArray)super.reshape(shape);
    }

    public boolean multipliesWith(INDArray a) {
        return this.columns() == a.rows();
    }

    @Override
    public float[] data() {
        return this.data;
    }

    @Override
    public IComplexNDArray prod(int dimension) {
        return Nd4j.createComplex(super.prod(dimension));
    }

    @Override
    public IComplexNDArray mean(int dimension) {
        return Nd4j.createComplex(super.mean(dimension));
    }

    @Override
    public IComplexNDArray assign(Number value) {
        IComplexNDArray one = this.linearView();
        for (int i = 0; i < one.length(); ++i) {
            one.putScalar(i, (IComplexNumber)Nd4j.createDouble(value.doubleValue(), 0.0));
        }
        return this;
    }

    @Override
    public IComplexNDArray rdiv(INDArray other) {
        return this.dup().rdivi(other);
    }

    @Override
    public IComplexNDArray rdivi(INDArray other) {
        return this.rdivi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray rdiv(INDArray other, INDArray result) {
        return this.dup().rdivi(other, result);
    }

    @Override
    public IComplexNDArray rdivi(INDArray other, INDArray result) {
        return (IComplexNDArray)other.divi(this, result);
    }

    @Override
    public IComplexNDArray rsub(INDArray other, INDArray result) {
        return this.dup().rsubi(other, result);
    }

    @Override
    public IComplexNDArray rsub(INDArray other) {
        return this.dup().rsubi(other);
    }

    @Override
    public IComplexNDArray rsubi(INDArray other) {
        return this.rsubi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray rsubi(INDArray other, INDArray result) {
        return (IComplexNDArray)other.subi(this, result);
    }

    public IComplexNumber max() {
        IComplexNDArray reshape = this.ravel();
        IComplexNumber max = (IComplexNumber)reshape.getScalar(0).element();
        for (int i = 1; i < reshape.length(); ++i) {
            IComplexNumber curr = (IComplexNumber)reshape.getScalar(i).element();
            double val = curr.realComponent().doubleValue();
            if (!(val > curr.realComponent().doubleValue())) continue;
            max = curr;
        }
        return max;
    }

    public IComplexNumber min() {
        IComplexNDArray reshape = this.ravel();
        IComplexNumber min = (IComplexNumber)reshape.getScalar(0).element();
        for (int i = 1; i < reshape.length(); ++i) {
            IComplexNumber curr = (IComplexNumber)reshape.getScalar(i).element();
            double val = curr.realComponent().doubleValue();
            if (!(val < curr.realComponent().doubleValue())) continue;
            min = curr;
        }
        return min;
    }

    @Override
    public IComplexNDArray max(int dimension) {
        return Nd4j.createComplex(super.max(dimension));
    }

    @Override
    public IComplexNDArray min(int dimension) {
        return Nd4j.createComplex(super.min(dimension));
    }

    @Override
    public IComplexNDArray normmax(int dimension) {
        if (dimension == Integer.MAX_VALUE) {
            return Nd4j.scalar(ComplexOps.normmax(this));
        }
        if (this.isVector()) {
            return this.sum(Integer.MAX_VALUE);
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final IComplexNDArray arr = Nd4j.createComplex(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                IComplexNDArray arr2 = (IComplexNDArray)nd.getResult();
                arr.put(i.get(), arr2.normmax(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                arr.put(i.get(), nd.normmax(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape);
    }

    @Override
    public IComplexNDArray sum(int dimension) {
        if (dimension == Integer.MAX_VALUE) {
            return Nd4j.scalar(ComplexOps.sum(this));
        }
        if (this.isVector()) {
            return this.sum(Integer.MAX_VALUE);
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final IComplexNDArray arr = Nd4j.createComplex(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                INDArray arr2 = (INDArray)nd.getResult();
                arr.put(i.get(), arr2.sum(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                arr.put(i.get(), nd.sum(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape);
    }

    @Override
    public IComplexNDArray norm1(int dimension) {
        if (dimension == Integer.MAX_VALUE) {
            return Nd4j.scalar(ComplexOps.norm1(this));
        }
        if (this.isVector()) {
            return this.norm1(Integer.MAX_VALUE);
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final IComplexNDArray arr = Nd4j.createComplex(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                IComplexNDArray arr2 = (IComplexNDArray)nd.getResult();
                arr.put(i.get(), arr2.norm1(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                arr.put(i.get(), nd.norm1(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape);
    }

    public IComplexDouble std() {
        StandardDeviation dev = new StandardDeviation();
        INDArray real = this.getReal();
        INDArray imag = this.imag();
        double std = dev.evaluate(ArrayUtil.doubleCopyOf(real.data()));
        double std2 = dev.evaluate(ArrayUtil.doubleCopyOf(imag.data()));
        return Nd4j.createDouble(std, std2);
    }

    @Override
    public INDArray std(int dimension) {
        if (dimension == Integer.MAX_VALUE) {
            return Nd4j.scalar(ComplexOps.std(this));
        }
        if (this.isVector()) {
            return this.std(Integer.MAX_VALUE);
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final IComplexNDArray arr = Nd4j.createComplex(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                IComplexNDArray arr2 = (IComplexNDArray)nd.getResult();
                arr.put(i.get(), arr2.std(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                arr.put(i.get(), nd.std(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape);
    }

    @Override
    public IComplexNDArray norm2(int dimension) {
        if (dimension == Integer.MAX_VALUE) {
            return Nd4j.scalar(ComplexOps.norm2(this));
        }
        if (this.isVector()) {
            return this.sum(Integer.MAX_VALUE);
        }
        int[] shape = ArrayUtil.removeIndex(this.shape(), dimension);
        final IComplexNDArray arr = Nd4j.createComplex(new int[]{ArrayUtil.prod(shape)});
        final AtomicInteger i = new AtomicInteger(0);
        this.iterateOverDimension(dimension, new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                IComplexNDArray arr2 = (IComplexNDArray)nd.getResult();
                arr.put(i.get(), arr2.norm2(0));
                i.incrementAndGet();
            }

            @Override
            public void operate(INDArray nd) {
                arr.put(i.get(), nd.norm2(0));
                i.incrementAndGet();
            }
        }, false);
        return arr.reshape(shape);
    }

    @Override
    public IComplexNumber[] toArray() {
        this.length = ArrayUtil.prod(this.shape);
        IComplexNumber[] ret = new IComplexNumber[this.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getComplex(i);
        }
        return ret;
    }

    @Override
    public IComplexNDArray reshape(int newRows, int newColumns) {
        return this.reshape(new int[]{newRows, newColumns});
    }

    @Override
    public IComplexNDArray getColumn(int c) {
        if (this.shape.length == 2) {
            if (this.ordering == 'c') {
                IComplexNDArray ret = Nd4j.createComplex(this.data, new int[]{this.shape[0]}, new int[]{this.stride[0]}, this.offset + c * 2, this.ordering);
                return ret;
            }
            IComplexNDArray ret = Nd4j.createComplex(this.data, new int[]{this.shape[0]}, new int[]{this.stride[0]}, this.offset + c * 2, this.ordering);
            return ret;
        }
        if (this.isColumnVector() && c == 0) {
            return this;
        }
        throw new IllegalArgumentException("Unable to getFromOrigin column of non 2d matrix");
    }

    @Override
    public IComplexNDArray getRow(int r) {
        if (this.shape.length == 2) {
            if (this.ordering == 'c') {
                IComplexNDArray ret = Nd4j.createComplex(this.data, new int[]{this.shape[1]}, new int[]{this.stride[1]}, this.offset + r * 2 * this.columns(), this.ordering);
                return ret;
            }
            IComplexNDArray ret = Nd4j.createComplex(this.data, new int[]{this.shape[1]}, new int[]{this.stride[1]}, this.offset + r * 2, this.ordering);
            return ret;
        }
        if (this.isRowVector() && r == 0) {
            return this;
        }
        throw new IllegalArgumentException("Unable to getFromOrigin row of non 2d matrix");
    }

    @Override
    public boolean equals(Object o) {
        IComplexNDArray n = null;
        if (!(o instanceof IComplexNDArray)) {
            return false;
        }
        if (n == null) {
            n = (IComplexNDArray)o;
        }
        if (this.isScalar() && n.isScalar()) {
            IComplexNumber c = n.getComplex(0);
            return (double)Math.abs(this.getComplex(0).sub(c).realComponent().floatValue()) < 1.0E-6;
        }
        if (this.isVector() && n.isVector()) {
            for (int i = 0; i < this.length; ++i) {
                float curr = this.getComplex(i).realComponent().floatValue();
                float comp = n.getComplex(i).realComponent().floatValue();
                float currImag = this.getComplex(i).imaginaryComponent().floatValue();
                float compImag = n.getComplex(i).imaginaryComponent().floatValue();
                if (!((double)Math.abs(curr - comp) > 0.001) && !((double)Math.abs(currImag - compImag) > 0.001)) continue;
                return false;
            }
            return true;
        }
        if (!Shape.shapeEquals(this.shape(), n.shape())) {
            return false;
        }
        if (this.isScalar()) {
            IComplexNumber c = n.getComplex(0);
            return this.getComplex(0).sub(c).absoluteValue().doubleValue() < 1.0E-6;
        }
        if (this.isVector()) {
            for (int i = 0; i < this.length; ++i) {
                IComplexNumber comp;
                IComplexNumber curr = this.getComplex(i);
                if (!(curr.sub(comp = n.getComplex(i)).absoluteValue().doubleValue() > 1.0E-6)) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.slices(); ++i) {
            if (this.slice(i).equals(n.slice(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public IComplexNDArray broadcast(int[] shape) {
        int targetDimensions = shape.length;
        int dims = this.shape.length;
        if (targetDimensions < dims) {
            throw new IllegalArgumentException("Invalid shape to broad cast " + Arrays.toString(shape));
        }
        if (dims == targetDimensions) {
            if (Shape.shapeEquals(shape, this.shape())) {
                return this;
            }
            throw new IllegalArgumentException("Invalid shape to broad cast " + Arrays.toString(shape));
        }
        int n = shape[0];
        IComplexNDArray s = this.broadcast(Arrays.copyOfRange(shape, 1, targetDimensions));
        return Nd4j.repeat(s, n);
    }

    @Override
    public Object element() {
        if (!this.isScalar()) {
            throw new IllegalStateException("Unable to getScalar the element of a non scalar");
        }
        int idx = this.linearIndex(0);
        return Nd4j.createDouble(this.data[idx], this.data[idx + 1]);
    }

    @Override
    public IComplexNDArray permute(int[] rearrange) {
        if (rearrange.length < this.shape.length) {
            return this.dup();
        }
        this.checkArrangeArray(rearrange);
        int[] newDims = this.doPermuteSwap(this.shape, rearrange);
        int[] newStrides = this.doPermuteSwap(this.stride, rearrange);
        IComplexNDArray ret = Nd4j.createComplex(this.data, newDims, newStrides, this.offset, this.ordering);
        return ret;
    }

    @Override
    public IComplexNDArray ravel() {
        final IComplexNDArray ret = Nd4j.createComplex(this.length, this.ordering);
        final AtomicInteger counter = new AtomicInteger(0);
        SliceOp op = new SliceOp(){

            @Override
            public void operate(DimensionSlice nd) {
                IComplexNDArray nd1 = (IComplexNDArray)nd.getResult();
                for (int i = 0; i < nd1.length(); ++i) {
                    int element = counter.getAndIncrement();
                    ret.putScalar(element, nd1.getComplex(i));
                }
            }

            @Override
            public void operate(INDArray nd) {
                IComplexNDArray nd1 = (IComplexNDArray)nd;
                for (int i = 0; i < nd.length(); ++i) {
                    int element = counter.getAndIncrement();
                    ret.putScalar(element, nd1.getComplex(i));
                }
            }
        };
        if (this.ordering == 'c') {
            this.iterateOverAllRows(op);
        } else if (this.ordering == 'f') {
            this.iterateOverAllColumns(op);
        }
        return ret;
    }

    @Override
    public String toString() {
        if (this.isScalar()) {
            return this.element().toString();
        }
        if (this.isMatrix()) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i = 0; i < this.rows; ++i) {
                sb.append('[');
                for (int j = 0; j < this.columns; ++j) {
                    sb.append(this.getComplex(i, j));
                    if (j >= this.columns - 1) continue;
                    sb.append(',');
                }
                sb.append(']');
            }
            sb.append("]\n");
            return sb.toString();
        }
        if (this.isVector()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < this.length; ++i) {
                sb.append(this.getComplex(i));
                if (i >= this.length - 1) continue;
                sb.append(',');
            }
            sb.append("]\n");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        int length = this.shape[0];
        sb.append("[");
        if (length > 0) {
            sb.append(this.slice(0).toString());
            for (int i = 1; i < this.slices(); ++i) {
                sb.append(this.slice(i).toString());
                if (i >= length - 1) continue;
                sb.append(',');
            }
        }
        sb.append("]\n");
        return sb.toString();
    }
}

