/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;

public class FeatureUtil {
    public static INDArray toOutcomeVector(int index, int numOutcomes) {
        int[] nums = new int[numOutcomes];
        nums[index] = 1;
        return ArrayUtil.toNDArray(nums);
    }

    public static INDArray toOutcomeMatrix(int[] index, int numOutcomes) {
        INDArray ret = Nd4j.create(index.length, numOutcomes);
        for (int i = 0; i < ret.rows(); ++i) {
            int[] nums = new int[numOutcomes];
            nums[index[i]] = 1;
            ret.putRow(i, ArrayUtil.toNDArray(nums));
        }
        return ret;
    }

    public static void normalizeMatrix(INDArray toNormalize) {
        INDArray columnMeans = toNormalize.mean(0);
        toNormalize.subiRowVector(columnMeans);
        INDArray std = toNormalize.std(0);
        std.addi(Nd4j.scalar(1.0E-6));
        toNormalize.diviRowVector(std);
    }

    public static void scaleByMax(INDArray toScale) {
        INDArray scale = toScale.max(1);
        for (int i = 0; i < toScale.rows(); ++i) {
            float scaleBy = scale.get(i);
            toScale.putRow(i, toScale.getRow(i).divi(Float.valueOf(scaleBy)));
        }
    }
}

