/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.ops.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.BaseElementWiseOp;

public class Stabilize
extends BaseElementWiseOp {
    private float k = 1.0f;

    public Stabilize(Float k) {
        this.k = k.floatValue();
    }

    public Stabilize(float k) {
        this.k = k;
    }

    public Stabilize() {
    }

    public Object apply(INDArray from, Object value, int i) {
        float realMin = 1.1755E-38f;
        float cutOff = (float)FastMath.log((double)realMin);
        if (value instanceof IComplexNumber) {
            IComplexNumber c = (IComplexNumber)value;
            float curr = c.realComponent().floatValue();
            if (curr * this.k > -cutOff) {
                return Nd4j.createDouble(-cutOff / this.k, c.imaginaryComponent().floatValue());
            }
            if (curr * this.k < cutOff) {
                return Nd4j.createDouble(cutOff / this.k, c.imaginaryComponent().floatValue());
            }
        } else {
            float curr = ((Float)value).floatValue();
            if (curr * this.k > -cutOff) {
                return Float.valueOf(-cutOff / this.k);
            }
            if (curr * this.k < cutOff) {
                return Float.valueOf(cutOff / this.k);
            }
        }
        return value;
    }
}

